/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.async.perftest.Histogram;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.apache.logging.log4j.core.util.Loader;

public class PerfTest {
    private static final String LINE100 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456";
    public static final String LINE500 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456";
    static boolean verbose = false;
    static boolean throughput;

    static long calcNanoTimeCost() {
        long start;
        long iterations = 10000000L;
        long finish = start = System.nanoTime();
        int i = 0;
        while ((long)i < 10000000L) {
            finish = System.nanoTime();
            ++i;
        }
        if (finish <= start) {
            throw new IllegalStateException();
        }
        finish = System.nanoTime();
        return (finish - start) / 10000000L;
    }

    static Histogram createHistogram() {
        long[] intervals = new long[31];
        long intervalUpperBound = 1L;
        int size = intervals.length - 1;
        for (int i = 0; i < size; ++i) {
            intervals[i] = intervalUpperBound *= 2L;
        }
        intervals[intervals.length - 1] = Long.MAX_VALUE;
        return new Histogram(intervals);
    }

    public static void main(String[] args) throws Exception {
        new PerfTest().doMain(args);
    }

    public void doMain(String[] args) throws Exception {
        String runnerClass = args[0];
        IPerfTestRunner runner = (IPerfTestRunner)Loader.newCheckedInstanceOf((String)runnerClass, IPerfTestRunner.class);
        String name = args[1];
        String resultFile = args.length > 2 ? args[2] : null;
        for (String arg : args) {
            if (verbose && throughput) break;
            if ("-verbose".equalsIgnoreCase(arg)) {
                verbose = true;
            }
            if (!"-throughput".equalsIgnoreCase(arg)) continue;
            throughput = true;
        }
        boolean threadCount = true;
        PerfTest.printf("Starting %s %s (%d)...%n", this.getClass().getSimpleName(), name, 1);
        this.runTestAndPrintResult(runner, name, 1, resultFile);
        runner.shutdown();
        System.exit(0);
    }

    public void runTestAndPrintResult(IPerfTestRunner runner, String name, int threadCount, String resultFile) throws Exception {
        Histogram warmupHist = PerfTest.createHistogram();
        PerfTest.println("Warming up the JVM...");
        long t1 = System.nanoTime();
        int LINES = 50000;
        int iterations = 0;
        long stop = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        do {
            this.runTest(runner, 50000, null, warmupHist, 1);
            ++iterations;
        } while (System.nanoTime() - stop < 0L);
        PerfTest.printf("Warmup complete in %.1f seconds (%d iterations)%n", (double)(System.nanoTime() - t1) / 1.0E9, iterations);
        PerfTest.println("Waiting 10 seconds for buffers to drain warmup data...");
        Thread.sleep(3000L);
        Thread.sleep(7000L);
        PerfTest.println("Starting the main test...");
        this.runSingleThreadedTest(runner, 50000, name, resultFile);
        Thread.sleep(1000L);
    }

    private void forceRemap(int linesPerIteration, int iterations, IPerfTestRunner runner) {
        int LINESEP = System.lineSeparator().getBytes(Charset.defaultCharset()).length;
        int bytesPerLine = 0 + LINE500.getBytes().length;
        int bytesWritten = bytesPerLine * linesPerIteration * iterations;
        int threshold = 0x40000000;
        int todo = 0x40000000 - bytesWritten;
        if (todo <= 0) {
            return;
        }
        byte[] filler = new byte[4096];
        Arrays.fill(filler, (byte)88);
        String str = new String(filler, Charset.defaultCharset());
        do {
            runner.log(str);
        } while ((todo -= 4096 + LINESEP) > 0);
    }

    private int runSingleThreadedTest(IPerfTestRunner runner, int LINES, String name, String resultFile) throws IOException {
        Histogram latency = PerfTest.createHistogram();
        this.runTest(runner, LINES, "end", latency, 1);
        PerfTest.reportResult(resultFile, name, latency);
        return LINES;
    }

    static void reportResult(String file, String name, Histogram histogram) throws IOException {
        String result = PerfTest.createSamplingReport(name, histogram);
        PerfTest.println(result);
        if (file != null) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.write(result);
                writer.write(System.lineSeparator());
            }
        }
    }

    static void printf(String msg, Object ... objects) {
        if (verbose) {
            System.out.printf(msg, objects);
        }
    }

    static void println(String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    static String createSamplingReport(String name, Histogram histogram) {
        Histogram data = histogram;
        if (throughput) {
            return data.getMax() + " operations/second";
        }
        String result = String.format("avg=%.0f 99%%=%d 99.99%%=%d sampleCount=%d", data.getMean(), data.getTwoNinesUpperBound(), data.getFourNinesUpperBound(), data.getCount());
        return result;
    }

    public void runTest(IPerfTestRunner runner, int lines, String finalMessage, Histogram histogram, int threadCount) {
        if (throughput) {
            runner.runThroughputTest(lines, histogram);
        } else {
            long nanoTimeCost = PerfTest.calcNanoTimeCost();
            runner.runLatencyTest(lines, histogram, nanoTimeCost, threadCount);
        }
        if (finalMessage != null) {
            runner.log(finalMessage);
        }
    }
}

