/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncQueueFullPolicyFactoryTest {
    @Before
    public void setUp() throws Exception {
        System.clearProperty("log4j2.AsyncQueueFullPolicy");
        System.clearProperty("log4j2.DiscardThreshold");
        PropertiesUtil.getProperties().reload();
    }

    @Test
    public void testCreateReturnsDefaultRouterByDefault() throws Exception {
        AsyncQueueFullPolicy router = AsyncQueueFullPolicyFactory.create();
        Assert.assertEquals(DefaultAsyncQueueFullPolicy.class, router.getClass());
    }

    @Test
    public void testCreateReturnsDiscardingRouterIfSpecified() throws Exception {
        System.setProperty("log4j2.AsyncQueueFullPolicy", "Discard");
        Assert.assertEquals(DiscardingAsyncQueueFullPolicy.class, AsyncQueueFullPolicyFactory.create().getClass());
        System.setProperty("log4j2.AsyncQueueFullPolicy", DiscardingAsyncQueueFullPolicy.class.getSimpleName());
        Assert.assertEquals(DiscardingAsyncQueueFullPolicy.class, AsyncQueueFullPolicyFactory.create().getClass());
        System.setProperty("log4j2.AsyncQueueFullPolicy", DiscardingAsyncQueueFullPolicy.class.getName());
        Assert.assertEquals(DiscardingAsyncQueueFullPolicy.class, AsyncQueueFullPolicyFactory.create().getClass());
    }

    @Test
    public void testCreateDiscardingRouterDefaultThresholdLevelInfo() throws Exception {
        System.setProperty("log4j2.AsyncQueueFullPolicy", "Discard");
        Assert.assertEquals((Object)Level.INFO, (Object)((DiscardingAsyncQueueFullPolicy)AsyncQueueFullPolicyFactory.create()).getThresholdLevel());
    }

    @Test
    public void testCreateDiscardingRouterThresholdLevelCustomizable() throws Exception {
        System.setProperty("log4j2.AsyncQueueFullPolicy", "Discard");
        for (Level level : Level.values()) {
            System.setProperty("log4j2.DiscardThreshold", level.name());
            Assert.assertEquals((Object)level, (Object)((DiscardingAsyncQueueFullPolicy)AsyncQueueFullPolicyFactory.create()).getThresholdLevel());
        }
    }

    @Test
    public void testCreateReturnsCustomRouterIfSpecified() throws Exception {
        System.setProperty("log4j2.AsyncQueueFullPolicy", CustomRouterDefaultConstructor.class.getName());
        Assert.assertEquals(CustomRouterDefaultConstructor.class, AsyncQueueFullPolicyFactory.create().getClass());
    }

    @Test
    public void testCreateReturnsDefaultRouterIfSpecifiedCustomRouterFails() throws Exception {
        System.setProperty("log4j2.AsyncQueueFullPolicy", DoesNotImplementInterface.class.getName());
        Assert.assertEquals(DefaultAsyncQueueFullPolicy.class, AsyncQueueFullPolicyFactory.create().getClass());
    }

    static class DoesNotImplementInterface {
        DoesNotImplementInterface() {
        }
    }

    static class CustomRouterDefaultConstructor
    implements AsyncQueueFullPolicy {
        public EventRoute getRoute(long backgroundThreadId, Level level) {
            return null;
        }
    }
}

