/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerTimestampMessageTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerTimestampMessageTest.xml");
        System.setProperty("log4j.Clock", PoisonClock.class.getName());
    }

    @AfterClass
    public static void afterClass() throws IllegalAccessException {
        System.setProperty("Log4jContextSelector", "");
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        File file = new File("target", "AsyncLoggerTimestampMessageTest.log");
        file.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        Assert.assertFalse((boolean)PoisonClock.called);
        log.info((Message)new TimeMsg("Async logger msg with embedded timestamp", 123456789000L));
        Assert.assertFalse((boolean)PoisonClock.called);
        CoreLoggerContexts.stopLoggerContext(false, file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((Object)line1);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.equals("123456789000 Async logger msg with embedded timestamp"));
    }

    static class TimeMsg
    extends SimpleMessage
    implements TimestampMessage {
        private static final long serialVersionUID = 1L;
        private final long timestamp;

        public TimeMsg(String msg, long timestamp) {
            super(msg);
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class PoisonClock
    implements Clock {
        public static boolean called = false;

        public long currentTimeMillis() {
            called = true;
            return 987654321L;
        }
    }
}

