/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class PropertiesRoutingAppenderTest {
    private static final String CONFIG = "log4j-routing.properties";
    private static final String UNKNOWN_LOG_FILE = "target/rolling1/rollingtestProps-Unknown.log";
    private static final String ALERT_LOG_FILE = "target/routing1/routingtestProps-Alert.log";
    private static final String ACTIVITY_LOG_FILE = "target/routing1/routingtestProps-Activity.log";
    private ListAppender app;
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing.properties");
    @Rule
    public RuleChain rules = this.loggerContextRule.withCleanFilesRule("target/rolling1/rollingtestProps-Unknown.log", "target/routing1/routingtestProps-Alert.log", "target/routing1/routingtestProps-Activity.log");

    @Before
    public void setUp() throws Exception {
        this.app = this.loggerContextRule.getListAppender("List");
    }

    @After
    public void tearDown() throws Exception {
        this.app.clear();
        this.loggerContextRule.getLoggerContext().stop();
    }

    @Test
    public void routingTest() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        List<LogEvent> list = this.app.getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        msg = new StructuredDataMessage("Test", "This is a test", "Alert");
        EventLogger.logEvent((StructuredDataMessage)msg);
        File file = new File(ALERT_LOG_FILE);
        Assert.assertTrue((String)"Alert file was not created", (boolean)file.exists());
        msg = new StructuredDataMessage("Test", "This is a test", "Activity");
        EventLogger.logEvent((StructuredDataMessage)msg);
        file = new File(ACTIVITY_LOG_FILE);
        Assert.assertTrue((String)"Activity file was not created", (boolean)file.exists());
    }
}

