/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.junit.Assert;
import org.junit.Test;

public class PathSortByModificationTimeTest {
    @Test
    public void testIsRecentFirstReturnsConstructorValue() {
        Assert.assertTrue((boolean)((PathSortByModificationTime)PathSortByModificationTime.createSorter((boolean)true)).isRecentFirst());
        Assert.assertFalse((boolean)((PathSortByModificationTime)PathSortByModificationTime.createSorter((boolean)false)).isRecentFirst());
    }

    @Test
    public void testCompareRecentFirst() {
        PathSorter sorter = PathSortByModificationTime.createSorter((boolean)true);
        Path p1 = Paths.get("aaa", new String[0]);
        Path p2 = Paths.get("bbb", new String[0]);
        DummyFileAttributes a1 = new DummyFileAttributes();
        DummyFileAttributes a2 = new DummyFileAttributes();
        a1.lastModified = FileTime.fromMillis(100L);
        a2.lastModified = FileTime.fromMillis(222L);
        Assert.assertEquals((String)"same path, 2nd more recent", (long)1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a2)));
        Assert.assertEquals((String)"path ignored, 2nd more recent", (long)1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a2)));
        Assert.assertEquals((String)"path ignored, 2nd more recent", (long)1L, (long)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a2)));
        Assert.assertEquals((String)"same path, 1st more recent", (long)-1L, (long)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"path ignored, 1st more recent", (long)-1L, (long)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p2, a1)));
        Assert.assertEquals((String)"path ignored, 1st more recent", (long)-1L, (long)sorter.compare((Object)this.path(p2, a2), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"same path, same time", (long)0L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"p2 < p1, same time", (long)1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a1)));
        Assert.assertEquals((String)"p2 < p1, same time", (long)-1L, (long)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a1)));
    }

    @Test
    public void testCompareRecentLast() {
        PathSorter sorter = PathSortByModificationTime.createSorter((boolean)false);
        Path p1 = Paths.get("aaa", new String[0]);
        Path p2 = Paths.get("bbb", new String[0]);
        DummyFileAttributes a1 = new DummyFileAttributes();
        DummyFileAttributes a2 = new DummyFileAttributes();
        a1.lastModified = FileTime.fromMillis(100L);
        a2.lastModified = FileTime.fromMillis(222L);
        Assert.assertEquals((String)"same path, 2nd more recent", (long)-1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a2)));
        Assert.assertEquals((String)"path ignored, 2nd more recent", (long)-1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a2)));
        Assert.assertEquals((String)"path ignored, 2nd more recent", (long)-1L, (long)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a2)));
        Assert.assertEquals((String)"same path, 1st more recent", (long)1L, (long)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"path ignored, 1st more recent", (long)1L, (long)sorter.compare((Object)this.path(p1, a2), (Object)this.path(p2, a1)));
        Assert.assertEquals((String)"path ignored, 1st more recent", (long)1L, (long)sorter.compare((Object)this.path(p2, a2), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"same path, same time", (long)0L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p1, a1)));
        Assert.assertEquals((String)"p1 < p2, same time", (long)-1L, (long)sorter.compare((Object)this.path(p1, a1), (Object)this.path(p2, a1)));
        Assert.assertEquals((String)"p1 < p2, same time", (long)1L, (long)sorter.compare((Object)this.path(p2, a1), (Object)this.path(p1, a1)));
    }

    private PathWithAttributes path(Path path, DummyFileAttributes attributes) {
        return new PathWithAttributes(path, (BasicFileAttributes)attributes);
    }
}

