/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.ByteArrayInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RollingAppenderOnStartup2Test {
    private static final String DIR = "target/rollOnStartup";
    private static final String TARGET_FILE = "target/rollOnStartup/orchestrator.log";
    private static final FastDateFormat formatter = FastDateFormat.getInstance((String)"MM-dd-yy-HH-mm-ss");
    private static final String ROLLED_FILE_PREFIX = "target/rollOnStartup/orchestrator-";
    private static final String ROLLED_FILE_SUFFIX = "-1.log.gz";
    private static final String TEST_DATA = "Hello world!";

    @BeforeClass
    public static void beforeClass() throws Exception {
        long copied;
        if (Files.exists(Paths.get(DIR, new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(DIR, new String[0]));){
                for (Path path : directoryStream) {
                    Files.delete(path);
                }
                Files.delete(Paths.get(DIR, new String[0]));
            }
        }
        DefaultConfiguration configuration = new DefaultConfiguration();
        Path target = Paths.get(TARGET_FILE, new String[0]);
        Assert.assertFalse((boolean)Files.exists(target, new LinkOption[0]));
        target.toFile().getParentFile().mkdirs();
        long timeStamp = System.currentTimeMillis() - 86400000L;
        String expectedDate = formatter.format(timeStamp);
        String rolledFileName = ROLLED_FILE_PREFIX + expectedDate + ROLLED_FILE_SUFFIX;
        Path rolled = Paths.get(rolledFileName, new String[0]);
        try (ByteArrayInputStream is = new ByteArrayInputStream(TEST_DATA.getBytes("UTF-8"));){
            copied = Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
        long size = Files.size(target);
        Assert.assertTrue((size > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)copied, (long)size);
        FileTime fileTime = FileTime.fromMillis(timeStamp);
        BasicFileAttributeView attrs = Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]);
        attrs.setTimes(fileTime, fileTime, fileTime);
        System.setProperty("log4j.configurationFile", "log4j-rollOnStartup.json");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        long size = 0L;
    }

    @Test
    public void testAppender() throws Exception {
        Logger logger = LogManager.getLogger(RollingAppenderOnStartup2Test.class);
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is test message number " + i);
        }
    }
}

