/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDeleteAccumulatedCount1Test {
    private static final String CONFIG = "log4j-rolling-with-custom-delete-accum-count1.xml";
    private static final String DIR = "target/rolling-with-delete-accum-count1/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete-accum-count1.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete-accum-count1/test");

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppender() throws Exception {
        void var12_16;
        Object[] files;
        Path p1 = this.writeTextTo("target/rolling-with-delete-accum-count1/test/my-1.log");
        Path p2 = this.writeTextTo("target/rolling-with-delete-accum-count1/test/my-2.log");
        Path p3 = this.writeTextTo("target/rolling-with-delete-accum-count1/test/my-3.log");
        Path p4 = this.writeTextTo("target/rolling-with-delete-accum-count1/test/my-4.log");
        Path p5 = this.writeTextTo("target/rolling-with-delete-accum-count1/test/my-5.log");
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            this.updateLastModified(p1, p2, p3, p4, p5);
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-delete-accum-count1/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-delete-accum-count1/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        for (File file : files = dir.listFiles()) {
            System.out.println(file + " (" + file.length() + "B) " + FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.ABSOLUTE).format(file.lastModified()));
        }
        List<String> expected = Arrays.asList("my-1.log", "my-2.log", "my-3.log", "my-4.log", "my-5.log");
        Assert.assertEquals((String)Arrays.toString(files), (long)(expected.size() + 6), (long)files.length);
        Object[] arr$ = files;
        int len$ = arr$.length;
        boolean bl = false;
        while (var12_16 < len$) {
            Object file = arr$[var12_16];
            if (!expected.contains(((File)file).getName()) && !((File)file).getName().startsWith("test-")) {
                Assert.fail((String)("unexpected file" + file));
            }
            ++var12_16;
        }
    }

    private void updateLastModified(Path ... paths) throws IOException {
        for (Path path : paths) {
            Files.setLastModifiedTime(path, FileTime.fromMillis(System.currentTimeMillis() + 2000L));
        }
    }

    private Path writeTextTo(String location) throws IOException {
        Path path = Paths.get(location, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter buffy = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
            buffy.write("some text");
            buffy.newLine();
            buffy.flush();
        }
        return path;
    }
}

