/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.nosql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.nosql.DefaultNoSqlObject;
import org.apache.logging.log4j.core.appender.nosql.NoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.NoSqlDatabaseManager;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.junit.ThreadContextStackRule;
import org.apache.logging.log4j.message.Message;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class NoSqlDatabaseManagerTest {
    @Mock
    private NoSqlConnection<Map<String, Object>, DefaultNoSqlObject> connection;
    @Mock
    private NoSqlProvider<NoSqlConnection<Map<String, Object>, DefaultNoSqlObject>> provider;
    @Mock
    private Message message;
    @Captor
    private ArgumentCaptor<NoSqlObject<Map<String, Object>>> captor;
    @Rule
    public final ThreadContextStackRule threadContextRule = new ThreadContextStackRule();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        BDDMockito.given((Object)this.provider.getConnection()).willReturn(this.connection);
        BDDMockito.given((Object)this.connection.createObject()).willAnswer((Answer)new Answer<DefaultNoSqlObject>(){

            public DefaultNoSqlObject answer(InvocationOnMock invocation) throws Throwable {
                return new DefaultNoSqlObject();
            }
        });
        BDDMockito.given((Object)this.connection.createList(ArgumentMatchers.anyInt())).willAnswer((Answer)new Answer<DefaultNoSqlObject[]>(){

            public DefaultNoSqlObject[] answer(InvocationOnMock invocation) throws Throwable {
                return new DefaultNoSqlObject[((Integer)invocation.getArgument(0)).intValue()];
            }
        });
    }

    @Test
    public void testConnection() {
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            Assert.assertNotNull((String)"The manager should not be null.", (Object)manager);
            manager.connectAndStart();
            ((NoSqlProvider)BDDMockito.then(this.provider).should()).getConnection();
            manager.commitAndClose();
        }
    }

    @Test
    public void testWriteInternalNotConnected01() {
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            this.expectedException.expect(AppenderLoggingException.class);
            manager.writeInternal((LogEvent)Mockito.mock(LogEvent.class), null);
        }
    }

    @Test
    public void testWriteInternalNotConnected02() {
        BDDMockito.given((Object)this.connection.isClosed()).willReturn((Object)true);
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            manager.startup();
            manager.connectAndStart();
            ((NoSqlProvider)BDDMockito.then(this.provider).should()).getConnection();
            this.expectedException.expect(AppenderLoggingException.class);
            manager.writeInternal((LogEvent)Mockito.mock(LogEvent.class), null);
        }
    }

    @Test
    public void testWriteInternal01() {
        BDDMockito.given((Object)this.connection.isClosed()).willReturn((Object)false);
        BDDMockito.given((Object)this.message.getFormattedMessage()).willReturn((Object)"My formatted message 01.");
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            manager.startup();
            manager.connectAndStart();
            ((NoSqlProvider)BDDMockito.then(this.provider).should()).getConnection();
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.WARN).setLoggerName("com.foo.NoSQLDbTest.testWriteInternal01").setMessage(this.message).setSource(new StackTraceElement("com.foo.Bar", "testMethod01", "Bar.java", 15)).setThreadId(1L).setThreadName("MyThread-A").setThreadPriority(1).setTimeMillis(1234567890123L).build();
            manager.writeInternal((LogEvent)event, null);
            ((NoSqlConnection)BDDMockito.then(this.connection).should()).insertObject((NoSqlObject)this.captor.capture());
            NoSqlObject inserted = (NoSqlObject)this.captor.getValue();
            Assert.assertNotNull((String)"The inserted value should not be null.", (Object)inserted);
            Map object = (Map)inserted.unwrap();
            Assert.assertNotNull((String)"The unwrapped object should not be null.", (Object)object);
            Assert.assertEquals((String)"The level is not correct.", (Object)Level.WARN, object.get("level"));
            Assert.assertEquals((String)"The logger is not correct.", (Object)"com.foo.NoSQLDbTest.testWriteInternal01", object.get("loggerName"));
            Assert.assertEquals((String)"The message is not correct.", (Object)"My formatted message 01.", object.get("message"));
            Assert.assertEquals((String)"The thread is not correct.", (Object)"MyThread-A", object.get("threadName"));
            Assert.assertEquals((String)"The millis is not correct.", (Object)1234567890123L, object.get("millis"));
            Assert.assertEquals((String)"The date is not correct.", (long)1234567890123L, (long)((Date)object.get("date")).getTime());
            Assert.assertTrue((String)"The source should be a map.", (boolean)(object.get("source") instanceof Map));
            Map source = (Map)object.get("source");
            Assert.assertEquals((String)"The class is not correct.", (Object)"com.foo.Bar", source.get("className"));
            Assert.assertEquals((String)"The method is not correct.", (Object)"testMethod01", source.get("methodName"));
            Assert.assertEquals((String)"The file name is not correct.", (Object)"Bar.java", source.get("fileName"));
            Assert.assertEquals((String)"The line number is not correct.", (Object)15, source.get("lineNumber"));
            Assert.assertNull((String)"The marker should be null.", object.get("marker"));
            Assert.assertNull((String)"The thrown should be null.", object.get("thrown"));
            Assert.assertTrue((String)"The context map should be empty.", (boolean)((Map)object.get("contextMap")).isEmpty());
            Assert.assertTrue((String)"The context stack should be null.", (boolean)((Collection)object.get("contextStack")).isEmpty());
        }
    }

    @Test
    public void testWriteInternal02() {
        BDDMockito.given((Object)this.connection.isClosed()).willReturn((Object)false);
        BDDMockito.given((Object)this.message.getFormattedMessage()).willReturn((Object)"Another cool message 02.");
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            manager.startup();
            manager.connectAndStart();
            ((NoSqlProvider)BDDMockito.then(this.provider).should()).getConnection();
            RuntimeException exception = new RuntimeException("This is something cool!");
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("hello", "world");
            context.put("user", "pass");
            ThreadContext.push((String)"message1");
            ThreadContext.push((String)"stack2");
            ThreadContext.ContextStack stack = ThreadContext.getImmutableStack();
            ThreadContext.clearStack();
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setLoggerName("com.foo.NoSQLDbTest.testWriteInternal02").setMessage(this.message).setSource(new StackTraceElement("com.bar.Foo", "anotherMethod03", "Foo.java", 9)).setMarker(MarkerManager.getMarker((String)"LoneMarker")).setThreadId(1L).setThreadName("AnotherThread-B").setThreadPriority(1).setTimeMillis(987654321564L).setThrown((Throwable)exception).setContextData(ContextDataFactory.createContextData(context)).setContextStack(stack).build();
            manager.writeInternal((LogEvent)event, null);
            ((NoSqlConnection)BDDMockito.then(this.connection).should()).insertObject((NoSqlObject)this.captor.capture());
            NoSqlObject inserted = (NoSqlObject)this.captor.getValue();
            Assert.assertNotNull((String)"The inserted value should not be null.", (Object)inserted);
            Map object = (Map)inserted.unwrap();
            Assert.assertNotNull((String)"The unwrapped object should not be null.", (Object)object);
            Assert.assertEquals((String)"The level is not correct.", (Object)Level.DEBUG, object.get("level"));
            Assert.assertEquals((String)"The logger is not correct.", (Object)"com.foo.NoSQLDbTest.testWriteInternal02", object.get("loggerName"));
            Assert.assertEquals((String)"The message is not correct.", (Object)"Another cool message 02.", object.get("message"));
            Assert.assertEquals((String)"The thread is not correct.", (Object)"AnotherThread-B", object.get("threadName"));
            Assert.assertEquals((String)"The millis is not correct.", (Object)987654321564L, object.get("millis"));
            Assert.assertEquals((String)"The date is not correct.", (long)987654321564L, (long)((Date)object.get("date")).getTime());
            Assert.assertTrue((String)"The source should be a map.", (boolean)(object.get("source") instanceof Map));
            Map source = (Map)object.get("source");
            Assert.assertEquals((String)"The class is not correct.", (Object)"com.bar.Foo", source.get("className"));
            Assert.assertEquals((String)"The method is not correct.", (Object)"anotherMethod03", source.get("methodName"));
            Assert.assertEquals((String)"The file name is not correct.", (Object)"Foo.java", source.get("fileName"));
            Assert.assertEquals((String)"The line number is not correct.", (Object)9, source.get("lineNumber"));
            Assert.assertTrue((String)"The marker should be a map.", (boolean)(object.get("marker") instanceof Map));
            Map marker = (Map)object.get("marker");
            Assert.assertEquals((String)"The marker name is not correct.", (Object)"LoneMarker", marker.get("name"));
            Assert.assertNull((String)"The marker parent should be null.", marker.get("parent"));
            Assert.assertTrue((String)"The thrown should be a map.", (boolean)(object.get("thrown") instanceof Map));
            Map thrown = (Map)object.get("thrown");
            Assert.assertEquals((String)"The thrown type is not correct.", (Object)"java.lang.RuntimeException", thrown.get("type"));
            Assert.assertEquals((String)"The thrown message is not correct.", (Object)"This is something cool!", thrown.get("message"));
            Assert.assertTrue((String)"The thrown stack trace should be a list.", (boolean)(thrown.get("stackTrace") instanceof List));
            List stackTrace = (List)thrown.get("stackTrace");
            Assert.assertEquals((String)"The thrown stack trace length is not correct.", (long)exception.getStackTrace().length, (long)stackTrace.size());
            for (int i = 0; i < exception.getStackTrace().length; ++i) {
                StackTraceElement e1 = exception.getStackTrace()[i];
                Map e2 = (Map)stackTrace.get(i);
                Assert.assertEquals((String)("Element class name [" + i + "] is not correct."), (Object)e1.getClassName(), e2.get("className"));
                Assert.assertEquals((String)("Element method name [" + i + "] is not correct."), (Object)e1.getMethodName(), e2.get("methodName"));
                Assert.assertEquals((String)("Element file name [" + i + "] is not correct."), (Object)e1.getFileName(), e2.get("fileName"));
                Assert.assertEquals((String)("Element line number [" + i + "] is not correct."), (Object)e1.getLineNumber(), e2.get("lineNumber"));
            }
            Assert.assertNull((String)"The thrown should have no cause.", thrown.get("cause"));
            Assert.assertTrue((String)"The context map should be a map.", (boolean)(object.get("contextMap") instanceof Map));
            Assert.assertEquals((String)"The context map is not correct.", context, object.get("contextMap"));
            Assert.assertTrue((String)"The context stack should be list.", (boolean)(object.get("contextStack") instanceof List));
            Assert.assertEquals((String)"The context stack is not correct.", (Object)stack.asList(), object.get("contextStack"));
        }
    }

    @Test
    public void testWriteInternal03() {
        BDDMockito.given((Object)this.connection.isClosed()).willReturn((Object)false);
        BDDMockito.given((Object)this.message.getFormattedMessage()).willReturn((Object)"Another cool message 02.");
        try (NoSqlDatabaseManager manager = NoSqlDatabaseManager.getNoSqlDatabaseManager((String)"name", (int)0, this.provider);){
            manager.startup();
            manager.connectAndStart();
            ((NoSqlProvider)BDDMockito.then(this.provider).should()).getConnection();
            IOException exception1 = new IOException("This is the cause.");
            SQLException exception2 = new SQLException("This is the result.", exception1);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("hello", "world");
            context.put("user", "pass");
            ThreadContext.push((String)"message1");
            ThreadContext.push((String)"stack2");
            ThreadContext.ContextStack stack = ThreadContext.getImmutableStack();
            ThreadContext.clearStack();
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setLoggerName("com.foo.NoSQLDbTest.testWriteInternal02").setMessage(this.message).setSource(new StackTraceElement("com.bar.Foo", "anotherMethod03", "Foo.java", 9)).setMarker(MarkerManager.getMarker((String)"AnotherMarker").addParents(new Marker[]{MarkerManager.getMarker((String)"Parent1").addParents(new Marker[]{MarkerManager.getMarker((String)"GrandParent1")}), MarkerManager.getMarker((String)"Parent2")})).setThreadId(1L).setThreadName("AnotherThread-B").setThreadPriority(1).setTimeMillis(987654321564L).setThrown((Throwable)exception2).setContextData(ContextDataFactory.createContextData(context)).setContextStack(stack).build();
            manager.writeInternal((LogEvent)event, null);
            ((NoSqlConnection)BDDMockito.then(this.connection).should()).insertObject((NoSqlObject)this.captor.capture());
            NoSqlObject inserted = (NoSqlObject)this.captor.getValue();
            Assert.assertNotNull((String)"The inserted value should not be null.", (Object)inserted);
            Map object = (Map)inserted.unwrap();
            Assert.assertNotNull((String)"The unwrapped object should not be null.", (Object)object);
            Assert.assertEquals((String)"The level is not correct.", (Object)Level.DEBUG, object.get("level"));
            Assert.assertEquals((String)"The logger is not correct.", (Object)"com.foo.NoSQLDbTest.testWriteInternal02", object.get("loggerName"));
            Assert.assertEquals((String)"The message is not correct.", (Object)"Another cool message 02.", object.get("message"));
            Assert.assertEquals((String)"The thread is not correct.", (Object)"AnotherThread-B", object.get("threadName"));
            Assert.assertEquals((String)"The millis is not correct.", (Object)987654321564L, object.get("millis"));
            Assert.assertEquals((String)"The date is not correct.", (long)987654321564L, (long)((Date)object.get("date")).getTime());
            Assert.assertTrue((String)"The source should be a map.", (boolean)(object.get("source") instanceof Map));
            Map source = (Map)object.get("source");
            Assert.assertEquals((String)"The class is not correct.", (Object)"com.bar.Foo", source.get("className"));
            Assert.assertEquals((String)"The method is not correct.", (Object)"anotherMethod03", source.get("methodName"));
            Assert.assertEquals((String)"The file name is not correct.", (Object)"Foo.java", source.get("fileName"));
            Assert.assertEquals((String)"The line number is not correct.", (Object)9, source.get("lineNumber"));
            Assert.assertTrue((String)"The marker should be a map.", (boolean)(object.get("marker") instanceof Map));
            Map marker = (Map)object.get("marker");
            Assert.assertEquals((String)"The marker name is not correct.", (Object)"AnotherMarker", marker.get("name"));
            Assert.assertTrue((String)"The marker parents should be a list.", (boolean)(marker.get("parents") instanceof List));
            List markerParents = (List)marker.get("parents");
            Assert.assertEquals((String)"The marker parents should contain two parents", (long)2L, (long)markerParents.size());
            Assert.assertTrue((String)"The marker parents[0] should be a map.", (boolean)(markerParents.get(0) instanceof Map));
            Map parent1 = (Map)markerParents.get(0);
            Assert.assertEquals((String)"The first marker parent name is not correct.", (Object)"Parent1", parent1.get("name"));
            Assert.assertTrue((String)"The marker parents[1] should be a map.", (boolean)(markerParents.get(1) instanceof Map));
            Map parent2 = (Map)markerParents.get(1);
            Assert.assertEquals((String)"The second marker parent name is not correct.", (Object)"Parent2", parent2.get("name"));
            Assert.assertNull((String)"The second marker should have no parent.", parent2.get("parent"));
            Assert.assertTrue((String)"The parent1 parents should be a list.", (boolean)(parent1.get("parents") instanceof List));
            List parent1Parents = (List)parent1.get("parents");
            Assert.assertEquals((String)"The parent1 parents should have only one parent", (long)1L, (long)parent1Parents.size());
            Assert.assertTrue((String)"The parent1Parents[0] should be a map.", (boolean)(parent1Parents.get(0) instanceof Map));
            Map parent1parent = (Map)parent1Parents.get(0);
            Assert.assertEquals((String)"The first parent1 parent name is not correct.", (Object)"GrandParent1", parent1parent.get("name"));
            Assert.assertNull((String)"The parent1parent marker should have no parent.", parent1parent.get("parent"));
            Assert.assertTrue((String)"The thrown should be a map.", (boolean)(object.get("thrown") instanceof Map));
            Map thrown = (Map)object.get("thrown");
            Assert.assertEquals((String)"The thrown type is not correct.", (Object)"java.sql.SQLException", thrown.get("type"));
            Assert.assertEquals((String)"The thrown message is not correct.", (Object)"This is the result.", thrown.get("message"));
            Assert.assertTrue((String)"The thrown stack trace should be a list.", (boolean)(thrown.get("stackTrace") instanceof List));
            List stackTrace = (List)thrown.get("stackTrace");
            Assert.assertEquals((String)"The thrown stack trace length is not correct.", (long)exception2.getStackTrace().length, (long)stackTrace.size());
            for (int i = 0; i < exception2.getStackTrace().length; ++i) {
                StackTraceElement e1 = exception2.getStackTrace()[i];
                Map e2 = (Map)stackTrace.get(i);
                Assert.assertEquals((String)("Element class name [" + i + "] is not correct."), (Object)e1.getClassName(), e2.get("className"));
                Assert.assertEquals((String)("Element method name [" + i + "] is not correct."), (Object)e1.getMethodName(), e2.get("methodName"));
                Assert.assertEquals((String)("Element file name [" + i + "] is not correct."), (Object)e1.getFileName(), e2.get("fileName"));
                Assert.assertEquals((String)("Element line number [" + i + "] is not correct."), (Object)e1.getLineNumber(), e2.get("lineNumber"));
            }
            Assert.assertTrue((String)"The thrown cause should be a map.", (boolean)(thrown.get("cause") instanceof Map));
            Map cause = (Map)thrown.get("cause");
            Assert.assertEquals((String)"The cause type is not correct.", (Object)"java.io.IOException", cause.get("type"));
            Assert.assertEquals((String)"The cause message is not correct.", (Object)"This is the cause.", cause.get("message"));
            Assert.assertTrue((String)"The cause stack trace should be a list.", (boolean)(cause.get("stackTrace") instanceof List));
            List causeStackTrace = (List)cause.get("stackTrace");
            Assert.assertEquals((String)"The cause stack trace length is not correct.", (long)exception1.getStackTrace().length, (long)causeStackTrace.size());
            for (int i = 0; i < exception1.getStackTrace().length; ++i) {
                StackTraceElement e1 = exception1.getStackTrace()[i];
                Map e2 = (Map)causeStackTrace.get(i);
                Assert.assertEquals((String)("Element class name [" + i + "] is not correct."), (Object)e1.getClassName(), e2.get("className"));
                Assert.assertEquals((String)("Element method name [" + i + "] is not correct."), (Object)e1.getMethodName(), e2.get("methodName"));
                Assert.assertEquals((String)("Element file name [" + i + "] is not correct."), (Object)e1.getFileName(), e2.get("fileName"));
                Assert.assertEquals((String)("Element line number [" + i + "] is not correct."), (Object)e1.getLineNumber(), e2.get("lineNumber"));
            }
            Assert.assertNull((String)"The cause should have no cause.", cause.get("cause"));
            Assert.assertTrue((String)"The context map should be a map.", (boolean)(object.get("contextMap") instanceof Map));
            Assert.assertEquals((String)"The context map is not correct.", context, object.get("contextMap"));
            Assert.assertTrue((String)"The context stack should be list.", (boolean)(object.get("contextStack") instanceof List));
            Assert.assertEquals((String)"The context stack is not correct.", (Object)stack.asList(), object.get("contextStack"));
        }
    }
}

