/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import org.apache.logging.log4j.core.appender.db.jdbc.ColumnConfig;
import org.junit.Assert;
import org.junit.Test;

public class ColumnConfigTest {
    @Test
    public void testNullNameNoConfig() {
        ColumnConfig config = ColumnConfig.newBuilder().setPattern("%l").build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testPatternAndLiteralNoConfig() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setPattern("%l").setLiteral("literal").build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testPatternAndDateNoConfig() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setPattern("%l").setEventTimestamp(true).build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testLiteralAndDateNoConfig() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setLiteral("literal").setEventTimestamp(true).build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testNoSettingNoConfig01() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testNoSettingNoConfig02() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setEventTimestamp(false).build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testNoSettingNoConfig03() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setPattern("").setLiteral("").setEventTimestamp(false).build();
        Assert.assertNull((String)"The result should be null.", (Object)config);
    }

    @Test
    public void testDateColumn01() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setEventTimestamp(true).build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col", (Object)config.getColumnName());
        Assert.assertNull((String)"The pattern should be null.", (Object)config.getLayout());
        Assert.assertNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertTrue((String)"The timestamp flag should be true.", (boolean)config.isEventTimestamp());
        Assert.assertFalse((String)"The unicode flag should be false.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }

    @Test
    public void testDateColumn02() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col2").setEventTimestamp(true).setUnicode(true).setClob(true).build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col2", (Object)config.getColumnName());
        Assert.assertNull((String)"The pattern should be null.", (Object)config.getLayout());
        Assert.assertNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertTrue((String)"The timestamp flag should be true.", (boolean)config.isEventTimestamp());
        Assert.assertFalse((String)"The unicode flag should be false.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }

    @Test
    public void testPatternColumn01() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setPattern("%l").build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col", (Object)config.getColumnName());
        Assert.assertNotNull((String)"The pattern should not be null.", (Object)config.getLayout());
        Assert.assertEquals((String)"The pattern is not correct.", (Object)"%l", (Object)config.getLayout().toString());
        Assert.assertNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertFalse((String)"The timestamp flag should be false.", (boolean)config.isEventTimestamp());
        Assert.assertTrue((String)"The unicode flag should be true.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }

    @Test
    public void testPatternColumn02() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col2").setPattern("%X{id} %level").setLiteral("").setEventTimestamp(false).setUnicode(false).setClob(true).build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col2", (Object)config.getColumnName());
        Assert.assertNotNull((String)"The pattern should not be null.", (Object)config.getLayout());
        Assert.assertEquals((String)"The pattern is not correct.", (Object)"%X{id} %level", (Object)config.getLayout().toString());
        Assert.assertNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertFalse((String)"The timestamp flag should be false.", (boolean)config.isEventTimestamp());
        Assert.assertFalse((String)"The unicode flag should be false.", (boolean)config.isUnicode());
        Assert.assertTrue((String)"The clob flag should be true.", (boolean)config.isClob());
    }

    @Test
    public void testPatternColumn03() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col3").setPattern("%X{id} %level").setLiteral("").setEventTimestamp(false).setUnicode(true).setClob(false).build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col3", (Object)config.getColumnName());
        Assert.assertNotNull((String)"The pattern should not be null.", (Object)config.getLayout());
        Assert.assertEquals((String)"The pattern is not correct.", (Object)"%X{id} %level", (Object)config.getLayout().toString());
        Assert.assertNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertFalse((String)"The timestamp flag should be false.", (boolean)config.isEventTimestamp());
        Assert.assertTrue((String)"The unicode flag should be true.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }

    @Test
    public void testLiteralColumn01() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col").setLiteral("literalValue01").build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col", (Object)config.getColumnName());
        Assert.assertNull((String)"The pattern should be null.", (Object)config.getLayout());
        Assert.assertNotNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertEquals((String)"The literal value is not correct.", (Object)"literalValue01", (Object)config.getLiteralValue());
        Assert.assertFalse((String)"The timestamp flag should be false.", (boolean)config.isEventTimestamp());
        Assert.assertFalse((String)"The unicode flag should be false.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }

    @Test
    public void testLiteralColumn02() {
        ColumnConfig config = ColumnConfig.newBuilder().setName("col2").setLiteral("USER1.MY_SEQUENCE.NEXT").setUnicode(true).setClob(true).build();
        Assert.assertNotNull((String)"The result should not be null.", (Object)config);
        Assert.assertEquals((String)"The column name is not correct.", (Object)"col2", (Object)config.getColumnName());
        Assert.assertNull((String)"The pattern should be null.", (Object)config.getLayout());
        Assert.assertNotNull((String)"The literal value should be null.", (Object)config.getLiteralValue());
        Assert.assertEquals((String)"The literal value is not correct.", (Object)"USER1.MY_SEQUENCE.NEXT", (Object)config.getLiteralValue());
        Assert.assertFalse((String)"The timestamp flag should be false.", (boolean)config.isEventTimestamp());
        Assert.assertFalse((String)"The unicode flag should be false.", (boolean)config.isUnicode());
        Assert.assertFalse((String)"The clob flag should be false.", (boolean)config.isClob());
    }
}

