/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.appender.SyslogAppenderTest;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.mock.MockSyslogServerFactory;
import org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.net.ssl.StoreConfigurationException;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.net.ssl.TlsSyslogMessageFormat;
import org.apache.logging.log4j.core.net.ssl.TlsSyslogTestUtil;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import org.junit.Test;

public class TlsSyslogAppenderTest
extends SyslogAppenderTest {
    private SSLServerSocketFactory serverSocketFactory;
    private TlsSyslogMessageFormat messageFormat;
    private SslConfiguration sslConfiguration;

    public TlsSyslogAppenderTest() throws StoreConfigurationException {
        this.initServerSocketFactory();
        this.root = this.ctx.getLogger("TLSSyslogAppenderTest");
    }

    @Test
    public void sendLargeLegacyBsdMessageOverTls() throws IOException, InterruptedException {
        String prefix = "BEGIN";
        this.initTlsTestEnvironment(1, TlsSyslogMessageFormat.LEGACY_BSD);
        char[] msg = new char[4124672 + "BEGIN".length()];
        Arrays.fill(msg, 'a');
        System.arraycopy("BEGIN".toCharArray(), 0, msg, 0, "BEGIN".length());
        this.sendAndCheckLegacyBsdMessage(new String(msg));
    }

    @Test
    public void sendLegacyBsdMessagesOverTls() throws IOException, InterruptedException {
        int numberOfMessages = 100;
        this.initTlsTestEnvironment(100, TlsSyslogMessageFormat.LEGACY_BSD);
        ArrayList<String> generatedMessages = TlsSyslogTestUtil.generateMessages(100, TlsSyslogMessageFormat.LEGACY_BSD);
        this.sendAndCheckLegacyBsdMessages(generatedMessages);
    }

    @Test
    public void sendStructuredMessageOverTls() throws InterruptedException, IOException {
        this.initTlsTestEnvironment(1, TlsSyslogMessageFormat.SYSLOG);
        this.sendAndCheckStructuredMessage();
    }

    @Test
    public void sendStructuredMessagesOverTls() throws IOException, InterruptedException {
        int numberOfMessages = 100;
        this.initTlsTestEnvironment(100, TlsSyslogMessageFormat.SYSLOG);
        this.sendAndCheckStructuredMessages(100);
    }

    private void initServerSocketFactory() throws StoreConfigurationException {
        KeyStoreConfiguration ksc = new KeyStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks", TestConstants.KEYSTORE_PWD(), null, null);
        TrustStoreConfiguration tsc = new TrustStoreConfiguration("src/test/resources/org/apache/logging/log4j/core/net/ssl/truststore.jks", TestConstants.TRUSTSTORE_PWD(), null, null);
        this.sslConfiguration = SslConfiguration.createSSLConfiguration(null, (KeyStoreConfiguration)ksc, (TrustStoreConfiguration)tsc);
        this.serverSocketFactory = this.sslConfiguration.getSslServerSocketFactory();
    }

    private SyslogAppender createAppender() {
        String format = this.messageFormat == TlsSyslogMessageFormat.LEGACY_BSD ? "LEGACY_BSD" : "RFC5424";
        return SyslogAppender.createAppender((String)"localhost", (int)8199, (String)"SSL", (SslConfiguration)this.sslConfiguration, (int)0, (int)-1, (boolean)true, (String)"Test", (boolean)true, (boolean)false, (Facility)Facility.LOCAL0, (String)"Audit", (int)18060, (boolean)true, (String)"RequestContext", null, null, (boolean)this.includeNewLine, null, (String)"TestApp", (String)"Test", null, (String)"ipAddress,loginId", null, (String)format, null, null, null, null, null, (boolean)false);
    }

    private void initTlsTestEnvironment(int numberOfMessages, TlsSyslogMessageFormat messageFormat) throws IOException {
        this.messageFormat = messageFormat;
        SSLServerSocket sslServerSocket = (SSLServerSocket)this.serverSocketFactory.createServerSocket(8199);
        this.syslogServer = MockSyslogServerFactory.createTLSSyslogServer(numberOfMessages, messageFormat, sslServerSocket);
        this.syslogServer.start();
        this.initAppender();
    }

    protected void initAppender() {
        this.appender = this.createAppender();
        this.validate(this.appender);
        this.appender.start();
        this.initRootLogger((Appender)this.appender);
    }
}

