/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryMappedFileAppenderRemapTest {
    final String LOGFILE = "target/MemoryMappedFileAppenderRemapTest.log";

    @Before
    public void before() {
        System.setProperty("log4j.configurationFile", "MemoryMappedFileAppenderRemapTest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemMapExtendsIfNeeded() throws Exception {
        String line4;
        String line3;
        String line2;
        String line1;
        File f = new File("target/MemoryMappedFileAppenderRemapTest.log");
        if (f.exists()) {
            Assert.assertTrue((boolean)f.delete());
        }
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger();
        char[] text = new char[200];
        Arrays.fill(text, 'A');
        try {
            log.warn("Test log1");
            Assert.assertTrue((boolean)f.exists());
            Assert.assertEquals((String)"initial length", (long)256L, (long)f.length());
            log.warn(new String(text));
            Assert.assertEquals((String)"grown", (long)512L, (long)f.length());
            log.warn(new String(text));
            Assert.assertEquals((String)"grown again", (long)768L, (long)f.length());
        }
        finally {
            CoreLoggerContexts.stopLoggerContext(false);
        }
        int LINESEP = System.lineSeparator().length();
        Assert.assertEquals((String)"Shrunk to actual used size", (long)(658 + 3 * LINESEP), (long)f.length());
        try (BufferedReader reader = new BufferedReader(new FileReader("target/MemoryMappedFileAppenderRemapTest.log"));){
            line1 = reader.readLine();
            line2 = reader.readLine();
            line3 = reader.readLine();
            line4 = reader.readLine();
        }
        Assert.assertNotNull((Object)line1);
        Assert.assertThat((Object)line1, (Matcher)CoreMatchers.containsString((String)"Test log1"));
        Assert.assertNotNull((Object)line2);
        Assert.assertThat((Object)line2, (Matcher)CoreMatchers.containsString((String)new String(text)));
        Assert.assertNotNull((Object)line3);
        Assert.assertThat((Object)line3, (Matcher)CoreMatchers.containsString((String)new String(text)));
        Assert.assertNull((String)"only three lines were logged", (Object)line4);
    }
}

