/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class PatternSelectorTest {
    private static final String CONFIG = "log4j-patternSelector.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-patternSelector.xml");

    @Test
    public void testMarkerPatternSelector() throws Exception {
        Logger logger = LogManager.getLogger((String)"TestMarkerPatternSelector");
        logger.traceEntry();
        logger.info("Hello World");
        logger.traceExit();
        ListAppender app = (ListAppender)context.getRequiredAppender("List");
        Assert.assertNotNull((String)"No ListAppender", (Object)((Object)app));
        List<String> messages = app.getMessages();
        Assert.assertNotNull((String)"No Messages", messages);
        Assert.assertTrue((String)("Incorrect number of messages. Expected 3, Actual " + messages.size() + ": " + messages), (messages.size() == 3 ? 1 : 0) != 0);
        String expect = String.format("[TRACE] TestMarkerPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testMarkerPatternSelector:43 Enter ======%n", new Object[0]);
        Assert.assertEquals((Object)expect, (Object)messages.get(0));
        Assert.assertEquals((Object)("[INFO ] TestMarkerPatternSelector Hello World" + Strings.LINE_SEPARATOR), (Object)messages.get(1));
        app.clear();
    }

    @Test
    public void testScriptPatternSelector() throws Exception {
        Logger logger = LogManager.getLogger((String)"TestScriptPatternSelector");
        Logger logger2 = LogManager.getLogger((String)"NoLocation");
        logger.traceEntry();
        logger.info("Hello World");
        logger2.info("No location information");
        logger.traceExit();
        ListAppender app = (ListAppender)context.getRequiredAppender("List2");
        Assert.assertNotNull((String)"No ListAppender", (Object)((Object)app));
        List<String> messages = app.getMessages();
        Assert.assertNotNull((String)"No Messages", messages);
        Assert.assertTrue((String)("Incorrect number of messages. Expected 4, Actual " + messages.size() + ": " + messages), (messages.size() == 4 ? 1 : 0) != 0);
        String expect = "[TRACE] TestScriptPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testScriptPatternSelector:62 Enter ======" + Strings.LINE_SEPARATOR;
        Assert.assertEquals((Object)expect, (Object)messages.get(0));
        expect = "[INFO ] TestScriptPatternSelector o.a.l.l.c.PatternSelectorTest.testScriptPatternSelector.63 Hello World" + Strings.LINE_SEPARATOR;
        Assert.assertEquals((Object)expect, (Object)messages.get(1));
        Assert.assertEquals((Object)("[INFO ] NoLocation No location information" + Strings.LINE_SEPARATOR), (Object)messages.get(2));
        app.clear();
    }

    @Test
    public void testJavaScriptPatternSelector() throws Exception {
        Logger logger = LogManager.getLogger((String)"TestJavaScriptPatternSelector");
        Logger logger2 = LogManager.getLogger((String)"JavascriptNoLocation");
        logger.traceEntry();
        logger.info("Hello World");
        logger2.info("No location information");
        logger.traceExit();
        ListAppender app = (ListAppender)context.getRequiredAppender("List3");
        Assert.assertNotNull((String)"No ListAppender", (Object)((Object)app));
        List<String> messages = app.getMessages();
        Assert.assertNotNull((String)"No Messages", messages);
        Assert.assertTrue((String)("Incorrect number of messages. Expected 4, Actual " + messages.size() + ": " + messages), (messages.size() == 4 ? 1 : 0) != 0);
        String expect = "[TRACE] TestJavaScriptPatternSelector ====== o.a.l.l.c.PatternSelectorTest.testJavaScriptPatternSelector:85 Enter ======" + Strings.LINE_SEPARATOR;
        Assert.assertEquals((Object)expect, (Object)messages.get(0));
        expect = "[INFO ] TestJavaScriptPatternSelector o.a.l.l.c.PatternSelectorTest.testJavaScriptPatternSelector.86 Hello World" + Strings.LINE_SEPARATOR;
        Assert.assertEquals((Object)expect, (Object)messages.get(1));
        Assert.assertEquals((Object)("[INFO ] JavascriptNoLocation No location information" + Strings.LINE_SEPARATOR), (Object)messages.get(2));
        app.clear();
    }
}

