/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;

public class GcFreeLoggingTestUtil {
    public static void executeLogging(String configurationFile, Class<?> testClass) throws Exception {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.configurationFile", configurationFile);
        Assert.assertTrue((String)"Constants.ENABLE_THREADLOCALS", (boolean)Constants.ENABLE_THREADLOCALS);
        Assert.assertTrue((String)"Constants.ENABLE_DIRECT_ENCODERS", (boolean)Constants.ENABLE_DIRECT_ENCODERS);
        Assert.assertFalse((String)"Constants.IS_WEB_APP", (boolean)Constants.IS_WEB_APP);
        MyCharSeq myCharSeq = new MyCharSeq();
        Marker testGrandParent = MarkerManager.getMarker((String)"testGrandParent");
        Marker testParent = MarkerManager.getMarker((String)"testParent").setParents(new Marker[]{testGrandParent});
        Marker test = MarkerManager.getMarker((String)"test").setParents(new Marker[]{testParent});
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        Logger logger = LogManager.getLogger((String)testClass.getName());
        logger.debug("debug not set");
        logger.fatal(test, "This message is logged to the console");
        logger.error("Sample error message");
        logger.error("Test parameterized message {}", (Object)"param");
        logger.error((Message)new StringMapMessage().with("eventId", "Login"));
        for (int i = 0; i < 256; ++i) {
            logger.debug("ensure all ringbuffer slots have been used once");
        }
        ThreadContext.remove((String)"aKey");
        ThreadContext.remove((String)"key2");
        final String[] exclude = new String[]{"java/util/concurrent/locks/AbstractQueuedSynchronizer$Node", "com/google/monitoring/runtime/instrumentation/Sampler"};
        final AtomicBoolean samplingEnabled = new AtomicBoolean(true);
        Sampler sampler = new Sampler(){

            public void sampleAllocation(int count, String desc, Object newObj, long size) {
                if (!samplingEnabled.get()) {
                    return;
                }
                for (int i = 0; i < exclude.length; ++i) {
                    if (!exclude[i].equals(desc)) continue;
                    return;
                }
                System.err.println("I just allocated the object " + newObj + " of type " + desc + " whose size is " + size);
                if (count != -1) {
                    System.err.println("It's an array of size " + count);
                }
                new RuntimeException().printStackTrace();
            }
        };
        Thread.sleep(500L);
        StringMapMessage mapMessage = (StringMapMessage)new StringMapMessage().with("eventId", "Login");
        AllocationRecorder.addSampler((Sampler)sampler);
        ThreadContext.put((String)"aKey", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        int ITERATIONS = 5;
        for (int i = 0; i < 5; ++i) {
            logger.error((CharSequence)myCharSeq);
            logger.error(MarkerManager.getMarker((String)"test"), (CharSequence)myCharSeq);
            logger.error("Test message");
            logger.error("Test parameterized message {}", (Object)"param");
            logger.error("Test parameterized message {}{}", (Object)"param", (Object)"param2");
            logger.error("Test parameterized message {}{}{}", (Object)"param", (Object)"param2", (Object)"abc");
            logger.error((Message)mapMessage);
            ThreadContext.remove((String)"aKey");
            ThreadContext.put((String)"aKey", (String)"value1");
        }
        Thread.sleep(50L);
        samplingEnabled.set(false);
        AllocationRecorder.removeSampler((Sampler)sampler);
        Thread.sleep(100L);
    }

    public static void runTest(Class<?> cls) throws Exception {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        String javaagent = "-javaagent:" + GcFreeLoggingTestUtil.agentJar();
        File tempFile = File.createTempFile("allocations", ".txt");
        tempFile.deleteOnExit();
        ProcessBuilder builder = new ProcessBuilder(javaBin, javaagent, "-cp", classpath, cls.getName());
        builder.redirectError(ProcessBuilder.Redirect.to(tempFile));
        builder.redirectOutput(ProcessBuilder.Redirect.to(tempFile));
        Process process = builder.start();
        process.waitFor();
        process.exitValue();
        String text = new String(Files.readAllBytes(tempFile.toPath()));
        List<String> lines = Files.readAllLines(tempFile.toPath(), Charset.defaultCharset());
        String className = cls.getSimpleName();
        Assert.assertEquals((String)text, (Object)("FATAL o.a.l.l.c." + className + " [main] value1 {aKey=value1, key2=value2, prop1=value1, prop2=value2} This message is logged to the console"), (Object)lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            Assert.assertFalse((String)(i + ": " + line + Strings.LINE_SEPARATOR + text), (line.contains("allocated") || line.contains("array") ? 1 : 0) != 0);
        }
    }

    private static File agentJar() {
        String name = AllocationRecorder.class.getName();
        URL url = AllocationRecorder.class.getResource("/" + name.replace('.', '/').concat(".class"));
        if (url == null) {
            throw new IllegalStateException("Could not find url for " + name);
        }
        String temp = url.toString();
        String path = temp.substring("jar:file:".length(), temp.indexOf(33));
        return new File(path);
    }

    public static class MyCharSeq
    implements CharSequence {
        final String seq = GcFreeLoggingTestUtil.class.toString();

        @Override
        public int length() {
            return this.seq.length();
        }

        @Override
        public char charAt(int index) {
            return this.seq.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.seq.subSequence(start, end);
        }

        @Override
        public String toString() {
            System.err.println("TEMP OBJECT CREATED!");
            throw new IllegalStateException("TEMP OBJECT CREATED!");
        }
    }
}

