/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class CustomLevelsTest {
    private static final String CONFIG = "log4j-customLevels.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-customLevels.xml");
    private ListAppender listAppender;
    private Level diagLevel;
    private Level noticeLevel;
    private Level verboseLevel;

    @Before
    public void before() {
        this.diagLevel = Level.getLevel((String)"DIAG");
        this.noticeLevel = Level.getLevel((String)"NOTICE");
        this.verboseLevel = Level.getLevel((String)"VERBOSE");
        this.listAppender = context.getListAppender("List1").clear();
    }

    @Test
    public void testCustomLevelInts() {
        Assert.assertEquals((long)350L, (long)this.diagLevel.intLevel());
        Assert.assertEquals((long)450L, (long)this.noticeLevel.intLevel());
        Assert.assertEquals((long)550L, (long)this.verboseLevel.intLevel());
    }

    @Test
    public void testCustomLevelPresence() {
        Assert.assertNotNull((Object)this.diagLevel);
        Assert.assertNotNull((Object)this.noticeLevel);
        Assert.assertNotNull((Object)this.verboseLevel);
    }

    @Test
    public void testLog() {
        Logger logger = context.getLogger();
        Assert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)0));
        logger.debug("Hello, {}", (Object)"World");
        Assert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)1));
        logger.log(this.diagLevel, "Hello DIAG");
        Assert.assertThat(this.listAppender.getEvents(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertEquals((Object)this.listAppender.getEvents().get(1).getLevel(), (Object)this.diagLevel);
    }
}

