/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class AppenderRefLevelTest {
    private static final String CONFIG = "log4j-reference-level.xml";
    private ListAppender app1;
    private ListAppender app2;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-reference-level.xml");
    Logger logger1 = context.getLogger("org.apache.logging.log4j.test1");
    Logger logger2 = context.getLogger("org.apache.logging.log4j.test2");
    Logger logger3 = context.getLogger("org.apache.logging.log4j.test3");
    Marker testMarker = MarkerManager.getMarker((String)"TEST");

    @Before
    public void before() {
        this.app1 = context.getListAppender("LIST1").clear();
        this.app2 = context.getListAppender("LIST2").clear();
    }

    @Test
    public void logger1() {
        this.logger1.traceEntry();
        this.logger1.debug("debug message");
        this.logger1.error("Test Message");
        this.logger1.info("Info Message");
        this.logger1.warn("warn Message");
        this.logger1.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 6, actual " + events.size()), (long)6L, (long)events.size());
        events = this.app2.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
    }

    @Test
    public void logger2() {
        this.logger2.traceEntry();
        this.logger2.debug("debug message");
        this.logger2.error("Test Message");
        this.logger2.info("Info Message");
        this.logger2.warn("warn Message");
        this.logger2.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 2, actual " + events.size()), (long)events.size(), (long)2L);
        events = this.app2.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 4, actual " + events.size()), (long)events.size(), (long)4L);
    }

    @Test
    public void logger3() {
        this.logger3.traceEntry();
        this.logger3.debug(this.testMarker, "debug message");
        this.logger3.error("Test Message");
        this.logger3.info(this.testMarker, "Info Message");
        this.logger3.warn("warn Message");
        this.logger3.traceExit();
        List<LogEvent> events = this.app1.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 4, actual " + events.size()), (long)4L, (long)events.size());
    }
}

