/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.dumbster.smtp;

import org.apache.logging.dumbster.smtp.SmtpActionType;
import org.apache.logging.dumbster.smtp.SmtpResponse;
import org.apache.logging.dumbster.smtp.SmtpState;

public class SmtpRequest {
    private final SmtpActionType action;
    private final SmtpState state;
    private final String params;

    public SmtpRequest(SmtpActionType actionType, String params, SmtpState state) {
        this.action = actionType;
        this.state = state;
        this.params = params;
    }

    public SmtpResponse execute() {
        SmtpResponse response = null;
        response = this.action.isStateless() ? (SmtpActionType.EXPN == this.action || SmtpActionType.VRFY == this.action ? new SmtpResponse(252, "Not supported", this.state) : (SmtpActionType.HELP == this.action ? new SmtpResponse(211, "No help available", this.state) : (SmtpActionType.NOOP == this.action ? new SmtpResponse(250, "OK", this.state) : (SmtpActionType.VRFY == this.action ? new SmtpResponse(252, "Not supported", this.state) : (SmtpActionType.RSET == this.action ? new SmtpResponse(250, "OK", SmtpState.GREET) : new SmtpResponse(500, "Command not recognized", this.state)))))) : (SmtpActionType.CONNECT == this.action ? (SmtpState.CONNECT == this.state ? new SmtpResponse(220, "localhost Dumbster SMTP service ready", SmtpState.GREET) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.EHLO == this.action ? (SmtpState.GREET == this.state ? new SmtpResponse(250, "OK", SmtpState.MAIL) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.MAIL == this.action ? (SmtpState.MAIL == this.state || SmtpState.QUIT == this.state ? new SmtpResponse(250, "OK", SmtpState.RCPT) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.RCPT == this.action ? (SmtpState.RCPT == this.state ? new SmtpResponse(250, "OK", this.state) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.DATA == this.action ? (SmtpState.RCPT == this.state ? new SmtpResponse(354, "Start mail input; end with <CRLF>.<CRLF>", SmtpState.DATA_HDR) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.UNRECOG == this.action ? (SmtpState.DATA_HDR == this.state || SmtpState.DATA_BODY == this.state ? new SmtpResponse(-1, "", this.state) : new SmtpResponse(500, "Command not recognized", this.state)) : (SmtpActionType.DATA_END == this.action ? (SmtpState.DATA_HDR == this.state || SmtpState.DATA_BODY == this.state ? new SmtpResponse(250, "OK", SmtpState.QUIT) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : (SmtpActionType.BLANK_LINE == this.action ? (SmtpState.DATA_HDR == this.state ? new SmtpResponse(-1, "", SmtpState.DATA_BODY) : (SmtpState.DATA_BODY == this.state ? new SmtpResponse(-1, "", this.state) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state))) : (SmtpActionType.QUIT == this.action ? (SmtpState.QUIT == this.state ? new SmtpResponse(221, "localhost Dumbster service closing transmission channel", SmtpState.CONNECT) : new SmtpResponse(503, "Bad sequence of commands: " + this.action, this.state)) : new SmtpResponse(500, "Command not recognized", this.state))))))))));
        return response;
    }

    public static SmtpRequest createRequest(String s, SmtpState state) {
        SmtpActionType action = null;
        String params = null;
        if (state == SmtpState.DATA_HDR) {
            if (s.equals(".")) {
                action = SmtpActionType.DATA_END;
            } else if (s.length() < 1) {
                action = SmtpActionType.BLANK_LINE;
            } else {
                action = SmtpActionType.UNRECOG;
                params = s;
            }
        } else if (state == SmtpState.DATA_BODY) {
            if (s.equals(".")) {
                action = SmtpActionType.DATA_END;
            } else {
                action = SmtpActionType.UNRECOG;
                params = s.length() < 1 ? "\n" : s;
            }
        } else {
            String su = s.toUpperCase();
            if (su.startsWith("EHLO ") || su.startsWith("HELO")) {
                action = SmtpActionType.EHLO;
                params = s.substring(5);
            } else if (su.startsWith("MAIL FROM:")) {
                action = SmtpActionType.MAIL;
                params = s.substring(10);
            } else if (su.startsWith("RCPT TO:")) {
                action = SmtpActionType.RCPT;
                params = s.substring(8);
            } else {
                action = su.startsWith("DATA") ? SmtpActionType.DATA : (su.startsWith("QUIT") ? SmtpActionType.QUIT : (su.startsWith("RSET") ? SmtpActionType.RSET : (su.startsWith("NOOP") ? SmtpActionType.NOOP : (su.startsWith("EXPN") ? SmtpActionType.EXPN : (su.startsWith("VRFY") ? SmtpActionType.VRFY : (su.startsWith("HELP") ? SmtpActionType.HELP : SmtpActionType.UNRECOG))))));
            }
        }
        SmtpRequest req = new SmtpRequest(action, params, state);
        return req;
    }

    public String getParams() {
        return this.params;
    }
}

