/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.appender;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.layout.SerializedLayout;

@Plugin(name="List", category="Core", elementType="appender", printObject=true)
public class ListAppender
extends AbstractAppender {
    final List<LogEvent> events = new ArrayList<LogEvent>();
    private final List<String> messages = new ArrayList<String>();
    final List<byte[]> data = new ArrayList<byte[]>();
    private final boolean newLine;
    private final boolean raw;
    private static final String WINDOWS_LINE_SEP = "\r\n";
    public CountDownLatch countDownLatch = null;

    public ListAppender(String name) {
        super(name, null, null);
        this.newLine = false;
        this.raw = false;
    }

    public ListAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean newline, boolean raw) {
        super(name, filter, layout);
        byte[] bytes;
        this.newLine = newline;
        this.raw = raw;
        if (layout != null && !(layout instanceof SerializedLayout) && (bytes = layout.getHeader()) != null) {
            this.write(bytes);
        }
    }

    public synchronized void append(LogEvent event) {
        Layout layout = this.getLayout();
        if (layout == null) {
            if (event instanceof MutableLogEvent) {
                this.events.add((LogEvent)((MutableLogEvent)event).createMemento());
            } else {
                this.events.add(event);
            }
        } else if (layout instanceof SerializedLayout) {
            byte[] header = layout.getHeader();
            byte[] content = layout.toByteArray(event);
            byte[] record = new byte[header.length + content.length];
            System.arraycopy(header, 0, record, 0, header.length);
            System.arraycopy(content, 0, record, header.length, content.length);
            this.data.add(record);
        } else {
            this.write(layout.toByteArray(event));
        }
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    void write(byte[] bytes) {
        if (this.raw) {
            this.data.add(bytes);
            return;
        }
        String str = new String(bytes);
        if (this.newLine) {
            int index = 0;
            while (index < str.length()) {
                int length;
                int end;
                int wend = str.indexOf(WINDOWS_LINE_SEP, index);
                int lend = str.indexOf(10, index);
                if (wend >= 0 && wend < lend) {
                    end = wend;
                    length = 2;
                } else {
                    end = lend;
                    length = 1;
                }
                if (index == end) {
                    if (!this.messages.get(this.messages.size() - length).isEmpty()) {
                        this.messages.add("");
                    }
                } else {
                    if (end < 0) {
                        this.messages.add(str.substring(index));
                        break;
                    }
                    this.messages.add(str.substring(index, end));
                }
                index = end + length;
            }
        } else {
            this.messages.add(str);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        byte[] bytes;
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        Layout layout = this.getLayout();
        if (layout != null && (bytes = layout.getFooter()) != null) {
            this.write(bytes);
        }
        this.setStopped();
        return true;
    }

    public synchronized ListAppender clear() {
        this.events.clear();
        this.messages.clear();
        this.data.clear();
        return this;
    }

    public synchronized List<LogEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public synchronized List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public List<String> getMessages(int minSize, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long endMillis = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (this.messages.size() < minSize && System.currentTimeMillis() < endMillis) {
            Thread.sleep(100L);
        }
        return Collections.unmodifiableList(this.messages);
    }

    public synchronized List<byte[]> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public static ListAppender createAppender(String name, boolean newLine, boolean raw, Layout<? extends Serializable> layout, Filter filter) {
        return new ListAppender(name, filter, layout, newLine, raw);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static ListAppender getListAppender(String name) {
        return (ListAppender)LoggerContext.getContext((boolean)false).getConfiguration().getAppender(name);
    }

    public String toString() {
        return "ListAppender [events=" + this.events + ", messages=" + this.messages + ", data=" + this.data + ", newLine=" + this.newLine + ", raw=" + this.raw + ", countDownLatch=" + this.countDownLatch + ", getHandler()=" + this.getHandler() + ", getLayout()=" + this.getLayout() + ", getName()=" + this.getName() + ", ignoreExceptions()=" + this.ignoreExceptions() + ", getFilter()=" + this.getFilter() + ", getState()=" + this.getState() + "]";
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ListAppender> {
        @PluginBuilderAttribute
        @Required
        private String name;
        @PluginBuilderAttribute
        private boolean entryPerNewLine;
        @PluginBuilderAttribute
        private boolean raw;
        @PluginElement(value="Layout")
        private Layout<? extends Serializable> layout;
        @PluginElement(value="Filter")
        private Filter filter;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEntryPerNewLine(boolean entryPerNewLine) {
            this.entryPerNewLine = entryPerNewLine;
            return this;
        }

        public Builder setRaw(boolean raw) {
            this.raw = raw;
            return this;
        }

        public Builder setLayout(Layout<? extends Serializable> layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public ListAppender build() {
            return new ListAppender(this.name, this.filter, this.layout, this.entryPerNewLine, this.raw);
        }
    }
}

