/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.appender;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="Deadlock", category="Core", elementType="appender", printObject=true)
public class DeadlockAppender
extends AbstractAppender {
    private WorkerThread thread = new WorkerThread();

    private DeadlockAppender(String name) {
        super(name, null, null, false);
    }

    public void start() {
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.thread.start();
        try {
            this.thread.join();
        }
        catch (Exception ex) {
            System.out.println("Thread interrupted");
        }
        this.setStopped();
        return true;
    }

    public void append(LogEvent event) {
        throw new LoggingException("Always fail");
    }

    @PluginFactory
    public static DeadlockAppender createAppender(@PluginAttribute(value="name") @Required(message="A name for the Appender must be specified") String name) {
        return new DeadlockAppender(name);
    }

    private class WorkerThread
    extends Thread {
        private WorkerThread() {
        }

        @Override
        public void run() {
            Logger logger = LogManager.getLogger((String)"org.apache.logging.log4j.test.WorkerThread");
            logger.debug("Worker is running");
        }
    }
}

