/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.sql.Connection;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class JdbcRule
implements TestRule {
    private final ConnectionSource connectionSource;
    private final String createTableStatement;
    private final String dropTableStatement;

    public JdbcRule(ConnectionSource connectionSource, String createTableStatement, String dropTableStatement) {
        this.dropTableStatement = dropTableStatement;
        this.connectionSource = connectionSource;
        this.createTableStatement = createTableStatement;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (Connection connection = JdbcRule.this.connectionSource.getConnection();){
                    try (java.sql.Statement statement = connection.createStatement();){
                        statement.executeUpdate(JdbcRule.this.createTableStatement);
                    }
                    base.evaluate();
                    statement = connection.createStatement();
                    var4_6 = null;
                    try {
                        statement.executeUpdate(JdbcRule.this.dropTableStatement);
                        statement.execute("SHUTDOWN");
                    }
                    catch (Throwable throwable) {
                        var4_6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (statement != null) {
                            if (var4_6 != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable x2) {
                                    var4_6.addSuppressed(x2);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
            }
        };
    }
}

