/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.junit.AbstractExternalFileCleaner;

public class CleanFolders
extends AbstractExternalFileCleaner {
    private static final int MAX_TRIES = 10;

    public CleanFolders(boolean before, boolean after, int maxTries, File ... files) {
        super(before, after, maxTries, null, files);
    }

    public CleanFolders(boolean before, boolean after, int maxTries, String ... fileNames) {
        super(before, after, maxTries, null, fileNames);
    }

    public CleanFolders(File ... folders) {
        super(true, true, 10, null, folders);
    }

    public CleanFolders(Path ... paths) {
        super(true, true, 10, null, paths);
    }

    public CleanFolders(PrintStream logger, File ... folders) {
        super(true, true, 10, logger, folders);
    }

    public CleanFolders(String ... folderNames) {
        super(true, true, 10, null, folderNames);
    }

    @Override
    protected boolean clean(Path path, int tryIndex) throws IOException {
        this.cleanFolder(path, tryIndex);
        return true;
    }

    private void cleanFolder(Path folder, int tryIndex) throws IOException {
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            Files.walkFileTree(folder, new DeleteAllFileVisitor(this.getPrintStream()));
        }
    }

    public static final class DeleteAllFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PrintStream printStream;

        public DeleteAllFileVisitor(PrintStream logger) {
            this.printStream = logger;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            this.printf("%s Deleting directory %s", "CLEANER", dir);
            boolean deleted = Files.deleteIfExists(dir);
            this.printf("%s Deleted directory %s: %s", "CLEANER", dir, deleted);
            return FileVisitResult.CONTINUE;
        }

        protected void printf(String format, Object ... args) {
            if (this.printStream != null) {
                this.printStream.printf(format, args);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.printf("%s Deleting file %s with %s", "CLEANER", file, attrs);
            boolean deleted = Files.deleteIfExists(file);
            this.printf("%s Deleted file %s: %s", "CLEANER", file, deleted);
            return FileVisitResult.CONTINUE;
        }
    }
}

