/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NameAbbreviatorTest {
    private final String pattern;
    private final String expected;

    public NameAbbreviatorTest(String pattern, String expected) {
        this.pattern = pattern;
        this.expected = expected;
    }

    @Parameterized.Parameters(name="pattern=\"{0}\", expected={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"0", "NameAbbreviatorTest"}, {"1", "NameAbbreviatorTest"}, {"2", "pattern.NameAbbreviatorTest"}, {"3", "core.pattern.NameAbbreviatorTest"}, {"1.", "o.a.l.l.c.p.NameAbbreviatorTest"}, {"1.1.~", "o.a.~.~.~.~.NameAbbreviatorTest"}, {".", "......NameAbbreviatorTest"});
    }

    @Test
    public void testAbbreviatorPatterns() throws Exception {
        NameAbbreviator abbreviator = NameAbbreviator.getAbbreviator((String)this.pattern);
        StringBuilder destination = new StringBuilder();
        abbreviator.abbreviate(this.getClass().getName(), destination);
        String actual = destination.toString();
        Assert.assertEquals((Object)this.expected, (Object)actual);
    }

    @Test
    public void testAbbreviatorPatternsAppend() throws Exception {
        NameAbbreviator abbreviator = NameAbbreviator.getAbbreviator((String)this.pattern);
        String PREFIX = "some random text";
        StringBuilder destination = new StringBuilder("some random text");
        abbreviator.abbreviate(this.getClass().getName(), destination);
        String actual = destination.toString();
        Assert.assertEquals((Object)("some random text" + this.expected), (Object)actual);
    }
}

