/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MapPatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.Assert;
import org.junit.Test;

public class MapPatternConverterTest {
    @Test
    public void testConverter() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("subject", "I");
        msg.put("verb", "love");
        msg.put("object", "Log4j");
        MapPatternConverter converter = MapPatternConverter.newInstance(null);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "subject=I";
        Assert.assertTrue((String)("Missing or incorrect subject. Expected " + expected + ", actual " + str), (boolean)str.contains(expected));
        expected = "verb=love";
        Assert.assertTrue((String)"Missing or incorrect verb", (boolean)str.contains(expected));
        expected = "object=Log4j";
        Assert.assertTrue((String)"Missing or incorrect object", (boolean)str.contains(expected));
        Assert.assertEquals((Object)"{object=Log4j, subject=I, verb=love}", (Object)str);
    }

    @Test
    public void testConverterWithKey() {
        StringMapMessage msg = new StringMapMessage();
        msg.put("subject", "I");
        msg.put("verb", "love");
        msg.put("object", "Log4j");
        MapPatternConverter converter = MapPatternConverter.newInstance((String[])new String[]{"object"});
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        String str = sb.toString();
        String expected = "Log4j";
        Assert.assertEquals((Object)"Log4j", (Object)str);
    }
}

