/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import java.util.Arrays;
import org.apache.logging.log4j.core.net.ssl.MemoryPasswordProvider;
import org.junit.Assert;
import org.junit.Test;

public class MemoryPasswordProviderTest {
    @Test
    public void testConstructorAllowsNull() {
        Assert.assertEquals(null, (Object)new MemoryPasswordProvider(null).getPassword());
    }

    @Test
    public void testConstructorDoesNotModifyOriginalParameterArray() {
        char[] initial = "123".toCharArray();
        new MemoryPasswordProvider(initial);
        Assert.assertArrayEquals((char[])"123".toCharArray(), (char[])initial);
    }

    @Test
    public void testGetPasswordReturnsCopyOfConstructorArray() {
        char[] initial = "123".toCharArray();
        MemoryPasswordProvider provider = new MemoryPasswordProvider(initial);
        char[] actual = provider.getPassword();
        Assert.assertArrayEquals((char[])"123".toCharArray(), (char[])actual);
        Assert.assertNotSame((Object)initial, (Object)actual);
        Arrays.fill(initial, 'a');
        Assert.assertArrayEquals((char[])"123".toCharArray(), (char[])provider.getPassword());
        Assert.assertNotSame((Object)provider.getPassword(), (Object)provider.getPassword());
    }
}

