/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class ReusableLogEventFactoryTest {
    @Test
    public void testCreateEventReturnsDifferentInstanceIfNotReleased() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assert.assertNotSame((Object)event1, (Object)event2);
        ReusableLogEventFactory.release((LogEvent)event1);
        ReusableLogEventFactory.release((LogEvent)event2);
    }

    @Test
    public void testCreateEventReturnsSameInstance() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        ReusableLogEventFactory.release((LogEvent)event1);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assert.assertSame((Object)event1, (Object)event2);
        ReusableLogEventFactory.release((LogEvent)event2);
        LogEvent event3 = this.callCreateEvent(factory, "c", Level.INFO, (Message)new SimpleMessage("123"), null);
        Assert.assertSame((Object)event2, (Object)event3);
        ReusableLogEventFactory.release((LogEvent)event3);
    }

    @Test
    public void testCreateEventOverwritesFields() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event1 = this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
        Assert.assertEquals((String)"logger", (Object)"a", (Object)event1.getLoggerName());
        Assert.assertEquals((String)"level", (Object)Level.DEBUG, (Object)event1.getLevel());
        Assert.assertEquals((String)"msg", (Object)new SimpleMessage("abc"), (Object)event1.getMessage());
        ReusableLogEventFactory.release((LogEvent)event1);
        LogEvent event2 = this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        Assert.assertSame((Object)event1, (Object)event2);
        Assert.assertEquals((String)"logger", (Object)"b", (Object)event1.getLoggerName());
        Assert.assertEquals((String)"level", (Object)Level.INFO, (Object)event1.getLevel());
        Assert.assertEquals((String)"msg", (Object)new SimpleMessage("xyz"), (Object)event1.getMessage());
        Assert.assertEquals((String)"logger", (Object)"b", (Object)event2.getLoggerName());
        Assert.assertEquals((String)"level", (Object)Level.INFO, (Object)event2.getLevel());
        Assert.assertEquals((String)"msg", (Object)new SimpleMessage("xyz"), (Object)event2.getMessage());
    }

    private LogEvent callCreateEvent(ReusableLogEventFactory factory, String logger, Level level, Message message, Throwable thrown) {
        return factory.createEvent(logger, null, this.getClass().getName(), level, message, null, thrown);
    }

    @Test
    public void testCreateEventReturnsThreadLocalInstance() throws Exception {
        final ReusableLogEventFactory factory = new ReusableLogEventFactory();
        final LogEvent[] event1 = new LogEvent[1];
        final LogEvent[] event2 = new LogEvent[1];
        Thread t1 = new Thread("THREAD 1"){

            @Override
            public void run() {
                event1[0] = ReusableLogEventFactoryTest.this.callCreateEvent(factory, "a", Level.DEBUG, (Message)new SimpleMessage("abc"), null);
            }
        };
        Thread t2 = new Thread("Thread 2"){

            @Override
            public void run() {
                event2[0] = ReusableLogEventFactoryTest.this.callCreateEvent(factory, "b", Level.INFO, (Message)new SimpleMessage("xyz"), null);
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertNotNull((Object)event1[0]);
        Assert.assertNotNull((Object)event2[0]);
        Assert.assertNotSame((Object)event1[0], (Object)event2[0]);
        Assert.assertEquals((String)"logger", (Object)"a", (Object)event1[0].getLoggerName());
        Assert.assertEquals((String)"level", (Object)Level.DEBUG, (Object)event1[0].getLevel());
        Assert.assertEquals((String)"msg", (Object)new SimpleMessage("abc"), (Object)event1[0].getMessage());
        Assert.assertEquals((String)"thread name", (Object)"THREAD 1", (Object)event1[0].getThreadName());
        Assert.assertEquals((String)"tid", (long)t1.getId(), (long)event1[0].getThreadId());
        Assert.assertEquals((String)"logger", (Object)"b", (Object)event2[0].getLoggerName());
        Assert.assertEquals((String)"level", (Object)Level.INFO, (Object)event2[0].getLevel());
        Assert.assertEquals((String)"msg", (Object)new SimpleMessage("xyz"), (Object)event2[0].getMessage());
        Assert.assertEquals((String)"thread name", (Object)"Thread 2", (Object)event2[0].getThreadName());
        Assert.assertEquals((String)"tid", (long)t2.getId(), (long)event2[0].getThreadId());
        ReusableLogEventFactory.release((LogEvent)event1[0]);
        ReusableLogEventFactory.release((LogEvent)event2[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateEventInitFieldsProperly() throws Exception {
        ReusableLogEventFactory factory = new ReusableLogEventFactory();
        LogEvent event = this.callCreateEvent(factory, "logger", Level.INFO, (Message)new SimpleMessage("xyz"), null);
        try {
            Assert.assertNotNull((Object)event.getContextMap());
            Assert.assertNotNull((Object)event.getContextData());
            Assert.assertNotNull((Object)event.getContextStack());
        }
        finally {
            ReusableLogEventFactory.release((LogEvent)event);
        }
    }
}

