/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.MutableThreadContextStack;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MutableLogEventTest {
    private static final StringMap CONTEXT_DATA = MutableLogEventTest.createContextData();
    private static final ThreadContext.ContextStack STACK = new MutableThreadContextStack(Arrays.asList("abc", "xyz"));
    static boolean useObjectInputStream = false;

    private static StringMap createContextData() {
        SortedArrayStringMap result = new SortedArrayStringMap();
        result.putValue("a", (Object)"1");
        result.putValue("b", (Object)"2");
        return result;
    }

    @BeforeClass
    public static void setupClass() {
        try {
            Class.forName("java.io.ObjectInputFilter");
            useObjectInputStream = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testToImmutable() {
        MutableLogEvent logEvent = new MutableLogEvent();
        Assert.assertNotSame((Object)logEvent, (Object)logEvent.toImmutable());
    }

    @Test
    public void testInitFromCopiesAllFields() {
        Log4jLogEvent source = Log4jLogEvent.newBuilder().setContextData(CONTEXT_DATA).setContextStack(STACK).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("a.b.c.d.e").setLoggerName("my name is Logger").setMarker(MarkerManager.getMarker((String)"on your marks")).setMessage((Message)new SimpleMessage("msg in a bottle")).setNanoTime(1234567L).setSource(new StackTraceElement("myclass", "mymethod", "myfile", 123)).setThreadId(100L).setThreadName("threadname").setThreadPriority(10).setThrown((Throwable)new RuntimeException("run")).setTimeMillis(987654321L).build();
        MutableLogEvent mutable = new MutableLogEvent();
        mutable.initFrom((LogEvent)source);
        Assert.assertEquals((String)"contextMap", (Object)CONTEXT_DATA, (Object)mutable.getContextData());
        Assert.assertEquals((String)"stack", (Object)STACK, (Object)mutable.getContextStack());
        Assert.assertEquals((String)"endOfBatch", (Object)true, (Object)mutable.isEndOfBatch());
        Assert.assertEquals((String)"IncludeLocation()", (Object)true, (Object)mutable.isIncludeLocation());
        Assert.assertEquals((String)"level", (Object)Level.FATAL, (Object)mutable.getLevel());
        Assert.assertEquals((String)"LoggerFqcn()", (Object)source.getLoggerFqcn(), (Object)mutable.getLoggerFqcn());
        Assert.assertEquals((String)"LoggerName", (Object)source.getLoggerName(), (Object)mutable.getLoggerName());
        Assert.assertEquals((String)"marker", (Object)source.getMarker(), (Object)mutable.getMarker());
        Assert.assertEquals((String)"msg", (Object)source.getMessage(), (Object)mutable.getMessage());
        Assert.assertEquals((String)"nano", (long)source.getNanoTime(), (long)mutable.getNanoTime());
        Assert.assertEquals((String)"src", (Object)source.getSource(), (Object)mutable.getSource());
        Assert.assertEquals((String)"tid", (long)source.getThreadId(), (long)mutable.getThreadId());
        Assert.assertEquals((String)"tname", (Object)source.getThreadName(), (Object)mutable.getThreadName());
        Assert.assertEquals((String)"tpriority", (long)source.getThreadPriority(), (long)mutable.getThreadPriority());
        Assert.assertEquals((String)"throwns", (Object)source.getThrown(), (Object)mutable.getThrown());
        Assert.assertEquals((String)"proxy", (Object)source.getThrownProxy(), (Object)mutable.getThrownProxy());
        Assert.assertEquals((String)"millis", (long)source.getTimeMillis(), (long)mutable.getTimeMillis());
    }

    @Test
    public void testInitFromReusableCopiesFormatString() {
        Message message = ReusableMessageFactory.INSTANCE.newMessage("msg in a {}", (Object)"bottle");
        Log4jLogEvent source = Log4jLogEvent.newBuilder().setContextData(CONTEXT_DATA).setContextStack(STACK).setEndOfBatch(true).setIncludeLocation(true).setLevel(Level.FATAL).setLoggerFqcn("a.b.c.d.e").setLoggerName("my name is Logger").setMarker(MarkerManager.getMarker((String)"on your marks")).setMessage(message).setNanoTime(1234567L).setSource(new StackTraceElement("myclass", "mymethod", "myfile", 123)).setThreadId(100L).setThreadName("threadname").setThreadPriority(10).setThrown((Throwable)new RuntimeException("run")).setTimeMillis(987654321L).build();
        MutableLogEvent mutable = new MutableLogEvent();
        mutable.initFrom((LogEvent)source);
        Assert.assertEquals((String)"format", (Object)"msg in a {}", (Object)mutable.getFormat());
        Assert.assertEquals((String)"formatted", (Object)"msg in a bottle", (Object)mutable.getFormattedMessage());
        Assert.assertEquals((String)"parameters", (Object[])new String[]{"bottle"}, (Object[])mutable.getParameters());
        Message memento = mutable.memento();
        Assert.assertEquals((String)"format", (Object)"msg in a {}", (Object)memento.getFormat());
        Assert.assertEquals((String)"formatted", (Object)"msg in a bottle", (Object)memento.getFormattedMessage());
        Assert.assertEquals((String)"parameters", (Object[])new String[]{"bottle"}, (Object[])memento.getParameters());
        Message eventMementoMessage = mutable.createMemento().getMessage();
        Assert.assertEquals((String)"format", (Object)"msg in a {}", (Object)eventMementoMessage.getFormat());
        Assert.assertEquals((String)"formatted", (Object)"msg in a bottle", (Object)eventMementoMessage.getFormattedMessage());
        Assert.assertEquals((String)"parameters", (Object[])new String[]{"bottle"}, (Object[])eventMementoMessage.getParameters());
        Message log4JLogEventMessage = new Log4jLogEvent.Builder((LogEvent)mutable).build().getMessage();
        Assert.assertEquals((String)"format", (Object)"msg in a {}", (Object)log4JLogEventMessage.getFormat());
        Assert.assertEquals((String)"formatted", (Object)"msg in a bottle", (Object)log4JLogEventMessage.getFormattedMessage());
        Assert.assertEquals((String)"parameters", (Object[])new String[]{"bottle"}, (Object[])log4JLogEventMessage.getParameters());
    }

    @Test
    public void testClear() {
        MutableLogEvent mutable = new MutableLogEvent();
        Assert.assertEquals((String)"context data", (long)0L, (long)mutable.getContextData().size());
        Assert.assertNull((String)"context stack", (Object)mutable.getContextStack());
        Assert.assertFalse((String)"end of batch", (boolean)mutable.isEndOfBatch());
        Assert.assertFalse((String)"incl loc", (boolean)mutable.isIncludeLocation());
        Assert.assertSame((String)"level", (Object)Level.OFF, (Object)mutable.getLevel());
        Assert.assertNull((String)"fqcn", (Object)mutable.getLoggerFqcn());
        Assert.assertNull((String)"logger", (Object)mutable.getLoggerName());
        Assert.assertNull((String)"marker", (Object)mutable.getMarker());
        Assert.assertEquals((String)"msg", (Object)mutable, (Object)mutable.getMessage());
        Assert.assertEquals((String)"nanoTm", (long)0L, (long)mutable.getNanoTime());
        Assert.assertEquals((String)"tid", (long)0L, (long)mutable.getThreadId());
        Assert.assertNull((String)"tname", (Object)mutable.getThreadName());
        Assert.assertEquals((String)"tpriority", (long)0L, (long)mutable.getThreadPriority());
        Assert.assertNull((String)"thrwn", (Object)mutable.getThrown());
        Assert.assertEquals((String)"timeMs", (long)0L, (long)mutable.getTimeMillis());
        Assert.assertNull((String)"source", (Object)mutable.getSource());
        Assert.assertNull((String)"thrownProxy", (Object)mutable.getThrownProxy());
        mutable.setContextData(CONTEXT_DATA);
        mutable.setContextStack(STACK);
        mutable.setEndOfBatch(true);
        mutable.setIncludeLocation(true);
        mutable.setLevel(Level.WARN);
        mutable.setLoggerFqcn(this.getClass().getName());
        mutable.setLoggerName("loggername");
        mutable.setMarker(MarkerManager.getMarker((String)"marked man"));
        mutable.setMessage((Message)new ParameterizedMessage("message in a {}", (Object)"bottle"));
        mutable.setNanoTime(1234L);
        mutable.setThreadId(987L);
        mutable.setThreadName("ito");
        mutable.setThreadPriority(9);
        mutable.setThrown((Throwable)new Exception());
        mutable.setTimeMillis(56789L);
        Assert.assertNotNull((String)"context map", (Object)mutable.getContextMap());
        Assert.assertNotNull((String)"context stack", (Object)mutable.getContextStack());
        Assert.assertTrue((String)"end of batch", (boolean)mutable.isEndOfBatch());
        Assert.assertTrue((String)"incl loc", (boolean)mutable.isIncludeLocation());
        Assert.assertNotNull((String)"level", (Object)mutable.getLevel());
        Assert.assertNotNull((String)"fqcn", (Object)mutable.getLoggerFqcn());
        Assert.assertNotNull((String)"logger", (Object)mutable.getLoggerName());
        Assert.assertNotNull((String)"marker", (Object)mutable.getMarker());
        Assert.assertEquals((String)"msg", (Object)new ParameterizedMessage("message in a {}", (Object)"bottle"), (Object)mutable.getMessage());
        Assert.assertNotEquals((String)"nanoTm", (long)0L, (long)mutable.getNanoTime());
        Assert.assertNotEquals((String)"tid", (long)0L, (long)mutable.getThreadId());
        Assert.assertNotNull((String)"tname", (Object)mutable.getThreadName());
        Assert.assertNotEquals((String)"tpriority", (long)0L, (long)mutable.getThreadPriority());
        Assert.assertNotNull((String)"thrwn", (Object)mutable.getThrown());
        Assert.assertNotEquals((String)"timeMs", (long)0L, (long)mutable.getTimeMillis());
        Assert.assertNotNull((String)"source", (Object)mutable.getSource());
        Assert.assertNotNull((String)"thrownProxy", (Object)mutable.getThrownProxy());
        mutable.clear();
        Assert.assertEquals((String)"context map", (long)0L, (long)mutable.getContextData().size());
        Assert.assertNull((String)"context stack", (Object)mutable.getContextStack());
        Assert.assertSame((String)"level", (Object)Level.OFF, (Object)mutable.getLevel());
        Assert.assertNull((String)"fqcn", (Object)mutable.getLoggerFqcn());
        Assert.assertNull((String)"logger", (Object)mutable.getLoggerName());
        Assert.assertNull((String)"marker", (Object)mutable.getMarker());
        Assert.assertEquals((String)"msg", (Object)mutable, (Object)mutable.getMessage());
        Assert.assertNull((String)"thrwn", (Object)mutable.getThrown());
        Assert.assertNull((String)"source", (Object)mutable.getSource());
        Assert.assertNull((String)"thrownProxy", (Object)mutable.getThrownProxy());
        Assert.assertTrue((String)"end of batch", (boolean)mutable.isEndOfBatch());
        Assert.assertTrue((String)"incl loc", (boolean)mutable.isIncludeLocation());
        Assert.assertNotEquals((String)"nanoTm", (long)0L, (long)mutable.getNanoTime());
        Assert.assertNotEquals((String)"timeMs", (long)0L, (long)mutable.getTimeMillis());
        Assert.assertNotEquals((String)"tid", (long)0L, (long)mutable.getThreadId());
        Assert.assertNotNull((String)"tname", (Object)mutable.getThreadName());
        Assert.assertNotEquals((String)"tpriority", (long)0L, (long)mutable.getThreadPriority());
    }

    @Test
    public void testJavaIoSerializable() throws Exception {
        MutableLogEvent evt = new MutableLogEvent();
        evt.setContextData(CONTEXT_DATA);
        evt.setContextStack(STACK);
        evt.setEndOfBatch(true);
        evt.setIncludeLocation(true);
        evt.setLevel(Level.WARN);
        evt.setLoggerFqcn(this.getClass().getName());
        evt.setLoggerName("loggername");
        evt.setMarker(MarkerManager.getMarker((String)"marked man"));
        evt.setMessage((Message)new SimpleMessage("peace for all"));
        evt.setNanoTime(1234L);
        evt.setThreadId(987L);
        evt.setThreadName("ito");
        evt.setThreadPriority(9);
        evt.setTimeMillis(56789L);
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assert.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assert.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assert.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assert.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assert.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assert.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assert.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assert.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assert.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assert.assertNotNull((Object)evt2.getSource());
        Assert.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assert.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assert.assertNull((Object)evt2.getThrown());
        Assert.assertNull((Object)evt2.getThrownProxy());
        Assert.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assert.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
        Assert.assertNotEquals((long)evt.getNanoTime(), (long)evt2.getNanoTime());
        Assert.assertEquals((long)0L, (long)evt2.getNanoTime());
    }

    @Test
    public void testJavaIoSerializableWithThrown() throws Exception {
        new InternalError("test error");
        MutableLogEvent evt = new MutableLogEvent();
        evt.setContextData(CONTEXT_DATA);
        evt.setContextStack(STACK);
        evt.setEndOfBatch(true);
        evt.setIncludeLocation(true);
        evt.setLevel(Level.WARN);
        evt.setLoggerFqcn(this.getClass().getName());
        evt.setLoggerName("loggername");
        evt.setMarker(MarkerManager.getMarker((String)"marked man"));
        evt.setMessage((Message)new SimpleMessage("peace for all"));
        evt.setNanoTime(1234L);
        evt.setThreadId(987L);
        evt.setThreadName("ito");
        evt.setThreadPriority(9);
        evt.setThrown((Throwable)new Exception());
        evt.setTimeMillis(56789L);
        byte[] binary = this.serialize(evt);
        Log4jLogEvent evt2 = this.deserialize(binary);
        Assert.assertEquals((long)evt.getTimeMillis(), (long)evt2.getTimeMillis());
        Assert.assertEquals((Object)evt.getLoggerFqcn(), (Object)evt2.getLoggerFqcn());
        Assert.assertEquals((Object)evt.getLevel(), (Object)evt2.getLevel());
        Assert.assertEquals((Object)evt.getLoggerName(), (Object)evt2.getLoggerName());
        Assert.assertEquals((Object)evt.getMarker(), (Object)evt2.getMarker());
        Assert.assertEquals((Object)evt.getContextData(), (Object)evt2.getContextData());
        Assert.assertEquals((Object)evt.getContextMap(), (Object)evt2.getContextMap());
        Assert.assertEquals((Object)evt.getContextStack(), (Object)evt2.getContextStack());
        Assert.assertEquals((Object)evt.getMessage(), (Object)evt2.getMessage());
        Assert.assertNotNull((Object)evt2.getSource());
        Assert.assertEquals((Object)evt.getSource(), (Object)evt2.getSource());
        Assert.assertEquals((Object)evt.getThreadName(), (Object)evt2.getThreadName());
        Assert.assertNull((Object)evt2.getThrown());
        Assert.assertNotNull((Object)evt2.getThrownProxy());
        Assert.assertEquals((Object)evt.getThrownProxy(), (Object)evt2.getThrownProxy());
        Assert.assertEquals((Object)evt.isEndOfBatch(), (Object)evt2.isEndOfBatch());
        Assert.assertEquals((Object)evt.isIncludeLocation(), (Object)evt2.isIncludeLocation());
        Assert.assertNotEquals((long)evt.getNanoTime(), (long)evt2.getNanoTime());
        Assert.assertEquals((long)0L, (long)evt2.getNanoTime());
    }

    private byte[] serialize(MutableLogEvent event) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(event);
        return arr.toByteArray();
    }

    private Log4jLogEvent deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = useObjectInputStream ? new ObjectInputStream(inArr) : new FilteredObjectInputStream((InputStream)inArr);
        Log4jLogEvent result = (Log4jLogEvent)in.readObject();
        return result;
    }
}

