/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.DynamicThresholdFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.ThreadContextMapRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DynamicThresholdFilterTest {
    @Rule
    public final ThreadContextMapRule threadContextRule = new ThreadContextMapRule();

    @After
    public void cleanup() {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
    }

    @Test
    public void testFilter() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("testuser", "DEBUG"), new KeyValuePair("JohnDoe", "warn")};
        DynamicThresholdFilter filter = DynamicThresholdFilter.createFilter((String)"userid", (KeyValuePair[])pairs, (Level)Level.ERROR, null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Object)null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, (Object)null, (Throwable)null));
        ThreadContext.clearMap();
        ThreadContext.put((String)"userid", (String)"JohnDoe");
        ThreadContext.put((String)"organization", (String)"apache");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test")).build();
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setLevel(Level.ERROR).setMessage((Message)new SimpleMessage("Test")).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        ThreadContext.clearMap();
    }

    @Test
    public void testFilterWorksWhenParamsArePassedAsArguments() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("testuser", "DEBUG"), new KeyValuePair("JohnDoe", "warn")};
        DynamicThresholdFilter filter = DynamicThresholdFilter.createFilter((String)"userid", (KeyValuePair[])pairs, (Level)Level.ERROR, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.NEUTRAL);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Object[] replacements = new Object[]{"one", "two", "three"};
        Assert.assertSame((Object)Filter.Result.ACCEPT, (Object)filter.filter(null, Level.DEBUG, null, "some test message", replacements));
        Assert.assertSame((Object)Filter.Result.ACCEPT, (Object)filter.filter(null, Level.DEBUG, null, "some test message", (Object)"one", (Object)"two", (Object)"three"));
        ThreadContext.clearMap();
    }

    @Test
    public void testConfig() {
        try (LoggerContext ctx = Configurator.initialize((String)"Test1", (String)"target/test-classes/log4j2-dynamicfilter.xml");){
            Configuration config = ctx.getConfiguration();
            Filter filter = config.getFilter();
            Assert.assertNotNull((String)"No DynamicThresholdFilter", (Object)filter);
            Assert.assertTrue((String)"Not a DynamicThresholdFilter", (boolean)(filter instanceof DynamicThresholdFilter));
            DynamicThresholdFilter dynamic = (DynamicThresholdFilter)filter;
            String key = dynamic.getKey();
            Assert.assertNotNull((String)"Key is null", (Object)key);
            Assert.assertEquals((String)"Incorrect key value", (Object)"loginId", (Object)key);
            Map map = dynamic.getLevelMap();
            Assert.assertNotNull((String)"Map is null", (Object)map);
            Assert.assertEquals((String)"Incorrect number of map elements", (long)1L, (long)map.size());
        }
    }
}

