/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.xml;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class XmlLoggerPropsTest {
    private static final String CONFIG = "log4j-loggerprops.xml";
    @Rule
    public final LoggerContextRule context = new LoggerContextRule("log4j-loggerprops.xml");

    @BeforeClass
    public static void setupClass() {
        System.setProperty("test", "test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithProps() {
        ListAppender listAppender = this.context.getListAppender("List");
        Assert.assertNotNull((String)"No List Appender", (Object)((Object)listAppender));
        try {
            Assert.assertThat((Object)this.context.getConfiguration(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(XmlConfiguration.class)));
            Logger logger = LogManager.getLogger(XmlLoggerPropsTest.class);
            logger.debug("Test with props");
            logger = LogManager.getLogger((String)"tiny.bubbles");
            logger.debug("Test on root");
            List<String> events = listAppender.getMessages();
            Assert.assertTrue((String)"No events", (events.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Incorrect number of events", (events.size() == 2 ? 1 : 0) != 0);
            Assert.assertThat((Object)events.get(0), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"user="), Matchers.containsString((String)"phrasex=****"), Matchers.containsString((String)"test=test"), Matchers.containsString((String)"test2=test2default"), Matchers.containsString((String)"test3=Unknown"), Matchers.containsString((String)"test4=test"), Matchers.containsString((String)"test5=test"), Matchers.containsString((String)"attribKey=attribValue"), Matchers.containsString((String)"duplicateKey=nodeValue")}));
            Assert.assertThat((Object)events.get(1), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"user="), Matchers.containsString((String)"phrasex=****"), Matchers.containsString((String)"test=test"), Matchers.containsString((String)"test2=test2default"), Matchers.containsString((String)"test3=Unknown"), Matchers.containsString((String)"test4=test"), Matchers.containsString((String)"test5=test"), Matchers.containsString((String)"attribKey=attribValue"), Matchers.containsString((String)"duplicateKey=nodeValue")}));
        }
        finally {
            System.clearProperty("test");
        }
    }
}

