/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.builder;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.CustomLevelConfig;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.CustomConfigurationFactory;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.GelfLayout;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationAssemblerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuildConfiguration() throws Exception {
        try {
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
            CustomConfigurationFactory.addTestFixtures("config name", (ConfigurationBuilder<BuiltConfiguration>)builder);
            Configuration configuration = (Configuration)builder.build();
            try (LoggerContext ctx = Configurator.initialize((Configuration)configuration);){
                this.validate(configuration);
            }
        }
        finally {
            System.getProperties().remove("Log4jContextSelector");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomConfigurationFactory() throws Exception {
        try {
            System.setProperty("log4j.configurationFactory", "org.apache.logging.log4j.core.config.builder.CustomConfigurationFactory");
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            Configuration config = ((LoggerContext)LogManager.getContext((boolean)false)).getConfiguration();
            this.validate(config);
        }
        finally {
            System.getProperties().remove("Log4jContextSelector");
            System.getProperties().remove("log4j.configurationFactory");
        }
    }

    private void validate(Configuration config) {
        Assert.assertNotNull((Object)config);
        Assert.assertNotNull((Object)config.getName());
        Assert.assertFalse((boolean)config.getName().isEmpty());
        Assert.assertNotNull((String)"No configuration created", (Object)config);
        Assert.assertEquals((String)("Incorrect State: " + config.getState()), (Object)config.getState(), (Object)LifeCycle.State.STARTED);
        Map appenders = config.getAppenders();
        Assert.assertNotNull((Object)appenders);
        Assert.assertTrue((String)("Incorrect number of Appenders: " + appenders.size()), (appenders.size() == 2 ? 1 : 0) != 0);
        KafkaAppender kafkaAppender = (KafkaAppender)appenders.get("Kafka");
        GelfLayout gelfLayout = (GelfLayout)kafkaAppender.getLayout();
        Map loggers = config.getLoggers();
        Assert.assertNotNull((Object)loggers);
        Assert.assertTrue((String)("Incorrect number of LoggerConfigs: " + loggers.size()), (loggers.size() == 2 ? 1 : 0) != 0);
        LoggerConfig rootLoggerConfig = (LoggerConfig)loggers.get("");
        Assert.assertEquals((Object)Level.ERROR, (Object)rootLoggerConfig.getLevel());
        Assert.assertFalse((boolean)rootLoggerConfig.isIncludeLocation());
        LoggerConfig loggerConfig = (LoggerConfig)loggers.get("org.apache.logging.log4j");
        Assert.assertEquals((Object)Level.DEBUG, (Object)loggerConfig.getLevel());
        Assert.assertTrue((boolean)loggerConfig.isIncludeLocation());
        Filter filter = config.getFilter();
        Assert.assertNotNull((String)"No Filter", (Object)filter);
        Assert.assertTrue((String)"Not a Threshold Filter", (boolean)(filter instanceof ThresholdFilter));
        List customLevels = config.getCustomLevels();
        Assert.assertNotNull((String)"No CustomLevels", (Object)filter);
        Assert.assertEquals((long)1L, (long)customLevels.size());
        CustomLevelConfig customLevel = (CustomLevelConfig)customLevels.get(0);
        Assert.assertEquals((Object)"Panic", (Object)customLevel.getLevelName());
        Assert.assertEquals((long)17L, (long)customLevel.getIntLevel());
        Logger logger = LogManager.getLogger(this.getClass());
        logger.info("Welcome to Log4j!");
    }
}

