/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;

@Plugin(name="Blocking", category="Core", elementType="appender", printObject=true)
public class BlockingAppender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    public List<LogEvent> logEvents = new CopyOnWriteArrayList<LogEvent>();
    public CountDownLatch countDownLatch = null;

    public BlockingAppender(String name) {
        super(name, null, null);
    }

    public void append(LogEvent event) {
        event.getMessage().getFormattedMessage();
        this.logEvents.add(Log4jLogEvent.createMemento((LogEvent)event));
        if (this.countDownLatch == null) {
            return;
        }
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @PluginFactory
    public static BlockingAppender createAppender(@PluginAttribute(value="name") @Required(message="No name provided for HangingAppender") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        return new BlockingAppender(name);
    }

    public void start() {
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        this.setStopped();
        return true;
    }
}

