/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.io.File;
import java.util.List;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RoutingAppenderWithPurgingTest {
    private static final String CONFIG = "log4j-routing-purge.xml";
    private static final String IDLE_LOG_FILE1 = "target/routing-purge-idle/routingtest-1.log";
    private static final String IDLE_LOG_FILE2 = "target/routing-purge-idle/routingtest-2.log";
    private static final String IDLE_LOG_FILE3 = "target/routing-purge-idle/routingtest-3.log";
    private static final String MANUAL_LOG_FILE1 = "target/routing-purge-manual/routingtest-1.log";
    private static final String MANUAL_LOG_FILE2 = "target/routing-purge-manual/routingtest-2.log";
    private static final String MANUAL_LOG_FILE3 = "target/routing-purge-manual/routingtest-3.log";
    private ListAppender app;
    private RoutingAppender routingAppenderIdle;
    private RoutingAppender routingAppenderIdleWithHangingAppender;
    private RoutingAppender routingAppenderManual;
    private final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing-purge.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFilesRule("target/routing-purge-idle/routingtest-1.log", "target/routing-purge-idle/routingtest-2.log", "target/routing-purge-idle/routingtest-3.log", "target/routing-purge-manual/routingtest-1.log", "target/routing-purge-manual/routingtest-2.log", "target/routing-purge-manual/routingtest-3.log");

    @Before
    public void setUp() throws Exception {
        this.app = this.loggerContextRule.getListAppender("List");
        this.routingAppenderIdle = this.loggerContextRule.getRequiredAppender("RoutingPurgeIdle", RoutingAppender.class);
        this.routingAppenderIdleWithHangingAppender = this.loggerContextRule.getRequiredAppender("RoutingPurgeIdleWithHangingAppender", RoutingAppender.class);
        this.routingAppenderManual = this.loggerContextRule.getRequiredAppender("RoutingPurgeManual", RoutingAppender.class);
    }

    @After
    public void tearDown() throws Exception {
        this.app.clear();
        this.loggerContextRule.getLoggerContext().stop();
    }

    @Test(timeout=5000L)
    public void routingTest() throws InterruptedException {
        StructuredDataMessage msg = new StructuredDataMessage("1", "This is a test 1", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        List<LogEvent> list = this.app.getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        msg = new StructuredDataMessage("2", "This is a test 2", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        msg = new StructuredDataMessage("3", "This is a test 3", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        String[] files = new String[]{IDLE_LOG_FILE1, IDLE_LOG_FILE2, IDLE_LOG_FILE3, MANUAL_LOG_FILE1, MANUAL_LOG_FILE2, MANUAL_LOG_FILE3};
        this.assertFileExistance(files);
        Assert.assertEquals((String)"Incorrect number of appenders with IdlePurgePolicy.", (long)3L, (long)this.routingAppenderIdle.getAppenders().size());
        Assert.assertEquals((String)"Incorrect number of appenders with IdlePurgePolicy with HangingAppender.", (long)3L, (long)this.routingAppenderIdleWithHangingAppender.getAppenders().size());
        Assert.assertEquals((String)"Incorrect number of appenders manual purge.", (long)3L, (long)this.routingAppenderManual.getAppenders().size());
        Thread.sleep(3000L);
        EventLogger.logEvent((StructuredDataMessage)msg);
        Assert.assertEquals((String)"Incorrect number of appenders with IdlePurgePolicy.", (long)1L, (long)this.routingAppenderIdle.getAppenders().size());
        Assert.assertEquals((String)"Incorrect number of appenders with manual purge.", (long)3L, (long)this.routingAppenderManual.getAppenders().size());
        this.routingAppenderManual.deleteAppender("1");
        this.routingAppenderManual.deleteAppender("2");
        this.routingAppenderManual.deleteAppender("3");
        Assert.assertEquals((String)"Incorrect number of appenders with IdlePurgePolicy.", (long)1L, (long)this.routingAppenderIdle.getAppenders().size());
        Assert.assertEquals((String)"Incorrect number of appenders with manual purge.", (long)0L, (long)this.routingAppenderManual.getAppenders().size());
        msg = new StructuredDataMessage("5", "This is a test 5", "Service");
        EventLogger.logEvent((StructuredDataMessage)msg);
        Assert.assertEquals((String)"Incorrect number of appenders with manual purge.", (long)1L, (long)this.routingAppenderManual.getAppenders().size());
        this.routingAppenderManual.deleteAppender("5");
        this.routingAppenderManual.deleteAppender("5");
        Assert.assertEquals((String)"Incorrect number of appenders with manual purge.", (long)0L, (long)this.routingAppenderManual.getAppenders().size());
    }

    private void assertFileExistance(String ... files) {
        for (String file : files) {
            Assert.assertTrue((String)("File should exist - " + file + " file "), (boolean)new File(file).exists());
        }
    }
}

