/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.categories.Scripts;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Scripts.Groovy.class})
public class RoutesScriptAppenderTest {
    @Rule
    public final LoggerContextRule loggerContextRule;
    private final boolean expectBindingEntries;

    @Parameterized.Parameters(name="{0} {1}")
    public static Object[][] getParameters() {
        return new Object[][]{{"log4j-routing-routes-script-groovy.xml", false}, {"log4j-routing-routes-script-javascript.xml", false}, {"log4j-routing-script-staticvars-javascript.xml", true}, {"log4j-routing-script-staticvars-groovy.xml", true}};
    }

    public RoutesScriptAppenderTest(String configLocation, boolean expectBindingEntries) {
        this.loggerContextRule = new LoggerContextRule(configLocation);
        this.expectBindingEntries = expectBindingEntries;
    }

    private void checkStaticVars() {
        RoutingAppender routingAppender = this.getRoutingAppender();
        ConcurrentMap map = routingAppender.getScriptStaticVariables();
        if (this.expectBindingEntries) {
            Assert.assertEquals((Object)"TestValue2", map.get("TestKey"));
            Assert.assertEquals((Object)"HEXDUMP", map.get("MarkerName"));
        }
    }

    private ListAppender getListAppender() {
        String key = "Service2";
        RoutingAppender routingAppender = this.getRoutingAppender();
        Assert.assertTrue((boolean)routingAppender.isStarted());
        Map appenders = routingAppender.getAppenders();
        AppenderControl appenderControl = (AppenderControl)appenders.get("Service2");
        Assert.assertNotNull((String)("No appender control generated for 'Service2'; appenders = " + appenders), (Object)appenderControl);
        ListAppender listAppender = (ListAppender)appenderControl.getAppender();
        return listAppender;
    }

    private RoutingAppender getRoutingAppender() {
        return this.loggerContextRule.getRequiredAppender("Routing", RoutingAppender.class);
    }

    private void logAndCheck() {
        Marker marker = MarkerManager.getMarker((String)"HEXDUMP");
        Logger logger = this.loggerContextRule.getLogger(RoutesScriptAppenderTest.class);
        logger.error("Hello");
        ListAppender listAppender = this.getListAppender();
        List<LogEvent> list = listAppender.getEvents();
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events. Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        logger.error("World");
        Assert.assertTrue((String)("Incorrect number of events. Expected 2, got " + list.size()), (list.size() == 2 ? 1 : 0) != 0);
        logger.error(marker, "DEADBEEF");
        Assert.assertTrue((String)("Incorrect number of events. Expected 3, got " + list.size()), (list.size() == 3 ? 1 : 0) != 0);
    }

    @Test(expected=AssertionError.class)
    public void testAppenderAbsence() {
        this.loggerContextRule.getListAppender("List1");
    }

    @Test
    public void testListAppenderPresence() {
        Assert.assertNull((String)"No appender control generated", this.getRoutingAppender().getAppenders().get("Service2"));
    }

    @Test
    public void testNoPurgePolicy() {
        Assert.assertNull((String)"Unexpected PurgePolicy", (Object)this.getRoutingAppender().getPurgePolicy());
    }

    @Test
    public void testNoRewritePolicy() {
        Assert.assertNull((String)"Unexpected RewritePolicy", (Object)this.getRoutingAppender().getRewritePolicy());
    }

    @Test
    public void testRoutingAppenderRoutes() {
        RoutingAppender routingAppender = this.getRoutingAppender();
        Assert.assertEquals((Object)this.expectBindingEntries, (Object)(routingAppender.getDefaultRouteScript() != null ? 1 : 0));
        Assert.assertEquals((Object)this.expectBindingEntries, (Object)(routingAppender.getDefaultRoute() != null ? 1 : 0));
        Routes routes = routingAppender.getRoutes();
        Assert.assertNotNull((Object)routes);
        Assert.assertNotNull((Object)routes.getPatternScript());
        LogEvent logEvent = DefaultLogEventFactory.getInstance().createEvent("", null, "", Level.ERROR, null, null, null);
        Assert.assertEquals((Object)"Service2", (Object)routes.getPattern(logEvent, new ConcurrentHashMap()));
    }

    @Test
    public void testRoutingAppenderPresence() {
        this.getRoutingAppender();
    }

    @Test
    public void testRoutingPresence1() {
        this.logAndCheck();
        this.checkStaticVars();
    }

    @Test
    public void testRoutingPresence2() {
        this.logAndCheck();
        this.checkStaticVars();
    }
}

