/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingRandomAccessFileManagerHeaderFooterTest {
    private static final String CONFIG = "RollingRandomAccessFileAppenderHeaderFooterTest.xml";
    private static final String DIR = "target/RollingRandomAccessFileAppenderHeaderFooterTest/";
    private static final String LOGFILE = "target/RollingRandomAccessFileAppenderHeaderFooterTest.log";
    public LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("RollingRandomAccessFileAppenderHeaderFooterTest.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/RollingRandomAccessFileAppenderHeaderFooterTest/");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = this.loggerContextRule.getLogger(RollingRandomAccessFileManagerHeaderFooterTest.class.getName());
    }

    @Ignore
    @Test
    public void testAppender() throws Exception {
        for (int i = 0; i < 8; ++i) {
            this.logger.debug("This is test message number " + i);
        }
        Thread.sleep(50L);
        File dir = new File(DIR);
        Assert.assertTrue((String)("Directory not created: " + dir), (boolean)dir.exists());
        Assert.assertTrue((String)("Directory empty: " + dir), (dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        for (File file : files) {
            this.assertHeader(file);
            this.assertFooter(file);
        }
        File logFile = new File(LOGFILE);
        Assert.assertTrue((String)"Expected logfile to exist: target/RollingRandomAccessFileAppenderHeaderFooterTest.log", (boolean)logFile.exists());
        this.assertHeader(logFile);
    }

    private void assertHeader(File file) throws Exception {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        String header = new String(layout.getHeader(), Charset.defaultCharset());
        String withoutTimestamp = header.substring(0, 435);
        String contents = new String(this.slurp(file), Charset.defaultCharset());
        String contentsInitialChunk = contents.substring(0, 435);
        Assert.assertEquals((String)file.getName(), (Object)withoutTimestamp, (Object)contentsInitialChunk);
    }

    private void assertFooter(File file) throws Exception {
        HtmlLayout layout = HtmlLayout.createDefaultLayout();
        String footer = new String(layout.getFooter(), Charset.defaultCharset());
        String contents = new String(this.slurp(file), Charset.defaultCharset());
        Assert.assertTrue((String)file.getName(), (boolean)contents.endsWith(footer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] slurp(File file) throws Exception {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] result = new byte[(int)file.length()];
            int pos = 0;
            int length = in.read(result);
            while (length > 0) {
                length = in.read(result, pos += length, result.length - pos);
            }
            byArray = result;
        }
        catch (Throwable throwable) {
            Closer.closeSilently(in);
            throw throwable;
        }
        Closer.closeSilently((AutoCloseable)in);
        return byArray;
    }
}

