/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RollingFileAppenderUpdateDataTest {
    private ConfigurationBuilder<BuiltConfiguration> buildConfigA() {
        return this.buildConfigurationBuilder("target/rolling-update-date/foo.log.%i");
    }

    private ConfigurationBuilder<BuiltConfiguration> buildConfigB() {
        return this.buildConfigurationBuilder("target/rolling-update-date/foo.log.%d{yyyy-MM-dd-HH:mm:ss}.%i");
    }

    private ConfigurationBuilder<BuiltConfiguration> buildConfigurationBuilder(String filePattern) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("LOG4J2-1964 demo");
        builder.setStatusLevel(Level.ERROR);
        builder.add((AppenderComponentBuilder)builder.newAppender("consoleLog", "Console").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_ERR));
        builder.add((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("fooAppender", "RollingFile").addAttribute("fileName", "target/rolling-update-date/foo.log")).addAttribute("filePattern", filePattern)).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "10MB")));
        builder.add((RootLoggerComponentBuilder)((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).add(builder.newAppenderRef("consoleLog"))).add(builder.newAppenderRef("fooAppender")));
        return builder;
    }

    @Test
    public void testClosingLoggerContext() {
        try (LoggerContext loggerContext1 = Configurator.initialize((Configuration)((Configuration)this.buildConfigA().build()));){
            this.validateAppender(loggerContext1, "target/rolling-update-date/foo.log.%i");
        }
        var2_2 = null;
        try (LoggerContext loggerContext2 = Configurator.initialize((Configuration)((Configuration)this.buildConfigB().build()));){
            this.validateAppender(loggerContext2, "target/rolling-update-date/foo.log.%d{yyyy-MM-dd-HH:mm:ss}.%i");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    @Ignore
    public void testNotClosingLoggerContext() {
        LoggerContext loggerContext1 = Configurator.initialize((Configuration)((Configuration)this.buildConfigA().build()));
        this.validateAppender(loggerContext1, "target-rolling-update-date/foo.log.%i");
        LoggerContext loggerContext2 = Configurator.initialize((Configuration)((Configuration)this.buildConfigB().build()));
        this.validateAppender(loggerContext2, "target/rolling-update-date/foo.log.%d{yyyy-MM-dd-HH:mm:ss}.%i");
    }

    private void validateAppender(LoggerContext loggerContext, String expectedFilePattern) {
        RollingFileAppender appender = (RollingFileAppender)loggerContext.getConfiguration().getAppender("fooAppender");
        Assert.assertNotNull((Object)appender);
        Assert.assertEquals((Object)expectedFilePattern, (Object)appender.getFilePattern());
        LogManager.getLogger((String)"root").info("just to show it works.");
    }
}

