/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.ConfigurationTestUtils;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class WriterAppenderTest {
    private static final String TEST_MSG = "FOO ERROR";
    @Rule
    public TestName testName = new TestName();

    private String getName(Writer writer) {
        return writer.getClass().getSimpleName() + "." + this.testName.getMethodName();
    }

    private void test(ByteArrayOutputStream out, Writer writer) throws SQLException {
        String name = this.getName(writer);
        this.addAppender(writer, name);
        Logger logger = LogManager.getLogger((String)name);
        logger.error(TEST_MSG);
        String actual = out.toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains(TEST_MSG));
    }

    private void test(Writer writer) throws SQLException {
        String name = this.getName(writer);
        this.addAppender(writer, name);
        Logger logger = LogManager.getLogger((String)name);
        logger.error(TEST_MSG);
        String actual = writer.toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains(TEST_MSG));
    }

    private void addAppender(Writer writer, String writerName) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.createDefaultLayout((Configuration)config);
        WriterAppender appender = WriterAppender.createAppender((StringLayout)layout, null, (Writer)writer, (String)writerName, (boolean)false, (boolean)true);
        appender.start();
        config.addAppender((Appender)appender);
        ConfigurationTestUtils.updateLoggers((Appender)appender, config);
    }

    @Test
    public void testWriterAppenderToCharArrayWriter() throws SQLException {
        this.test(new CharArrayWriter());
    }

    @Test
    public void testWriterAppenderToOutputStreamWriter() throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.test(out, writer);
    }

    @Test
    public void testWriterAppenderToPrintWriter() throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out);
        this.test(out, writer);
    }

    @Test
    public void testWriterAppenderToStringWriter() throws SQLException {
        this.test(new StringWriter());
    }
}

