/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.net.SocketException;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.SyslogAppender;
import org.apache.logging.log4j.core.appender.SyslogAppenderTestBase;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.mock.MockSyslogServerFactory;
import org.apache.logging.log4j.util.EnglishEnums;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SyslogAppenderTest
extends SyslogAppenderTestBase {
    public SyslogAppenderTest() {
        this.root = this.ctx.getLogger("SyslogAppenderTest");
    }

    @Before
    public void setUp() {
        this.sentMessages.clear();
    }

    @After
    public void teardown() {
        this.removeAppenders();
        if (this.syslogServer != null) {
            this.syslogServer.shutdown();
        }
    }

    @Test
    public void testTCPAppender() throws Exception {
        this.initTCPTestEnvironment(null);
        this.sendAndCheckLegacyBsdMessage("This is a test message");
        this.sendAndCheckLegacyBsdMessage("This is a test message 2");
    }

    @Test
    public void testDefaultAppender() throws Exception {
        this.initTCPTestEnvironment(null);
        this.sendAndCheckLegacyBsdMessage("This is a test message");
        this.sendAndCheckLegacyBsdMessage("This is a test message 2");
    }

    @Test
    public void testTCPStructuredAppender() throws Exception {
        this.initTCPTestEnvironment("RFC5424");
        this.sendAndCheckStructuredMessage();
    }

    @Test
    public void testUDPAppender() throws Exception {
        this.initUDPTestEnvironment("bsd");
        this.sendAndCheckLegacyBsdMessage("This is a test message");
        this.root.removeAppender((Appender)this.appender);
        this.appender.stop();
    }

    @Test
    public void testUDPStructuredAppender() throws Exception {
        this.initUDPTestEnvironment("RFC5424");
        this.sendAndCheckStructuredMessage();
        this.root.removeAppender((Appender)this.appender);
        this.appender.stop();
    }

    protected void initUDPTestEnvironment(String messageFormat) throws SocketException {
        this.syslogServer = MockSyslogServerFactory.createUDPSyslogServer(1, 8199);
        this.syslogServer.start();
        this.initAppender("udp", messageFormat);
    }

    protected void initTCPTestEnvironment(String messageFormat) throws IOException {
        this.syslogServer = MockSyslogServerFactory.createTCPSyslogServer(1, 8199);
        this.syslogServer.start();
        this.initAppender("tcp", messageFormat);
    }

    protected void initAppender(String transportFormat, String messageFormat) {
        this.appender = this.createAppender(transportFormat, messageFormat);
        this.validate(this.appender);
        this.appender.start();
        this.initRootLogger((Appender)this.appender);
    }

    protected SyslogAppender createAppender(String protocol, String format) {
        return this.newSyslogAppenderBuilder(protocol, format, this.includeNewLine).build();
    }

    protected SyslogAppender.Builder newSyslogAppenderBuilder(String protocol, String format, boolean newLine) {
        return ((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)((SyslogAppender.Builder)SyslogAppender.newSyslogAppenderBuilder().withPort(8199)).withProtocol((Protocol)EnglishEnums.valueOf(Protocol.class, (String)protocol))).withReconnectDelayMillis(-1)).withName("TestApp")).withIgnoreExceptions(false)).setId("Audit").setEnterpriseNumber(18060).setMdcId("RequestContext").setNewLine(newLine).setAppName("TestApp").setMsgId("Test").setFormat(format);
    }
}

