/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConfigurationTestUtils;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class OutputStreamAppenderTest {
    private static final String TEST_MSG = "FOO ERROR";
    @Rule
    public TestName testName = new TestName();

    private String getName(OutputStream out) {
        return out.getClass().getSimpleName() + "." + this.testName.getMethodName();
    }

    private void addAppender(OutputStream outputStream, String outputStreamName) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.createDefaultLayout((Configuration)config);
        OutputStreamAppender appender = OutputStreamAppender.createAppender((Layout)layout, null, (OutputStream)outputStream, (String)outputStreamName, (boolean)false, (boolean)true);
        appender.start();
        config.addAppender((Appender)appender);
        ConfigurationTestUtils.updateLoggers((Appender)appender, config);
    }

    @Test
    public void testOutputStreamAppenderToBufferedOutputStream() throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream os = new BufferedOutputStream(out);
        String name = this.getName(out);
        Logger logger = LogManager.getLogger((String)name);
        this.addAppender(os, name);
        logger.error(TEST_MSG);
        String actual = out.toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains(TEST_MSG));
    }

    @Test
    public void testOutputStreamAppenderToByteArrayOutputStream() throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String name = this.getName(out);
        Logger logger = LogManager.getLogger((String)name);
        this.addAppender(out, name);
        logger.error(TEST_MSG);
        String actual = ((Object)out).toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains(TEST_MSG));
    }

    @Test
    public void testUpdatePatternWithFileAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName("target/" + this.getClass().getName() + ".log").withAppend(false).withName("File")).withIgnoreExceptions(false)).withBufferedIo(false)).withBufferSize(4000)).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        ConfigurationTestUtils.updateLoggers((Appender)appender, config);
        LogManager.getLogger().error("FOO MSG");
    }
}

