/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="Hanging", category="Core", elementType="appender", printObject=true)
public class HangingAppender
extends AbstractAppender {
    private static final long serialVersionUID = 1L;
    private final long delay;
    private final long startupDelay;
    private final long shutdownDelay;

    public HangingAppender(String name, long delay, long startupDelay, long shutdownDelay) {
        super(name, null, null);
        this.delay = delay;
        this.startupDelay = startupDelay;
        this.shutdownDelay = shutdownDelay;
    }

    public void append(LogEvent event) {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @PluginFactory
    public static HangingAppender createAppender(@PluginAttribute(value="name") @Required(message="No name provided for HangingAppender") String name, @PluginAttribute(value="delay") long delay, @PluginAttribute(value="startupDelay") long startupDelay, @PluginAttribute(value="shutdownDelay") long shutdownDelay, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        return new HangingAppender(name, delay, startupDelay, shutdownDelay);
    }

    public void start() {
        try {
            Thread.sleep(this.startupDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.start();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        try {
            Thread.sleep(this.shutdownDelay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setStopped();
        return true;
    }
}

