/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.FileAppenderPermissionsTest;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class FileAppenderPermissionsXmlConfigTest {
    private static final String DIR = "target/permissions1";
    private static final String CONFIG = "log4j-posix.xml";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-posix.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/permissions1");

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeTrue((boolean)FileUtils.isFilePosixAttributeViewSupported());
    }

    @Test
    public void testFilePermissions() throws Exception {
        Logger logger = loggerContextRule.getLogger(FileAppenderPermissionsTest.class);
        for (int i = 0; i < 1000; ++i) {
            String message = "This is test message number " + i;
            logger.debug(message);
        }
        Assert.assertEquals((Object)"rw-------", (Object)PosixFilePermissions.toString(Files.getPosixFilePermissions(Paths.get("target/permissions1/AppenderTest-1.log", new String[0]), new LinkOption[0])));
    }
}

