/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.Strings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConsoleAppenderTest {
    private static final String LOG4J_SKIP_JANSI = "log4j.skipJansi";
    ByteArrayOutputStream baos;
    @Mock
    PrintStream psMock;

    @AfterClass
    public static void afterClass() {
        System.clearProperty(LOG4J_SKIP_JANSI);
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty(LOG4J_SKIP_JANSI, "true");
    }

    @Before
    public void before() {
        System.setProperty(LOG4J_SKIP_JANSI, "true");
        this.baos = new ByteArrayOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConsoleStreamManagerDoesNotClose(PrintStream ps, ConsoleAppender.Target targetName, SystemSetter systemSetter) {
        try {
            systemSetter.systemSet(this.psMock);
            PatternLayout layout = PatternLayout.newBuilder().withAlwaysWriteExceptions(true).build();
            ConsoleAppender app = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withLayout((Layout)layout)).setTarget(targetName).withName("Console")).withIgnoreExceptions(false)).build();
            app.start();
            Assert.assertTrue((String)"Appender did not start", (boolean)app.isStarted());
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(ConsoleAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).build();
            app.append((LogEvent)event);
            app.stop();
            Assert.assertFalse((String)"Appender did not stop", (boolean)app.isStarted());
        }
        finally {
            systemSetter.systemSet(ps);
        }
        ((PrintStream)BDDMockito.then((Object)this.psMock).should(Mockito.atLeastOnce())).write((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((PrintStream)BDDMockito.then((Object)this.psMock).should(Mockito.atLeastOnce())).flush();
    }

    @Test
    public void testFollowSystemErr() {
        this.testFollowSystemPrintStream(System.err, ConsoleAppender.Target.SYSTEM_ERR, SystemSetter.SYSTEM_ERR);
    }

    @Test
    public void testFollowSystemOut() {
        this.testFollowSystemPrintStream(System.out, ConsoleAppender.Target.SYSTEM_OUT, SystemSetter.SYSTEM_OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowSystemPrintStream(PrintStream ps, ConsoleAppender.Target target, SystemSetter systemSetter) {
        ConsoleAppender app = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setTarget(target).setFollow(true).withIgnoreExceptions(false)).withName("test")).build();
        Assert.assertEquals((Object)target, (Object)app.getTarget());
        app.start();
        try {
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("TestLogger").setLoggerFqcn(ConsoleAppenderTest.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Test")).build();
            Assert.assertTrue((String)"Appender did not start", (boolean)app.isStarted());
            systemSetter.systemSet(new PrintStream(this.baos));
            try {
                app.append((LogEvent)event);
            }
            finally {
                systemSetter.systemSet(ps);
            }
            String msg = this.baos.toString();
            Assert.assertNotNull((String)"No message", (Object)msg);
            Assert.assertTrue((String)("Incorrect message: \"" + msg + "\""), (boolean)msg.endsWith("Test" + Strings.LINE_SEPARATOR));
        }
        finally {
            app.stop();
        }
        Assert.assertFalse((String)"Appender did not stop", (boolean)app.isStarted());
    }

    @Test
    public void testSystemErrStreamManagerDoesNotClose() {
        this.testConsoleStreamManagerDoesNotClose(System.err, ConsoleAppender.Target.SYSTEM_ERR, SystemSetter.SYSTEM_ERR);
    }

    @Test
    public void testSystemOutStreamManagerDoesNotClose() {
        this.testConsoleStreamManagerDoesNotClose(System.out, ConsoleAppender.Target.SYSTEM_OUT, SystemSetter.SYSTEM_OUT);
    }

    private static enum SystemSetter {
        SYSTEM_OUT{

            @Override
            void systemSet(PrintStream printStream) {
                System.setOut(printStream);
            }
        }
        ,
        SYSTEM_ERR{

            @Override
            void systemSet(PrintStream printStream) {
                System.setErr(printStream);
            }
        };


        abstract void systemSet(PrintStream var1);
    }
}

