/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EventParameterMemoryLeakTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.configurationFile", "EventParameterMemoryLeakTest.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParametersAreNotLeaked() throws Exception {
        File file = new File("target", "EventParameterMemoryLeakTest.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        CountDownLatch latch = new CountDownLatch(1);
        ParameterObject parameter = new ParameterObject("paramValue", latch);
        log.info("Message with parameter {}", (Object)parameter);
        log.info((Object)parameter);
        log.info("test", (Throwable)new ObjectThrowable(parameter));
        log.info("test {}", (Object)"hello", (Object)new ObjectThrowable(parameter));
        parameter = null;
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        String line3 = reader.readLine();
        String line4 = reader.readLine();
        String line5 = reader.readLine();
        reader.close();
        file.delete();
        MatcherAssert.assertThat((Object)line1, (Matcher)Matchers.containsString((String)"Message with parameter paramValue"));
        MatcherAssert.assertThat((Object)line2, (Matcher)Matchers.containsString((String)"paramValue"));
        MatcherAssert.assertThat((Object)line3, (Matcher)Matchers.containsString((String)"paramValue"));
        MatcherAssert.assertThat((Object)line4, (Matcher)Matchers.containsString((String)"paramValue"));
        Assert.assertNull((String)"Expected only three lines", (Object)line5);
        gcHelper.run();
        try (GarbageCollectionHelper gcHelper = new GarbageCollectionHelper();){
            Assert.assertTrue((String)"Parameter should have been garbage collected", (boolean)latch.await(30L, TimeUnit.SECONDS));
        }
    }

    private static final class GarbageCollectionHelper
    implements Closeable,
    Runnable {
        private static final OutputStream sink = ByteStreams.nullOutputStream();
        public final AtomicBoolean running = new AtomicBoolean();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Thread gcThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (GarbageCollectionHelper.this.running.get()) {
                        try {
                            sink.write(new byte[0x100000]);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        System.gc();
                    }
                }
                finally {
                    GarbageCollectionHelper.this.latch.countDown();
                }
            }
        });

        private GarbageCollectionHelper() {
        }

        @Override
        public void run() {
            if (this.running.compareAndSet(false, true)) {
                this.gcThread.start();
            }
        }

        @Override
        public void close() {
            this.running.set(false);
            try {
                Assert.assertTrue((String)"GarbageCollectionHelper did not shut down cleanly", (boolean)this.latch.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class ObjectThrowable
    extends RuntimeException {
        private final Object object;

        ObjectThrowable(Object object) {
            super(String.valueOf(object));
            this.object = object;
        }

        @Override
        public String toString() {
            return "ObjectThrowable " + this.object;
        }
    }

    private static final class ParameterObject {
        private final String value;
        private final CountDownLatch latch;

        ParameterObject(String value, CountDownLatch latch) {
            this.value = value;
            this.latch = latch;
        }

        public String toString() {
            return this.value;
        }

        protected void finalize() throws Throwable {
            this.latch.countDown();
            super.finalize();
        }
    }
}

