/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractDriverManagerConnectionSource;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="PoolingDriver", category="Core", elementType="connectionSource", printObject=true)
public final class PoolingDriverConnectionSource
extends AbstractDriverManagerConnectionSource {
    public static final String URL_PREFIX = "jdbc:apache:commons:dbcp:";
    private final String poolingDriverClassName = "org.apache.commons.dbcp2.PoolingDriver";
    private final String poolName;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newPoolingDriverConnectionSourceBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public PoolingDriverConnectionSource(String driverClassName, String connectionString, char[] userName, char[] password, Property[] properties, String poolName) throws SQLException {
        super(driverClassName, connectionString, URL_PREFIX + poolName, userName, password, properties);
        this.poolName = poolName;
        this.setupDriver(connectionString);
    }

    public String getActualConnectionString() {
        return super.getActualConnectionString();
    }

    private PoolingDriver getPoolingDriver() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(URL_PREFIX);
        if (driver == null) {
            PoolingDriverConnectionSource.getLogger().error("No JDBC driver for '{}'", (Object)URL_PREFIX);
        }
        return driver;
    }

    private void setupDriver(String connectionString) throws SQLException {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectionString, null);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        this.loadDriver("org.apache.commons.dbcp2.PoolingDriver");
        PoolingDriver driver = this.getPoolingDriver();
        if (driver != null) {
            PoolingDriverConnectionSource.getLogger().debug("Registering DBCP pool '{}'", (Object)this.poolName);
            driver.registerPool(this.poolName, (ObjectPool)connectionPool);
        }
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        try {
            PoolingDriver driver = this.getPoolingDriver();
            if (driver != null) {
                PoolingDriverConnectionSource.getLogger().debug("Closing DBCP pool '{}'", (Object)this.poolName);
                driver.closePool(this.poolName);
            }
            return true;
        }
        catch (Exception e) {
            PoolingDriverConnectionSource.getLogger().error("Exception stopping connection source for '{}' \u2192 '{}'", (Object)this.getConnectionString(), (Object)this.getActualConnectionString(), (Object)e);
            return false;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractDriverManagerConnectionSource.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<PoolingDriverConnectionSource> {
        public static final String DEFAULT_POOL_NAME = "example";
        private String poolName = "example";

        public PoolingDriverConnectionSource build() {
            try {
                return new PoolingDriverConnectionSource(this.getDriverClassName(), this.getConnectionString(), this.getUserName(), this.getPassword(), this.getProperties(), this.poolName);
            }
            catch (SQLException e) {
                AbstractDriverManagerConnectionSource.getLogger().error("Exception constructing {} to '{}'", ((Object)((Object)this)).getClass(), (Object)this.getConnectionString(), (Object)e);
                return null;
            }
        }

        public B setPoolName(String poolName) {
            this.poolName = poolName;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

