/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.junit.AbstractExternalFileCleaner;

public class CleanFolders
extends AbstractExternalFileCleaner {
    private static final int MAX_TRIES = 10;

    public CleanFolders(boolean before, boolean after, int maxTries, File ... files) {
        super(before, after, maxTries, null, files);
    }

    public CleanFolders(boolean before, boolean after, int maxTries, String ... fileNames) {
        super(before, after, maxTries, null, fileNames);
    }

    public CleanFolders(File ... folders) {
        super(true, true, 10, null, folders);
    }

    public CleanFolders(Logger logger, File ... folders) {
        super(true, true, 10, logger, folders);
    }

    public CleanFolders(Path ... paths) {
        super(true, true, 10, null, paths);
    }

    public CleanFolders(String ... folderNames) {
        super(true, true, 10, null, folderNames);
    }

    private void cleanFolder(Path folder, int tryIndex) throws IOException {
        if (Files.exists(folder, new LinkOption[0]) && Files.isDirectory(folder, new LinkOption[0])) {
            Files.walkFileTree(folder, new DeleteAllFileVisitor(this.getLogger()));
        }
    }

    @Override
    protected boolean clean(Path path, int tryIndex) throws IOException {
        this.cleanFolder(path, tryIndex);
        return true;
    }

    public static final class DeleteAllFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Logger logger;

        public DeleteAllFileVisitor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (this.logger != null) {
                this.logger.debug(AbstractExternalFileCleaner.CLEANER_MARKER, "Deleting directory {}", (Object)dir);
            }
            boolean deleted = Files.deleteIfExists(dir);
            if (this.logger != null) {
                this.logger.debug(AbstractExternalFileCleaner.CLEANER_MARKER, "Deleted directory {}: {}", (Object)dir, (Object)deleted);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.logger != null) {
                this.logger.debug(AbstractExternalFileCleaner.CLEANER_MARKER, "Deleting file {} with {}", (Object)file, (Object)attrs);
            }
            boolean deleted = Files.deleteIfExists(file);
            if (this.logger != null) {
                this.logger.debug(AbstractExternalFileCleaner.CLEANER_MARKER, "Deleted file {}: {}", (Object)file, (Object)deleted);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

