/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.junit;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public abstract class AbstractExternalFileCleaner
extends ExternalResource {
    protected static final Marker CLEANER_MARKER = MarkerManager.getMarker((String)"CLEANER");
    private static final int SLEEP_RETRY_MILLIS = 200;
    private final boolean cleanAfter;
    private final boolean cleanBefore;
    private final Set<Path> files;
    private final int maxTries;
    private final Logger logger;

    public AbstractExternalFileCleaner(boolean before, boolean after, int maxTries, Logger logger, File ... files) {
        this.cleanBefore = before;
        this.cleanAfter = after;
        this.maxTries = maxTries;
        this.files = new HashSet<Path>(files.length);
        this.logger = logger;
        for (File file : files) {
            this.files.add(file.toPath());
        }
    }

    public AbstractExternalFileCleaner(boolean before, boolean after, int maxTries, Logger logger, Path ... files) {
        this.cleanBefore = before;
        this.cleanAfter = after;
        this.maxTries = maxTries;
        this.logger = logger;
        this.files = new HashSet<Path>(Arrays.asList(files));
    }

    public AbstractExternalFileCleaner(boolean before, boolean after, int maxTries, Logger logger, String ... fileNames) {
        this.cleanBefore = before;
        this.cleanAfter = after;
        this.maxTries = maxTries;
        this.logger = logger;
        this.files = new HashSet<Path>(fileNames.length);
        for (String fileName : fileNames) {
            this.files.add(Paths.get(fileName, new String[0]));
        }
    }

    protected void after() {
        if (this.cleanAfter()) {
            this.clean();
        }
    }

    protected void before() {
        if (this.cleanBefore()) {
            this.clean();
        }
    }

    protected void clean() {
        HashMap<Path, IOException> failures = new HashMap<Path, IOException>();
        block4: for (Path path : this.getPaths()) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            for (int i = 0; i < this.getMaxTries(); ++i) {
                try {
                    if (this.clean(path, i)) {
                        if (!failures.containsKey(path)) continue block4;
                        failures.remove(path);
                        continue block4;
                    }
                }
                catch (IOException e) {
                    if (this.logger != null) {
                        this.logger.error("Caught exception cleaning {}", (Object)this, (Object)e);
                    }
                    failures.put(path, e);
                }
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (failures.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry failure : failures.entrySet()) {
                ((IOException)failure.getValue()).printStackTrace();
                if (!first) {
                    sb.append(", ");
                }
                sb.append(failure.getKey()).append(" failed with ").append(failure.getValue());
                first = false;
            }
            Assert.fail((String)sb.toString());
        }
    }

    protected abstract boolean clean(Path var1, int var2) throws IOException;

    public boolean cleanAfter() {
        return this.cleanAfter;
    }

    public boolean cleanBefore() {
        return this.cleanBefore;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public Set<Path> getPaths() {
        return this.files;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [files=" + this.files + ", cleanAfter=" + this.cleanAfter + ", cleanBefore=" + this.cleanBefore + "]";
    }
}

