/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.CachedClock;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.CoarseCachedClock;
import org.apache.logging.log4j.core.util.SystemClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClockFactoryTest {
    public static void resetClocks() throws IllegalAccessException {
        ClockFactoryTest.resetClock(Log4jLogEvent.class);
        ClockFactoryTest.resetClock(AsyncLogger.class);
    }

    public static void resetClock(Class<?> clazz) throws IllegalAccessException {
        System.clearProperty("log4j.Clock");
        Field field = FieldUtils.getField(clazz, (String)"CLOCK", (boolean)true);
        FieldUtils.removeFinalModifier((Field)field, (boolean)true);
        FieldUtils.writeStaticField((Field)field, (Object)ClockFactory.getClock(), (boolean)false);
    }

    @Before
    public void setUp() throws Exception {
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testDefaultIsSystemClock() {
        System.clearProperty("log4j.Clock");
        Assert.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifySystemClockShort() {
        System.setProperty("log4j.Clock", "SystemClock");
        Assert.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifySystemClockLong() {
        System.setProperty("log4j.Clock", SystemClock.class.getName());
        Assert.assertSame(SystemClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCachedClockShort() {
        System.setProperty("log4j.Clock", "CachedClock");
        Assert.assertSame(CachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCachedClockLong() {
        System.setProperty("log4j.Clock", CachedClock.class.getName());
        Assert.assertSame(CachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCoarseCachedClockShort() {
        System.setProperty("log4j.Clock", "CoarseCachedClock");
        Assert.assertSame(CoarseCachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testSpecifyCoarseCachedClockLong() {
        System.setProperty("log4j.Clock", CoarseCachedClock.class.getName());
        Assert.assertSame(CoarseCachedClock.class, ClockFactory.getClock().getClass());
    }

    @Test
    public void testCustomClock() {
        System.setProperty("log4j.Clock", MyClock.class.getName());
        Assert.assertSame(MyClock.class, ClockFactory.getClock().getClass());
    }

    public static class MyClock
    implements Clock {
        public long currentTimeMillis() {
            return 42L;
        }
    }
}

