/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;

@CommandLine.Command(name="picocli.Demo", sortOptions=false, header={"@|green        .__                    .__  .__ |@", "@|green ______ |__| ____  ____   ____ |  | |__||@", "@|green \\____ \\|  |/ ___\\/  _ \\_/ ___\\|  | |  ||@", "@|green |  |_> >  \\  \\__(  <_> )  \\___|  |_|  ||@", "@|green |   __/|__|\\___  >____/ \\___  >____/__||@", "@|green |__|           \\/           \\/         |@", ""}, description={"", "Demonstrates picocli subcommands parsing and usage help."}, optionListHeading="@|bold %nOptions|@:%n", footer={"", "@|bold VM Options|@:", "Run with @|yellow -ea|@ to enable assertions used in the tests.", "Run with @|yellow -Dpicocli.ansi|@=@|italic true|@ to force picocli to use ansi codes,", " or with @|yellow -Dpicocli.ansi|@=@|italic false|@ to force picocli to NOT use ansi codes.", "(By default picocli will use ansi codes if the platform supports it.)", "", "@|cyan If you would like to contribute or report an issue|@", "@|cyan go to github: https://github.com/remkop/picocli|@", "", "@|cyan If you like the project star it on github and follow me on twitter!|@", "@|cyan This project is created and maintained by Remko Popma (@remkopopma)|@", ""})
public class Demo
implements Runnable {
    @CommandLine.Option(names={"-a", "--autocomplete"}, description={"Generate sample autocomplete script for git"})
    private boolean autocomplete;
    @CommandLine.Option(names={"-1", "--showUsageForSubcommandGitCommit"}, description={"Shows usage help for the git-commit subcommand"})
    private boolean showUsageForSubcommandGitCommit;
    @CommandLine.Option(names={"-2", "--showUsageForMainCommand"}, description={"Shows usage help for a command with subcommands"})
    private boolean showUsageForMainCommand;
    @CommandLine.Option(names={"-3", "--showUsageForSubcommandGitStatus"}, description={"Shows usage help for the git-status subcommand"})
    private boolean showUsageForSubcommandGitStatus;
    @CommandLine.Option(names={"--simple"}, description={"Show help for the first simple Example in the manual"})
    private boolean showSimpleExample;
    @CommandLine.Option(names={"--mixed"}, hidden=true, description={"Show help with mixed Ansi colors and styles in description"})
    private boolean showAnsiInDescription;
    @CommandLine.Option(names={"-i", "--index"}, description={"@|fg(21) S|@@|fg(57) h|@@|fg(93) o|@@|fg(129) w|@@|fg(129)  |@@|fg(165) 2|@@|fg(201) 5|@@|fg(225) 6|@@|fg(123)  |@@|fg(122) c|@@|fg(120) o|@@|fg(118) l|@@|fg(148) o|@@|fg(142) r|@@|fg(136)  |@@|fg(136) p|@@|fg(130) a|@@|fg(124) l|@@|fg(160) e|@@|fg(196) t|@@|fg(198) t|@@|fg(199) e|@@|fg(200)  |@@|fg(201) i|@@|fg(213) n|@@|fg(219) d|@@|fg(225) e|@@|fg(231) x|@@|fg(230)  |@@|fg(229) v|@@|fg(228) a|@@|fg(227) l|@@|fg(226) u|@@|fg(190) e|@@|fg(154) s|@"})
    private boolean showIndexedColorPalette;
    @CommandLine.Option(names={"-r", "--rgb"}, description={"@|fg(0;0;5) S|@@|fg(1;0;5) h|@@|fg(2;0;5) o|@@|fg(3;0;5) w|@@|fg(3;0;5)  |@@|fg(4;0;5) 2|@@|fg(5;0;5) 5|@@|fg(5;4;5) 6|@@|fg(2;5;5)  |@@|fg(2;5;4) c|@@|fg(2;5;2) o|@@|fg(2;5;0) l|@@|fg(3;4;0) o|@@|fg(3;3;0) r|@@|fg(3;2;0)  |@@|fg(3;2;0) p|@@|fg(3;1;0) a|@@|fg(3;0;0) l|@@|fg(4;0;0) e|@@|fg(5;0;0) t|@@|fg(5;0;2) t|@@|fg(5;0;3) e|@@|fg(5;0;4)  |@@|fg(5;0;5) R|@@|fg(5;2;5) G|@@|fg(5;3;5) B|@@|fg(5;4;5)  |@@|fg(5;5;5) c|@@|fg(5;5;4) o|@@|fg(5;5;3) m|@@|fg(5;5;2) p|@@|fg(5;5;1) o|@@|fg(5;5;0) n|@@|fg(4;5;0) e|@@|fg(3;5;0) n|@@|fg(2;5;0) t|@@|fg(1;5;0)  |@@|fg(1;5;0) v|@@|fg(0;5;0) a|@@|fg(0;4;0) l|@@|fg(0;3;0) u|@@|fg(0;2;0) e|@@|fg(0;1;0) s|@"})
    private boolean showRgbColorPalette;
    @CommandLine.Option(names={"-t", "--tests"}, description={"Runs all tests in this class"})
    private boolean runTests;
    static final String EXPECTED_USAGE_MAIN = "Usage: git [-hV] [--git-dir=<gitDir>]%nGit is a fast, scalable, distributed revision control system with an unusually%nrich command set that provides both high-level operations and full access to%ninternals.%n  -V, --version               Prints version information and exits%n  -h, --help                  Prints this help message and exits%n      --git-dir=<gitDir>      Set the path to the repository%n%nCommands:%n%nThe most commonly used git commands are:%n  status    Show the working tree status.%n  commit    Record changes to the repository.%n  add       Add file contents to the index.%n  branch    List, create, or delete branches.%n  checkout  Checkout a branch or paths to the working tree.%n  clone     Clone a repository into a new directory.%n  diff      Show changes between commits, commit and working tree, etc.%n  merge     Join two or more development histories together.%n  push      Update remote refs along with associated objects.%n  rebase    Forward-port local commits to the updated upstream head.%n  tag       Create, list, delete or verify a tag object signed with GPG.%n";
    static final String EXPECTED_USAGE_MAIN_ANSI = "Usage: @|bold git|@ [@|yellow -hV|@] [@|yellow --git-dir|@=@|italic <gitDir>|@]%nGit is a fast, scalable, distributed revision control system with an unusually%nrich command set that provides both high-level operations and full access to%ninternals.%n  @|yellow -V|@, @|yellow --version|@               Prints version information and exits%n  @|yellow -h|@, @|yellow --help|@                  Prints this help message and exits%n      @|yellow --git-dir|@=@|italic <gitDir>|@      Set the path to the repository%n%nCommands:%n%nThe most commonly used git commands are:%n  @|bold status|@    Show the working tree status.%n  @|bold commit|@    Record changes to the repository.%n  @|bold add|@       Add file contents to the index.%n  @|bold branch|@    List, create, or delete branches.%n  @|bold checkout|@  Checkout a branch or paths to the working tree.%n  @|bold clone|@     Clone a repository into a new directory.%n  @|bold diff|@      Show changes between commits, commit and working tree, etc.%n  @|bold merge|@     Join two or more development histories together.%n  @|bold push|@      Update remote refs along with associated objects.%n  @|bold rebase|@    Forward-port local commits to the updated upstream head.%n  @|bold tag|@       Create, list, delete or verify a tag object signed with GPG.%n";
    static final String EXPECTED_USAGE_GITSTATUS = "Show the working tree status.%nUsage: git-status [<options>...] [--] [<pathspec>...]%nDisplays paths that have differences between the index file and the current%nHEAD commit, paths that have differences between the working tree and the index%nfile, and paths in the working tree that are not tracked by Git (and are not%nignored by gitignore(5)). The first are what you would commit by running git%ncommit; the second and third are what you could commit by running git add%nbefore running git commit.%n      --ignored               Show ignored files as well%n  -b, --branch                Show the branch and tracking info even in%n                                short-format%n  -s, --short                 Give the output in the short-format%n  -u, --untracked=<mode>      Show untracked files.%n                              The mode parameter is optional (defaults to%n                                `all`), and is used to specify the handling of%n                                untracked files.%n                              The possible options are:%n                               * no - Show no untracked files.%n                               * normal - Shows untracked files and directories.%n                               * all - Also shows individual files in untracked%n                                directories.%n                                Default: all%n";
    static final String EXPECTED_USAGE_GITSTATUS_ANSI = "Show the working tree status.%nUsage: @|bold git-status|@ [@|yellow <options>|@...] [--] [@|yellow <pathspec>|@...]%nDisplays paths that have differences between the index file and the current%nHEAD commit, paths that have differences between the working tree and the index%nfile, and paths in the working tree that are not tracked by Git (and are not%nignored by gitignore(5)). The first are what you would commit by running git%ncommit; the second and third are what you could commit by running git add%nbefore running git commit.%n      @|yellow --ignored|@               Show ignored files as well%n  @|yellow -b|@, @|yellow --branch|@                Show the branch and tracking info even in%n                                short-format%n  @|yellow -s|@, @|yellow --short|@                 Give the output in the short-format%n  @|yellow -u|@, @|yellow --untracked|@=@|italic <mode>|@      Show untracked files.%n                              The mode parameter is optional (defaults to%n                                `all`), and is used to specify the handling of%n                                untracked files.%n                              The possible options are:%n                               * @|yellow no|@ - Show no untracked files.%n                               * @|yellow normal|@ - Shows untracked files and directories.%n                               * @|yellow all|@ - Also shows individual files in untracked%n                                directories.%n                                Default: all%n";
    static final String EXPECTED_USAGE_GITCOMMIT = "Usage:%n%nRecord changes to the repository.%n%ngit-commit [-ap] [--fixup=<commit>] [--squash=<commit>] [-c=<commit>]%n           [-C=<commit>] [-F=<file>] [-m=<msg>]... [<files>]...%n%nDescription:%n%nStores the current contents of the index in a new commit along with a log%nmessage from the user describing the changes.%n%nParameters:%n      [<files>]...            the files to commit%n%nOptions:%n  -a, --all                   Tell the command to automatically stage files%n                                that have been modified and deleted, but new%n                                files you have not told Git about are not%n                                affected.%n  -p, --patch                 Use the interactive patch selection interface to%n                                chose which changes to commit%n  -C, --reuse-message=<commit>%n                              Take an existing commit object, and reuse the log%n                                message and the authorship information%n                                (including the timestamp) when creating the%n                                commit.%n  -c, --reedit-message=<commit>%n                              Like -C, but with -c the editor is invoked, so%n                                that the user canfurther edit the commit%n                                message.%n      --fixup=<commit>        Construct a commit message for use with rebase%n                                --autosquash.%n      --squash=<commit>       Construct a commit message for use with rebase%n                                --autosquash. The commitmessage subject line is%n                                taken from the specified commit with a prefix%n                                of \"squash! \". Can be used with additional%n                                commit message options (-m/-c/-C/-F).%n  -F, --file=<file>           Take the commit message from the given file. Use%n                                - to read the message from the standard input.%n  -m, --message=<msg>         Use the given <msg> as the commit message. If%n                                multiple -m options are given, their values are%n                                concatenated as separate paragraphs.%n";
    static final String EXPECTED_USAGE_GITCOMMIT_ANSI = "@|bold,underline Usage:|@%n%nRecord changes to the repository.%n%n@|bold git-commit|@ [@|yellow -ap|@] [@|yellow --fixup|@=@|italic <commit>|@] [@|yellow --squash|@=@|italic <commit>|@] [@|yellow -c|@=@|italic <commit>|@]%n           [@|yellow -C|@=@|italic <commit>|@] [@|yellow -F|@=@|italic <file>|@] [@|yellow -m|@=@|italic <msg>|@]... [@|yellow <files>|@]...%n%n@|bold,underline Description:|@%n%nStores the current contents of the index in a new commit along with a log%nmessage from the user describing the changes.%n%n@|bold,underline Parameters:|@%n      [@|yellow <files>|@]...            the files to commit%n%n@|bold,underline Options:|@%n  @|yellow -a|@, @|yellow --all|@                   Tell the command to automatically stage files%n                                that have been modified and deleted, but new%n                                files you have not told Git about are not%n                                affected.%n  @|yellow -p|@, @|yellow --patch|@                 Use the interactive patch selection interface to%n                                chose which changes to commit%n  @|yellow -C|@, @|yellow --reuse-message|@=@|italic <commit|@@|italic >|@%n                              Take an existing commit object, and reuse the log%n                                message and the authorship information%n                                (including the timestamp) when creating the%n                                commit.%n  @|yellow -c|@, @|yellow --reedit-message|@=@|italic <commi|@@|italic t>|@%n                              Like -C, but with -c the editor is invoked, so%n                                that the user canfurther edit the commit%n                                message.%n      @|yellow --fixup|@=@|italic <commit>|@        Construct a commit message for use with rebase%n                                --autosquash.%n      @|yellow --squash|@=@|italic <commit>|@       Construct a commit message for use with rebase%n                                --autosquash. The commitmessage subject line is%n                                taken from the specified commit with a prefix%n                                of \"squash! \". Can be used with additional%n                                commit message options (-m/-c/-C/-F).%n  @|yellow -F|@, @|yellow --file|@=@|italic <file>|@           Take the commit message from the given file. Use%n                                - to read the message from the standard input.%n  @|yellow -m|@, @|yellow --message|@=@|italic <msg>|@         Use the given <msg> as the commit message. If%n                                multiple -m options are given, their values are%n                                concatenated as separate paragraphs.%n";

    public static void main(String[] args) {
        CommandLine.run((Runnable)new Demo(), (PrintStream)System.err, (String[])args);
    }

    @Override
    public void run() {
        if (!(this.runTests || this.showSimpleExample || this.showAnsiInDescription || this.showIndexedColorPalette || this.showRgbColorPalette || this.showUsageForMainCommand || this.showUsageForSubcommandGitCommit || this.showUsageForSubcommandGitStatus || this.autocomplete)) {
            CommandLine.usage((Object)this, (PrintStream)System.err);
            return;
        }
        if (this.runTests) {
            Demo.testParseSubCommands();
            System.out.println("Ran tests OK.");
        }
        if (this.showSimpleExample) {
            this.showSimpleExampleUsage();
        }
        if (this.showAnsiInDescription) {
            this.showAnsiInDescription();
        }
        if (this.showIndexedColorPalette) {
            this.showIndexedColorPalette();
        }
        if (this.showRgbColorPalette) {
            this.showRgbColorPalette();
        }
        if (this.showUsageForMainCommand) {
            this.testUsageMainCommand();
        }
        if (this.showUsageForSubcommandGitStatus) {
            this.testUsageSubCommandStatus();
        }
        if (this.showUsageForSubcommandGitCommit) {
            this.testUsageSubCommandCommit();
        }
    }

    private void showSimpleExampleUsage() {
        class Example {
            @CommandLine.Option(names={"-v", "--verbose"}, description={"Be verbose."})
            private boolean verbose = false;
            @CommandLine.Option(names={"-h", "--help"}, help=true, description={"Displays this help message and quits."})
            private boolean helpRequested = false;
            @CommandLine.Parameters(arity="1..*", paramLabel="FILE", description={"File(s) to process."})
            private File[] inputFiles;

            Example() {
            }
        }
        CommandLine.usage((Object)new Example(), (PrintStream)System.out);
    }

    private void showAnsiInDescription() {
        @CommandLine.Command(description={"Custom @|bold,underline styles|@ and @|fg(red) colors|@."})
        class AnsiDescription {
            AnsiDescription() {
            }
        }
        CommandLine.usage((Object)new AnsiDescription(), (PrintStream)System.out);
    }

    private void showIndexedColorPalette() {
        int[] foregroundBackground;
        for (int fbg : foregroundBackground = new int[]{38, 48}) {
            int col;
            int b;
            int g;
            int r;
            for (r = 0; r < 2; ++r) {
                for (g = 0; g < 6; ++g) {
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (0 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%3d \u001b[0m", fbg, col, col);
                    }
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (1 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%3d \u001b[0m", fbg, col, col);
                    }
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (2 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%3d \u001b[0m", fbg, col, col);
                    }
                    System.out.println();
                }
                System.out.println();
            }
            r = 6;
            for (g = 0; g < 4; ++g) {
                for (b = 0; b < 6; ++b) {
                    col = 16 + 36 * r + 6 * g + b;
                    System.out.printf("\u001b[%d;5;%dm%3d \u001b[0m", fbg, col, col);
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    private void showRgbColorPalette() {
        int[] foregroundBackground;
        for (int fbg : foregroundBackground = new int[]{38, 48}) {
            int col;
            int b;
            int g;
            int r;
            for (r = 0; r < 2; ++r) {
                System.out.println("RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB RGB ");
                for (g = 0; g < 6; ++g) {
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (0 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%d%d%d \u001b[0m", fbg, col, 0 + 3 * r, g, b);
                    }
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (1 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%d%d%d \u001b[0m", fbg, col, 1 + 3 * r, g, b);
                    }
                    for (b = 0; b < 6; ++b) {
                        col = 16 + 36 * (2 + 3 * r) + 6 * g + b;
                        System.out.printf("\u001b[%d;5;%dm%d%d%d \u001b[0m", fbg, col, 2 + 3 * r, g, b);
                    }
                    System.out.println();
                }
                System.out.println();
            }
            System.out.println("RGB RGB RGB RGB RGB RGB");
            r = 6;
            for (g = 0; g < 4; ++g) {
                for (b = 0; b < 6; ++b) {
                    col = 16 + 36 * r + 6 * g + b;
                    System.out.printf("\u001b[%d;5;%dm%d%d%d \u001b[0m", fbg, col, r, g, b);
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    public static void testParseSubCommands() {
        CommandLine commandLine = Demo.mainCommand();
        String[] args = new String[]{"--git-dir=/home/rpopma/picocli", "status", "-sbuno"};
        List parsed = commandLine.parse(args);
        assert (parsed.size() == 2) : "found 2 commands";
        assert (((CommandLine)parsed.get(0)).getCommand().getClass() == Git.class);
        assert (((CommandLine)parsed.get(1)).getCommand().getClass() == GitStatus.class);
        Git git = (Git)((CommandLine)parsed.get(0)).getCommand();
        assert (git.gitDir.equals(new File("/home/rpopma/picocli")));
        GitStatus status = (GitStatus)((CommandLine)parsed.get(1)).getCommand();
        assert (status.shortFormat) : "status -s";
        assert (status.branchInfo) : "status -b";
        assert (!status.showIgnored) : "status --showIgnored not specified";
        assert (status.mode == GitStatusMode.no) : "status -u=no";
    }

    static CommandLine mainCommand() {
        CommandLine commandLine = new CommandLine((Object)new Git());
        commandLine.addSubcommand("status", (Object)new GitStatus());
        commandLine.addSubcommand("commit", (Object)new GitCommit());
        commandLine.addSubcommand("add", (Object)new GitAdd());
        commandLine.addSubcommand("branch", (Object)new GitBranch());
        commandLine.addSubcommand("checkout", (Object)new GitCheckout());
        commandLine.addSubcommand("clone", (Object)new GitClone());
        commandLine.addSubcommand("diff", (Object)new GitDiff());
        commandLine.addSubcommand("merge", (Object)new GitMerge());
        commandLine.addSubcommand("push", (Object)new GitPush());
        commandLine.addSubcommand("rebase", (Object)new GitRebase());
        commandLine.addSubcommand("tag", (Object)new GitTag());
        return commandLine;
    }

    public void testUsageMainCommand() {
        CommandLine commandLine = Demo.mainCommand();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            commandLine.usage(new PrintStream((OutputStream)baos, true, "UTF8"));
            String result = baos.toString("UTF8");
            System.out.println(result);
            assert (String.format(EXPECTED_USAGE_MAIN, new Object[0]).equals(result));
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public void testUsageSubCommandStatus() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CommandLine.usage((Object)new GitStatus(), (PrintStream)new PrintStream((OutputStream)baos, true, "UTF8"));
            String result = baos.toString("UTF8");
            System.out.println(result);
            assert (String.format(EXPECTED_USAGE_GITSTATUS, new Object[0]).equals(result));
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public void testUsageSubCommandCommit() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CommandLine.usage((Object)new GitCommit(), (PrintStream)new PrintStream((OutputStream)baos, true, "UTF8"));
            String result = baos.toString("UTF8");
            System.out.println(result);
            assert (String.format(EXPECTED_USAGE_GITCOMMIT, new Object[0]).equals(result));
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError(ex.toString());
        }
    }

    @CommandLine.Command(name="checksum", description={"Prints the checksum (MD5 by default) of a file to STDOUT."})
    static class CheckSum
    implements Callable<Void> {
        @CommandLine.Parameters(index="0", description={"The file whose checksum to calculate."})
        private File file;
        @CommandLine.Option(names={"-a", "--algorithm"}, description={"MD5, SHA-1, SHA-256, ..."})
        private String algorithm = "MD5";
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit."})
        private boolean helpRequested;

        CheckSum() {
        }

        public static void main(String[] args) throws Exception {
            CommandLine.call((Callable)new CheckSum(), (PrintStream)System.err, (String[])args);
        }

        @Override
        public Void call() throws Exception {
            if (this.helpRequested) {
                CommandLine.usage((Object)this, (PrintStream)System.err);
                return null;
            }
            byte[] digest = MessageDigest.getInstance(this.algorithm).digest(this.readBytes(this.file));
            this.print(digest, System.out);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] readBytes(File f) throws IOException {
            int pos = 0;
            int len = 0;
            byte[] buffer = new byte[(int)f.length()];
            try (FileInputStream fis = null;){
                fis = new FileInputStream(f);
                while ((len = fis.read(buffer, pos, buffer.length - pos)) > 0) {
                    pos += len;
                }
            }
            return buffer;
        }

        void print(byte[] digest, PrintStream out) {
            for (int i = 0; i < digest.length; ++i) {
                if ((digest[i] & 0xFF) < 16) {
                    out.print('0');
                }
                out.print(Integer.toHexString(digest[i] & 0xFF));
            }
            out.println();
        }
    }

    @CommandLine.Command(name="git-tag", header={"Create, list, delete or verify a tag object signed with GPG."})
    static class GitTag {
        GitTag() {
        }
    }

    @CommandLine.Command(name="git-rebase", header={"Forward-port local commits to the updated upstream head."})
    static class GitRebase {
        GitRebase() {
        }
    }

    @CommandLine.Command(name="git-push", header={"Update remote refs along with associated objects."})
    static class GitPush {
        GitPush() {
        }
    }

    @CommandLine.Command(name="git-merge", header={"Join two or more development histories together."})
    static class GitMerge {
        GitMerge() {
        }
    }

    @CommandLine.Command(name="git-diff", header={"Show changes between commits, commit and working tree, etc."})
    static class GitDiff {
        GitDiff() {
        }
    }

    @CommandLine.Command(name="git-clone", header={"Clone a repository into a new directory."})
    static class GitClone {
        GitClone() {
        }
    }

    @CommandLine.Command(name="git-checkout", header={"Checkout a branch or paths to the working tree."})
    static class GitCheckout {
        GitCheckout() {
        }
    }

    @CommandLine.Command(name="git-branch", header={"List, create, or delete branches."})
    static class GitBranch {
        GitBranch() {
        }
    }

    @CommandLine.Command(name="git-add", header={"Add file contents to the index."})
    static class GitAdd {
        GitAdd() {
        }
    }

    @CommandLine.Command(name="git-commit", sortOptions=false, headerHeading="@|bold,underline Usage:|@%n%n", synopsisHeading="%n", descriptionHeading="%n@|bold,underline Description:|@%n%n", parameterListHeading="%n@|bold,underline Parameters:|@%n", optionListHeading="%n@|bold,underline Options:|@%n", header={"Record changes to the repository."}, description={"Stores the current contents of the index in a new commit along with a log message from the user describing the changes."})
    static class GitCommit {
        @CommandLine.Option(names={"-a", "--all"}, description={"Tell the command to automatically stage files that have been modified and deleted, but new files you have not told Git about are not affected."})
        boolean all;
        @CommandLine.Option(names={"-p", "--patch"}, description={"Use the interactive patch selection interface to chose which changes to commit"})
        boolean patch;
        @CommandLine.Option(names={"-C", "--reuse-message"}, paramLabel="<commit>", description={"Take an existing commit object, and reuse the log message and the authorship information (including the timestamp) when creating the commit."})
        String reuseMessageCommit;
        @CommandLine.Option(names={"-c", "--reedit-message"}, paramLabel="<commit>", description={"Like -C, but with -c the editor is invoked, so that the user canfurther edit the commit message."})
        String reEditMessageCommit;
        @CommandLine.Option(names={"--fixup"}, paramLabel="<commit>", description={"Construct a commit message for use with rebase --autosquash."})
        String fixupCommit;
        @CommandLine.Option(names={"--squash"}, paramLabel="<commit>", description={"Construct a commit message for use with rebase --autosquash. The commitmessage subject line is taken from the specified commit with a prefix of \"squash! \". Can be used with additional commit message options (-m/-c/-C/-F)."})
        String squashCommit;
        @CommandLine.Option(names={"-F", "--file"}, paramLabel="<file>", description={"Take the commit message from the given file. Use - to read the message from the standard input."})
        File file;
        @CommandLine.Option(names={"-m", "--message"}, paramLabel="<msg>", description={"Use the given <msg> as the commit message. If multiple -m options are given, their values are concatenated as separate paragraphs."})
        List<String> message = new ArrayList<String>();
        @CommandLine.Parameters(paramLabel="<files>", description={"the files to commit"})
        List<File> files = new ArrayList<File>();

        GitCommit() {
        }
    }

    @CommandLine.Command(name="git-status", header={"Show the working tree status."}, showDefaultValues=true, customSynopsis={"@|bold git-status|@ [@|yellow <options>|@...] [--] [@|yellow <pathspec>|@...]"}, description={"Displays paths that have differences between the index file and the current HEAD commit, paths that have differences between the working tree and the index file, and paths in the working tree that are not tracked by Git (and are not ignored by gitignore(5)). The first are what you would commit by running git commit; the second and third are what you could commit by running git add before running git commit."})
    static class GitStatus {
        @CommandLine.Option(names={"-s", "--short"}, description={"Give the output in the short-format"})
        boolean shortFormat;
        @CommandLine.Option(names={"-b", "--branch"}, description={"Show the branch and tracking info even in short-format"})
        boolean branchInfo;
        @CommandLine.Option(names={"--ignored"}, description={"Show ignored files as well"})
        boolean showIgnored;
        @CommandLine.Option(names={"-u", "--untracked"}, paramLabel="<mode>", description={"Show untracked files.", "The mode parameter is optional (defaults to `all`), and is used to specify the handling of untracked files.", "The possible options are:", " * @|yellow no|@ - Show no untracked files.", " * @|yellow normal|@ - Shows untracked files and directories.", " * @|yellow all|@ - Also shows individual files in untracked directories."})
        GitStatusMode mode = GitStatusMode.all;

        GitStatus() {
        }
    }

    static enum GitStatusMode {
        all,
        no,
        normal;

    }

    @CommandLine.Command(name="git", sortOptions=false, description={"Git is a fast, scalable, distributed revision control system with an unusually rich command set that provides both high-level operations and full access to internals."}, commandListHeading="%nCommands:%n%nThe most commonly used git commands are:%n")
    static class Git {
        @CommandLine.Option(names={"-V", "--version"}, help=true, description={"Prints version information and exits"})
        boolean isVersionRequested;
        @CommandLine.Option(names={"-h", "--help"}, help=true, description={"Prints this help message and exits"})
        boolean isHelpRequested;
        @CommandLine.Option(names={"--git-dir"}, description={"Set the path to the repository"})
        File gitDir;

        Git() {
        }
    }
}

