/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.PrintStream;
import java.lang.reflect.Field;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;

@CommandLine.Command(name="picocli.CustomLayoutDemo", description={"Demonstrates picocli custom layouts."}, footer={"Run with -Dpicocli.ansi=true  to force picocli to use ansi codes,", "or  with -Dpicocli.ansi=false to force picocli to NOT use ansi codes.", "By default picocli will use ansi codes if the platform supports it."})
public class CustomLayoutDemo
implements Runnable {
    @CommandLine.Option(names={"-z", "--zip"}, description={"Show usage help for a layout with 2 options per row."})
    private boolean showZip;
    @CommandLine.Option(names={"-n", "--netstat"}, description={"Show usage help for a layout with a narrow options column and a wide description column. Descriptions that wrap to the next row are not indented."})
    private boolean showNetstat;

    public static void main(String[] args) {
        CommandLine.run((Runnable)new CustomLayoutDemo(), (PrintStream)System.err, (String[])args);
    }

    @Override
    public void run() {
        if (!this.showZip && !this.showNetstat) {
            CommandLine.usage((Object)this, (PrintStream)System.err);
            return;
        }
        if (this.showZip) {
            System.out.println(CustomLayoutDemo.createZipUsageFormat(CommandLine.Help.Ansi.AUTO));
        }
        if (this.showNetstat) {
            System.out.println(CustomLayoutDemo.createNetstatUsageFormat(CommandLine.Help.Ansi.AUTO));
        }
    }

    public static String createZipUsageFormat(CommandLine.Help.Ansi ansi) {
        CommandLine.Help.TextTable textTable = new CommandLine.Help.TextTable(ansi, new CommandLine.Help.Column[]{new CommandLine.Help.Column(5, 2, CommandLine.Help.Column.Overflow.TRUNCATE), new CommandLine.Help.Column(30, 2, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(4, 1, CommandLine.Help.Column.Overflow.TRUNCATE), new CommandLine.Help.Column(39, 2, CommandLine.Help.Column.Overflow.WRAP)});
        class TwoOptionsPerRowLayout
        extends CommandLine.Help.Layout {
            CommandLine.Help.TextTable.Cell previous = new CommandLine.Help.TextTable.Cell(0, 0);

            TwoOptionsPerRowLayout(CommandLine.Help.ColorScheme colorScheme, CommandLine.Help.TextTable textTable, CommandLine.Help.IOptionRenderer optionRenderer, CommandLine.Help.IParameterRenderer parameterRenderer) {
                super(colorScheme, textTable, optionRenderer, parameterRenderer);
            }

            public void layout(Field field, CommandLine.Help.Ansi.Text[][] values) {
                CommandLine.Help.Ansi.Text[] columnValues = values[0];
                int col = this.previous.column + 1;
                if (col == 1 || col + columnValues.length > this.table.columns.length) {
                    if (this.table.rowCount() == 0 || this.table.rowCount() == this.previous.row + 1) {
                        this.table.addEmptyRow();
                    }
                    col = 0;
                }
                for (int i = 0; i < columnValues.length; ++i) {
                    this.previous = this.table.putValue(this.table.rowCount() - 1, col + i, columnValues[i]);
                }
            }
        }
        TwoOptionsPerRowLayout layout = new TwoOptionsPerRowLayout(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)ansi), textTable, CommandLine.Help.createMinimalOptionRenderer(), CommandLine.Help.createMinimalParameterRenderer());
        @CommandLine.Command(description={"Copyright (c) 1990-2008 Info-ZIP - Type 'zip \"-L\"' for software license.", "Zip 3.0 (July 5th 2008). Command:", "@|bold zip|@ [@|yellow -options|@] [@|yellow -b|@ @|underline path|@] [@|yellow -t|@ @|underline mmddyyyy|@] [@|yellow -n|@ @|underline suffixes|@] [@|yellow zipfile|@ @|underline list|@] [@|yellow -xi|@ @|underline list|@]", "  The default action is to add or replace zipfile entries from list, which", "  can include the special name - to compress standard input.", "  If @|yellow zipfile|@ and @|yellow list|@ are omitted, zip compresses stdin to stdout."})
        class Zip {
            @CommandLine.Option(names={"-f"}, description={"freshen: only changed files"})
            boolean freshen;
            @CommandLine.Option(names={"-u"}, description={"update: only changed or new files"})
            boolean update;
            @CommandLine.Option(names={"-d"}, description={"delete entries in zipfile"})
            boolean delete;
            @CommandLine.Option(names={"-m"}, description={"move into zipfile (delete OS files)"})
            boolean move;
            @CommandLine.Option(names={"-r"}, description={"recurse into directories"})
            boolean recurse;
            @CommandLine.Option(names={"-j"}, description={"junk (don't record) directory names"})
            boolean junk;
            @CommandLine.Option(names={"-0"}, description={"store only"})
            boolean store;
            @CommandLine.Option(names={"-l"}, description={"convert LF to CR LF (@|yellow -ll|@ CR LF to LF)"})
            boolean lf2crlf;
            @CommandLine.Option(names={"-1"}, description={"compress faster"})
            boolean faster;
            @CommandLine.Option(names={"-9"}, description={"compress better"})
            boolean better;
            @CommandLine.Option(names={"-q"}, description={"quiet operation"})
            boolean quiet;
            @CommandLine.Option(names={"-v"}, description={"verbose operation/print version info"})
            boolean verbose;
            @CommandLine.Option(names={"-c"}, description={"add one-line comments"})
            boolean comments;
            @CommandLine.Option(names={"-z"}, description={"add zipfile comment"})
            boolean zipComment;
            @CommandLine.Option(names={"-@"}, description={"read names from stdin"})
            boolean readFileList;
            @CommandLine.Option(names={"-o"}, description={"make zipfile as old as latest entry"})
            boolean old;
            @CommandLine.Option(names={"-x"}, description={"exclude the following names"})
            boolean exclude;
            @CommandLine.Option(names={"-i"}, description={"include only the following names"})
            boolean include;
            @CommandLine.Option(names={"-F"}, description={"fix zipfile (@|yellow -FF|@ try harder)"})
            boolean fix;
            @CommandLine.Option(names={"-D"}, description={"do not add directory entries"})
            boolean directories;
            @CommandLine.Option(names={"-A"}, description={"adjust self-extracting exe"})
            boolean adjust;
            @CommandLine.Option(names={"-J"}, description={"junk zipfile prefix (unzipsfx)"})
            boolean junkPrefix;
            @CommandLine.Option(names={"-T"}, description={"test zipfile integrity"})
            boolean test;
            @CommandLine.Option(names={"-X"}, description={"eXclude eXtra file attributes"})
            boolean excludeAttribs;
            @CommandLine.Option(names={"-y"}, description={"store symbolic links as the link instead of the referenced file"})
            boolean symbolic;
            @CommandLine.Option(names={"-e"}, description={"encrypt"})
            boolean encrypt;
            @CommandLine.Option(names={"-n"}, description={"don't compress these suffixes"})
            boolean dontCompress;
            @CommandLine.Option(names={"-h2"}, description={"show more help"})
            boolean moreHelp;

            Zip() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Zip(), ansi);
        StringBuilder sb = new StringBuilder();
        sb.append(help.description(new Object[0]));
        layout.addOptions(help.optionFields, help.parameterLabelRenderer);
        sb.append((Object)layout);
        return sb.toString();
    }

    public static String createNetstatUsageFormat(CommandLine.Help.Ansi ansi) {
        StringBuilder sb = new StringBuilder();
        @CommandLine.Command(name="NETSTAT", separator=" ", abbreviateSynopsis=true, header={"Displays protocol statistics and current TCP/IP network connections.%n"})
        class Netstat {
            @CommandLine.Option(names={"-a"}, description={"Displays all connections and listening ports."})
            boolean displayAll;
            @CommandLine.Option(names={"-b"}, description={"Displays the executable involved in creating each connection or listening port. In some cases well-known executables host multiple independent components, and in these cases the sequence of components involved in creating the connection or listening port is displayed. In this case the executable name is in [] at the bottom, on top is the component it called, and so forth until TCP/IP was reached. Note that this option can be time-consuming and will fail unless you have sufficient permissions."})
            boolean displayExecutable;
            @CommandLine.Option(names={"-e"}, description={"Displays Ethernet statistics. This may be combined with the -s option."})
            boolean displayEthernetStats;
            @CommandLine.Option(names={"-f"}, description={"Displays Fully Qualified Domain Names (FQDN) for foreign addresses."})
            boolean displayFQCN;
            @CommandLine.Option(names={"-n"}, description={"Displays addresses and port numbers in numerical form."})
            boolean displayNumerical;
            @CommandLine.Option(names={"-o"}, description={"Displays the owning process ID associated with each connection."})
            boolean displayOwningProcess;
            @CommandLine.Option(names={"-p"}, paramLabel="proto", description={"Shows connections for the protocol specified by proto; proto may be any of: TCP, UDP, TCPv6, or UDPv6.  If used with the -s option to display per-protocol statistics, proto may be any of: IP, IPv6, ICMP, ICMPv6, TCP, TCPv6, UDP, or UDPv6."})
            Protocol proto;
            @CommandLine.Option(names={"-q"}, description={"Displays all connections, listening ports, and bound nonlistening TCP ports. Bound nonlistening ports may or may not be associated with an active connection."})
            boolean query;
            @CommandLine.Option(names={"-r"}, description={"Displays the routing table."})
            boolean displayRoutingTable;
            @CommandLine.Option(names={"-s"}, description={"Displays per-protocol statistics.  By default, statistics are shown for IP, IPv6, ICMP, ICMPv6, TCP, TCPv6, UDP, and UDPv6; the -p option may be used to specify a subset of the default."})
            boolean displayStatistics;
            @CommandLine.Option(names={"-t"}, description={"Displays the current connection offload state."})
            boolean displayOffloadState;
            @CommandLine.Option(names={"-x"}, description={"Displays NetworkDirect connections, listeners, and shared endpoints."})
            boolean displayNetDirect;
            @CommandLine.Option(names={"-y"}, description={"Displays the TCP connection template for all connections. Cannot be combined with the other options."})
            boolean displayTcpConnectionTemplate;
            @CommandLine.Parameters(arity="0..1", paramLabel="interval", description={"Redisplays selected statistics, pausing interval seconds between each display.  Press CTRL+C to stop redisplaying statistics.  If omitted, netstat will print the current configuration information once."})
            int interval;

            Netstat() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Netstat(), ansi);
        help.synopsisHeading = "";
        sb.append(help.header(new Object[0])).append(help.detailedSynopsis(0, null, false));
        sb.append(System.getProperty("line.separator"));
        CommandLine.Help.TextTable textTable = new CommandLine.Help.TextTable(ansi, new CommandLine.Help.Column[]{new CommandLine.Help.Column(15, 2, CommandLine.Help.Column.Overflow.TRUNCATE), new CommandLine.Help.Column(65, 1, CommandLine.Help.Column.Overflow.WRAP)});
        textTable.indentWrappedLines = 0;
        CommandLine.Help.Layout layout = new CommandLine.Help.Layout(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)ansi), textTable, CommandLine.Help.createMinimalOptionRenderer(), CommandLine.Help.createMinimalParameterRenderer());
        layout.addOptions(help.optionFields, help.parameterLabelRenderer);
        layout.addPositionalParameters(help.positionalParametersFields, CommandLine.Help.createMinimalParamLabelRenderer());
        sb.append(layout);
        return sb.toString();
    }

    private static enum Protocol {
        IP,
        IPv6,
        ICMP,
        ICMPv6,
        TCP,
        TCPv6,
        UDP,
        UDPv6;

    }
}

