/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;
import org.apache.logging.log4j.core.tools.picocli.Demo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CommandLineTest {
    @Before
    public void setUp() {
        System.clearProperty("picocli.trace");
    }

    @After
    public void tearDown() {
        System.clearProperty("picocli.trace");
    }

    private static void setTraceLevel(String level) {
        System.setProperty("picocli.trace", level);
    }

    @Test
    public void testVersion() {
        Assert.assertEquals((Object)"2.0.3", (Object)"2.0.3");
    }

    @Test
    public void testDefaults() {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[0]);
        Assert.assertEquals((String)"boolean", (Object)false, (Object)bean.booleanField);
        Assert.assertEquals((String)"Boolean", null, (Object)bean.aBooleanField);
        Assert.assertEquals((String)"byte", (long)0L, (long)bean.byteField);
        Assert.assertEquals((String)"Byte", null, (Object)bean.aByteField);
        Assert.assertEquals((String)"char", (long)0L, (long)bean.charField);
        Assert.assertEquals((String)"Character", null, (Object)bean.aCharacterField);
        Assert.assertEquals((String)"short", (long)0L, (long)bean.shortField);
        Assert.assertEquals((String)"Short", null, (Object)bean.aShortField);
        Assert.assertEquals((String)"int", (long)0L, (long)bean.intField);
        Assert.assertEquals((String)"Integer", null, (Object)bean.anIntegerField);
        Assert.assertEquals((String)"long", (long)0L, (long)bean.longField);
        Assert.assertEquals((String)"Long", null, (Object)bean.aLongField);
        Assert.assertEquals((String)"float", (float)0.0f, (float)bean.floatField, (float)Float.MIN_VALUE);
        Assert.assertEquals((String)"Float", null, (Object)bean.aFloatField);
        Assert.assertEquals((String)"double", (double)0.0, (double)bean.doubleField, (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"Double", null, (Object)bean.aDoubleField);
        Assert.assertEquals((String)"String", null, (Object)bean.aStringField);
        Assert.assertEquals((String)"StringBuilder", null, (Object)bean.aStringBuilderField);
        Assert.assertEquals((String)"CharSequence", null, (Object)bean.aCharSequenceField);
        Assert.assertEquals((String)"File", null, (Object)bean.aFileField);
        Assert.assertEquals((String)"URL", null, (Object)bean.anURLField);
        Assert.assertEquals((String)"URI", null, (Object)bean.anURIField);
        Assert.assertEquals((String)"Date", null, (Object)bean.aDateField);
        Assert.assertEquals((String)"Time", null, (Object)bean.aTimeField);
        Assert.assertEquals((String)"BigDecimal", null, (Object)bean.aBigDecimalField);
        Assert.assertEquals((String)"BigInteger", null, (Object)bean.aBigIntegerField);
        Assert.assertEquals((String)"Charset", null, (Object)bean.aCharsetField);
        Assert.assertEquals((String)"InetAddress", null, (Object)bean.anInetAddressField);
        Assert.assertEquals((String)"Pattern", null, (Object)bean.aPatternField);
        Assert.assertEquals((String)"UUID", null, (Object)bean.anUUIDField);
    }

    @Test
    public void testTypeConversionSucceedsForValidInput() throws MalformedURLException, URISyntaxException, UnknownHostException, ParseException {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-boolean", "-Boolean", "-byte", "12", "-Byte", "23", "-char", "p", "-Character", "i", "-short", "34", "-Short", "45", "-int", "56", "-Integer", "67", "-long", "78", "-Long", "89", "-float", "1.23", "-Float", "2.34", "-double", "3.45", "-Double", "4.56", "-String", "abc", "-StringBuilder", "bcd", "-CharSequence", "xyz", "-File", "abc.txt", "-URL", "http://pico-cli.github.io", "-URI", "http://pico-cli.github.io/index.html", "-Date", "2017-01-30", "-Time", "23:59:59", "-BigDecimal", "12345678901234567890.123", "-BigInteger", "123456789012345678901", "-Charset", "UTF8", "-InetAddress", InetAddress.getLocalHost().getHostName(), "-Pattern", "a*b", "-UUID", "c7d51423-bf9d-45dd-a30d-5b16fafe42e2"});
        Assert.assertEquals((String)"boolean", (Object)true, (Object)bean.booleanField);
        Assert.assertEquals((String)"Boolean", (Object)Boolean.TRUE, (Object)bean.aBooleanField);
        Assert.assertEquals((String)"byte", (long)12L, (long)bean.byteField);
        Assert.assertEquals((String)"Byte", (Object)23, (Object)bean.aByteField);
        Assert.assertEquals((String)"char", (long)112L, (long)bean.charField);
        Assert.assertEquals((String)"Character", (Object)Character.valueOf('i'), (Object)bean.aCharacterField);
        Assert.assertEquals((String)"short", (long)34L, (long)bean.shortField);
        Assert.assertEquals((String)"Short", (Object)45, (Object)bean.aShortField);
        Assert.assertEquals((String)"int", (long)56L, (long)bean.intField);
        Assert.assertEquals((String)"Integer", (Object)67, (Object)bean.anIntegerField);
        Assert.assertEquals((String)"long", (long)78L, (long)bean.longField);
        Assert.assertEquals((String)"Long", (Object)89L, (Object)bean.aLongField);
        Assert.assertEquals((String)"float", (float)1.23f, (float)bean.floatField, (float)Float.MIN_VALUE);
        Assert.assertEquals((String)"Float", (Object)Float.valueOf(2.34f), (Object)bean.aFloatField);
        Assert.assertEquals((String)"double", (double)3.45, (double)bean.doubleField, (double)Double.MIN_VALUE);
        Assert.assertEquals((String)"Double", (Object)4.56, (Object)bean.aDoubleField);
        Assert.assertEquals((String)"String", (Object)"abc", (Object)bean.aStringField);
        Assert.assertEquals((String)"StringBuilder type", StringBuilder.class, bean.aStringBuilderField.getClass());
        Assert.assertEquals((String)"StringBuilder", (Object)"bcd", (Object)bean.aStringBuilderField.toString());
        Assert.assertEquals((String)"CharSequence", (Object)"xyz", (Object)bean.aCharSequenceField);
        Assert.assertEquals((String)"File", (Object)new File("abc.txt"), (Object)bean.aFileField);
        Assert.assertEquals((String)"URL", (Object)new URL("http://pico-cli.github.io"), (Object)bean.anURLField);
        Assert.assertEquals((String)"URI", (Object)new URI("http://pico-cli.github.io/index.html"), (Object)bean.anURIField);
        Assert.assertEquals((String)"Date", (Object)new SimpleDateFormat("yyyy-MM-dd").parse("2017-01-30"), (Object)bean.aDateField);
        Assert.assertEquals((String)"Time", (Object)new Time(new SimpleDateFormat("HH:mm:ss").parse("23:59:59").getTime()), (Object)bean.aTimeField);
        Assert.assertEquals((String)"BigDecimal", (Object)new BigDecimal("12345678901234567890.123"), (Object)bean.aBigDecimalField);
        Assert.assertEquals((String)"BigInteger", (Object)new BigInteger("123456789012345678901"), (Object)bean.aBigIntegerField);
        Assert.assertEquals((String)"Charset", (Object)Charset.forName("UTF8"), (Object)bean.aCharsetField);
        Assert.assertEquals((String)"InetAddress", (Object)InetAddress.getByName(InetAddress.getLocalHost().getHostName()), (Object)bean.anInetAddressField);
        Assert.assertEquals((String)"Pattern", (Object)Pattern.compile("a*b").pattern(), (Object)bean.aPatternField.pattern());
        Assert.assertEquals((String)"UUID", (Object)UUID.fromString("c7d51423-bf9d-45dd-a30d-5b16fafe42e2"), (Object)bean.anUUIDField);
    }

    @Test
    public void testByteFieldsAreDecimal() {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-byte", "0x1F", "-Byte", "0x0F"});
            Assert.fail((String)"Should fail on hex input");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"Could not convert '0x1F' to byte for option '-byte': java.lang.NumberFormatException: For input string: \"0x1F\"", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCustomByteConverterAcceptsHexadecimalDecimalAndOctal() {
        SupportedTypes bean = new SupportedTypes();
        CommandLine commandLine = new CommandLine((Object)bean);
        CommandLine.ITypeConverter<Byte> converter = new CommandLine.ITypeConverter<Byte>(){

            public Byte convert(String s) {
                return Byte.decode(s);
            }
        };
        commandLine.registerConverter(Byte.class, (CommandLine.ITypeConverter)converter);
        commandLine.registerConverter(Byte.TYPE, (CommandLine.ITypeConverter)converter);
        commandLine.parse(new String[]{"-byte", "0x1F", "-Byte", "0x0F"});
        Assert.assertEquals((long)31L, (long)bean.byteField);
        Assert.assertEquals((Object)15, (Object)bean.aByteField);
        commandLine.parse(new String[]{"-byte", "010", "-Byte", "010"});
        Assert.assertEquals((long)8L, (long)bean.byteField);
        Assert.assertEquals((Object)8, (Object)bean.aByteField);
        commandLine.parse(new String[]{"-byte", "34", "-Byte", "34"});
        Assert.assertEquals((long)34L, (long)bean.byteField);
        Assert.assertEquals((Object)34, (Object)bean.aByteField);
    }

    @Test
    public void testShortFieldsAreDecimal() {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-short", "0xFF", "-Short", "0x6FFE"});
            Assert.fail((String)"Should fail on hex input");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"Could not convert '0xFF' to short for option '-short': java.lang.NumberFormatException: For input string: \"0xFF\"", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCustomShortConverterAcceptsHexadecimalDecimalAndOctal() {
        SupportedTypes bean = new SupportedTypes();
        CommandLine commandLine = new CommandLine((Object)bean);
        CommandLine.ITypeConverter<Short> shortConverter = new CommandLine.ITypeConverter<Short>(){

            public Short convert(String s) {
                return Short.decode(s);
            }
        };
        commandLine.registerConverter(Short.class, (CommandLine.ITypeConverter)shortConverter);
        commandLine.registerConverter(Short.TYPE, (CommandLine.ITypeConverter)shortConverter);
        commandLine.parse(new String[]{"-short", "0xFF", "-Short", "0x6FFE"});
        Assert.assertEquals((long)255L, (long)bean.shortField);
        Assert.assertEquals((Object)28670, (Object)bean.aShortField);
        commandLine.parse(new String[]{"-short", "010", "-Short", "010"});
        Assert.assertEquals((long)8L, (long)bean.shortField);
        Assert.assertEquals((Object)8, (Object)bean.aShortField);
        commandLine.parse(new String[]{"-short", "34", "-Short", "34"});
        Assert.assertEquals((long)34L, (long)bean.shortField);
        Assert.assertEquals((Object)34, (Object)bean.aShortField);
    }

    @Test
    public void testIntFieldsAreDecimal() {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-int", "0xFF", "-Integer", "0xFFFF"});
            Assert.fail((String)"Should fail on hex input");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"Could not convert '0xFF' to int for option '-int': java.lang.NumberFormatException: For input string: \"0xFF\"", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCustomIntConverterAcceptsHexadecimalDecimalAndOctal() {
        SupportedTypes bean = new SupportedTypes();
        CommandLine commandLine = new CommandLine((Object)bean);
        CommandLine.ITypeConverter<Integer> intConverter = new CommandLine.ITypeConverter<Integer>(){

            public Integer convert(String s) {
                return Integer.decode(s);
            }
        };
        commandLine.registerConverter(Integer.class, (CommandLine.ITypeConverter)intConverter);
        commandLine.registerConverter(Integer.TYPE, (CommandLine.ITypeConverter)intConverter);
        commandLine.parse(new String[]{"-int", "0xFF", "-Integer", "0xFFFF"});
        Assert.assertEquals((long)255L, (long)bean.intField);
        Assert.assertEquals((Object)65535, (Object)bean.anIntegerField);
        commandLine.parse(new String[]{"-int", "010", "-Integer", "010"});
        Assert.assertEquals((long)8L, (long)bean.intField);
        Assert.assertEquals((Object)8, (Object)bean.anIntegerField);
        commandLine.parse(new String[]{"-int", "34", "-Integer", "34"});
        Assert.assertEquals((long)34L, (long)bean.intField);
        Assert.assertEquals((Object)34, (Object)bean.anIntegerField);
    }

    @Test
    public void testLongFieldsAreDecimal() {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-long", "0xAABBCC", "-Long", "0xAABBCCDD"});
            Assert.fail((String)"Should fail on hex input");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"Could not convert '0xAABBCC' to long for option '-long': java.lang.NumberFormatException: For input string: \"0xAABBCC\"", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCustomLongConverterAcceptsHexadecimalDecimalAndOctal() {
        SupportedTypes bean = new SupportedTypes();
        CommandLine commandLine = new CommandLine((Object)bean);
        CommandLine.ITypeConverter<Long> longConverter = new CommandLine.ITypeConverter<Long>(){

            public Long convert(String s) {
                return Long.decode(s);
            }
        };
        commandLine.registerConverter(Long.class, (CommandLine.ITypeConverter)longConverter);
        commandLine.registerConverter(Long.TYPE, (CommandLine.ITypeConverter)longConverter);
        commandLine.parse(new String[]{"-long", "0xAABBCC", "-Long", "0xAABBCCDD"});
        Assert.assertEquals((long)0xAABBCCL, (long)bean.longField);
        Assert.assertEquals((Object)2864434397L, (Object)bean.aLongField);
        commandLine.parse(new String[]{"-long", "010", "-Long", "010"});
        Assert.assertEquals((long)8L, (long)bean.longField);
        Assert.assertEquals((Object)8L, (Object)bean.aLongField);
        commandLine.parse(new String[]{"-long", "34", "-Long", "34"});
        Assert.assertEquals((long)34L, (long)bean.longField);
        Assert.assertEquals((Object)34L, (Object)bean.aLongField);
    }

    @Test
    public void testTimeFormatHHmmSupported() throws ParseException {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59"});
        Assert.assertEquals((String)"Time", (Object)new Time(new SimpleDateFormat("HH:mm").parse("23:59").getTime()), (Object)bean.aTimeField);
    }

    @Test
    public void testTimeFormatHHmmssSupported() throws ParseException {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:58"});
        Assert.assertEquals((String)"Time", (Object)new Time(new SimpleDateFormat("HH:mm:ss").parse("23:59:58").getTime()), (Object)bean.aTimeField);
    }

    @Test
    public void testTimeFormatHHmmssDotSSSSupported() throws ParseException {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:58.123"});
        Assert.assertEquals((String)"Time", (Object)new Time(new SimpleDateFormat("HH:mm:ss.SSS").parse("23:59:58.123").getTime()), (Object)bean.aTimeField);
    }

    @Test
    public void testTimeFormatHHmmssCommaSSSSupported() throws ParseException {
        SupportedTypes bean = (SupportedTypes)CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:58,123"});
        Assert.assertEquals((String)"Time", (Object)new Time(new SimpleDateFormat("HH:mm:ss,SSS").parse("23:59:58,123").getTime()), (Object)bean.aTimeField);
    }

    @Test
    public void testTimeFormatHHmmssSSSInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:58;123"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'23:59:58;123' is not a HH:mm[:ss[.SSS]] time for option '-Time'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testTimeFormatHHmmssDotInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:58."});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'23:59:58.' is not a HH:mm[:ss[.SSS]] time for option '-Time'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testTimeFormatHHmmsssInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:587"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'23:59:587' is not a HH:mm[:ss[.SSS]] time for option '-Time'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testTimeFormatHHmmssColonInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Time", "23:59:"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'23:59:' is not a HH:mm[:ss[.SSS]] time for option '-Time'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testDateFormatYYYYmmddInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Date", "20170131"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'20170131' is not a yyyy-MM-dd date for option '-Date'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testCharConverterInvalidError() throws ParseException {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-Character", "aa"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'aa' is not a single character for option '-Character'", (Object)expected.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{"-char", "aa"});
            Assert.fail((String)"Invalid format was accepted");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'aa' is not a single character for option '-char'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testNumberConvertersInvalidError() {
        this.parseInvalidValue("-Byte", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-byte", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-Short", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-short", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-Integer", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-int", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-Long", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-long", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-Float", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-float", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-Double", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-double", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
        this.parseInvalidValue("-BigDecimal", "aa", ": java.lang.NumberFormatException");
        this.parseInvalidValue("-BigInteger", "aa", ": java.lang.NumberFormatException: For input string: \"aa\"");
    }

    @Test
    public void testURLConvertersInvalidError() {
        this.parseInvalidValue("-URL", ":::", ": java.net.MalformedURLException: no protocol: :::");
    }

    @Test
    public void testURIConvertersInvalidError() {
        this.parseInvalidValue("-URI", ":::", ": java.net.URISyntaxException: Expected scheme name at index 0: :::");
    }

    @Test
    public void testCharsetConvertersInvalidError() {
        this.parseInvalidValue("-Charset", "aa", ": java.nio.charset.UnsupportedCharsetException: aa");
    }

    @Test
    public void testInetAddressConvertersInvalidError() {
        this.parseInvalidValue("-InetAddress", "%$::a?*!a", ": java.net.UnknownHostException: %$::a?*!a");
    }

    @Test
    public void testUUIDConvertersInvalidError() {
        this.parseInvalidValue("-UUID", "aa", ": java.lang.IllegalArgumentException: Invalid UUID string: aa");
    }

    @Test
    public void testRegexPatternConverterInvalidError() {
        this.parseInvalidValue("-Pattern", "[[(aa", String.format(": java.util.regex.PatternSyntaxException: Unclosed character class near index 4%n[[(aa%n    ^", new Object[0]));
    }

    private void parseInvalidValue(String option, String value, String errorMessage) {
        try {
            CommandLine.populateCommand((Object)new SupportedTypes(), (String[])new String[]{option, value});
            Assert.fail((String)("Invalid format " + value + " was accepted for " + option));
        }
        catch (CommandLine.ParameterException actual) {
            String type = option.substring(1);
            String expected = "Could not convert '" + value + "' to " + type + " for option '" + option + "'" + errorMessage;
            Assert.assertTrue((String)("expected:<" + expected + "> but was:<" + actual.getMessage() + ">"), (boolean)actual.getMessage().startsWith(actual.getMessage()));
        }
    }

    @Test
    public void testCustomConverter() {
        class App {
            @CommandLine.Parameters
            Glob globField;

            App() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new App());
        class Glob {
            public final String glob;

            public Glob(String glob) {
                this.glob = glob;
            }
        }
        class GlobConverter
        implements CommandLine.ITypeConverter<Glob> {
            GlobConverter() {
            }

            public Glob convert(String value) throws Exception {
                return new Glob(value);
            }
        }
        commandLine.registerConverter(Glob.class, (CommandLine.ITypeConverter)new GlobConverter());
        String[] args = new String[]{"a*glob*pattern"};
        List parsed = commandLine.parse(args);
        Assert.assertEquals((String)"not empty", (long)1L, (long)parsed.size());
        Assert.assertTrue((boolean)(((CommandLine)parsed.get(0)).getCommand() instanceof App));
        App app = (App)((CommandLine)parsed.get(0)).getCommand();
        Assert.assertEquals((Object)args[0], (Object)app.globField.glob);
    }

    @Test
    public void testEnumTypeConversionSuceedsForValidInput() {
        EnumParams params = (EnumParams)CommandLine.populateCommand((Object)new EnumParams(), (String[])"-timeUnit SECONDS -timeUnitArray MILLISECONDS SECONDS -timeUnitList SECONDS MICROSECONDS NANOSECONDS".split(" "));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)params.timeUnit));
        Assert.assertArrayEquals((Object[])new TimeUnit[]{TimeUnit.MILLISECONDS, TimeUnit.SECONDS}, (Object[])params.timeUnitArray);
        ArrayList<TimeUnit> expected = new ArrayList<TimeUnit>(Arrays.asList(TimeUnit.SECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS));
        Assert.assertEquals(expected, params.timeUnitList);
    }

    @Test
    public void testEnumTypeConversionFailsForInvalidInput() {
        try {
            CommandLine.populateCommand((Object)new EnumParams(), (String[])new String[]{"-timeUnit", "xyz"});
            Assert.fail((String)"Accepted invalid timeunit");
        }
        catch (Exception ex) {
            String prefix = "Could not convert 'xyz' to TimeUnit for option '-timeUnit': java.lang.IllegalArgumentException: No enum cons";
            String suffix = " java.util.concurrent.TimeUnit.xyz";
            Assert.assertEquals((Object)prefix, (Object)ex.getMessage().substring(0, prefix.length()));
            Assert.assertEquals((Object)suffix, (Object)ex.getMessage().substring(ex.getMessage().length() - suffix.length(), ex.getMessage().length()));
        }
    }

    @Ignore(value="Requires #14 case-insensitive enum parsing")
    @Test
    public void testEnumTypeConversionIsCaseInsensitive() {
        EnumParams params = (EnumParams)CommandLine.populateCommand((Object)new EnumParams(), (String[])"-timeUnit sEcONds -timeUnitArray milliSeconds miCroSeConds -timeUnitList SEConds MiCROsEconds nanoSEConds".split(" "));
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)params.timeUnit));
        Assert.assertArrayEquals((Object[])new TimeUnit[]{TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS}, (Object[])params.timeUnitArray);
        ArrayList<TimeUnit> expected = new ArrayList<TimeUnit>(Arrays.asList(TimeUnit.SECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS));
        Assert.assertEquals(expected, params.timeUnitList);
    }

    @Test
    public void testEnumArrayTypeConversionFailsForInvalidInput() {
        try {
            CommandLine.populateCommand((Object)new EnumParams(), (String[])new String[]{"-timeUnitArray", "a", "b"});
            Assert.fail((String)"Accepted invalid timeunit");
        }
        catch (Exception ex) {
            String prefix = "Could not convert 'a' to TimeUnit for option '-timeUnitArray' at index 0 (<timeUnitArray>): java.lang.IllegalArgumentException: No enum const";
            String suffix = " java.util.concurrent.TimeUnit.a";
            Assert.assertEquals((Object)prefix, (Object)ex.getMessage().substring(0, prefix.length()));
            Assert.assertEquals((Object)suffix, (Object)ex.getMessage().substring(ex.getMessage().length() - suffix.length(), ex.getMessage().length()));
        }
    }

    @Test
    public void testEnumListTypeConversionFailsForInvalidInput() {
        try {
            CommandLine.populateCommand((Object)new EnumParams(), (String[])new String[]{"-timeUnitList", "SECONDS", "b", "c"});
            Assert.fail((String)"Accepted invalid timeunit");
        }
        catch (Exception ex) {
            String prefix = "Could not convert 'b' to TimeUnit for option '-timeUnitList' at index 1 (<timeUnitList>): java.lang.IllegalArgumentException: No enum const";
            String suffix = " java.util.concurrent.TimeUnit.b";
            Assert.assertEquals((Object)prefix, (Object)ex.getMessage().substring(0, prefix.length()));
            Assert.assertEquals((Object)suffix, (Object)ex.getMessage().substring(ex.getMessage().length() - suffix.length(), ex.getMessage().length()));
        }
    }

    @Test
    public void testArrayOptionParametersAreAlwaysInstantiated() {
        EnumParams params = new EnumParams();
        TimeUnit[] array = params.timeUnitArray;
        new CommandLine((Object)params).parse(new String[]{"-timeUnitArray", "SECONDS", "MILLISECONDS"});
        Assert.assertNotSame((Object)array, (Object)params.timeUnitArray);
    }

    @Test
    public void testListOptionParametersAreInstantiatedIfNull() {
        EnumParams params = new EnumParams();
        Assert.assertNull(params.timeUnitList);
        new CommandLine((Object)params).parse(new String[]{"-timeUnitList", "SECONDS", "MICROSECONDS", "MILLISECONDS"});
        Assert.assertEquals(Arrays.asList(TimeUnit.SECONDS, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS), params.timeUnitList);
    }

    @Test
    public void testListOptionParametersAreReusedInstantiatedIfNonNull() {
        EnumParams params = new EnumParams();
        ArrayList<TimeUnit> list = new ArrayList<TimeUnit>();
        params.timeUnitList = list;
        new CommandLine((Object)params).parse(new String[]{"-timeUnitList", "SECONDS", "MICROSECONDS", "SECONDS"});
        Assert.assertEquals(Arrays.asList(TimeUnit.SECONDS, TimeUnit.MICROSECONDS, TimeUnit.SECONDS), params.timeUnitList);
        Assert.assertSame(list, params.timeUnitList);
    }

    @Test
    public void testArrayPositionalParametersAreAppendedNotReplaced() {
        class ArrayPositionalParams {
            @CommandLine.Parameters
            int[] array;

            ArrayPositionalParams() {
            }
        }
        ArrayPositionalParams params = new ArrayPositionalParams();
        int[] array = params.array = new int[3];
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotSame((Object)array, (Object)params.array);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 3, 2, 1}, (int[])params.array);
    }

    @Test
    public void testListPositionalParametersAreInstantiatedIfNull() {
        ListPositionalParams params = new ListPositionalParams();
        Assert.assertNull(params.list);
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotNull(params.list);
        Assert.assertEquals(Arrays.asList(3, 2, 1), params.list);
    }

    @Test
    public void testListPositionalParametersAreReusedIfNonNull() {
        ListPositionalParams params = new ListPositionalParams();
        List<Integer> list = params.list = new ArrayList<Integer>();
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.list);
        Assert.assertEquals(Arrays.asList(3, 2, 1), params.list);
    }

    @Test
    public void testListPositionalParametersAreAppendedToIfNonNull() {
        ListPositionalParams params = new ListPositionalParams();
        params.list = new ArrayList<Integer>();
        params.list.add(234);
        List<Integer> list = params.list;
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.list);
        Assert.assertEquals(Arrays.asList(234, 3, 2, 1), params.list);
    }

    @Test
    public void testSortedSetPositionalParametersAreInstantiatedIfNull() {
        SortedSetPositionalParams params = new SortedSetPositionalParams();
        Assert.assertNull(params.sortedSet);
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotNull(params.sortedSet);
        Assert.assertEquals(Arrays.asList(1, 2, 3), new ArrayList<Integer>(params.sortedSet));
    }

    @Test
    public void testSortedSetPositionalParametersAreReusedIfNonNull() {
        SortedSetPositionalParams params = new SortedSetPositionalParams();
        SortedSet<Integer> list = params.sortedSet = new TreeSet<Integer>();
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.sortedSet);
        Assert.assertEquals(Arrays.asList(1, 2, 3), new ArrayList<Integer>(params.sortedSet));
    }

    @Test
    public void testSortedSetPositionalParametersAreAppendedToIfNonNull() {
        SortedSetPositionalParams params = new SortedSetPositionalParams();
        params.sortedSet = new TreeSet<Integer>();
        params.sortedSet.add(234);
        SortedSet<Integer> list = params.sortedSet;
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.sortedSet);
        Assert.assertEquals(Arrays.asList(1, 2, 3, 234), new ArrayList<Integer>(params.sortedSet));
    }

    @Test
    public void testSetPositionalParametersAreInstantiatedIfNull() {
        SetPositionalParams params = new SetPositionalParams();
        Assert.assertNull(params.set);
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotNull(params.set);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3)), params.set);
    }

    @Test
    public void testSetPositionalParametersAreReusedIfNonNull() {
        SetPositionalParams params = new SetPositionalParams();
        Set<Integer> list = params.set = new TreeSet<Integer>();
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.set);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3)), params.set);
    }

    @Test
    public void testSetPositionalParametersAreAppendedToIfNonNull() {
        SetPositionalParams params = new SetPositionalParams();
        params.set = new TreeSet<Integer>();
        params.set.add(234);
        Set<Integer> list = params.set;
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.set);
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(1, 2, 3, 234)), params.set);
    }

    @Test
    public void testQueuePositionalParametersAreInstantiatedIfNull() {
        QueuePositionalParams params = new QueuePositionalParams();
        Assert.assertNull(params.queue);
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotNull(params.queue);
        Assert.assertEquals(new LinkedList<Integer>(Arrays.asList(3, 2, 1)), params.queue);
    }

    @Test
    public void testQueuePositionalParametersAreReusedIfNonNull() {
        QueuePositionalParams params = new QueuePositionalParams();
        Queue<Integer> list = params.queue = new LinkedList<Integer>();
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.queue);
        Assert.assertEquals(new LinkedList<Integer>(Arrays.asList(3, 2, 1)), params.queue);
    }

    @Test
    public void testQueuePositionalParametersAreAppendedToIfNonNull() {
        QueuePositionalParams params = new QueuePositionalParams();
        params.queue = new LinkedList<Integer>();
        params.queue.add(234);
        Queue<Integer> list = params.queue;
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.queue);
        Assert.assertEquals(new LinkedList<Integer>(Arrays.asList(234, 3, 2, 1)), params.queue);
    }

    @Test
    public void testCollectionPositionalParametersAreInstantiatedIfNull() {
        CollectionPositionalParams params = new CollectionPositionalParams();
        Assert.assertNull(params.collection);
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertNotNull(params.collection);
        Assert.assertEquals(Arrays.asList(3, 2, 1), params.collection);
    }

    @Test
    public void testCollectionPositionalParametersAreReusedIfNonNull() {
        CollectionPositionalParams params = new CollectionPositionalParams();
        Collection<Integer> list = params.collection = new ArrayList<Integer>();
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.collection);
        Assert.assertEquals(Arrays.asList(3, 2, 1), params.collection);
    }

    @Test
    public void testCollectionPositionalParametersAreAppendedToIfNonNull() {
        CollectionPositionalParams params = new CollectionPositionalParams();
        params.collection = new ArrayList<Integer>();
        params.collection.add(234);
        Collection<Integer> list = params.collection;
        new CommandLine((Object)params).parse(new String[]{"3", "2", "1"});
        Assert.assertSame(list, params.collection);
        Assert.assertEquals(Arrays.asList(234, 3, 2, 1), params.collection);
    }

    @Test(expected=CommandLine.DuplicateOptionAnnotationsException.class)
    public void testDuplicateOptionsAreRejected() {
        class DuplicateOptions {
            @CommandLine.Option(names={"-duplicate"})
            public int value1;
            @CommandLine.Option(names={"-duplicate"})
            public int value2;

            DuplicateOptions() {
            }
        }
        new CommandLine((Object)new DuplicateOptions());
    }

    @Test(expected=CommandLine.DuplicateOptionAnnotationsException.class)
    public void testClashingAnnotationsAreRejected() {
        class ClashingAnnotation {
            @CommandLine.Option(names={"-o"})
            @CommandLine.Parameters
            public String[] bothOptionAndParameters;

            ClashingAnnotation() {
            }
        }
        new CommandLine((Object)new ClashingAnnotation());
    }

    @Test
    public void testCanInitializePrivateFinalFields() {
        PrivateFinalOptionFields ff = (PrivateFinalOptionFields)CommandLine.populateCommand((Object)new PrivateFinalOptionFields(), (String[])new String[]{"-f", "reference value"});
        Assert.assertEquals((Object)"reference value", (Object)ff.field);
    }

    @Ignore(value="Needs Reject final primitive fields annotated with @Option or @Parameters #68")
    @Test
    public void testCanInitializeFinalPrimitiveFields() {
        PrivateFinalOptionFields ff = (PrivateFinalOptionFields)CommandLine.populateCommand((Object)new PrivateFinalOptionFields(), (String[])new String[]{"-p", "12"});
        Assert.assertEquals((String)"primitive value", (long)12L, (long)43L);
    }

    @Test
    public void testLastValueSelectedIfOptionSpecifiedMultipleTimes() {
        CommandLineTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new PrivateFinalOptionFields()).setOverwrittenOptionsAllowed(true);
        cmd.parse(new String[]{"-f", "111", "-f", "222"});
        PrivateFinalOptionFields ff = (PrivateFinalOptionFields)cmd.getCommand();
        Assert.assertEquals((Object)"222", (Object)ff.field);
    }

    @Test
    public void testCanInitializePrivateFinalParameterFields() {
        PrivateFinalParameterFields ff = (PrivateFinalParameterFields)CommandLine.populateCommand((Object)new PrivateFinalParameterFields(), (String[])new String[]{"ref value"});
        Assert.assertEquals((Object)"ref value", (Object)ff.field);
    }

    @Ignore(value="Needs Reject final primitive fields annotated with @Option or @Parameters #68")
    @Test
    public void testCannotInitializePrivateFinalPrimitiveParameterFields() {
        PrivateFinalParameterFields ff = (PrivateFinalParameterFields)CommandLine.populateCommand((Object)new PrivateFinalParameterFields(), (String[])new String[]{"ref value", "12"});
        Assert.assertEquals((Object)"ref value", (Object)ff.field);
        Assert.assertEquals((String)"primitive value", (long)12L, (long)43L);
    }

    @Test
    public void testErrorIfRequiredOptionNotSpecified() {
        try {
            CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"arg1", "arg2"});
            Assert.fail((String)"Missing required field should have thrown exception");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '--required=<required>'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNoErrorIfRequiredOptionSpecified() {
        CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"--required", "arg1", "arg2"});
    }

    @Test
    public void testNoErrorIfRequiredOptionNotSpecifiedWhenHelpRequested() {
        RequiredField requiredField = (RequiredField)CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"-?"});
        Assert.assertTrue((String)"help requested", (boolean)requiredField.isHelpRequested);
    }

    @Test
    public void testNoErrorIfRequiredOptionNotSpecifiedWhenUsageHelpRequested() {
        RequiredField requiredField = (RequiredField)CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"--help"});
        Assert.assertTrue((String)"usage help requested", (boolean)requiredField.usageHelp);
    }

    @Test
    public void testNoErrorIfRequiredOptionNotSpecifiedWhenVersionHelpRequested() {
        RequiredField requiredField = (RequiredField)CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"--version"});
        Assert.assertTrue((String)"version info requested", (boolean)requiredField.versionHelp);
    }

    @Test
    public void testCommandLine_isUsageHelpRequested_trueWhenSpecified() {
        List parsedCommands = new CommandLine((Object)new RequiredField()).parse(new String[]{"--help"});
        Assert.assertTrue((String)"usage help requested", (boolean)((CommandLine)parsedCommands.get(0)).isUsageHelpRequested());
    }

    @Test
    public void testCommandLine_isVersionHelpRequested_trueWhenSpecified() {
        List parsedCommands = new CommandLine((Object)new RequiredField()).parse(new String[]{"--version"});
        Assert.assertTrue((String)"version info requested", (boolean)((CommandLine)parsedCommands.get(0)).isVersionHelpRequested());
    }

    @Test
    public void testCommandLine_isUsageHelpRequested_falseWhenNotSpecified() {
        List parsedCommands = new CommandLine((Object)new RequiredField()).parse(new String[]{"--version"});
        Assert.assertFalse((String)"usage help requested", (boolean)((CommandLine)parsedCommands.get(0)).isUsageHelpRequested());
    }

    @Test
    public void testCommandLine_isVersionHelpRequested_falseWhenNotSpecified() {
        List parsedCommands = new CommandLine((Object)new RequiredField()).parse(new String[]{"--help"});
        Assert.assertFalse((String)"version info requested", (boolean)((CommandLine)parsedCommands.get(0)).isVersionHelpRequested());
    }

    @Test
    public void testHelpRequestedFlagResetWhenParsing_staticMethod() {
        RequiredField requiredField = (RequiredField)CommandLine.populateCommand((Object)new RequiredField(), (String[])new String[]{"-?"});
        Assert.assertTrue((String)"help requested", (boolean)requiredField.isHelpRequested);
        requiredField.isHelpRequested = false;
        try {
            CommandLine.populateCommand((Object)requiredField, (String[])new String[]{"arg1", "arg2"});
            Assert.fail((String)"Missing required field should have thrown exception");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '--required=<required>'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testHelpRequestedFlagResetWhenParsing_instanceMethod() {
        RequiredField requiredField = new RequiredField();
        CommandLine commandLine = new CommandLine((Object)requiredField);
        commandLine.parse(new String[]{"-?"});
        Assert.assertTrue((String)"help requested", (boolean)requiredField.isHelpRequested);
        requiredField.isHelpRequested = false;
        try {
            commandLine.parse(new String[]{"arg1", "arg2"});
            Assert.fail((String)"Missing required field should have thrown exception");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '--required=<required>'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testCompactFieldsAnyOrder() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])new String[]{"-rvoout"});
        this.verifyCompact(compact, true, true, "out", null);
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])new String[]{"-vroout"});
        this.verifyCompact(compact, true, true, "out", null);
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])new String[]{"-vro=out"});
        this.verifyCompact(compact, true, true, "out", null);
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rv p1 p2".split(" "));
        this.verifyCompact(compact, true, true, null, this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-voout p1 p2".split(" "));
        this.verifyCompact(compact, true, false, "out", this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-voout -r p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-r -v -oout p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rv -o out p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-oout -r -v p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
        compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rvo out p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
        try {
            CommandLine.populateCommand((Object)new CompactFields(), (String[])"-oout -r -vp1 p2".split(" "));
            Assert.fail((String)"should fail: -v does not take an argument");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [-p1]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testCompactFieldsWithUnmatchedArguments() {
        CommandLineTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new CompactFields()).setUnmatchedArgumentsAllowed(true);
        cmd.parse("-oout -r -vp1 p2".split(" "));
        Assert.assertEquals(Arrays.asList("-p1"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testCompactWithOptionParamSeparatePlusParameters() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-r -v -o out p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
    }

    @Test
    public void testCompactWithOptionParamAttachedEqualsSeparatorChar() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rvo=out p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
    }

    @Test
    public void testCompactWithOptionParamAttachedColonSeparatorChar() {
        CompactFields compact = new CompactFields();
        CommandLine cmd = new CommandLine((Object)compact);
        cmd.setSeparator(":");
        cmd.parse("-rvo:out p1 p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
    }

    @Test
    public void testDefaultSeparatorIsEquals() {
        Assert.assertEquals((Object)"=", (Object)new CommandLine((Object)new CompactFields()).getSeparator());
    }

    @Test
    public void testOptionsMixedWithParameters() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-r -v p1 -o out p2".split(" "));
        this.verifyCompact(compact, true, true, "out", this.fileArray("p1", "p2"));
    }

    @Test
    public void testShortOptionsWithSeparatorButNoValueAssignsEmptyStringEvenIfNotLast() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-ro= -v".split(" "));
        this.verifyCompact(compact, false, true, "-v", null);
    }

    @Test
    public void testShortOptionsWithColonSeparatorButNoValueAssignsEmptyStringEvenIfNotLast() {
        CompactFields compact = new CompactFields();
        CommandLine cmd = new CommandLine((Object)compact);
        cmd.setSeparator(":");
        cmd.parse("-ro: -v".split(" "));
        this.verifyCompact(compact, false, true, "-v", null);
    }

    @Test
    public void testShortOptionsWithSeparatorButNoValueFailsIfValueRequired() {
        try {
            CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rvo=".split(" "));
            Assert.fail((String)"Expected exception");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter for option '-o' (<outputFile>)", (Object)ex.getMessage());
        }
    }

    @Test
    public void testShortOptionsWithSeparatorButNoValueAssignsQuotedEmptyStringEvenIfNotLast() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-ro=\"\" -v".split(" "));
        this.verifyCompact(compact, true, true, "", null);
    }

    @Test
    public void testShortOptionsWithColonSeparatorButNoValueAssignsQuotedEmptyStringEvenIfNotLast() {
        CompactFields compact = new CompactFields();
        CommandLine cmd = new CommandLine((Object)compact);
        cmd.setSeparator(":");
        cmd.parse("-ro:\"\" -v".split(" "));
        this.verifyCompact(compact, true, true, "", null);
    }

    @Test
    public void testShortOptionsWithSeparatorButNoValueAssignsEmptyQuotedStringIfLast() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rvo=\"\"".split(" "));
        this.verifyCompact(compact, true, true, "", null);
    }

    @Test
    public void testDoubleDashSeparatesPositionalParameters() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-oout -- -r -v p1 p2".split(" "));
        this.verifyCompact(compact, false, false, "out", this.fileArray("-r", "-v", "p1", "p2"));
    }

    @Test
    public void testDebugOutputForDoubleDashSeparatesPositionalParameters() throws UnsupportedEncodingException {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        String PROPERTY = "picocli.trace";
        String old = System.getProperty("picocli.trace");
        System.setProperty("picocli.trace", "DEBUG");
        CommandLine.populateCommand((Object)new CompactFields(), (String[])"-oout -- -r -v p1 p2".split(" "));
        System.setErr(originalErr);
        if (old == null) {
            System.clearProperty("picocli.trace");
        } else {
            System.setProperty("picocli.trace", old);
        }
        String expected = String.format("[picocli INFO] Parsing 6 command line args [-oout, --, -r, -v, p1, p2]%n[picocli DEBUG] Initializing %1$s$CompactFields: 3 options, 1 positional parameters, 0 required, 0 subcommands.%n[picocli DEBUG] Processing argument '-oout'. Remainder=[--, -r, -v, p1, p2]%n[picocli DEBUG] '-oout' cannot be separated into <option>=<option-parameter>%n[picocli DEBUG] Trying to process '-oout' as clustered short options%n[picocli DEBUG] Found option '-o' in -oout: field java.io.File %1$s$CompactFields.outputFile, arity=1%n[picocli DEBUG] Trying to process 'out' as option parameter%n[picocli INFO] Setting File field 'CompactFields.outputFile' to 'out' (was 'null') for option -o%n[picocli DEBUG] Processing argument '--'. Remainder=[-r, -v, p1, p2]%n[picocli INFO] Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n[picocli DEBUG] Processing next arg as a positional parameter at index=0. Remainder=[-r, -v, p1, p2]%n[picocli DEBUG] Position 0 is in index range 0..*. Trying to assign args to java.io.File[] %1$s$CompactFields.inputFiles, arity=0..1%n[picocli INFO] Adding [-r] to File[] field 'CompactFields.inputFiles' for args[0..*] at position 0%n[picocli DEBUG] Consumed 1 arguments, moving position to index 1.%n[picocli DEBUG] Processing next arg as a positional parameter at index=1. Remainder=[-v, p1, p2]%n[picocli DEBUG] Position 1 is in index range 0..*. Trying to assign args to java.io.File[] %1$s$CompactFields.inputFiles, arity=0..1%n[picocli INFO] Adding [-v] to File[] field 'CompactFields.inputFiles' for args[0..*] at position 1%n[picocli DEBUG] Consumed 1 arguments, moving position to index 2.%n[picocli DEBUG] Processing next arg as a positional parameter at index=2. Remainder=[p1, p2]%n[picocli DEBUG] Position 2 is in index range 0..*. Trying to assign args to java.io.File[] %1$s$CompactFields.inputFiles, arity=0..1%n[picocli INFO] Adding [p1] to File[] field 'CompactFields.inputFiles' for args[0..*] at position 2%n[picocli DEBUG] Consumed 1 arguments, moving position to index 3.%n[picocli DEBUG] Processing next arg as a positional parameter at index=3. Remainder=[p2]%n[picocli DEBUG] Position 3 is in index range 0..*. Trying to assign args to java.io.File[] %1$s$CompactFields.inputFiles, arity=0..1%n[picocli INFO] Adding [p2] to File[] field 'CompactFields.inputFiles' for args[0..*] at position 3%n[picocli DEBUG] Consumed 1 arguments, moving position to index 4.%n", CommandLineTest.class.getName(), new File("/home/rpopma/picocli"));
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private File[] fileArray(String ... paths) {
        File[] result = new File[paths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new File(paths[i]);
        }
        return result;
    }

    private void verifyCompact(CompactFields compact, boolean verbose, boolean recursive, String out, File[] params) {
        Assert.assertEquals((String)"-v", (Object)verbose, (Object)compact.verbose);
        Assert.assertEquals((String)"-r", (Object)recursive, (Object)compact.recursive);
        Assert.assertEquals((String)"-o", (Object)(out == null ? null : new File(out)), (Object)compact.outputFile);
        if (params == null) {
            Assert.assertNull((String)"args", (Object)compact.inputFiles);
        } else {
            Assert.assertArrayEquals((String)("args=" + Arrays.toString(compact.inputFiles)), (Object[])params, (Object[])compact.inputFiles);
        }
    }

    @Test
    public void testNonSpacedOptions() {
        CompactFields compact = (CompactFields)CommandLine.populateCommand((Object)new CompactFields(), (String[])"-rvo arg path path".split(" "));
        Assert.assertTrue((String)"-r", (boolean)compact.recursive);
        Assert.assertTrue((String)"-v", (boolean)compact.verbose);
        Assert.assertEquals((String)"-o", (Object)new File("arg"), (Object)compact.outputFile);
        Assert.assertArrayEquals((String)"args", (Object[])new File[]{new File("path"), new File("path")}, (Object[])compact.inputFiles);
    }

    @Test
    public void testPrimitiveParameters() {
        class PrimitiveIntParameters {
            @CommandLine.Parameters
            int[] intParams;

            PrimitiveIntParameters() {
            }
        }
        PrimitiveIntParameters params = (PrimitiveIntParameters)CommandLine.populateCommand((Object)new PrimitiveIntParameters(), (String[])"1 2 3 4".split(" "));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])params.intParams);
    }

    @Test(expected=CommandLine.MissingTypeConverterException.class)
    public void testMissingTypeConverter() {
        class MissingConverter {
            @CommandLine.Option(names={"--socket"})
            Socket socket;

            MissingConverter() {
            }
        }
        CommandLine.populateCommand((Object)new MissingConverter(), (String[])"--socket anyString".split(" "));
    }

    @Test
    public void testParametersDeclaredOutOfOrderWithNoArgs() {
        try {
            class WithParams {
                @CommandLine.Parameters(index="1")
                String param1;
                @CommandLine.Parameters(index="0")
                String param0;

                WithParams() {
                }
            }
            CommandLine.populateCommand((Object)new WithParams(), (String[])new String[0]);
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters: <param0>, <param1>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testOptionsMayDefineAnyPrefixChar() {
        VariousPrefixCharacters params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"-d 123 /4 /S 765 /T=98 /Owner=xyz -SingleDash [CPM CP/M (CMS=cmsVal".split(" "));
        Assert.assertEquals((String)"-d", (long)123L, (long)params.dash);
        Assert.assertEquals((String)"/S", (long)765L, (long)params.slashS);
        Assert.assertEquals((String)"/T", (long)98L, (long)params.slashT);
        Assert.assertTrue((String)"/4", (boolean)params.fourDigit);
        Assert.assertTrue((String)"-SingleDash", (boolean)params.singleDash);
        Assert.assertEquals((String)"/Owner", (Object)"xyz", (Object)params.owner);
        Assert.assertEquals((String)"[CPM", (Object)"CP/M", (Object)params.cpm);
        Assert.assertEquals((String)"(CMS", (Object)"cmsVal", (Object)params.cms);
    }

    @Test
    public void testGnuLongOptionsWithVariousSeparators() {
        VariousPrefixCharacters params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--dash 123".split(" "));
        Assert.assertEquals((String)"--dash val", (long)123L, (long)params.dash);
        params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--dash=234 --owner=x".split(" "));
        Assert.assertEquals((String)"--dash=val", (long)234L, (long)params.dash);
        Assert.assertEquals((String)"--owner=x", (Object)"x", (Object)params.owner);
        params = new VariousPrefixCharacters();
        CommandLine cmd = new CommandLine((Object)params);
        cmd.setSeparator(":");
        cmd.parse(new String[]{"--dash:345"});
        Assert.assertEquals((String)"--dash:val", (long)345L, (long)params.dash);
        params = new VariousPrefixCharacters();
        cmd = new CommandLine((Object)params);
        cmd.setSeparator(":");
        cmd.parse("--dash:345 --owner:y".split(" "));
        Assert.assertEquals((String)"--dash:val", (long)345L, (long)params.dash);
        Assert.assertEquals((String)"--owner:y", (Object)"y", (Object)params.owner);
    }

    @Test
    public void testSeparatorCanBeSetDeclaratively() {
        try {
            @CommandLine.Command(separator=":")
            class App {
                @CommandLine.Option(names={"--opt"}, required=true)
                String opt;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--opt=abc"});
            Assert.fail((String)"Expected failure with unknown separator");
        }
        catch (CommandLine.MissingParameterException ok) {
            Assert.assertEquals((Object)"Missing required option '--opt:<opt>'", (Object)ok.getMessage());
        }
    }

    @Test
    public void testIfSeparatorSetTheDefaultSeparatorIsNotRecognized() {
        try {
            @CommandLine.Command(separator=":")
            class App {
                @CommandLine.Option(names={"--opt"}, required=true)
                String opt;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--opt=abc"});
            Assert.fail((String)"Expected failure with unknown separator");
        }
        catch (CommandLine.MissingParameterException ok) {
            Assert.assertEquals((Object)"Missing required option '--opt:<opt>'", (Object)ok.getMessage());
        }
    }

    @Test
    public void testIfSeparatorSetTheDefaultSeparatorIsNotRecognizedWithUnmatchedArgsAllowed() {
        CommandLineTest.setTraceLevel("OFF");
        @CommandLine.Command(separator=":")
        class App {
            @CommandLine.Option(names={"--opt"}, required=true)
            String opt;

            App() {
            }
        }
        CommandLine cmd = new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true);
        try {
            cmd.parse(new String[]{"--opt=abc"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ok) {
            Assert.assertEquals((Object)"Missing required option '--opt:<opt>'", (Object)ok.getMessage());
            Assert.assertEquals(Arrays.asList("--opt=abc"), (Object)cmd.getUnmatchedArguments());
        }
    }

    @Test
    public void testGnuLongOptionsWithVariousSeparatorsOnlyAndNoValue() {
        VariousPrefixCharacters params;
        try {
            params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--dash".split(" "));
            Assert.fail((String)"int option needs arg");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter for option '-d' (<dash>)", (Object)ex.getMessage());
        }
        try {
            params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--owner".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter for option '/Owner' (<owner>)", (Object)ex.getMessage());
        }
        params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--owner=".split(" "));
        Assert.assertEquals((String)"--owner= (at end)", (Object)"", (Object)params.owner);
        params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--owner= /4".split(" "));
        Assert.assertEquals((String)"--owner= (in middle)", (Object)"", (Object)params.owner);
        Assert.assertEquals((String)"/4", (Object)true, (Object)params.fourDigit);
        try {
            params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--dash=".split(" "));
            Assert.fail((String)"int option (with sep but no value) needs arg");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Could not convert '' to int for option '-d': java.lang.NumberFormatException: For input string: \"\"", (Object)ex.getMessage());
        }
        try {
            params = (VariousPrefixCharacters)CommandLine.populateCommand((Object)new VariousPrefixCharacters(), (String[])"--dash= /4".split(" "));
            Assert.fail((String)"int option (with sep but no value, followed by other option) needs arg");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Could not convert '' to int for option '-d': java.lang.NumberFormatException: For input string: \"\"", (Object)ex.getMessage());
        }
    }

    @Test
    public void testOptionParameterSeparatorIsCustomizable() {
        VariousPrefixCharacters params = new VariousPrefixCharacters();
        CommandLine cmd = new CommandLine((Object)params);
        cmd.setSeparator(":");
        cmd.parse("-d 123 /4 /S 765 /T:98 /Owner:xyz -SingleDash [CPM CP/M (CMS:cmsVal".split(" "));
        Assert.assertEquals((String)"-d", (long)123L, (long)params.dash);
        Assert.assertEquals((String)"/S", (long)765L, (long)params.slashS);
        Assert.assertEquals((String)"/T", (long)98L, (long)params.slashT);
        Assert.assertTrue((String)"/4", (boolean)params.fourDigit);
        Assert.assertTrue((String)"-SingleDash", (boolean)params.singleDash);
        Assert.assertEquals((String)"/Owner", (Object)"xyz", (Object)params.owner);
        Assert.assertEquals((String)"[CPM", (Object)"CP/M", (Object)params.cpm);
        Assert.assertEquals((String)"(CMS", (Object)"cmsVal", (Object)params.cms);
    }

    @Test(expected=NullPointerException.class)
    public void testOptionParameterSeparatorCannotBeSetToNull() {
        CommandLine cmd = new CommandLine((Object)new VariousPrefixCharacters());
        cmd.setSeparator(null);
    }

    @Test
    public void testPotentiallyNestedOptionParsedCorrectly() {
        class MyOption {
            @CommandLine.Option(names={"-p"})
            String path;

            MyOption() {
            }
        }
        MyOption opt = (MyOption)CommandLine.populateCommand((Object)new MyOption(), (String[])new String[]{"-pa-p"});
        Assert.assertEquals((Object)"a-p", (Object)opt.path);
        opt = (MyOption)CommandLine.populateCommand((Object)new MyOption(), (String[])new String[]{"-p-ap"});
        Assert.assertEquals((Object)"-ap", (Object)opt.path);
    }

    @Test
    public void testArityGreaterThanOneForSingleValuedFields() {
        class Arity2 {
            @CommandLine.Option(names={"-p"}, arity="2")
            String path;
            @CommandLine.Option(names={"-o"}, arity="2")
            String[] otherPath;

            Arity2() {
            }
        }
        Arity2 opt = (Arity2)CommandLine.populateCommand((Object)new Arity2(), (String[])"-o a b".split(" "));
        try {
            opt = (Arity2)CommandLine.populateCommand((Object)new Arity2(), (String[])"-p a b".split(" "));
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [b]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testOptionParameterQuotesRemovedFromValue() {
        class TextOption {
            @CommandLine.Option(names={"-t"})
            String text;

            TextOption() {
            }
        }
        TextOption opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t", "\"a text\""});
        Assert.assertEquals((Object)"a text", (Object)opt.text);
    }

    @Test
    public void testLongOptionAttachedQuotedParameterQuotesRemovedFromValue() {
        class TextOption {
            @CommandLine.Option(names={"--text"})
            String text;

            TextOption() {
            }
        }
        TextOption opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"--text=\"a text\""});
        Assert.assertEquals((Object)"a text", (Object)opt.text);
    }

    @Test
    public void testShortOptionAttachedQuotedParameterQuotesRemovedFromValue() {
        class TextOption {
            @CommandLine.Option(names={"-t"})
            String text;

            TextOption() {
            }
        }
        TextOption opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t\"a text\""});
        Assert.assertEquals((Object)"a text", (Object)opt.text);
        opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t=\"a text\""});
        Assert.assertEquals((Object)"a text", (Object)opt.text);
    }

    @Test
    public void testShortOptionQuotedParameterTypeConversion() {
        class TextOption {
            @CommandLine.Option(names={"-t"})
            int[] number;
            @CommandLine.Option(names={"-v"}, arity="1")
            boolean verbose;

            TextOption() {
            }
        }
        TextOption opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t", "\"123\"", "-v", "\"true\""});
        Assert.assertEquals((long)123L, (long)opt.number[0]);
        Assert.assertTrue((boolean)opt.verbose);
        opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t\"123\"", "-v\"true\""});
        Assert.assertEquals((long)123L, (long)opt.number[0]);
        Assert.assertTrue((boolean)opt.verbose);
        opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t=\"345\"", "-v=\"true\""});
        Assert.assertEquals((long)345L, (long)opt.number[0]);
        Assert.assertTrue((boolean)opt.verbose);
    }

    @Test
    public void testOptionMultiParameterQuotesRemovedFromValue() {
        class TextOption {
            @CommandLine.Option(names={"-t"})
            String[] text;

            TextOption() {
            }
        }
        TextOption opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t", "\"a text\"", "-t", "\"another text\"", "-t", "\"x z\""});
        Assert.assertArrayEquals((Object[])new String[]{"a text", "another text", "x z"}, (Object[])opt.text);
        opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t\"a text\"", "-t\"another text\"", "-t\"x z\""});
        Assert.assertArrayEquals((Object[])new String[]{"a text", "another text", "x z"}, (Object[])opt.text);
        opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t=\"a text\"", "-t=\"another text\"", "-t=\"x z\""});
        Assert.assertArrayEquals((Object[])new String[]{"a text", "another text", "x z"}, (Object[])opt.text);
        try {
            opt = (TextOption)CommandLine.populateCommand((Object)new TextOption(), (String[])new String[]{"-t=\"a text\"", "-t=\"another text\"", "\"x z\""});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [\"x z\"]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testPositionalParameterQuotesRemovedFromValue() {
        class TextParams {
            @CommandLine.Parameters
            String[] text;

            TextParams() {
            }
        }
        TextParams opt = (TextParams)CommandLine.populateCommand((Object)new TextParams(), (String[])new String[]{"\"a text\""});
        Assert.assertEquals((Object)"a text", (Object)opt.text[0]);
    }

    @Test
    public void testPositionalMultiParameterQuotesRemovedFromValue() {
        class TextParams {
            @CommandLine.Parameters
            String[] text;

            TextParams() {
            }
        }
        TextParams opt = (TextParams)CommandLine.populateCommand((Object)new TextParams(), (String[])new String[]{"\"a text\"", "\"another text\"", "\"x z\""});
        Assert.assertArrayEquals((Object[])new String[]{"a text", "another text", "x z"}, (Object[])opt.text);
    }

    @Test
    public void testPositionalMultiQuotedParameterTypeConversion() {
        class TextParams {
            @CommandLine.Parameters
            int[] numbers;

            TextParams() {
            }
        }
        TextParams opt = (TextParams)CommandLine.populateCommand((Object)new TextParams(), (String[])new String[]{"\"123\"", "\"456\"", "\"999\""});
        Assert.assertArrayEquals((int[])new int[]{123, 456, 999}, (int[])opt.numbers);
    }

    @Test
    public void testSubclassedOptions() {
        class ChildOption
        extends 1ParentOption {
            @CommandLine.Option(names={"-t"})
            String text;

            ChildOption() {
                class ParentOption {
                    @CommandLine.Option(names={"-p"})
                    String path;

                    ParentOption() {
                    }
                }
            }
        }
        ChildOption opt = (ChildOption)CommandLine.populateCommand((Object)new ChildOption(), (String[])new String[]{"-p", "somePath", "-t", "\"a text\""});
        Assert.assertEquals((Object)"somePath", (Object)opt.path);
        Assert.assertEquals((Object)"a text", (Object)opt.text);
    }

    @Test
    public void testSubclassedOptionsWithShadowedOptionNameThrowsDuplicateOptionAnnotationsException() {
        class ChildOption
        extends ParentOption {
            @CommandLine.Option(names={"-p"})
            String text;

            ChildOption() {
                class ParentOption {
                    @CommandLine.Option(names={"-p"})
                    String path;

                    ParentOption() {
                    }
                }
            }
        }
        try {
            CommandLine.populateCommand((Object)new ChildOption(), (String[])new String[]{""});
            Assert.fail((String)"expected CommandLine$DuplicateOptionAnnotationsException");
        }
        catch (CommandLine.DuplicateOptionAnnotationsException ex) {
            String expected = String.format("Option name '-p' is used by both %s.path and %s.text", ParentOption.class.getName(), ChildOption.class.getName());
            Assert.assertEquals((Object)expected, (Object)ex.getMessage());
        }
    }

    @Test
    public void testSubclassedOptionsWithShadowedFieldInitializesChildField() {
        class ChildOption
        extends 3ParentOption {
            @CommandLine.Option(names={"-childPath"})
            String path;

            ChildOption() {
                class ParentOption {
                    @CommandLine.Option(names={"-parentPath"})
                    String path;

                    ParentOption() {
                    }
                }
            }
        }
        ChildOption opt = (ChildOption)CommandLine.populateCommand((Object)new ChildOption(), (String[])new String[]{"-childPath", "somePath"});
        Assert.assertEquals((Object)"somePath", (Object)opt.path);
        opt = (ChildOption)CommandLine.populateCommand((Object)new ChildOption(), (String[])new String[]{"-parentPath", "somePath"});
        Assert.assertNull((Object)opt.path);
    }

    @Test
    public void testPositionalParamWithAbsoluteIndex() {
        class App {
            @CommandLine.Parameters(index="0")
            File file0;
            @CommandLine.Parameters(index="1")
            File file1;
            @CommandLine.Parameters(index="2", arity="0..1")
            File file2;
            @CommandLine.Parameters
            List<String> all;

            App() {
            }
        }
        App app1 = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"000", "111", "222", "333"});
        Assert.assertEquals((String)"arg[0]", (Object)new File("000"), (Object)app1.file0);
        Assert.assertEquals((String)"arg[1]", (Object)new File("111"), (Object)app1.file1);
        Assert.assertEquals((String)"arg[2]", (Object)new File("222"), (Object)app1.file2);
        Assert.assertEquals((String)"args", Arrays.asList("000", "111", "222", "333"), app1.all);
        App app2 = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"000", "111"});
        Assert.assertEquals((String)"arg[0]", (Object)new File("000"), (Object)app2.file0);
        Assert.assertEquals((String)"arg[1]", (Object)new File("111"), (Object)app2.file1);
        Assert.assertEquals((String)"arg[2]", null, (Object)app2.file2);
        Assert.assertEquals((String)"args", Arrays.asList("000", "111"), app2.all);
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"000"});
            Assert.fail((String)"Should fail with missingParamException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <file1>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testPositionalParamWithFixedIndexRange() {
        System.setProperty("picocli.trace", "OFF");
        class App {
            @CommandLine.Parameters(index="0..1")
            File file0_1;
            @CommandLine.Parameters(index="1..2", type={File.class})
            List<File> fileList1_2;
            @CommandLine.Parameters(index="0..3")
            File[] fileArray0_3 = new File[4];
            @CommandLine.Parameters
            List<String> all;

            App() {
            }
        }
        App app1 = new App();
        new CommandLine((Object)app1).setOverwrittenOptionsAllowed(true).parse(new String[]{"000", "111", "222", "333"});
        Assert.assertEquals((String)"field initialized with arg[0]", (Object)new File("111"), (Object)app1.file0_1);
        Assert.assertEquals((String)"arg[1] and arg[2]", Arrays.asList(new File("111"), new File("222")), app1.fileList1_2);
        Assert.assertArrayEquals((String)"arg[0-3]", (Object[])new File[]{null, null, null, null, new File("000"), new File("111"), new File("222"), new File("333")}, (Object[])app1.fileArray0_3);
        Assert.assertEquals((String)"args", Arrays.asList("000", "111", "222", "333"), app1.all);
        App app2 = new App();
        new CommandLine((Object)app2).setOverwrittenOptionsAllowed(true).parse(new String[]{"000", "111"});
        Assert.assertEquals((String)"field initialized with arg[0]", (Object)new File("111"), (Object)app2.file0_1);
        Assert.assertEquals((String)"arg[1]", Arrays.asList(new File("111")), app2.fileList1_2);
        Assert.assertArrayEquals((String)"arg[0-3]", (Object[])new File[]{null, null, null, null, new File("000"), new File("111")}, (Object[])app2.fileArray0_3);
        Assert.assertEquals((String)"args", Arrays.asList("000", "111"), app2.all);
        App app3 = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"000"});
        Assert.assertEquals((String)"field initialized with arg[0]", (Object)new File("000"), (Object)app3.file0_1);
        Assert.assertEquals((String)"arg[1]", null, app3.fileList1_2);
        Assert.assertArrayEquals((String)"arg[0-3]", (Object[])new File[]{null, null, null, null, new File("000")}, (Object[])app3.fileArray0_3);
        Assert.assertEquals((String)"args", Arrays.asList("000"), app3.all);
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"Should fail with missingParamException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <file0_1>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testPositionalParamWithFixedAndVariableIndexRanges() throws Exception {
        class App {
            @CommandLine.Parameters(index="0")
            InetAddress host1;
            @CommandLine.Parameters(index="1")
            int port1;
            @CommandLine.Parameters(index="2")
            InetAddress host2;
            @CommandLine.Parameters(index="3..4", arity="1..2")
            int[] port2range;
            @CommandLine.Parameters(index="4..*")
            String[] files;

            App() {
            }
        }
        App app1 = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"localhost", "1111", "localhost", "2222", "3333", "file1", "file2"});
        Assert.assertEquals((Object)InetAddress.getByName("localhost"), (Object)app1.host1);
        Assert.assertEquals((long)1111L, (long)app1.port1);
        Assert.assertEquals((Object)InetAddress.getByName("localhost"), (Object)app1.host2);
        Assert.assertArrayEquals((int[])new int[]{2222, 3333}, (int[])app1.port2range);
        Assert.assertArrayEquals((Object[])new String[]{"file1", "file2"}, (Object[])app1.files);
    }

    @Ignore(value="Requires #70 support for variable arity in positional parameters")
    @Test
    public void testPositionalParamWithFixedIndexRangeAndVariableArity() throws Exception {
        class App {
            @CommandLine.Parameters(index="0")
            InetAddress host1;
            @CommandLine.Parameters(index="1")
            int port1;
            @CommandLine.Parameters(index="2")
            InetAddress host2;
            @CommandLine.Parameters(index="3..4", arity="1..2")
            int[] port2range;
            @CommandLine.Parameters(index="4..*")
            String[] files;

            App() {
            }
        }
        App app2 = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"localhost", "1111", "localhost", "2222", "file1", "file2"});
        Assert.assertEquals((Object)InetAddress.getByName("localhost"), (Object)app2.host1);
        Assert.assertEquals((long)1111L, (long)app2.port1);
        Assert.assertEquals((Object)InetAddress.getByName("localhost"), (Object)app2.host2);
        Assert.assertArrayEquals((int[])new int[]{2222}, (int[])app2.port2range);
        Assert.assertArrayEquals((Object[])new String[]{"file1", "file2"}, (Object[])app2.files);
    }

    @Test(expected=CommandLine.ParameterIndexGapException.class)
    public void testPositionalParamWithIndexGap_SkipZero() throws Exception {
        class SkipZero {
            @CommandLine.Parameters(index="1")
            String str;

            SkipZero() {
            }
        }
        CommandLine.populateCommand((Object)new SkipZero(), (String[])new String[]{"val1", "val2"});
    }

    @Test(expected=CommandLine.ParameterIndexGapException.class)
    public void testPositionalParamWithIndexGap_RangeSkipZero() throws Exception {
        class SkipZero {
            @CommandLine.Parameters(index="1..*")
            String str;

            SkipZero() {
            }
        }
        CommandLine.populateCommand((Object)new SkipZero(), (String[])new String[]{"val1", "val2"});
    }

    @Test(expected=CommandLine.ParameterIndexGapException.class)
    public void testPositionalParamWithIndexGap_FixedIndexGap() throws Exception {
        class SkipOne {
            @CommandLine.Parameters(index="0")
            String str0;
            @CommandLine.Parameters(index="2")
            String str2;

            SkipOne() {
            }
        }
        CommandLine.populateCommand((Object)new SkipOne(), (String[])new String[]{"val1", "val2"});
    }

    @Test(expected=CommandLine.ParameterIndexGapException.class)
    public void testPositionalParamWithIndexGap_RangeIndexGap() throws Exception {
        class SkipTwo {
            @CommandLine.Parameters(index="0..1")
            String str0;
            @CommandLine.Parameters(index="3")
            String str2;

            SkipTwo() {
            }
        }
        CommandLine.populateCommand((Object)new SkipTwo(), (String[])new String[]{"val0", "val1", "val2", "val3"});
    }

    @Test
    public void testPositionalParamWithIndexGap_VariableRangeIndexNoGap() throws Exception {
        class NoGap {
            @CommandLine.Parameters(index="0..*")
            String[] str0;
            @CommandLine.Parameters(index="3")
            String str2;

            NoGap() {
            }
        }
        NoGap noGap = (NoGap)CommandLine.populateCommand((Object)new NoGap(), (String[])new String[]{"val0", "val1", "val2", "val3"});
        Assert.assertArrayEquals((Object[])new String[]{"val0", "val1", "val2", "val3"}, (Object[])noGap.str0);
        Assert.assertEquals((Object)"val3", (Object)noGap.str2);
    }

    @Test
    public void testPositionalParamWithIndexGap_RangeIndexNoGap() throws Exception {
        class NoGap {
            @CommandLine.Parameters(index="0..1")
            String[] str0;
            @CommandLine.Parameters(index="2")
            String str2;

            NoGap() {
            }
        }
        NoGap noGap = (NoGap)CommandLine.populateCommand((Object)new NoGap(), (String[])new String[]{"val0", "val1", "val2"});
        Assert.assertArrayEquals((Object[])new String[]{"val0", "val1"}, (Object[])noGap.str0);
        Assert.assertEquals((Object)"val2", (Object)noGap.str2);
    }

    @Test(expected=CommandLine.UnmatchedArgumentException.class)
    public void testPositionalParamsDisallowUnknownArgumentSingleValue() throws Exception {
        class SingleValue {
            @CommandLine.Parameters(index="0")
            String str;

            SingleValue() {
            }
        }
        SingleValue single = (SingleValue)CommandLine.populateCommand((Object)new SingleValue(), (String[])new String[]{"val1", "val2"});
        Assert.assertEquals((Object)"val1", (Object)single.str);
    }

    @Test(expected=CommandLine.UnmatchedArgumentException.class)
    public void testPositionalParamsDisallowUnknownArgumentMultiValue() throws Exception {
        class SingleValue {
            @CommandLine.Parameters(index="0..2")
            String[] str;

            SingleValue() {
            }
        }
        CommandLine.populateCommand((Object)new SingleValue(), (String[])new String[]{"val0", "val1", "val2", "val3"});
    }

    @Test
    public void testPositionalParamsUnknownArgumentSingleValueWithUnmatchedArgsAllowed() throws Exception {
        CommandLineTest.setTraceLevel("OFF");
        class SingleValue {
            @CommandLine.Parameters(index="0")
            String str;

            SingleValue() {
            }
        }
        CommandLine cmd = new CommandLine((Object)new SingleValue()).setUnmatchedArgumentsAllowed(true);
        cmd.parse(new String[]{"val1", "val2"});
        Assert.assertEquals((Object)"val1", (Object)((SingleValue)cmd.getCommand()).str);
        Assert.assertEquals(Arrays.asList("val2"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testPositionalParamsUnknownArgumentMultiValueWithUnmatchedArgsAllowed() throws Exception {
        CommandLineTest.setTraceLevel("OFF");
        class SingleValue {
            @CommandLine.Parameters(index="0..2")
            String[] str;

            SingleValue() {
            }
        }
        CommandLine cmd = new CommandLine((Object)new SingleValue()).setUnmatchedArgumentsAllowed(true);
        cmd.parse(new String[]{"val0", "val1", "val2", "val3"});
        Assert.assertArrayEquals((Object[])new String[]{"val0", "val1", "val2"}, (Object[])((SingleValue)cmd.getCommand()).str);
        Assert.assertEquals(Arrays.asList("val3"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testPositionalParamSingleValueButWithoutIndex() throws Exception {
        class SingleValue {
            @CommandLine.Parameters
            String str;

            SingleValue() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new SingleValue(), (String[])new String[]{"val1", "val2"});
            Assert.fail((String)"Expected OverwrittenOptionException");
        }
        catch (CommandLine.OverwrittenOptionException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<str>) should be specified only once", (Object)ex.getMessage());
        }
        CommandLineTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new SingleValue()).setOverwrittenOptionsAllowed(true);
        cmd.parse(new String[]{"val1", "val2"});
        Assert.assertEquals((Object)"val2", (Object)((SingleValue)cmd.getCommand()).str);
    }

    @Test
    public void testSplitInOptionArray() {
        class Args {
            @CommandLine.Option(names={"-a"}, split=",")
            String[] values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "-a=B", "-a", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a", "a,b,c", "-a", "B", "-a", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "-a", "B", "-a", "C", "-a", "D,E,F"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C", "D", "E", "F"}, (Object[])args.values);
        try {
            args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "B", "C"});
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched arguments [B, C]", (Object)ok.getMessage());
        }
        try {
            args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "B", "-a=C"});
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [B]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testSplitInOptionArrayWithSpaces() {
        class Args {
            @CommandLine.Option(names={"-a"}, split=" ")
            String[] values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=\"a b c\""});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a b c", "-a", "B", "-a", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a", "\"a b c\"", "-a=B", "-a=C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=\"a b c\"", "-a=B", "-a", "C", "-a=D E F"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C", "D", "E", "F"}, (Object[])args.values);
        try {
            args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a b c", "B", "C"});
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched arguments [B, C]", (Object)ok.getMessage());
        }
        try {
            args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a b c", "B", "-a=C"});
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [B]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testSplitInOptionArrayWithArity() {
        class Args {
            @CommandLine.Option(names={"-a"}, split=",", arity="0..4")
            String[] values;
            @CommandLine.Parameters
            String[] params;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a"});
        Assert.assertArrayEquals((Object[])new String[0], (Object[])args.values);
        Assert.assertNull((Object)args.params);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "B", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        Assert.assertNull((Object)args.params);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a", "a,b,c", "B", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        Assert.assertNull((Object)args.params);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "B", "C", "D,E,F"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C", "D", "E", "F"}, (Object[])args.values);
        Assert.assertNull((Object)args.params);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c,d", "B", "C", "D", "E,F"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "B", "C", "D"}, (Object[])args.values);
        Assert.assertArrayEquals((Object[])new String[]{"E,F"}, (Object[])args.params);
    }

    @Test
    public void testSplitInOptionCollection() {
        class Args {
            @CommandLine.Option(names={"-a"}, split=",")
            List<String> values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "-a", "B", "-a=C"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a", "a,b,c", "-a", "B", "-a", "C"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "-a", "B", "-a", "C", "-a", "D,E,F"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C", "D", "E", "F"), args.values);
        try {
            args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c", "B", "C"});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched arguments [B, C]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testSplitInParametersArray() {
        class Args {
            @CommandLine.Parameters(split=",")
            String[] values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C", "D,E,F"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "C", "D", "E", "F"}, (Object[])args.values);
    }

    @Test
    public void testSplitInParametersArrayWithArity() {
        class Args {
            @CommandLine.Parameters(arity="2..4", split=",")
            String[] values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b", "c,d"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b", "c,d", "e,f"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d", "e", "f"}, (Object[])args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "d", "e,f"});
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "B", "d", "e", "f"}, (Object[])args.values);
        try {
            CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c,d,e"});
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<values>) requires at least 2 values, but only 1 were specified: [a,b,c,d,e]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new Args(), (String[])new String[0]);
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<values>) requires at least 2 values, but none were specified.", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B,C", "d", "e", "f,g"});
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<values>) requires at least 2 values, but only 1 were specified: [f,g]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSplitInParametersCollection() {
        class Args {
            @CommandLine.Parameters(split=",")
            List<String> values;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C"), args.values);
        args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c", "B", "C", "D,E,F"});
        Assert.assertEquals(Arrays.asList("a", "b", "c", "B", "C", "D", "E", "F"), args.values);
    }

    @Test
    public void testSplitIgnoredInOptionSingleValueField() {
        class Args {
            @CommandLine.Option(names={"-a"}, split=",")
            String value;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-a=a,b,c"});
        Assert.assertEquals((Object)"a,b,c", (Object)args.value);
    }

    @Test
    public void testSplitIgnoredInParameterSingleValueField() {
        class Args {
            @CommandLine.Parameters(split=",")
            String value;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"a,b,c"});
        Assert.assertEquals((Object)"a,b,c", (Object)args.value);
    }

    @Test
    public void testParseSubCommands() {
        CommandLine commandLine = Demo.mainCommand();
        List parsed = commandLine.parse("--git-dir=/home/rpopma/picocli status -sbuno".split(" "));
        Assert.assertEquals((String)"command count", (long)2L, (long)parsed.size());
        Assert.assertEquals(Demo.Git.class, ((CommandLine)parsed.get(0)).getCommand().getClass());
        Assert.assertEquals(Demo.GitStatus.class, ((CommandLine)parsed.get(1)).getCommand().getClass());
        Demo.Git git = (Demo.Git)((CommandLine)parsed.get(0)).getCommand();
        Assert.assertEquals((Object)new File("/home/rpopma/picocli"), (Object)git.gitDir);
        Demo.GitStatus status = (Demo.GitStatus)((CommandLine)parsed.get(1)).getCommand();
        Assert.assertTrue((String)"status -s", (boolean)status.shortFormat);
        Assert.assertTrue((String)"status -b", (boolean)status.branchInfo);
        Assert.assertFalse((String)"NOT status --showIgnored", (boolean)status.showIgnored);
        Assert.assertEquals((String)"status -u=no", (Object)((Object)Demo.GitStatusMode.no), (Object)((Object)status.mode));
    }

    @Test
    public void testTracingInfoWithSubCommands() throws Exception {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        String PROPERTY = "picocli.trace";
        String old = System.getProperty("picocli.trace");
        System.setProperty("picocli.trace", "");
        CommandLine commandLine = Demo.mainCommand();
        commandLine.parse(new String[]{"--git-dir=/home/rpopma/picocli", "commit", "-m", "\"Fixed typos\"", "--", "src1.java", "src2.java", "src3.java"});
        System.setErr(originalErr);
        if (old == null) {
            System.clearProperty("picocli.trace");
        } else {
            System.setProperty("picocli.trace", old);
        }
        String expected = String.format("[picocli INFO] Parsing 8 command line args [--git-dir=/home/rpopma/picocli, commit, -m, \"Fixed typos\", --, src1.java, src2.java, src3.java]%n[picocli INFO] Setting File field 'Git.gitDir' to '%s' (was 'null') for option --git-dir%n[picocli INFO] Adding [Fixed typos] to List<String> field 'GitCommit.message' for option -m%n[picocli INFO] Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n[picocli INFO] Adding [src1.java] to List<File> field 'GitCommit.files' for args[0..*] at position 0%n[picocli INFO] Adding [src2.java] to List<File> field 'GitCommit.files' for args[0..*] at position 1%n[picocli INFO] Adding [src3.java] to List<File> field 'GitCommit.files' for args[0..*] at position 2%n", new File("/home/rpopma/picocli"));
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTracingDebugWithSubCommands() throws Exception {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        String PROPERTY = "picocli.trace";
        String old = System.getProperty("picocli.trace");
        System.setProperty("picocli.trace", "DEBUG");
        CommandLine commandLine = Demo.mainCommand();
        commandLine.parse(new String[]{"--git-dir=/home/rpopma/picocli", "commit", "-m", "\"Fixed typos\"", "--", "src1.java", "src2.java", "src3.java"});
        System.setErr(originalErr);
        if (old == null) {
            System.clearProperty("picocli.trace");
        } else {
            System.setProperty("picocli.trace", old);
        }
        String expected = String.format("[picocli INFO] Parsing 8 command line args [--git-dir=/home/rpopma/picocli, commit, -m, \"Fixed typos\", --, src1.java, src2.java, src3.java]%n[picocli DEBUG] Initializing %1$s$Git: 3 options, 0 positional parameters, 0 required, 11 subcommands.%n[picocli DEBUG] Processing argument '--git-dir=/home/rpopma/picocli'. Remainder=[commit, -m, \"Fixed typos\", --, src1.java, src2.java, src3.java]%n[picocli DEBUG] Separated '--git-dir' option from '/home/rpopma/picocli' option parameter%n[picocli DEBUG] Found option named '--git-dir': field java.io.File %1$s$Git.gitDir, arity=1%n[picocli INFO] Setting File field 'Git.gitDir' to '%2$s' (was 'null') for option --git-dir%n[picocli DEBUG] Processing argument 'commit'. Remainder=[-m, \"Fixed typos\", --, src1.java, src2.java, src3.java]%n[picocli DEBUG] Found subcommand 'commit' (%1$s$GitCommit)%n[picocli DEBUG] Initializing %1$s$GitCommit: 8 options, 1 positional parameters, 0 required, 0 subcommands.%n[picocli DEBUG] Processing argument '-m'. Remainder=[\"Fixed typos\", --, src1.java, src2.java, src3.java]%n[picocli DEBUG] '-m' cannot be separated into <option>=<option-parameter>%n[picocli DEBUG] Found option named '-m': field java.util.List %1$s$GitCommit.message, arity=1%n[picocli INFO] Adding [Fixed typos] to List<String> field 'GitCommit.message' for option -m%n[picocli DEBUG] Processing argument '--'. Remainder=[src1.java, src2.java, src3.java]%n[picocli INFO] Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n[picocli DEBUG] Processing next arg as a positional parameter at index=0. Remainder=[src1.java, src2.java, src3.java]%n[picocli DEBUG] Position 0 is in index range 0..*. Trying to assign args to java.util.List %1$s$GitCommit.files, arity=0..1%n[picocli INFO] Adding [src1.java] to List<File> field 'GitCommit.files' for args[0..*] at position 0%n[picocli DEBUG] Consumed 1 arguments, moving position to index 1.%n[picocli DEBUG] Processing next arg as a positional parameter at index=1. Remainder=[src2.java, src3.java]%n[picocli DEBUG] Position 1 is in index range 0..*. Trying to assign args to java.util.List %1$s$GitCommit.files, arity=0..1%n[picocli INFO] Adding [src2.java] to List<File> field 'GitCommit.files' for args[0..*] at position 1%n[picocli DEBUG] Consumed 1 arguments, moving position to index 2.%n[picocli DEBUG] Processing next arg as a positional parameter at index=2. Remainder=[src3.java]%n[picocli DEBUG] Position 2 is in index range 0..*. Trying to assign args to java.util.List %1$s$GitCommit.files, arity=0..1%n[picocli INFO] Adding [src3.java] to List<File> field 'GitCommit.files' for args[0..*] at position 2%n[picocli DEBUG] Consumed 1 arguments, moving position to index 3.%n", Demo.class.getName(), new File("/home/rpopma/picocli"));
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTraceWarningIfOptionOverwrittenWhenOverwrittenOptionsAllowed() throws Exception {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        CommandLine cmd = new CommandLine((Object)new PrivateFinalOptionFields()).setOverwrittenOptionsAllowed(true);
        cmd.parse(new String[]{"-f", "111", "-f", "222", "-f", "333"});
        PrivateFinalOptionFields ff = (PrivateFinalOptionFields)cmd.getCommand();
        Assert.assertEquals((Object)"333", (Object)ff.field);
        System.setErr(originalErr);
        String expected = String.format("[picocli WARN] Overwriting String field 'PrivateFinalOptionFields.field' value '111' with '222' for option -f%n[picocli WARN] Overwriting String field 'PrivateFinalOptionFields.field' value '222' with '333' for option -f%n", new Object[0]);
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTraceWarningIfUnmatchedArgsWhenUnmatchedArgumentsAllowed() throws Exception {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        class App {
            @CommandLine.Parameters(index="0", arity="2", split="\\|", type={Integer.class, String.class})
            Map<Integer, String> message;

            App() {
            }
        }
        CommandLine cmd = (CommandLine)new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true).parse(new String[]{"1=a", "2=b", "3=c", "4=d"}).get(0);
        Assert.assertEquals(Arrays.asList("3=c", "4=d"), (Object)cmd.getUnmatchedArguments());
        System.setErr(originalErr);
        String expected = String.format("[picocli WARN] Unmatched arguments: [3=c, 4=d]%n", new Object[0]);
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCommandListReturnsRegisteredCommands() {
        @CommandLine.Command
        class MainCommand {
            MainCommand() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new MainCommand());
        @CommandLine.Command
        class Command1 {
            Command1() {
            }
        }
        @CommandLine.Command
        class Command2 {
            Command2() {
            }
        }
        commandLine.addSubcommand("cmd1", (Object)new Command1()).addSubcommand("cmd2", (Object)new Command2());
        Map commandMap = commandLine.getSubcommands();
        Assert.assertEquals((long)2L, (long)commandMap.size());
        Assert.assertTrue((String)"cmd1", (boolean)(((CommandLine)commandMap.get("cmd1")).getCommand() instanceof Command1));
        Assert.assertTrue((String)"cmd2", (boolean)(((CommandLine)commandMap.get("cmd2")).getCommand() instanceof Command2));
    }

    private static CommandLine createNestedCommand() {
        CommandLine commandLine = new CommandLine((Object)new MainCommand());
        commandLine.addSubcommand("cmd1", (Object)new CommandLine((Object)new ChildCommand1()).addSubcommand("sub11", (Object)new GrandChild1Command1()).addSubcommand("sub12", (Object)new GrandChild1Command2())).addSubcommand("cmd2", (Object)new CommandLine((Object)new ChildCommand2()).addSubcommand("sub21", (Object)new GrandChild2Command1()).addSubcommand("sub22", (Object)new CommandLine((Object)new GrandChild2Command2()).addSubcommand("sub22sub1", (Object)new GreatGrandChild2Command2_1())));
        return commandLine;
    }

    @Test
    public void testCommandListReturnsOnlyCommandsRegisteredOnInstance() {
        CommandLine commandLine = CommandLineTest.createNestedCommand();
        Map commandMap = commandLine.getSubcommands();
        Assert.assertEquals((long)2L, (long)commandMap.size());
        Assert.assertTrue((String)"cmd1", (boolean)(((CommandLine)commandMap.get("cmd1")).getCommand() instanceof ChildCommand1));
        Assert.assertTrue((String)"cmd2", (boolean)(((CommandLine)commandMap.get("cmd2")).getCommand() instanceof ChildCommand2));
    }

    @Test
    public void testParseNestedSubCommands() {
        List main = CommandLineTest.createNestedCommand().parse(new String[]{"cmd1"});
        Assert.assertEquals((long)2L, (long)main.size());
        Assert.assertFalse((boolean)((MainCommand)((CommandLine)main.get((int)0)).getCommand()).a);
        Assert.assertFalse((boolean)((ChildCommand1)((CommandLine)main.get((int)1)).getCommand()).b);
        List mainWithOptions = CommandLineTest.createNestedCommand().parse(new String[]{"-a", "cmd1", "-b"});
        Assert.assertEquals((long)2L, (long)mainWithOptions.size());
        Assert.assertTrue((boolean)((MainCommand)((CommandLine)mainWithOptions.get((int)0)).getCommand()).a);
        Assert.assertTrue((boolean)((ChildCommand1)((CommandLine)mainWithOptions.get((int)1)).getCommand()).b);
        List sub1 = CommandLineTest.createNestedCommand().parse(new String[]{"cmd1", "sub11"});
        Assert.assertEquals((long)3L, (long)sub1.size());
        Assert.assertFalse((boolean)((MainCommand)((CommandLine)sub1.get((int)0)).getCommand()).a);
        Assert.assertFalse((boolean)((ChildCommand1)((CommandLine)sub1.get((int)1)).getCommand()).b);
        Assert.assertFalse((boolean)((GrandChild1Command1)((CommandLine)sub1.get((int)2)).getCommand()).d);
        List sub1WithOptions = CommandLineTest.createNestedCommand().parse(new String[]{"-a", "cmd1", "-b", "sub11", "-d"});
        Assert.assertEquals((long)3L, (long)sub1WithOptions.size());
        Assert.assertTrue((boolean)((MainCommand)((CommandLine)sub1WithOptions.get((int)0)).getCommand()).a);
        Assert.assertTrue((boolean)((ChildCommand1)((CommandLine)sub1WithOptions.get((int)1)).getCommand()).b);
        Assert.assertTrue((boolean)((GrandChild1Command1)((CommandLine)sub1WithOptions.get((int)2)).getCommand()).d);
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"cmd1", "sub11", "sub12"});
            Assert.fail((String)"Expected exception for sub12");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub12]", (Object)ex.getMessage());
        }
        List sub22sub1 = CommandLineTest.createNestedCommand().parse(new String[]{"cmd2", "sub22", "sub22sub1"});
        Assert.assertEquals((long)4L, (long)sub22sub1.size());
        Assert.assertFalse((boolean)((MainCommand)((CommandLine)sub22sub1.get((int)0)).getCommand()).a);
        Assert.assertFalse((boolean)((ChildCommand2)((CommandLine)sub22sub1.get((int)1)).getCommand()).c);
        Assert.assertFalse((boolean)((GrandChild2Command2)((CommandLine)sub22sub1.get((int)2)).getCommand()).g);
        Assert.assertFalse((boolean)((GreatGrandChild2Command2_1)((CommandLine)sub22sub1.get((int)3)).getCommand()).h);
        List sub22sub1WithOptions = CommandLineTest.createNestedCommand().parse(new String[]{"-a", "cmd2", "-c", "sub22", "-g", "sub22sub1", "-h"});
        Assert.assertEquals((long)4L, (long)sub22sub1WithOptions.size());
        Assert.assertTrue((boolean)((MainCommand)((CommandLine)sub22sub1WithOptions.get((int)0)).getCommand()).a);
        Assert.assertTrue((boolean)((ChildCommand2)((CommandLine)sub22sub1WithOptions.get((int)1)).getCommand()).c);
        Assert.assertTrue((boolean)((GrandChild2Command2)((CommandLine)sub22sub1WithOptions.get((int)2)).getCommand()).g);
        Assert.assertTrue((boolean)((GreatGrandChild2Command2_1)((CommandLine)sub22sub1WithOptions.get((int)3)).getCommand()).h);
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"-a", "-b", "cmd1"});
            Assert.fail((String)"unmatched option should prevents remainder to be parsed as command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [-b]", (Object)ex.getMessage());
        }
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"cmd1", "sub21"});
            Assert.fail((String)"sub-commands for different parent command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub21]", (Object)ex.getMessage());
        }
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"cmd1", "sub22sub1"});
            Assert.fail((String)"sub-sub-commands for different parent command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub22sub1]", (Object)ex.getMessage());
        }
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"sub11"});
            Assert.fail((String)"sub-commands without preceding parent command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub11]", (Object)ex.getMessage());
        }
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"sub21"});
            Assert.fail((String)"sub-commands without preceding parent command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub21]", (Object)ex.getMessage());
        }
        try {
            CommandLineTest.createNestedCommand().parse(new String[]{"sub22sub1"});
            Assert.fail((String)"sub-sub-commands without preceding parent/grandparent command");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [sub22sub1]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testParseNestedSubCommandsAllowingUnmatchedArguments() {
        CommandLineTest.setTraceLevel("OFF");
        List result1 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"-a", "-b", "cmd1"});
        Assert.assertEquals(Arrays.asList("-b"), (Object)((CommandLine)result1.get(0)).getUnmatchedArguments());
        List result2 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"cmd1", "sub21"});
        Assert.assertEquals(Arrays.asList("sub21"), (Object)((CommandLine)result2.get(1)).getUnmatchedArguments());
        List result3 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"cmd1", "sub22sub1"});
        Assert.assertEquals(Arrays.asList("sub22sub1"), (Object)((CommandLine)result3.get(1)).getUnmatchedArguments());
        List result4 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"sub11"});
        Assert.assertEquals(Arrays.asList("sub11"), (Object)((CommandLine)result4.get(0)).getUnmatchedArguments());
        List result5 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"sub21"});
        Assert.assertEquals(Arrays.asList("sub21"), (Object)((CommandLine)result5.get(0)).getUnmatchedArguments());
        List result6 = CommandLineTest.createNestedCommand().setUnmatchedArgumentsAllowed(true).parse(new String[]{"sub22sub1"});
        Assert.assertEquals(Arrays.asList("sub22sub1"), (Object)((CommandLine)result6.get(0)).getUnmatchedArguments());
    }

    @Test(expected=CommandLine.MissingTypeConverterException.class)
    public void testCustomTypeConverterNotRegisteredAtAll() {
        CommandLine commandLine = CommandLineTest.createNestedCommand();
        commandLine.parse(new String[]{"cmd1", "sub12", "-e", "TXT"});
    }

    @Test(expected=CommandLine.MissingTypeConverterException.class)
    public void testCustomTypeConverterRegisteredBeforeSubcommandsAdded() {
        @CommandLine.Command
        class TopLevel {
            TopLevel() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new TopLevel());
        commandLine.registerConverter(CustomType.class, (CommandLine.ITypeConverter)new CustomType(null));
        commandLine.addSubcommand("main", (Object)CommandLineTest.createNestedCommand());
        commandLine.parse(new String[]{"main", "cmd1", "sub12", "-e", "TXT"});
    }

    @Test
    public void testCustomTypeConverterRegisteredAfterSubcommandsAdded() {
        @CommandLine.Command
        class TopLevel {
            TopLevel() {
            }

            public boolean equals(Object o) {
                return this.getClass().equals(o.getClass());
            }
        }
        CommandLine commandLine = new CommandLine((Object)new TopLevel());
        commandLine.addSubcommand("main", (Object)CommandLineTest.createNestedCommand());
        commandLine.registerConverter(CustomType.class, (CommandLine.ITypeConverter)new CustomType(null));
        List parsed = commandLine.parse(new String[]{"main", "cmd1", "sub12", "-e", "TXT"});
        Assert.assertEquals((long)4L, (long)parsed.size());
        Assert.assertEquals(TopLevel.class, ((CommandLine)parsed.get(0)).getCommand().getClass());
        Assert.assertFalse((boolean)((MainCommand)((CommandLine)parsed.get((int)1)).getCommand()).a);
        Assert.assertFalse((boolean)((ChildCommand1)((CommandLine)parsed.get((int)2)).getCommand()).b);
        Assert.assertEquals((Object)"TXT", (Object)((GrandChild1Command2)((CommandLine)parsed.get((int)3)).getCommand()).e.val);
    }

    @Test
    public void testRunCallsRunnableIfParseSucceeds() {
        final boolean[] runWasCalled = new boolean[]{false};
        @CommandLine.Command
        class App
        implements Runnable {
            App() {
            }

            @Override
            public void run() {
                runWasCalled[0] = true;
            }
        }
        CommandLine.run((Runnable)new App(), (PrintStream)System.err, (String[])new String[0]);
        Assert.assertTrue((boolean)runWasCalled[0]);
    }

    @Test
    public void testRunPrintsErrorIfParseFails() throws UnsupportedEncodingException {
        final boolean[] runWasCalled = new boolean[]{false};
        PrintStream oldErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setErr(new PrintStream((OutputStream)baos, true, "UTF8"));
        class App
        implements Runnable {
            @CommandLine.Option(names={"-number"})
            int number;

            App() {
            }

            @Override
            public void run() {
                runWasCalled[0] = true;
            }
        }
        CommandLine.run((Runnable)new App(), (PrintStream)System.err, (String[])new String[]{"-number", "not a number"});
        System.setErr(oldErr);
        String result = baos.toString("UTF8");
        Assert.assertFalse((boolean)runWasCalled[0]);
        Assert.assertEquals((Object)String.format("Could not convert 'not a number' to int for option '-number': java.lang.NumberFormatException: For input string: \"not a number\"%nUsage: <main class> [-number=<number>]%n      -number=<number>%n", new Object[0]), (Object)result);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testRunRequiresAnnotatedCommand() {
        class App
        implements Runnable {
            App() {
            }

            @Override
            public void run() {
            }
        }
        CommandLine.run((Runnable)new App(), (PrintStream)System.err, (String[])new String[0]);
    }

    @Test
    public void testCallReturnsCallableResultParseSucceeds() throws Exception {
        @CommandLine.Command
        class App
        implements Callable<Boolean> {
            App() {
            }

            @Override
            public Boolean call() {
                return true;
            }
        }
        Assert.assertTrue((boolean)((Boolean)CommandLine.call((Callable)new App(), (PrintStream)System.err, (String[])new String[0])));
    }

    @Test
    public void testCallReturnsNullAndPrintsErrorIfParseFails() throws Exception {
        PrintStream oldErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setErr(new PrintStream((OutputStream)baos, true, "UTF8"));
        class App
        implements Callable<Boolean> {
            @CommandLine.Option(names={"-number"})
            int number;

            App() {
            }

            @Override
            public Boolean call() {
                return true;
            }
        }
        Boolean callResult = (Boolean)CommandLine.call((Callable)new App(), (PrintStream)System.err, (String[])new String[]{"-number", "not a number"});
        System.setErr(oldErr);
        String result = baos.toString("UTF8");
        Assert.assertNull((Object)callResult);
        Assert.assertEquals((Object)String.format("Could not convert 'not a number' to int for option '-number': java.lang.NumberFormatException: For input string: \"not a number\"%nUsage: <main class> [-number=<number>]%n      -number=<number>%n", new Object[0]), (Object)result);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testCallRequiresAnnotatedCommand() throws Exception {
        class App
        implements Callable<Object> {
            App() {
            }

            @Override
            public Object call() {
                return null;
            }
        }
        CommandLine.call((Callable)new App(), (PrintStream)System.err, (String[])new String[0]);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testPopulateCommandRequiresAnnotatedCommand() {
        class App {
            App() {
            }
        }
        CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testUsageObjectPrintstreamRequiresAnnotatedCommand() {
        class App {
            App() {
            }
        }
        CommandLine.usage((Object)new App(), (PrintStream)System.out);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testUsageObjectPrintstreamAnsiRequiresAnnotatedCommand() {
        class App {
            App() {
            }
        }
        CommandLine.usage((Object)new App(), (PrintStream)System.out, (CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF);
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testUsageObjectPrintstreamColorschemeRequiresAnnotatedCommand() {
        class App {
            App() {
            }
        }
        CommandLine.usage((Object)new App(), (PrintStream)System.out, (CommandLine.Help.ColorScheme)CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF));
    }

    @Test(expected=CommandLine.InitializationException.class)
    public void testConstructorRequiresAnnotatedCommand() {
        class App {
            App() {
            }
        }
        new CommandLine((Object)new App());
    }

    @Test
    public void testOverwrittenOptionDisallowedByDefault() {
        class App {
            @CommandLine.Option(names={"-s"})
            String string;
            @CommandLine.Option(names={"-v"})
            boolean bool;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-s", "1", "-s", "2"});
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.OverwrittenOptionException ex) {
            Assert.assertEquals((Object)"option '-s' (<string>) should be specified only once", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-v", "-v"});
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.OverwrittenOptionException ex) {
            Assert.assertEquals((Object)"option '-v' (<bool>) should be specified only once", (Object)ex.getMessage());
        }
    }

    @Test
    public void testOverwrittenOptionDisallowedByDefaultRegardlessOfAlias() {
        class App {
            @CommandLine.Option(names={"-s", "--str"})
            String string;
            @CommandLine.Option(names={"-v", "--verbose"})
            boolean bool;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-s", "1", "--str", "2"});
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.OverwrittenOptionException ex) {
            Assert.assertEquals((Object)"option '-s' (<string>) should be specified only once", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-v", "--verbose"});
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.OverwrittenOptionException ex) {
            Assert.assertEquals((Object)"option '-v' (<bool>) should be specified only once", (Object)ex.getMessage());
        }
    }

    @Test
    public void testOverwrittenOptionSetsLastValueIfAllowed() {
        CommandLineTest.setTraceLevel("OFF");
        class App {
            @CommandLine.Option(names={"-s", "--str"})
            String string;
            @CommandLine.Option(names={"-v", "--verbose"})
            boolean bool;

            App() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new App()).setOverwrittenOptionsAllowed(true);
        commandLine.parse(new String[]{"-s", "1", "--str", "2"});
        Assert.assertEquals((Object)"2", (Object)((App)commandLine.getCommand()).string);
        commandLine = new CommandLine((Object)new App()).setOverwrittenOptionsAllowed(true);
        commandLine.parse(new String[]{"-v", "--verbose", "-v"});
        Assert.assertEquals((Object)true, (Object)((App)commandLine.getCommand()).bool);
    }

    @Test
    public void testIssue141Npe() {
        class A {
            @CommandLine.Option(names={"-u", "--user"}, required=true, description={"user id"})
            private String user;
            @CommandLine.Option(names={"-p", "--password"}, required=true, description={"password"})
            private String password;

            A() {
            }
        }
        A a = new A();
        CommandLine commandLine = new CommandLine((Object)a);
        try {
            commandLine.parse(new String[]{"-u", "foo"});
            Assert.fail((String)"expected exception");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '-p=<password>'", (Object)ex.getLocalizedMessage());
        }
        commandLine.parse(new String[]{"-u", "foo", "-p", "abc"});
    }

    @Test
    public void testToggleBooleanValue() {
        class App {
            @CommandLine.Option(names={"-a"})
            boolean primitiveFalse = false;
            @CommandLine.Option(names={"-b"})
            boolean primitiveTrue = true;
            @CommandLine.Option(names={"-c"})
            Boolean objectFalse = false;
            @CommandLine.Option(names={"-d"})
            Boolean objectTrue = true;
            @CommandLine.Option(names={"-e"})
            Boolean objectNull = null;

            App() {
            }
        }
        App app = (App)CommandLine.populateCommand((Object)new App(), (String[])"-a -b -c -d -e".split(" "));
        Assert.assertTrue((boolean)app.primitiveFalse);
        Assert.assertFalse((boolean)app.primitiveTrue);
        Assert.assertTrue((boolean)app.objectFalse);
        Assert.assertFalse((boolean)app.objectTrue);
        Assert.assertTrue((boolean)app.objectNull);
    }

    @Test(timeout=15000L)
    public void testIssue148InfiniteLoop() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(output);
        @CommandLine.Command(showDefaultValues=true)
        class App {
            @CommandLine.Option(names={"--foo-bar-baz"})
            String foo = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";

            App() {
            }
        }
        CommandLine.usage((Object)new App(), (PrintStream)printStream);
        String content = new String(output.toByteArray(), "UTF-8").replaceAll("\r\n", "\n");
        String expectedOutput = "Usage: <main class> [--foo-bar-baz=<foo>]\n      --foo-bar-baz=<foo>       Default:\n                                aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n                                aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n";
        Assert.assertEquals((Object)expectedOutput, (Object)content);
    }

    @Test
    public void testDeclarativelyAddSubcommands() {
        CommandLine main = new CommandLine((Object)new MainCommand_testDeclarativelyAddSubcommands());
        Assert.assertEquals((long)1L, (long)main.getSubcommands().size());
        CommandLine sub1 = (CommandLine)main.getSubcommands().get("sub1");
        Assert.assertEquals(Sub1_testDeclarativelyAddSubcommands.class, sub1.getCommand().getClass());
        Assert.assertEquals((long)1L, (long)sub1.getSubcommands().size());
        CommandLine subsub1 = (CommandLine)sub1.getSubcommands().get("subsub1");
        Assert.assertEquals(SubSub1_testDeclarativelyAddSubcommands.class, subsub1.getCommand().getClass());
    }

    @Test
    public void testGetParentForDeclarativelyAddedSubcommands() {
        CommandLine main = new CommandLine((Object)new MainCommand_testDeclarativelyAddSubcommands());
        Assert.assertEquals((long)1L, (long)main.getSubcommands().size());
        CommandLine sub1 = (CommandLine)main.getSubcommands().get("sub1");
        Assert.assertSame((Object)main, (Object)sub1.getParent());
        Assert.assertEquals(Sub1_testDeclarativelyAddSubcommands.class, sub1.getCommand().getClass());
        Assert.assertEquals((long)1L, (long)sub1.getSubcommands().size());
        CommandLine subsub1 = (CommandLine)sub1.getSubcommands().get("subsub1");
        Assert.assertSame((Object)sub1, (Object)subsub1.getParent());
        Assert.assertEquals(SubSub1_testDeclarativelyAddSubcommands.class, subsub1.getCommand().getClass());
    }

    @Test
    public void testGetParentForProgrammaticallyAddedSubcommands() {
        CommandLine main = CommandLineTest.createNestedCommand();
        for (CommandLine child : main.getSubcommands().values()) {
            Assert.assertSame((Object)main, (Object)child.getParent());
            for (CommandLine grandChild : child.getSubcommands().values()) {
                Assert.assertSame((Object)child, (Object)grandChild.getParent());
            }
        }
    }

    @Test
    public void testGetParentIsNullForTopLevelCommands() {
        @CommandLine.Command
        class Top {
            Top() {
            }
        }
        Assert.assertNull((Object)new CommandLine((Object)new Top()).getParent());
    }

    @Test
    public void testDeclarativelyAddSubcommandsFailsWithoutNoArgConstructor() {
        try {
            @CommandLine.Command(subcommands={ABC.class})
            class MainCommand {
                MainCommand() {
                }
            }
            new CommandLine((Object)new MainCommand());
        }
        catch (CommandLine.InitializationException ex) {
            @CommandLine.Command(name="sub1")
            class ABC {
                ABC() {
                }
            }
            String expected = String.format("Cannot instantiate subcommand %s: the class has no constructor", ABC.class.getName());
            Assert.assertEquals((Object)expected, (Object)ex.getMessage());
        }
    }

    @Test
    public void testDeclarativelyAddSubcommandsFailsWithoutAnnotation() {
        try {
            @CommandLine.Command(subcommands={MissingCommandAnnotation.class})
            class MainCommand {
                MainCommand() {
                }
            }
            new CommandLine((Object)new MainCommand());
        }
        catch (CommandLine.InitializationException ex) {
            class MissingCommandAnnotation {
            }
            String expected = String.format("Subcommand %s is missing the mandatory @Command annotation with a 'name' attribute", MissingCommandAnnotation.class.getName());
            Assert.assertEquals((Object)expected, (Object)ex.getMessage());
        }
    }

    @Test
    public void testDeclarativelyAddSubcommandsFailsWithoutNameOnCommandAnnotation() {
        try {
            @CommandLine.Command(subcommands={MissingNameAttribute.class})
            class MainCommand {
                MainCommand() {
                }
            }
            new CommandLine((Object)new MainCommand());
        }
        catch (CommandLine.InitializationException ex) {
            @CommandLine.Command
            class MissingNameAttribute {
            }
            String expected = String.format("Subcommand %s is missing the mandatory @Command annotation with a 'name' attribute", MissingNameAttribute.class.getName());
            Assert.assertEquals((Object)expected, (Object)ex.getMessage());
        }
    }

    @Test
    public void testMapFieldHappyCase() {
        class App {
            @CommandLine.Option(names={"-P", "-map"}, type={String.class, String.class})
            Map<String, String> map = new HashMap<String, String>();

            App() {
            }

            private void validateMapField() {
                Assert.assertEquals((long)1L, (long)this.map.size());
                Assert.assertEquals(HashMap.class, this.map.getClass());
                Assert.assertEquals((Object)"BBB", (Object)this.map.get("AAA"));
            }
        }
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map", "AAA=BBB"})).validateMapField();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB"})).validateMapField();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P=AAA=BBB"})).validateMapField();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-PAAA=BBB"})).validateMapField();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P", "AAA=BBB"})).validateMapField();
    }

    @Test
    public void testMapFieldHappyCaseWithMultipleValues() {
        class App {
            @CommandLine.Option(names={"-P", "-map"}, split=",", type={String.class, String.class})
            Map<String, String> map;

            App() {
            }

            private void validateMapField3Values() {
                Assert.assertEquals((long)3L, (long)this.map.size());
                Assert.assertEquals(LinkedHashMap.class, this.map.getClass());
                Assert.assertEquals((Object)"BBB", (Object)this.map.get("AAA"));
                Assert.assertEquals((Object)"DDD", (Object)this.map.get("CCC"));
                Assert.assertEquals((Object)"FFF", (Object)this.map.get("EEE"));
            }
        }
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB,CCC=DDD,EEE=FFF"})).validateMapField3Values();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-PAAA=BBB,CCC=DDD,EEE=FFF"})).validateMapField3Values();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P", "AAA=BBB,CCC=DDD,EEE=FFF"})).validateMapField3Values();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB", "-map=CCC=DDD", "-map=EEE=FFF"})).validateMapField3Values();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-PAAA=BBB", "-PCCC=DDD", "-PEEE=FFF"})).validateMapField3Values();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P", "AAA=BBB", "-P", "CCC=DDD", "-P", "EEE=FFF"})).validateMapField3Values();
        try {
            ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P", "AAA=BBB", "CCC=DDD", "EEE=FFF"})).validateMapField3Values();
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched arguments [CCC=DDD, EEE=FFF]", (Object)ok.getMessage());
        }
        try {
            ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB", "CCC=DDD", "EEE=FFF"})).validateMapField3Values();
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched arguments [CCC=DDD, EEE=FFF]", (Object)ok.getMessage());
        }
        try {
            ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-PAAA=BBB", "-PCCC=DDD", "EEE=FFF"})).validateMapField3Values();
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [EEE=FFF]", (Object)ok.getMessage());
        }
        try {
            ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-P", "AAA=BBB", "-P", "CCC=DDD", "EEE=FFF"})).validateMapField3Values();
            Assert.fail((String)"Expected UnmatchedArgEx");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [EEE=FFF]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testMapField_InstantiatesConcreteMap() {
        class App {
            @CommandLine.Option(names={"-map"}, type={String.class, String.class})
            TreeMap<String, String> map;

            App() {
            }
        }
        App app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB"});
        Assert.assertEquals((long)1L, (long)app.map.size());
        Assert.assertEquals(TreeMap.class, app.map.getClass());
        Assert.assertEquals((Object)"BBB", (Object)app.map.get("AAA"));
    }

    @Test
    public void testMapFieldMissingTypeAttribute() {
        class App {
            @CommandLine.Option(names={"-map"})
            TreeMap<String, String> map;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB"});
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)("Field java.util.TreeMap " + App.class.getName() + ".map needs two types (one for the map key, one for the value) but only has 1 types configured."), (Object)ex.getMessage());
        }
    }

    @Test
    public void testMapFieldMissingTypeConverter() {
        class App {
            @CommandLine.Option(names={"-map"}, type={Thread.class, Thread.class})
            TreeMap<String, String> map;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-map=AAA=BBB"});
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)("No TypeConverter registered for java.lang.Thread of field java.util.TreeMap " + App.class.getName() + ".map"), (Object)ex.getMessage());
        }
    }

    @Test
    public void testMapFieldWithSplitRegex() {
        class App {
            @CommandLine.Option(names={"-fix"}, split="\\|", type={Integer.class, String.class})
            Map<Integer, String> message;

            App() {
            }

            private void validate() {
                Assert.assertEquals((long)10L, (long)this.message.size());
                Assert.assertEquals(LinkedHashMap.class, this.message.getClass());
                Assert.assertEquals((Object)"FIX.4.4", (Object)this.message.get(8));
                Assert.assertEquals((Object)"69", (Object)this.message.get(9));
                Assert.assertEquals((Object)"A", (Object)this.message.get(35));
                Assert.assertEquals((Object)"MBT", (Object)this.message.get(49));
                Assert.assertEquals((Object)"TargetCompID", (Object)this.message.get(56));
                Assert.assertEquals((Object)"9", (Object)this.message.get(34));
                Assert.assertEquals((Object)"20130625-04:05:32.682", (Object)this.message.get(52));
                Assert.assertEquals((Object)"0", (Object)this.message.get(98));
                Assert.assertEquals((Object)"30", (Object)this.message.get(108));
                Assert.assertEquals((Object)"052", (Object)this.message.get(10));
            }
        }
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-fix", "8=FIX.4.4|9=69|35=A|49=MBT|56=TargetCompID|34=9|52=20130625-04:05:32.682|98=0|108=30|10=052"})).validate();
    }

    @Test
    public void testMapFieldArityWithSplitRegex() {
        class App {
            @CommandLine.Option(names={"-fix"}, arity="2", split="\\|", type={Integer.class, String.class})
            Map<Integer, String> message;

            App() {
            }

            private void validate() {
                Assert.assertEquals((String)this.message.toString(), (long)4L, (long)this.message.size());
                Assert.assertEquals(LinkedHashMap.class, this.message.getClass());
                Assert.assertEquals((Object)"a", (Object)this.message.get(1));
                Assert.assertEquals((Object)"b", (Object)this.message.get(2));
                Assert.assertEquals((Object)"c", (Object)this.message.get(3));
                Assert.assertEquals((Object)"d", (Object)this.message.get(4));
            }
        }
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-fix", "1=a", "2=b|3=c|4=d"})).validate();
        ((App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-fix", "1=a", "2=b", "-fix", "3=c", "4=d"})).validate();
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-fix", "1=a|2=b|3=c|4=d"});
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"option '-fix' at index 0 (<Integer=String>) requires at least 2 values, but only 1 were specified: [1=a|2=b|3=c|4=d]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-fix", "1=a", "2=b", "3=c|4=d"});
            Assert.fail((String)"UnmatchedArgumentException expected");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [3=c|4=d]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMapPositionalParameterFieldMaxArity() {
        class App {
            @CommandLine.Parameters(index="0", arity="2", split="\\|", type={Integer.class, String.class})
            Map<Integer, String> message;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"1=a", "2=b", "3=c", "4=d"});
            Assert.fail((String)"UnmatchedArgumentsException expected");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched arguments [3=c, 4=d]", (Object)ex.getMessage());
        }
        CommandLineTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true);
        cmd.parse(new String[]{"1=a", "2=b", "3=c", "4=d"});
        Assert.assertEquals(Arrays.asList("3=c", "4=d"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testMapPositionalParameterFieldArity3() {
        class App {
            @CommandLine.Parameters(index="0", arity="3", split="\\|", type={Integer.class, String.class})
            Map<Integer, String> message;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"1=a", "2=b", "3=c", "4=d"});
            Assert.fail((String)"UnmatchedArgumentsException expected");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [4=d]", (Object)ex.getMessage());
        }
        CommandLineTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true);
        cmd.parse(new String[]{"1=a", "2=b", "3=c", "4=d"});
        Assert.assertEquals(Arrays.asList("4=d"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testMapAndCollectionFieldTypeInference() {
        class App {
            @CommandLine.Option(names={"-a"})
            Map<Integer, URI> a;
            @CommandLine.Option(names={"-b"})
            Map<TimeUnit, StringBuilder> b;
            @CommandLine.Option(names={"-c"})
            Map c;
            @CommandLine.Option(names={"-d"})
            List<File> d;
            @CommandLine.Option(names={"-e"})
            Map<? extends Integer, ? super Long> e;
            @CommandLine.Option(names={"-f"}, type={Long.class, Float.class})
            Map<? extends Number, ? super Number> f;
            @CommandLine.Option(names={"-g"}, type={TimeUnit.class, Float.class})
            Map g;

            App() {
            }
        }
        App app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-a", "8=/path", "-a", "98765432=/path/to/resource", "-b", "SECONDS=abc", "-c", "123=ABC", "-d", "/path/to/file", "-e", "12345=67890", "-f", "12345=67.89", "-g", "MILLISECONDS=12.34"});
        Assert.assertEquals((long)app.a.size(), (long)2L);
        Assert.assertEquals((Object)URI.create("/path"), (Object)app.a.get(8));
        Assert.assertEquals((Object)URI.create("/path/to/resource"), (Object)app.a.get(98765432));
        Assert.assertEquals((long)app.b.size(), (long)1L);
        Assert.assertEquals((Object)"abc", (Object)app.b.get((Object)TimeUnit.SECONDS).toString());
        Assert.assertEquals((long)app.c.size(), (long)1L);
        Assert.assertEquals((Object)"ABC", app.c.get("123"));
        Assert.assertEquals((long)app.d.size(), (long)1L);
        Assert.assertEquals((Object)new File("/path/to/file"), (Object)app.d.get(0));
        Assert.assertEquals((long)app.e.size(), (long)1L);
        Assert.assertEquals((Object)new Long(67890L), (Object)app.e.get(12345));
        Assert.assertEquals((long)app.f.size(), (long)1L);
        Assert.assertEquals((Object)Float.valueOf(67.89f), (Object)app.f.get(new Long(12345L)));
        Assert.assertEquals((long)app.g.size(), (long)1L);
        Assert.assertEquals((Object)Float.valueOf(12.34f), app.g.get((Object)TimeUnit.MILLISECONDS));
    }

    @Test
    public void testUseTypeAttributeInsteadOfFieldType() {
        class App {
            @CommandLine.Option(names={"--num"}, type={BigDecimal.class})
            Number[] number;
            @CommandLine.Parameters(type={StringBuilder.class})
            Appendable address;

            App() {
            }
        }
        App app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--num", "123.456", "ABC"});
        Assert.assertEquals((long)1L, (long)app.number.length);
        Assert.assertEquals((Object)new BigDecimal("123.456"), (Object)app.number[0]);
        Assert.assertEquals((Object)"ABC", (Object)app.address.toString());
        Assert.assertTrue((boolean)(app.address instanceof StringBuilder));
    }

    @Test
    public void testMultipleMissingOptions() {
        try {
            class App {
                @CommandLine.Option(names={"-a"}, required=true)
                String first;
                @CommandLine.Option(names={"-b"}, required=true)
                String second;
                @CommandLine.Option(names={"-c"}, required=true)
                String third;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required options [-a=<first>, -b=<second>, -c=<third>]", (Object)ex.getMessage());
        }
    }

    @Test
    public void test185MissingOptionsShouldUseLabel() {
        try {
            class App {
                @CommandLine.Parameters(arity="1", paramLabel="IN_FILE", description={"The input file"})
                File foo;
                @CommandLine.Option(names={"-o"}, paramLabel="OUT_FILE", description={"The output file"}, required=true)
                File bar;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required options [-o=OUT_FILE, params[*]=IN_FILE]", (Object)ex.getMessage());
        }
    }

    @Test
    public void test185MissingMapOptionsShouldUseLabel() {
        try {
            class App {
                @CommandLine.Parameters(arity="1", type={Long.class, File.class}, description={"The input file mapping"})
                Map<Long, File> foo;
                @CommandLine.Option(names={"-o"}, description={"The output file mapping"}, required=true)
                Map<String, String> bar;
                @CommandLine.Option(names={"-x"}, paramLabel="KEY=VAL", description={"Some other mapping"}, required=true)
                Map<String, String> xxx;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"MissingParameterException expected");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required options [-o=<String=String>, -x=KEY=VAL, params[*]=<Long=File>]", (Object)ex.getMessage());
        }
    }

    @Test
    public void testAnyExceptionWrappedInParameterException() {
        try {
            class App {
                @CommandLine.Option(names={"-queue"}, type={String.class}, split=",")
                ArrayBlockingQueue<String> queue = new ArrayBlockingQueue(2);

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])"-queue a,b,c".split(" "));
            Assert.fail((String)"ParameterException expected");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"IllegalStateException: Queue full while processing argument at or before arg[1] 'a,b,c' in [-queue, a,b,c]: java.lang.IllegalStateException: Queue full", (Object)ex.getMessage());
        }
    }

    @Test
    public void test149UnmatchedShortOptionsAreMisinterpretedAsOperands() {
        class App {
            @CommandLine.Option(names={"-a"})
            String first;
            @CommandLine.Option(names={"-b"})
            String second;
            @CommandLine.Option(names={"-c", "--ccc"})
            String third;
            @CommandLine.Parameters
            String[] positional;

            App() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-xx", "-a", "aValue"});
            Assert.fail((String)"UnmatchedArgumentException expected for -xx");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [-xx]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-x", "-a", "aValue"});
            Assert.fail((String)"UnmatchedArgumentException expected for -x");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [-x]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--x", "-a", "aValue"});
            Assert.fail((String)"UnmatchedArgumentException expected for --x");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [--x]", (Object)ex.getMessage());
        }
    }

    @Test
    public void test149NonOptionArgsShouldBeTreatedAsOperands() {
        class App {
            @CommandLine.Option(names={"/a"})
            String first;
            @CommandLine.Option(names={"/b"})
            String second;
            @CommandLine.Option(names={"/c", "--ccc"})
            String third;
            @CommandLine.Parameters
            String[] positional;

            App() {
            }
        }
        App app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-yy", "-a"});
        Assert.assertArrayEquals((Object[])new String[]{"-yy", "-a"}, (Object[])app.positional);
        app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-y", "-a"});
        Assert.assertArrayEquals((Object[])new String[]{"-y", "-a"}, (Object[])app.positional);
        app = (App)CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--y", "-a"});
        Assert.assertArrayEquals((Object[])new String[]{"--y", "-a"}, (Object[])app.positional);
    }

    @Test
    public void test149LongMatchWeighsWhenDeterminingOptionResemblance() {
        try {
            class App {
                @CommandLine.Option(names={"/a"})
                String first;
                @CommandLine.Option(names={"/b"})
                String second;
                @CommandLine.Option(names={"/c", "--ccc"})
                String third;
                @CommandLine.Parameters
                String[] positional;

                App() {
                }
            }
            CommandLine.populateCommand((Object)new App(), (String[])new String[]{"--ccd", "-a"});
            Assert.fail((String)"UnmatchedArgumentException expected for --x");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [--ccd]", (Object)ex.getMessage());
        }
    }

    @Test
    public void test149OnlyUnmatchedOptionStoredOthersParsed() throws Exception {
        PrintStream originalErr = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2500);
        System.setErr(new PrintStream(baos));
        class App {
            @CommandLine.Option(names={"-a"})
            String first;
            @CommandLine.Option(names={"-b"})
            String second;
            @CommandLine.Option(names={"-c", "--ccc"})
            String third;
            @CommandLine.Parameters
            String[] positional;

            App() {
            }
        }
        CommandLine cmd = (CommandLine)new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true).parse(new String[]{"-yy", "-a=A"}).get(0);
        Assert.assertEquals(Arrays.asList("-yy"), (Object)cmd.getUnmatchedArguments());
        Assert.assertEquals((Object)"A", (Object)((App)cmd.getCommand()).first);
        cmd = (CommandLine)new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true).parse(new String[]{"-y", "-b=B"}).get(0);
        Assert.assertEquals(Arrays.asList("-y"), (Object)cmd.getUnmatchedArguments());
        Assert.assertEquals((Object)"B", (Object)((App)cmd.getCommand()).second);
        cmd = (CommandLine)new CommandLine((Object)new App()).setUnmatchedArgumentsAllowed(true).parse(new String[]{"--y", "-c=C"}).get(0);
        Assert.assertEquals(Arrays.asList("--y"), (Object)cmd.getUnmatchedArguments());
        Assert.assertEquals((Object)"C", (Object)((App)cmd.getCommand()).third);
        String expected = String.format("[picocli WARN] Unmatched arguments: [-yy]%n[picocli WARN] Unmatched arguments: [-y]%n[picocli WARN] Unmatched arguments: [--y]%n", new Object[0]);
        String actual = new String(baos.toByteArray(), "UTF8");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test176OptionModifier() {
        class Args {
            @CommandLine.Option(names={"-option"}, description={"the option value"})
            String option;
            @CommandLine.Option(names={"-option:env"}, description={"the environment variable to look up for the actual value"})
            String optionEnvKey;
            @CommandLine.Option(names={"-option:file"}, description={"path to the file containing the option value"})
            File optionFile;

            Args() {
            }
        }
        Args args = (Args)CommandLine.populateCommand((Object)new Args(), (String[])new String[]{"-option", "VAL", "-option:env", "KEY", "-option:file", "/path/to/file"});
        Assert.assertEquals((Object)"VAL", (Object)args.option);
        Assert.assertEquals((Object)"KEY", (Object)args.optionEnvKey);
        Assert.assertEquals((Object)new File("/path/to/file"), (Object)args.optionFile);
    }

    @Test
    public void test187GetCommandNameReturnsMainClassByDefault() {
        class Args {
            @CommandLine.Parameters
            String[] args;

            Args() {
            }
        }
        Assert.assertEquals((Object)"<main class>", (Object)new CommandLine((Object)new Args()).getCommandName());
        Assert.assertEquals((Object)"<main class>", (Object)"<main class>");
    }

    @Test
    public void test187GetCommandNameReturnsCommandAnnotationNameAttribute() {
        @CommandLine.Command(name="someCommand")
        class Args {
            @CommandLine.Parameters
            String[] args;

            Args() {
            }
        }
        Assert.assertEquals((Object)"someCommand", (Object)new CommandLine((Object)new Args()).getCommandName());
    }

    @Test
    public void test187SetCommandNameOverwritesCommandAnnotationNameAttribute() {
        @CommandLine.Command(name="someCommand")
        class Args {
            @CommandLine.Parameters
            String[] args;

            Args() {
            }
        }
        Assert.assertEquals((Object)"someCommand", (Object)new CommandLine((Object)new Args()).getCommandName());
        String OTHER = "a different name";
        Assert.assertEquals((Object)OTHER, (Object)new CommandLine((Object)new Args()).setCommandName(OTHER).getCommandName());
    }

    @Test
    public void test187GetCommandReturnsSubclassName() {
        @CommandLine.Command(name="child")
        class Child
        extends 1Parent {
            Child() {
                @CommandLine.Command(name="parent")
                class Parent {
                    Parent() {
                    }
                }
            }
        }
        Assert.assertEquals((Object)"child", (Object)new CommandLine((Object)new Child()).getCommandName());
    }

    @Test
    public void testIssue203InconsistentExceptions() {
        class Example {
            @CommandLine.Option(names={"-h", "--help"}, help=true, description={"Displays this help message and quits."})
            private boolean helpRequested;
            @CommandLine.Option(names={"-o", "--out-dir"}, required=true, description={"The output directory"})
            private File outputDir;
            @CommandLine.Parameters(arity="1..*", description={"The input files"})
            private File[] inputFiles;

            Example() {
            }
        }
        try {
            new CommandLine((Object)new Example()).parse(new String[]{"-o /tmp"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters at positions 0..*: <inputFiles>", (Object)ex.getMessage());
        }
        try {
            new CommandLine((Object)new Example()).parse(new String[]{"-o", " /tmp"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters at positions 0..*: <inputFiles>", (Object)ex.getMessage());
        }
        try {
            new CommandLine((Object)new Example()).parse(new String[]{"inputfile1", "inputfile2"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '-o=<outputDir>'", (Object)ex.getMessage());
        }
        try {
            new CommandLine((Object)new Example()).parse(new String[]{""});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required option '-o=<outputDir>'", (Object)ex.getMessage());
        }
        try {
            new CommandLine((Object)new Example()).parse(new String[0]);
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required options [-o=<outputDir>, params[*]=<inputFiles>]", (Object)ex.getMessage());
        }
        Example example = new Example();
        new CommandLine((Object)example).parse(new String[]{"-o", "/tmp", "inputfile1", "inputfile2"});
        Assert.assertEquals((Object)new File("/tmp"), (Object)example.outputDir);
        Assert.assertEquals((long)2L, (long)example.inputFiles.length);
        Assert.assertEquals((Object)new File("inputfile1"), (Object)example.inputFiles[0]);
        Assert.assertEquals((Object)new File("inputfile2"), (Object)example.inputFiles[1]);
    }

    @Test
    public void testIssue207ParameterExceptionProvidesAccessToFailedCommand_Programmatic() {
        class Sub2 {
            @CommandLine.Option(names={"-y"}, required=true)
            String y;

            Sub2() {
            }
        }
        class Sub1 {
            @CommandLine.Option(names={"-x"}, required=true)
            String x;

            Sub1() {
            }
        }
        class Top {
            @CommandLine.Option(names={"-o"}, required=true)
            String option;

            Top() {
            }
        }
        try {
            new CommandLine((Object)new Top()).addSubcommand("sub1", (Object)new Sub1()).addSubcommand("sub2", (Object)new Sub2()).parse("sub1 -x abc".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Top));
        }
        try {
            new CommandLine((Object)new Top()).addSubcommand("sub1", (Object)new Sub1()).addSubcommand("sub2", (Object)new Sub2()).parse("-o OPT sub1 -wrong ABC".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Sub1));
        }
        try {
            new CommandLine((Object)new Top()).addSubcommand("sub1", (Object)new Sub1()).addSubcommand("sub2", (Object)new Sub2()).parse("-o OPT sub2 -wrong ABC".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Sub2));
        }
        List parsed = new CommandLine((Object)new Top()).addSubcommand("sub1", (Object)new Sub1()).addSubcommand("sub2", (Object)new Sub2()).parse("-o OPT sub1 -x ABC".split(" "));
        Assert.assertEquals((long)2L, (long)parsed.size());
        Assert.assertEquals((Object)"OPT", (Object)((Top)((CommandLine)parsed.get((int)0)).getCommand()).option);
        Assert.assertEquals((Object)"ABC", (Object)((Sub1)((CommandLine)parsed.get((int)1)).getCommand()).x);
    }

    @Test
    public void testIssue207ParameterExceptionProvidesAccessToFailedCommand_Declarative() {
        @CommandLine.Command(subcommands={Sub207A.class, Sub207B.class})
        class Top {
            @CommandLine.Option(names={"-o"}, required=true)
            String option;

            Top() {
            }
        }
        try {
            new CommandLine((Object)new Top()).parse("sub207A -x abc".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Top));
        }
        try {
            new CommandLine((Object)new Top()).parse("-o OPT sub207A -wrong ABC".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Sub207A));
        }
        try {
            new CommandLine((Object)new Top()).parse("-o OPT sub207B -wrong ABC".split(" "));
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertTrue((boolean)(ex.getCommandLine().getCommand() instanceof Sub207B));
        }
        List parsed = new CommandLine((Object)new Top()).parse("-o OPT sub207A -x ABC".split(" "));
        Assert.assertEquals((long)2L, (long)parsed.size());
        Assert.assertEquals((Object)"OPT", (Object)((Top)((CommandLine)parsed.get((int)0)).getCommand()).option);
        Assert.assertEquals((Object)"ABC", (Object)((Sub207A)((CommandLine)parsed.get((int)1)).getCommand()).x);
    }

    @Test
    public void testIssue226EmptyStackWithClusteredOptions() {
        class Options {
            @CommandLine.Option(names={"-b"})
            private boolean buffered = false;
            @CommandLine.Option(names={"-o"})
            private boolean overwriteOutput = true;
            @CommandLine.Option(names={"-v"})
            private boolean verbose = false;

            Options() {
            }
        }
        Options options = (Options)CommandLine.populateCommand((Object)new Options(), (String[])new String[]{"-bov"});
        Assert.assertTrue((boolean)options.buffered);
        Assert.assertFalse((boolean)options.overwriteOutput);
        Assert.assertTrue((boolean)options.verbose);
    }

    @CommandLine.Command(name="sub207B")
    private static class Sub207B {
        @CommandLine.Option(names={"-y"}, required=true)
        String y;

        private Sub207B() {
        }
    }

    @CommandLine.Command(name="sub207A")
    private static class Sub207A {
        @CommandLine.Option(names={"-x"}, required=true)
        String x;

        private Sub207A() {
        }
    }

    @CommandLine.Command(subcommands={Sub1_testDeclarativelyAddSubcommands.class})
    static class MainCommand_testDeclarativelyAddSubcommands {
        MainCommand_testDeclarativelyAddSubcommands() {
        }
    }

    @CommandLine.Command(name="sub1", subcommands={SubSub1_testDeclarativelyAddSubcommands.class})
    static class Sub1_testDeclarativelyAddSubcommands {
    }

    @CommandLine.Command(name="subsub1")
    static class SubSub1_testDeclarativelyAddSubcommands {
        private SubSub1_testDeclarativelyAddSubcommands() {
        }
    }

    static class CustomType
    implements CommandLine.ITypeConverter<CustomType> {
        private final String val;

        private CustomType(String val) {
            this.val = val;
        }

        public CustomType convert(String value) {
            return new CustomType(value);
        }
    }

    static class GreatGrandChild2Command2_1 {
        @CommandLine.Option(names={"-h"})
        boolean h;
        @CommandLine.Option(names={"-t", "--type"})
        CustomType customType;

        GreatGrandChild2Command2_1() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class GrandChild2Command2 {
        @CommandLine.Option(names={"-g"})
        boolean g;

        GrandChild2Command2() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class GrandChild2Command1 {
        @CommandLine.Option(names={"-f"})
        boolean f;

        GrandChild2Command1() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class GrandChild1Command2 {
        @CommandLine.Option(names={"-e"})
        CustomType e;

        GrandChild1Command2() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class GrandChild1Command1 {
        @CommandLine.Option(names={"-d"})
        boolean d;

        GrandChild1Command1() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class ChildCommand2 {
        @CommandLine.Option(names={"-c"})
        boolean c;

        ChildCommand2() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class ChildCommand1 {
        @CommandLine.Option(names={"-b"})
        boolean b;

        ChildCommand1() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    static class MainCommand {
        @CommandLine.Option(names={"-a"})
        boolean a;

        MainCommand() {
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }

    class VariousPrefixCharacters {
        @CommandLine.Option(names={"-d", "--dash"})
        int dash;
        @CommandLine.Option(names={"/S"})
        int slashS;
        @CommandLine.Option(names={"/T"})
        int slashT;
        @CommandLine.Option(names={"/4"})
        boolean fourDigit;
        @CommandLine.Option(names={"/Owner", "--owner"})
        String owner;
        @CommandLine.Option(names={"-SingleDash"})
        boolean singleDash;
        @CommandLine.Option(names={"[CPM"})
        String cpm;
        @CommandLine.Option(names={"(CMS"})
        String cms;

        VariousPrefixCharacters() {
        }
    }

    private class CompactFields {
        @CommandLine.Option(names={"-v"})
        boolean verbose;
        @CommandLine.Option(names={"-r"})
        boolean recursive;
        @CommandLine.Option(names={"-o"})
        File outputFile;
        @CommandLine.Parameters
        File[] inputFiles;

        private CompactFields() {
        }
    }

    private static class RequiredField {
        @CommandLine.Option(names={"-?", "/?"}, help=true)
        boolean isHelpRequested;
        @CommandLine.Option(names={"-V", "--version"}, versionHelp=true)
        boolean versionHelp;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
        boolean usageHelp;
        @CommandLine.Option(names={"--required"}, required=true)
        private String required;
        @CommandLine.Parameters
        private String[] remainder;

        private RequiredField() {
        }
    }

    private static class PrivateFinalParameterFields {
        @CommandLine.Parameters(index="0")
        private final String field;
        @CommandLine.Parameters(index="1", arity="0..1")
        private final int primitive = 43;

        private PrivateFinalParameterFields() {
            this.field = null;
        }
    }

    private static class PrivateFinalOptionFields {
        @CommandLine.Option(names={"-f"})
        private final String field;
        @CommandLine.Option(names={"-p"})
        private final int primitive = 43;

        private PrivateFinalOptionFields() {
            this.field = null;
        }
    }

    class CollectionPositionalParams {
        @CommandLine.Parameters(type={Integer.class})
        Collection<Integer> collection;

        CollectionPositionalParams() {
        }
    }

    class QueuePositionalParams {
        @CommandLine.Parameters(type={Integer.class})
        Queue<Integer> queue;

        QueuePositionalParams() {
        }
    }

    class SetPositionalParams {
        @CommandLine.Parameters(type={Integer.class})
        Set<Integer> set;

        SetPositionalParams() {
        }
    }

    class SortedSetPositionalParams {
        @CommandLine.Parameters(type={Integer.class})
        SortedSet<Integer> sortedSet;

        SortedSetPositionalParams() {
        }
    }

    private class ListPositionalParams {
        @CommandLine.Parameters(type={Integer.class})
        List<Integer> list;

        private ListPositionalParams() {
        }
    }

    private static class EnumParams {
        @CommandLine.Option(names={"-timeUnit"})
        TimeUnit timeUnit;
        @CommandLine.Option(names={"-timeUnitArray"}, arity="2")
        TimeUnit[] timeUnitArray;
        @CommandLine.Option(names={"-timeUnitList"}, type={TimeUnit.class}, arity="3")
        List<TimeUnit> timeUnitList;

        private EnumParams() {
        }
    }

    static class SupportedTypes {
        @CommandLine.Option(names={"-boolean"})
        boolean booleanField;
        @CommandLine.Option(names={"-Boolean"})
        Boolean aBooleanField;
        @CommandLine.Option(names={"-byte"})
        byte byteField;
        @CommandLine.Option(names={"-Byte"})
        Byte aByteField;
        @CommandLine.Option(names={"-char"})
        char charField;
        @CommandLine.Option(names={"-Character"})
        Character aCharacterField;
        @CommandLine.Option(names={"-short"})
        short shortField;
        @CommandLine.Option(names={"-Short"})
        Short aShortField;
        @CommandLine.Option(names={"-int"})
        int intField;
        @CommandLine.Option(names={"-Integer"})
        Integer anIntegerField;
        @CommandLine.Option(names={"-long"})
        long longField;
        @CommandLine.Option(names={"-Long"})
        Long aLongField;
        @CommandLine.Option(names={"-float"})
        float floatField;
        @CommandLine.Option(names={"-Float"})
        Float aFloatField;
        @CommandLine.Option(names={"-double"})
        double doubleField;
        @CommandLine.Option(names={"-Double"})
        Double aDoubleField;
        @CommandLine.Option(names={"-String"})
        String aStringField;
        @CommandLine.Option(names={"-StringBuilder"})
        StringBuilder aStringBuilderField;
        @CommandLine.Option(names={"-CharSequence"})
        CharSequence aCharSequenceField;
        @CommandLine.Option(names={"-File"})
        File aFileField;
        @CommandLine.Option(names={"-URL"})
        URL anURLField;
        @CommandLine.Option(names={"-URI"})
        URI anURIField;
        @CommandLine.Option(names={"-Date"})
        Date aDateField;
        @CommandLine.Option(names={"-Time"})
        Time aTimeField;
        @CommandLine.Option(names={"-BigDecimal"})
        BigDecimal aBigDecimalField;
        @CommandLine.Option(names={"-BigInteger"})
        BigInteger aBigIntegerField;
        @CommandLine.Option(names={"-Charset"})
        Charset aCharsetField;
        @CommandLine.Option(names={"-InetAddress"})
        InetAddress anInetAddressField;
        @CommandLine.Option(names={"-Pattern"})
        Pattern aPatternField;
        @CommandLine.Option(names={"-UUID"})
        UUID anUUIDField;

        SupportedTypes() {
        }
    }
}

