/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;
import org.apache.logging.log4j.core.tools.picocli.CustomLayoutDemo;
import org.apache.logging.log4j.core.tools.picocli.Demo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CommandLineHelpTest {
    private static final String LINESEP = System.getProperty("line.separator");

    @After
    public void after() {
        System.getProperties().remove("picocli.color.commands");
        System.getProperties().remove("picocli.color.options");
        System.getProperties().remove("picocli.color.parameters");
        System.getProperties().remove("picocli.color.optionParams");
    }

    private static String usageString(Object annotatedObject, CommandLine.Help.Ansi ansi) throws UnsupportedEncodingException {
        return CommandLineHelpTest.usageString(new CommandLine(annotatedObject), ansi);
    }

    private static String usageString(CommandLine commandLine, CommandLine.Help.Ansi ansi) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        commandLine.usage(new PrintStream((OutputStream)baos, true, "UTF8"), ansi);
        String result = baos.toString("UTF8");
        if (ansi == CommandLine.Help.Ansi.AUTO) {
            baos.reset();
            commandLine.usage(new PrintStream((OutputStream)baos, true, "UTF8"));
            Assert.assertEquals((Object)result, (Object)baos.toString("UTF8"));
        } else if (ansi == CommandLine.Help.Ansi.ON) {
            baos.reset();
            commandLine.usage(new PrintStream((OutputStream)baos, true, "UTF8"), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
            Assert.assertEquals((Object)result, (Object)baos.toString("UTF8"));
        }
        return result;
    }

    private static Field field(Class<?> cls, String fieldName) throws NoSuchFieldException {
        return cls.getDeclaredField(fieldName);
    }

    private static Field[] fields(Class<?> cls, String ... fieldNames) throws NoSuchFieldException {
        Field[] result = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = cls.getDeclaredField(fieldNames[i]);
        }
        return result;
    }

    @Test
    public void testWithoutShowDefaultValues() throws Exception {
        @CommandLine.Command
        class Params {
            @CommandLine.Option(names={"-f", "--file"}, required=true, description={"the file to use"})
            File file;

            Params() {
            }
        }
        String result = CommandLineHelpTest.usageString(new Params(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> -f=<file>%n  -f, --file=<file>           the file to use%n", ""), (Object)result);
    }

    @Test
    public void testShowDefaultValues() throws Exception {
        @CommandLine.Command(showDefaultValues=true)
        class Params {
            @CommandLine.Option(names={"-f", "--file"}, required=true, description={"the file to use"})
            File file = new File("theDefault.txt");

            Params() {
            }
        }
        String result = CommandLineHelpTest.usageString(new Params(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> -f=<file>%n  -f, --file=<file>           the file to use%n                                Default: theDefault.txt%n", new Object[0]), (Object)result);
    }

    @Test
    public void testShowDefaultValuesArrayField() throws Exception {
        @CommandLine.Command(showDefaultValues=true)
        class Params {
            @CommandLine.Option(names={"-x", "--array"}, required=true, description={"the array"})
            int[] array = new int[]{1, 5, 11, 23};

            Params() {
            }
        }
        String result = CommandLineHelpTest.usageString(new Params(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> -x=<array> [-x=<array>]...%n  -x, --array=<array>         the array%n                                Default: [1, 5, 11, 23]%n", new Object[0]), (Object)result);
    }

    @Test
    public void testUsageSeparatorWithoutDefault() throws Exception {
        @CommandLine.Command
        class Params {
            @CommandLine.Option(names={"-f", "--file"}, required=true, description={"the file to use"})
            File file = new File("def.txt");

            Params() {
            }
        }
        String result = CommandLineHelpTest.usageString(new Params(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> -f=<file>%n  -f, --file=<file>           the file to use%n", ""), (Object)result);
    }

    @Test
    public void testUsageSeparator() throws Exception {
        @CommandLine.Command(showDefaultValues=true)
        class Params {
            @CommandLine.Option(names={"-f", "--file"}, required=true, description={"the file to use"})
            File file = new File("def.txt");

            Params() {
            }
        }
        String result = CommandLineHelpTest.usageString(new Params(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> -f=<file>%n  -f, --file=<file>           the file to use%n                                Default: def.txt%n", ""), (Object)result);
    }

    @Test
    public void testUsageParamLabels() throws Exception {
        @CommandLine.Command
        class ParamLabels {
            @CommandLine.Option(names={"-P"}, paramLabel="KEY=VALUE", type={String.class, String.class}, description={"Project properties (key-value pairs)"})
            Map<String, String> props;
            @CommandLine.Option(names={"-f"}, paramLabel="FILE", description={"files"})
            File[] f;
            @CommandLine.Option(names={"-n"}, description={"a number option"})
            int number;
            @CommandLine.Parameters(index="0", paramLabel="NUM", description={"number param"})
            int n;
            @CommandLine.Parameters(index="1", description={"the host parameter"})
            InetAddress host;

            ParamLabels() {
            }
        }
        String result = CommandLineHelpTest.usageString(new ParamLabels(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> [-n=<number>] [-f=FILE]... [-P=KEY=VALUE]... NUM <host>%n      NUM                     number param%n      <host>                  the host parameter%n  -f= FILE                    files%n  -n= <number>                a number option%n  -P= KEY=VALUE               Project properties (key-value pairs)%n", ""), (Object)result);
    }

    @Test
    public void testUsageParamLabelsWithLongMapOptionName() throws Exception {
        @CommandLine.Command
        class ParamLabels {
            @CommandLine.Option(names={"-P", "--properties"}, paramLabel="KEY=VALUE", type={String.class, String.class}, description={"Project properties (key-value pairs)"})
            Map<String, String> props;
            @CommandLine.Option(names={"-f"}, paramLabel="FILE", description={"a file"})
            File f;
            @CommandLine.Option(names={"-n"}, description={"a number option"})
            int number;
            @CommandLine.Parameters(index="0", paramLabel="NUM", description={"number param"})
            int n;
            @CommandLine.Parameters(index="1", description={"the host parameter"})
            InetAddress host;

            ParamLabels() {
            }
        }
        String result = CommandLineHelpTest.usageString(new ParamLabels(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: <main class> [-f=FILE] [-n=<number>] [-P=KEY=VALUE]... NUM <host>%n      NUM                     number param%n      <host>                  the host parameter%n  -f= FILE                    a file%n  -n= <number>                a number option%n  -P, --properties=KEY=VALUE  Project properties (key-value pairs)%n", ""), (Object)result);
    }

    @Test
    public void testUsageVariableArityRequiredShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -a=ARG [-a=ARG]... -b=[ARG]... [-b=[ARG]...]... -c=ARG...%n                    [-c=ARG...]... -d=ARG ARG... [-d=ARG ARG...]...%n  -a= ARG%n  -b= [ARG]...%n  -c= ARG...%n  -d= ARG ARG...%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"-b"}, required=true, paramLabel="ARG", arity="0..*")
            List<String> b;
            @CommandLine.Option(names={"-c"}, required=true, paramLabel="ARG", arity="1..*")
            String[] c;
            @CommandLine.Option(names={"-d"}, required=true, paramLabel="ARG", arity="2..*")
            List<String> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-a=ARG]... [-b=[ARG]...]... [-c=ARG...]... [-d=ARG%n                    ARG...]...%n  -a= ARG%n  -b= [ARG]...%n  -c= ARG...%n  -d= ARG ARG...%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, paramLabel="ARG")
            List<String> a;
            @CommandLine.Option(names={"-b"}, paramLabel="ARG", arity="0..*")
            String[] b;
            @CommandLine.Option(names={"-c"}, paramLabel="ARG", arity="1..*")
            List<String> c;
            @CommandLine.Option(names={"-d"}, paramLabel="ARG", arity="2..*")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityRequiredShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -a[=ARG] [-a[=ARG]]... -b=ARG [ARG] [-b=ARG [ARG]]...%n                    -c=ARG [ARG [ARG]] [-c=ARG [ARG [ARG]]]... -d=ARG ARG [ARG%n                    [ARG]] [-d=ARG ARG [ARG [ARG]]]...%n  -a= [ARG]%n  -b= ARG [ARG]%n  -c= ARG [ARG [ARG]]%n  -d= ARG ARG [ARG [ARG]]%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, paramLabel="ARG", arity="0..1")
            List<String> a;
            @CommandLine.Option(names={"-b"}, required=true, paramLabel="ARG", arity="1..2")
            String[] b;
            @CommandLine.Option(names={"-c"}, required=true, paramLabel="ARG", arity="1..3")
            String[] c;
            @CommandLine.Option(names={"-d"}, required=true, paramLabel="ARG", arity="2..4")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-a[=ARG]]... [-b=ARG [ARG]]... [-c=ARG [ARG [ARG]]]...%n                    [-d=ARG ARG [ARG [ARG]]]...%n  -a= [ARG]%n  -b= ARG [ARG]%n  -c= ARG [ARG [ARG]]%n  -d= ARG ARG [ARG [ARG]]%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, paramLabel="ARG", arity="0..1")
            List<String> a;
            @CommandLine.Option(names={"-b"}, paramLabel="ARG", arity="1..2")
            String[] b;
            @CommandLine.Option(names={"-c"}, paramLabel="ARG", arity="1..3")
            String[] c;
            @CommandLine.Option(names={"-d"}, paramLabel="ARG", arity="2..4")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityRequiredShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -b [-b]... -a=ARG [-a=ARG]... -c=ARG [-c=ARG]... -d=ARG ARG%n                    [-d=ARG ARG]...%n  -a= ARG%n  -b%n  -c= ARG%n  -d= ARG ARG%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"-b"}, required=true, paramLabel="ARG", arity="0")
            String[] b;
            @CommandLine.Option(names={"-c"}, required=true, paramLabel="ARG", arity="1")
            String[] c;
            @CommandLine.Option(names={"-d"}, required=true, paramLabel="ARG", arity="2")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityShortOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-b]... [-a=ARG]... [-c=ARG]... [-d=ARG ARG]...%n  -a= ARG%n  -b%n  -c= ARG%n  -d= ARG ARG%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"-b"}, paramLabel="ARG", arity="0")
            String[] b;
            @CommandLine.Option(names={"-c"}, paramLabel="ARG", arity="1")
            String[] c;
            @CommandLine.Option(names={"-d"}, paramLabel="ARG", arity="2")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityRequiredLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> --aa=ARG [--aa=ARG]... --bb=[ARG]... [--bb=[ARG]...]...%n                    --cc=ARG... [--cc=ARG...]... --dd=ARG ARG... [--dd=ARG%n                    ARG...]...%n      --aa=ARG%n      --bb=[ARG]...%n      --cc=ARG...%n      --dd=ARG ARG...%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, required=true, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"--bb"}, required=true, paramLabel="ARG", arity="0..*")
            List<String> b;
            @CommandLine.Option(names={"--cc"}, required=true, paramLabel="ARG", arity="1..*")
            String[] c;
            @CommandLine.Option(names={"--dd"}, required=true, paramLabel="ARG", arity="2..*")
            List<String> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [--aa=ARG]... [--bb=[ARG]...]... [--cc=ARG...]... [--dd=ARG%n                    ARG...]...%n      --aa=ARG%n      --bb=[ARG]...%n      --cc=ARG...%n      --dd=ARG ARG...%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, paramLabel="ARG")
            List<String> a;
            @CommandLine.Option(names={"--bb"}, paramLabel="ARG", arity="0..*")
            String[] b;
            @CommandLine.Option(names={"--cc"}, paramLabel="ARG", arity="1..*")
            List<String> c;
            @CommandLine.Option(names={"--dd"}, paramLabel="ARG", arity="2..*")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityRequiredLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> --aa[=ARG] [--aa[=ARG]]... --bb=ARG [ARG] [--bb=ARG%n                    [ARG]]... --cc=ARG [ARG [ARG]] [--cc=ARG [ARG [ARG]]]...%n                    --dd=ARG ARG [ARG [ARG]] [--dd=ARG ARG [ARG [ARG]]]...%n      --aa[=ARG]%n      --bb=ARG [ARG]%n      --cc=ARG [ARG [ARG]]%n      --dd=ARG ARG [ARG [ARG]]%n                              foobar%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, required=true, paramLabel="ARG", arity="0..1")
            List<String> a;
            @CommandLine.Option(names={"--bb"}, required=true, paramLabel="ARG", arity="1..2")
            String[] b;
            @CommandLine.Option(names={"--cc"}, required=true, paramLabel="ARG", arity="1..3")
            String[] c;
            @CommandLine.Option(names={"--dd"}, required=true, paramLabel="ARG", arity="2..4", description={"foobar"})
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [--aa[=ARG]]... [--bb=ARG [ARG]]... [--cc=ARG [ARG%n                    [ARG]]]... [--dd=ARG ARG [ARG [ARG]]]...%n      --aa[=ARG]%n      --bb=ARG [ARG]%n      --cc=ARG [ARG [ARG]]%n      --dd=ARG ARG [ARG [ARG]]%n                              foobar%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, paramLabel="ARG", arity="0..1")
            List<String> a;
            @CommandLine.Option(names={"--bb"}, paramLabel="ARG", arity="1..2")
            String[] b;
            @CommandLine.Option(names={"--cc"}, paramLabel="ARG", arity="1..3")
            String[] c;
            @CommandLine.Option(names={"--dd"}, paramLabel="ARG", arity="2..4", description={"foobar"})
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityRequiredLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> --bb [--bb]... --aa=ARG [--aa=ARG]... --cc=ARG%n                    [--cc=ARG]... --dd=ARG ARG [--dd=ARG ARG]...%n      --aa=ARG%n      --bb%n      --cc=ARG%n      --dd=ARG ARG%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, required=true, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"--bb"}, required=true, paramLabel="ARG", arity="0")
            String[] b;
            @CommandLine.Option(names={"--cc"}, required=true, paramLabel="ARG", arity="1")
            String[] c;
            @CommandLine.Option(names={"--dd"}, required=true, paramLabel="ARG", arity="2")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityLongOptionArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [--bb]... [--aa=ARG]... [--cc=ARG]... [--dd=ARG ARG]...%n      --aa=ARG%n      --bb%n      --cc=ARG%n      --dd=ARG ARG%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"--aa"}, paramLabel="ARG")
            String[] a;
            @CommandLine.Option(names={"--bb"}, paramLabel="ARG", arity="0")
            String[] b;
            @CommandLine.Option(names={"--cc"}, paramLabel="ARG", arity="1")
            String[] c;
            @CommandLine.Option(names={"--dd"}, paramLabel="ARG", arity="2")
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityRequiredShortOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -a=KEY=VAL [-a=KEY=VAL]... -b=[<String=String>]... [-b=%n                    [<String=String>]...]... -c=<String=TimeUnit>...%n                    [-c=<String=TimeUnit>...]... -d=<Integer=URL>%n                    <Integer=URL>... [-d=<Integer=URL> <Integer=URL>...]...%n  -a= KEY=VAL%n  -b= [<String=String>]...%n  -c= <String=TimeUnit>...%n  -d= <Integer=URL> <Integer=URL>...%n                              description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, paramLabel="KEY=VAL")
            Map<String, String> a;
            @CommandLine.Option(names={"-b"}, required=true, arity="0..*")
            Map b;
            @CommandLine.Option(names={"-c"}, required=true, arity="1..*", type={String.class, TimeUnit.class})
            Map<String, TimeUnit> c;
            @CommandLine.Option(names={"-d"}, required=true, arity="2..*", type={Integer.class, URL.class}, description={"description"})
            Map<Integer, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-a=<String=String>]... [-b=[<Integer=Integer>]...]...%n                    [-c=KEY=VALUE...]... [-d=<String=URL> <String=URL>...]...%n  -a= <String=String>%n  -b= [<Integer=Integer>]...%n  -c= KEY=VALUE...%n  -d= <String=URL> <String=URL>...%n                              description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"})
            Map<String, String> a;
            @CommandLine.Option(names={"-b"}, arity="0..*", type={Integer.class, Integer.class})
            Map<Integer, Integer> b;
            @CommandLine.Option(names={"-c"}, paramLabel="KEY=VALUE", arity="1..*", type={String.class, TimeUnit.class})
            Map<String, TimeUnit> c;
            @CommandLine.Option(names={"-d"}, arity="2..*", type={String.class, URL.class}, description={"description"})
            Map<String, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityRequiredOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -a[=<String=String>] [-a[=<String=String>]]...%n                    -b=<Integer=Integer> [<Integer=Integer>]%n                    [-b=<Integer=Integer> [<Integer=Integer>]]...%n                    -c=<String=URL> [<String=URL> [<String=URL>]]%n                    [-c=<String=URL> [<String=URL> [<String=URL>]]]... -d=K=URL%n                    K=URL [K=URL [K=URL]] [-d=K=URL K=URL [K=URL [K=URL]]]...%n  -a= [<String=String>]       a description%n  -b= <Integer=Integer> [<Integer=Integer>]%n                              b description%n  -c= <String=URL> [<String=URL> [<String=URL>]]%n                              c description%n  -d= K=URL K=URL [K=URL [K=URL]]%n                              d description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, arity="0..1", description={"a description"})
            Map<String, String> a;
            @CommandLine.Option(names={"-b"}, required=true, arity="1..2", type={Integer.class, Integer.class}, description={"b description"})
            Map<Integer, Integer> b;
            @CommandLine.Option(names={"-c"}, required=true, arity="1..3", type={String.class, URL.class}, description={"c description"})
            Map<String, URL> c;
            @CommandLine.Option(names={"-d"}, required=true, paramLabel="K=URL", arity="2..4", description={"d description"})
            Map<String, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-a[=<UUID=URL>]]... [-b=<Long=UUID> [<Long=UUID>]]...%n                    [-c=<String=String> [<String=String> [<String=String>]]]...%n                    [-d=K=V K=V [K=V [K=V]]]...%n  -a= [<UUID=URL>]            a description%n  -b= <Long=UUID> [<Long=UUID>]%n                              b description%n  -c= <String=String> [<String=String> [<String=String>]]%n                              c description%n  -d= K=V K=V [K=V [K=V]]     d description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, arity="0..1", description={"a description"})
            Map<UUID, URL> a;
            @CommandLine.Option(names={"-b"}, arity="1..2", type={Long.class, UUID.class}, description={"b description"})
            Map<?, ?> b;
            @CommandLine.Option(names={"-c"}, arity="1..3", type={Long.class}, description={"c description"})
            Map<?, ?> c;
            @CommandLine.Option(names={"-d"}, paramLabel="K=V", arity="2..4", description={"d description"})
            Map<?, ?> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityRequiredOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> -b [-b]... -a=<Short=Field> [-a=<Short=Field>]...%n                    -c=<Long=File> [-c=<Long=File>]... -d=<URI=URL> <URI=URL>%n                    [-d=<URI=URL> <URI=URL>]...%n  -a= <Short=Field>           a description%n  -b                          b description%n  -c= <Long=File>             c description%n  -d= <URI=URL> <URI=URL>     d description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, required=true, description={"a description"})
            Map<Short, Field> a;
            @CommandLine.Option(names={"-b"}, required=true, paramLabel="KEY=VAL", arity="0", description={"b description"})
            Map b;
            @CommandLine.Option(names={"-c"}, required=true, arity="1", type={Long.class, File.class}, description={"c description"})
            Map<Long, File> c;
            @CommandLine.Option(names={"-d"}, required=true, arity="2", type={URI.class, URL.class}, description={"d description"})
            Map<URI, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityOptionMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [-b]... [-a=<Short=Field>]... [-c=<Long=File>]...%n                    [-d=<URI=URL> <URI=URL>]...%n  -a= <Short=Field>           a description%n  -b                          b description%n  -c= <Long=File>             c description%n  -d= <URI=URL> <URI=URL>     d description%n", new Object[0]);
        class Args {
            @CommandLine.Option(names={"-a"}, type={Short.class, Field.class}, description={"a description"})
            Map<Short, Field> a;
            @CommandLine.Option(names={"-b"}, arity="0", type={UUID.class, Long.class}, description={"b description"})
            Map b;
            @CommandLine.Option(names={"-c"}, arity="1", description={"c description"})
            Map<Long, File> c;
            @CommandLine.Option(names={"-d"}, arity="2", type={URI.class, URL.class}, description={"d description"})
            Map<URI, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityParametersArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [APARAM]... [<b>]... <c>... <d> <d>...%n      [APARAM]...             APARAM description%n      [<b>]...                b description%n      <c>...                  c description%n      <d> <d>...              d description%n", new Object[0]);
        class Args {
            @CommandLine.Parameters(paramLabel="APARAM", description={"APARAM description"})
            String[] a;
            @CommandLine.Parameters(arity="0..*", description={"b description"})
            List<String> b;
            @CommandLine.Parameters(arity="1..*", description={"c description"})
            String[] c;
            @CommandLine.Parameters(arity="2..*", description={"d description"})
            List<String> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityParameterArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [PARAMA] PARAMB [PARAMB] PARAMC [PARAMC [PARAMC]] PARAMD%n                    PARAMD [PARAMD [PARAMD]]%n      [PARAMA]                PARAMA description%n      PARAMB [PARAMB]         PARAMB description%n      PARAMC [PARAMC [PARAMC]]%n                              PARAMC description%n      PARAMD PARAMD [PARAMD [PARAMD]]%n                              PARAMD description%n", new Object[0]);
        class Args {
            @CommandLine.Parameters(index="0", paramLabel="PARAMA", arity="0..1", description={"PARAMA description"})
            List<String> a;
            @CommandLine.Parameters(index="0", paramLabel="PARAMB", arity="1..2", description={"PARAMB description"})
            String[] b;
            @CommandLine.Parameters(index="0", paramLabel="PARAMC", arity="1..3", description={"PARAMC description"})
            String[] c;
            @CommandLine.Parameters(index="0", paramLabel="PARAMD", arity="2..4", description={"PARAMD description"})
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityParametersArray() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class>  [<a>]... <c> <d> <d>%n                              b description (arity=0)%n      [<a>]...                a description (default arity)%n      <c>                     b description (arity=1)%n      <d> <d>                 b description (arity=2)%n", new Object[0]);
        class Args {
            @CommandLine.Parameters(description={"a description (default arity)"})
            String[] a;
            @CommandLine.Parameters(index="0", arity="0", description={"b description (arity=0)"})
            String[] b;
            @CommandLine.Parameters(index="1", arity="1", description={"b description (arity=1)"})
            String[] c;
            @CommandLine.Parameters(index="2", arity="2", description={"b description (arity=2)"})
            String[] d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageVariableArityParametersMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [<String=String>]... [<Integer=Integer>]... KEY=VALUE...%n                    <String=URL> <String=URL>...%n      [<String=String>]...%n      [<Integer=Integer>]...  a description (arity=0..*)%n      KEY=VALUE...%n      <String=URL> <String=URL>...%n                              description%n", new Object[0]);
        class Args {
            @CommandLine.Parameters
            Map<String, String> a;
            @CommandLine.Parameters(arity="0..*", description={"a description (arity=0..*)"})
            Map<Integer, Integer> b;
            @CommandLine.Parameters(paramLabel="KEY=VALUE", arity="1..*", type={String.class, TimeUnit.class})
            Map<String, TimeUnit> c;
            @CommandLine.Parameters(arity="2..*", type={String.class, URL.class}, description={"description"})
            Map<String, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageRangeArityParametersMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class> [<UUID=URL>] <Long=UUID> [<Long=UUID>] <String=String>%n                    [<String=String> [<String=String>]] K=V K=V [K=V [K=V]]%n      [<UUID=URL>]            a description%n      <Long=UUID> [<Long=UUID>]%n                              b description%n      <String=String> [<String=String> [<String=String>]]%n                              c description%n      K=V K=V [K=V [K=V]]     d description%n", new Object[0]);
        class Args {
            @CommandLine.Parameters(index="0", arity="0..1", description={"a description"})
            Map<UUID, URL> a;
            @CommandLine.Parameters(index="1", arity="1..2", type={Long.class, UUID.class}, description={"b description"})
            Map<?, ?> b;
            @CommandLine.Parameters(index="2", arity="1..3", type={Long.class}, description={"c description"})
            Map<?, ?> c;
            @CommandLine.Parameters(index="3", paramLabel="K=V", arity="2..4", description={"d description"})
            Map<?, ?> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageFixedArityParametersMap() throws UnsupportedEncodingException {
        String expected = String.format("Usage: <main class>  [<Short=Field>]... <Long=File> <URI=URL> <URI=URL>%n                              b description (arity=0)%n      [<Short=Field>]...      a description%n      <Long=File>             c description%n      <URI=URL> <URI=URL>     d description%n", new Object[0]);
        class Args {
            @CommandLine.Parameters(type={Short.class, Field.class}, description={"a description"})
            Map<Short, Field> a;
            @CommandLine.Parameters(index="0", arity="0", type={UUID.class, Long.class}, description={"b description (arity=0)"})
            Map b;
            @CommandLine.Parameters(index="1", arity="1", description={"c description"})
            Map<Long, File> c;
            @CommandLine.Parameters(index="2", arity="2", type={URI.class, URL.class}, description={"d description"})
            Map<URI, URL> d;

            Args() {
            }
        }
        Assert.assertEquals((Object)expected, (Object)CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testShortestFirstComparator_sortsShortestFirst() {
        Object[] values = new String[]{"12345", "12", "123", "123456", "1", "", "1234"};
        Arrays.sort(values, new CommandLine.Help.ShortestFirst());
        Object[] expected = new String[]{"", "1", "12", "123", "1234", "12345", "123456"};
        Assert.assertArrayEquals((Object[])expected, (Object[])values);
    }

    @Test
    public void testShortestFirstComparator_sortsDeclarationOrderIfEqualLength() {
        Object[] values = new String[]{"-d", "-", "-a", "--alpha", "--b", "--a", "--beta"};
        Arrays.sort(values, new CommandLine.Help.ShortestFirst());
        Object[] expected = new String[]{"-", "-d", "-a", "--b", "--a", "--beta", "--alpha"};
        Assert.assertArrayEquals((Object[])expected, (Object[])values);
    }

    @Test
    public void testSortByShortestOptionNameComparator() throws Exception {
        class App {
            @CommandLine.Option(names={"-t", "--aaaa"})
            boolean aaaa;
            @CommandLine.Option(names={"--bbbb", "-k"})
            boolean bbbb;
            @CommandLine.Option(names={"-c", "--cccc"})
            boolean cccc;

            App() {
            }
        }
        Object[] fields = CommandLineHelpTest.fields(App.class, "aaaa", "bbbb", "cccc");
        Arrays.sort(fields, new CommandLine.Help.SortByShortestOptionNameAlphabetically());
        Object[] expected = CommandLineHelpTest.fields(App.class, "cccc", "bbbb", "aaaa");
        Assert.assertArrayEquals((Object[])expected, (Object[])fields);
    }

    @Test
    public void testSortByOptionArityAndNameComparator_sortsByMaxThenMinThenName() throws Exception {
        class App {
            @CommandLine.Option(names={"-t", "--aaaa"})
            boolean tImplicitArity0;
            @CommandLine.Option(names={"-e", "--EEE"}, arity="1")
            boolean explicitArity1;
            @CommandLine.Option(names={"--bbbb", "-k"})
            boolean kImplicitArity0;
            @CommandLine.Option(names={"--AAAA", "-a"})
            int aImplicitArity1;
            @CommandLine.Option(names={"--BBBB", "-z"})
            String[] zImplicitArity1;
            @CommandLine.Option(names={"--ZZZZ", "-b"}, arity="1..3")
            String[] bExplicitArity1_3;
            @CommandLine.Option(names={"-f", "--ffff"})
            boolean fImplicitArity0;

            App() {
            }
        }
        Object[] fields = CommandLineHelpTest.fields(App.class, "tImplicitArity0", "explicitArity1", "kImplicitArity0", "aImplicitArity1", "zImplicitArity1", "bExplicitArity1_3", "fImplicitArity0");
        Arrays.sort(fields, new CommandLine.Help.SortByOptionArityAndNameAlphabetically());
        Object[] expected = CommandLineHelpTest.fields(App.class, "fImplicitArity0", "kImplicitArity0", "tImplicitArity0", "aImplicitArity1", "explicitArity1", "zImplicitArity1", "bExplicitArity1_3");
        Assert.assertArrayEquals((Object[])expected, (Object[])fields);
    }

    @Test
    public void testCreateMinimalOptionRenderer_ReturnsMinimalOptionRenderer() {
        Assert.assertEquals(CommandLine.Help.MinimalOptionRenderer.class, CommandLine.Help.createMinimalOptionRenderer().getClass());
    }

    @Test
    public void testMinimalOptionRenderer_rendersFirstDeclaredOptionNameAndDescription() {
        CommandLine.Help.IOptionRenderer renderer = CommandLine.Help.createMinimalOptionRenderer();
        class Example {
            @CommandLine.Option(names={"---long", "-L"}, description={"long description"})
            String longField;
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, description={"other"})
            String otherField;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row1 = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)help.ansi()));
        Assert.assertEquals((long)1L, (long)row1.length);
        Object[] objectArray = new CommandLine.Help.Ansi.Text[2];
        CommandLine.Help.Ansi ansi = help.ansi();
        ansi.getClass();
        objectArray[0] = new CommandLine.Help.Ansi.Text(ansi, String.format("%s---long%s=%s<longField>%s", "@|fg(yellow) ", "|@", "@|italic ", "|@"));
        CommandLine.Help.Ansi ansi2 = help.ansi();
        ansi2.getClass();
        objectArray[1] = new CommandLine.Help.Ansi.Text(ansi2, "long description");
        Assert.assertArrayEquals((Object[])objectArray, (Object[])row1[0]);
        field = (Field)help.optionFields.get(1);
        CommandLine.Help.Ansi.Text[][] row2 = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)help.ansi()));
        Assert.assertEquals((long)1L, (long)row2.length);
        Object[] objectArray2 = new CommandLine.Help.Ansi.Text[2];
        CommandLine.Help.Ansi ansi3 = help.ansi();
        ansi3.getClass();
        objectArray2[0] = new CommandLine.Help.Ansi.Text(ansi3, String.format("%s-b%s=%s<otherField>%s", "@|fg(yellow) ", "|@", "@|italic ", "|@"));
        CommandLine.Help.Ansi ansi4 = help.ansi();
        ansi4.getClass();
        objectArray2[1] = new CommandLine.Help.Ansi.Text(ansi4, "other");
        Assert.assertArrayEquals((Object[])objectArray2, (Object[])row2[0]);
    }

    @Test
    public void testCreateDefaultOptionRenderer_ReturnsDefaultOptionRenderer() {
        Assert.assertEquals(CommandLine.Help.DefaultOptionRenderer.class, new CommandLine.Help((Object)new UsageDemo()).createDefaultOptionRenderer().getClass());
    }

    private static CommandLine.Help.Ansi.Text[] textArray(CommandLine.Help help, String ... str) {
        return CommandLineHelpTest.textArray(help.ansi(), str);
    }

    private static CommandLine.Help.Ansi.Text[] textArray(CommandLine.Help.Ansi ansi, String ... str) {
        CommandLine.Help.Ansi.Text[] result = new CommandLine.Help.Ansi.Text[str.length];
        for (int i = 0; i < str.length; ++i) {
            CommandLine.Help.Ansi.Text text;
            if (str[i] == null) {
                text = CommandLine.Help.Ansi.EMPTY_TEXT;
            } else {
                CommandLine.Help.Ansi ansi2 = ansi;
                ansi2.getClass();
                text = new CommandLine.Help.Ansi.Text(ansi2, str[i]);
            }
            result[i] = text;
        }
        return result;
    }

    @Test
    public void testDefaultOptionRenderer_rendersShortestOptionNameThenOtherOptionNamesAndDescription() {
        @CommandLine.Command(showDefaultValues=true)
        class Example {
            @CommandLine.Option(names={"---long", "-L"}, description={"long description"})
            String longField;
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, description={"other"})
            String otherField = "abc";

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row1 = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row1.length);
        Assert.assertArrayEquals((String)Arrays.toString(row1[0]), (Object[])CommandLineHelpTest.textArray(help, "", "-L", ",", "---long=<longField>", "long description"), (Object[])row1[0]);
        field = (Field)help.optionFields.get(1);
        CommandLine.Help.Ansi.Text[][] row2 = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)2L, (long)row2.length);
        Assert.assertArrayEquals((String)Arrays.toString(row2[0]), (Object[])CommandLineHelpTest.textArray(help, "", "-b", ",", "-a, --alpha=<otherField>", "other"), (Object[])row2[0]);
        Assert.assertArrayEquals((String)Arrays.toString(row2[1]), (Object[])CommandLineHelpTest.textArray(help, "", "", "", "", "  Default: abc"), (Object[])row2[1]);
    }

    @Test
    public void testDefaultOptionRenderer_rendersSpecifiedMarkerForRequiredOptionsWithDefault() {
        @CommandLine.Command(requiredOptionMarker=42, showDefaultValues=true)
        class Example {
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, required=true, description={"other"})
            String otherField = "abc";

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)2L, (long)row.length);
        Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, "*", "-b", ",", "-a, --alpha=<otherField>", "other"), (Object[])row[0]);
        Assert.assertArrayEquals((String)Arrays.toString(row[1]), (Object[])CommandLineHelpTest.textArray(help, "", "", "", "", "  Default: abc"), (Object[])row[1]);
    }

    @Test
    public void testDefaultOptionRenderer_rendersSpecifiedMarkerForRequiredOptionsWithoutDefault() {
        @CommandLine.Command(requiredOptionMarker=42)
        class Example {
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, required=true, description={"other"})
            String otherField = "abc";

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row.length);
        Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, "*", "-b", ",", "-a, --alpha=<otherField>", "other"), (Object[])row[0]);
    }

    @Test
    public void testDefaultOptionRenderer_rendersSpacePrefixByDefaultForRequiredOptionsWithoutDefaultValue() {
        class Example {
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, required=true, description={"other"})
            String otherField;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row.length);
        Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, " ", "-b", ",", "-a, --alpha=<otherField>", "other"), (Object[])row[0]);
    }

    @Test
    public void testDefaultOptionRenderer_rendersSpacePrefixByDefaultForRequiredOptionsWithDefaultValue() {
        class Example {
            @CommandLine.Option(names={"-b", "-a", "--alpha"}, required=true, description={"other"})
            String otherField;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        help.showDefaultValues = true;
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        Field field = (Field)help.optionFields.get(0);
        CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row.length);
        Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, " ", "-b", ",", "-a, --alpha=<otherField>", "other"), (Object[])row[0]);
    }

    @Test
    public void testDefaultParameterRenderer_rendersSpacePrefixByDefaultForParametersWithPositiveArity() {
        class Required {
            @CommandLine.Parameters(description={"required"})
            String required;

            Required() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Required());
        CommandLine.Help.IParameterRenderer renderer = help.createDefaultParameterRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = CommandLine.Help.createMinimalParamLabelRenderer();
        Field field = (Field)help.positionalParametersFields.get(0);
        CommandLine.Help.Ansi.Text[][] row1 = renderer.render(field.getAnnotation(CommandLine.Parameters.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row1.length);
        Assert.assertArrayEquals((String)Arrays.toString(row1[0]), (Object[])CommandLineHelpTest.textArray(help, " ", "", "", "<required>", "required"), (Object[])row1[0]);
    }

    @Test
    public void testDefaultParameterRenderer_rendersSpecifiedMarkerForParametersWithPositiveArity() {
        @CommandLine.Command(requiredOptionMarker=42)
        class Required {
            @CommandLine.Parameters(description={"required"})
            String required;

            Required() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Required());
        CommandLine.Help.IParameterRenderer renderer = help.createDefaultParameterRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = CommandLine.Help.createMinimalParamLabelRenderer();
        Field field = (Field)help.positionalParametersFields.get(0);
        CommandLine.Help.Ansi.Text[][] row1 = renderer.render(field.getAnnotation(CommandLine.Parameters.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row1.length);
        Assert.assertArrayEquals((String)Arrays.toString(row1[0]), (Object[])CommandLineHelpTest.textArray(help, "*", "", "", "<required>", "required"), (Object[])row1[0]);
    }

    @Test
    public void testDefaultParameterRenderer_rendersSpacePrefixForParametersWithZeroArity() {
        @CommandLine.Command(requiredOptionMarker=42)
        class Optional {
            @CommandLine.Parameters(arity="0..1", description={"optional"})
            String optional;

            Optional() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Optional());
        CommandLine.Help.IParameterRenderer renderer = help.createDefaultParameterRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = CommandLine.Help.createMinimalParamLabelRenderer();
        Field field = (Field)help.positionalParametersFields.get(0);
        CommandLine.Help.Ansi.Text[][] row1 = renderer.render(field.getAnnotation(CommandLine.Parameters.class), field, parameterRenderer, help.colorScheme);
        Assert.assertEquals((long)1L, (long)row1.length);
        Assert.assertArrayEquals((String)Arrays.toString(row1[0]), (Object[])CommandLineHelpTest.textArray(help, "", "", "", "<optional>", "optional"), (Object[])row1[0]);
    }

    @Test
    public void testDefaultOptionRenderer_rendersCommaOnlyIfBothShortAndLongOptionNamesExist() {
        class Example {
            @CommandLine.Option(names={"-v"}, description={"shortBool"})
            boolean shortBoolean;
            @CommandLine.Option(names={"--verbose"}, description={"longBool"})
            boolean longBoolean;
            @CommandLine.Option(names={"-x", "--xeno"}, description={"combiBool"})
            boolean combiBoolean;
            @CommandLine.Option(names={"-s"}, description={"shortOnly"})
            String shortOnlyField;
            @CommandLine.Option(names={"--long"}, description={"longOnly"})
            String longOnlyField;
            @CommandLine.Option(names={"-b", "--beta"}, description={"combi"})
            String combiField;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        help.showDefaultValues = false;
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        String[][] expected = new String[][]{{"", "-v", "", "", "shortBool"}, {"", "", "", "--verbose", "longBool"}, {"", "-x", ",", "--xeno", "combiBool"}, {"", "-s", "=", "<shortOnlyField>", "shortOnly"}, {"", "", "", "--long=<longOnlyField>", "longOnly"}, {"", "-b", ",", "--beta=<combiField>", "combi"}};
        int i = -1;
        for (Field field : help.optionFields) {
            CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
            Assert.assertEquals((long)1L, (long)row.length);
            Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, expected[++i]), (Object[])row[0]);
        }
    }

    @Test
    public void testDefaultOptionRenderer_omitsDefaultValuesForBooleanFields() {
        @CommandLine.Command(showDefaultValues=true)
        class Example {
            @CommandLine.Option(names={"-v"}, description={"shortBool"})
            boolean shortBoolean;
            @CommandLine.Option(names={"--verbose"}, description={"longBool"})
            Boolean longBoolean;
            @CommandLine.Option(names={"-s"}, description={"shortOnly"})
            String shortOnlyField = "short";
            @CommandLine.Option(names={"--long"}, description={"longOnly"})
            String longOnlyField = "long";
            @CommandLine.Option(names={"-b", "--beta"}, description={"combi"})
            int combiField = 123;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IOptionRenderer renderer = help.createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer parameterRenderer = help.createDefaultParamLabelRenderer();
        String[][] expected = new String[][]{{"", "-v", "", "", "shortBool"}, {"", "", "", "--verbose", "longBool"}, {"", "-s", "=", "<shortOnlyField>", "shortOnly"}, {"", "", "", "", "Default: short"}, {"", "", "", "--long=<longOnlyField>", "longOnly"}, {"", "", "", "", "Default: long"}, {"", "-b", ",", "--beta=<combiField>", "combi"}, {"", "", "", "", "Default: 123"}};
        int[] rowCount = new int[]{1, 1, 2, 2, 2};
        int i = -1;
        int rowIndex = 0;
        for (Field field : help.optionFields) {
            CommandLine.Help.Ansi.Text[][] row = renderer.render(field.getAnnotation(CommandLine.Option.class), field, parameterRenderer, help.colorScheme);
            Assert.assertEquals((long)rowCount[++i], (long)row.length);
            Assert.assertArrayEquals((String)Arrays.toString(row[0]), (Object[])CommandLineHelpTest.textArray(help, expected[rowIndex]), (Object[])row[0]);
            rowIndex += rowCount[i];
        }
    }

    @Test
    public void testCreateDefaultParameterRenderer_ReturnsDefaultParameterRenderer() {
        Assert.assertEquals(CommandLine.Help.DefaultParamLabelRenderer.class, new CommandLine.Help((Object)new UsageDemo()).createDefaultParamLabelRenderer().getClass());
    }

    @Test
    public void testDefaultParameterRenderer_showsParamLabelIfPresentOrFieldNameOtherwise() {
        class Example {
            @CommandLine.Option(names={"--without"})
            String longField;
            @CommandLine.Option(names={"--with"}, paramLabel="LABEL")
            String otherField;

            Example() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new Example());
        CommandLine.Help.IParamLabelRenderer equalSeparatedParameterRenderer = help.createDefaultParamLabelRenderer();
        help.separator = " ";
        CommandLine.Help.IParamLabelRenderer spaceSeparatedParameterRenderer = help.createDefaultParamLabelRenderer();
        String[] expected = new String[]{"<longField>", "LABEL"};
        int i = -1;
        for (Field field : help.optionFields) {
            CommandLine.Help.Ansi.Text withSpace = spaceSeparatedParameterRenderer.renderParameterLabel(field, help.ansi(), Collections.emptyList());
            Assert.assertEquals((String)withSpace.toString(), (Object)(" " + expected[++i]), (Object)withSpace.toString());
            CommandLine.Help.Ansi.Text withEquals = equalSeparatedParameterRenderer.renderParameterLabel(field, help.ansi(), Collections.emptyList());
            Assert.assertEquals((String)withEquals.toString(), (Object)("=" + expected[i]), (Object)withEquals.toString());
        }
    }

    @Test
    public void testDefaultParameterRenderer_appliesToPositionalArgumentsIgnoresSeparator() {
        class WithLabel {
            @CommandLine.Parameters(paramLabel="POSITIONAL_ARGS")
            String positional;

            WithLabel() {
            }
        }
        CommandLine.Help withLabel = new CommandLine.Help((Object)new WithLabel());
        CommandLine.Help.IParamLabelRenderer equals = withLabel.createDefaultParamLabelRenderer();
        withLabel.separator = "=";
        CommandLine.Help.IParamLabelRenderer spaced = withLabel.createDefaultParamLabelRenderer();
        CommandLine.Help.Ansi.Text withSpace = spaced.renderParameterLabel((Field)withLabel.positionalParametersFields.get(0), withLabel.ansi(), Collections.emptyList());
        Assert.assertEquals((String)withSpace.toString(), (Object)"POSITIONAL_ARGS", (Object)withSpace.toString());
        CommandLine.Help.Ansi.Text withEquals = equals.renderParameterLabel((Field)withLabel.positionalParametersFields.get(0), withLabel.ansi(), Collections.emptyList());
        Assert.assertEquals((String)withEquals.toString(), (Object)"POSITIONAL_ARGS", (Object)withEquals.toString());
        class WithoutLabel {
            @CommandLine.Parameters
            String positional;

            WithoutLabel() {
            }
        }
        CommandLine.Help withoutLabel = new CommandLine.Help((Object)new WithoutLabel());
        withSpace = spaced.renderParameterLabel((Field)withoutLabel.positionalParametersFields.get(0), withoutLabel.ansi(), Collections.emptyList());
        Assert.assertEquals((String)withSpace.toString(), (Object)"<positional>", (Object)withSpace.toString());
        withEquals = equals.renderParameterLabel((Field)withoutLabel.positionalParametersFields.get(0), withoutLabel.ansi(), Collections.emptyList());
        Assert.assertEquals((String)withEquals.toString(), (Object)"<positional>", (Object)withEquals.toString());
    }

    @Test
    public void testDefaultLayout_addsEachRowToTable() {
        final CommandLine.Help.Ansi.Text[][] values = new CommandLine.Help.Ansi.Text[][]{CommandLineHelpTest.textArray(CommandLine.Help.Ansi.OFF, "a", "b", "c", "d"), CommandLineHelpTest.textArray(CommandLine.Help.Ansi.OFF, "1", "2", "3", "4")};
        final int[] count = new int[]{0};
        CommandLine.Help.TextTable tt = new CommandLine.Help.TextTable(CommandLine.Help.Ansi.OFF){

            public void addRowValues(CommandLine.Help.Ansi.Text[] columnValues) {
                Assert.assertArrayEquals((Object[])values[count[0]], (Object[])columnValues);
                count[0] = count[0] + 1;
            }
        };
        CommandLine.Help.Layout layout = new CommandLine.Help.Layout(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF), tt);
        layout.layout(null, (CommandLine.Help.Ansi.Text[][])values);
        Assert.assertEquals((long)2L, (long)count[0]);
    }

    @Test
    public void testAbreviatedSynopsis_withoutParameters() {
        @CommandLine.Command(abbreviateSynopsis=true)
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [OPTIONS]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testAbreviatedSynopsis_withoutParameters_ANSI() {
        @CommandLine.Command(abbreviateSynopsis=true)
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [OPTIONS]" + LINESEP).toString(), (Object)help.synopsis(0));
    }

    @Test
    public void testAbreviatedSynopsis_withParameters() {
        @CommandLine.Command(abbreviateSynopsis=true)
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [OPTIONS] [<files>]..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testAbreviatedSynopsis_withParameters_ANSI() {
        @CommandLine.Command(abbreviateSynopsis=true)
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [OPTIONS] [@|yellow <files>|@]..." + LINESEP).toString(), (Object)help.synopsis(0));
    }

    @Test
    public void testAbreviatedSynopsis_commandNameCustomizableDeclaratively() throws UnsupportedEncodingException {
        String expected = "Usage: aprogram [OPTIONS] [<files>]...%n      [<files>]...%n  -c, --count=<count>%n  -v, --verbose%n";
        @CommandLine.Command(abbreviateSynopsis=true, name="aprogram")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new CommandLine((Object)new App()), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format(expected, new Object[0]), (Object)actual);
    }

    @Test
    public void testAbreviatedSynopsis_commandNameCustomizableProgrammatically() throws UnsupportedEncodingException {
        String expected = "Usage: anotherProgram [OPTIONS] [<files>]...%n      [<files>]...%n  -c, --count=<count>%n  -v, --verbose%n";
        @CommandLine.Command(abbreviateSynopsis=true)
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new CommandLine((Object)new App()).setCommandName("anotherProgram"), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format(expected, new Object[0]), (Object)actual);
    }

    @Test
    public void testSynopsis_commandNameCustomizableDeclaratively() throws UnsupportedEncodingException {
        String expected = "Usage: aprogram [-v] [-c=<count>] [<files>]...%n      [<files>]...%n  -c, --count=<count>%n  -v, --verbose%n";
        @CommandLine.Command(name="aprogram")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new CommandLine((Object)new App()), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format(expected, new Object[0]), (Object)actual);
    }

    @Test
    public void testSynopsis_commandNameCustomizableProgrammatically() throws UnsupportedEncodingException {
        String expected = "Usage: anotherProgram [-v] [-c=<count>] [<files>]...%n      [<files>]...%n  -c, --count=<count>%n  -v, --verbose%n";
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new CommandLine((Object)new App()).setCommandName("anotherProgram"), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format(expected, new Object[0]), (Object)actual);
    }

    @Test
    public void testSynopsis_optionalOptionArity1_n_withDefaultSeparator() {
        @CommandLine.Command
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="1..*")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c=<count>...]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity1_n_withDefaultSeparator_ANSI() {
        @CommandLine.Command
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="1..*")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@=@|italic <count>|@...]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity0_1_withSpaceSeparator() {
        @CommandLine.Command(separator=" ")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="0..1")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c [<count>]]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity0_1_withSpaceSeparator_ANSI() {
        @CommandLine.Command(separator=" ")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="0..1")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@ [@|italic <count>|@]]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_requiredOptionWithSeparator() {
        @CommandLine.Command
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, required=true)
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] -c=<count>" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_requiredOptionWithSeparator_ANSI() {
        @CommandLine.Command
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, required=true)
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] @|yellow -c|@=@|italic <count>|@" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOption_withSpaceSeparator() {
        @CommandLine.Command(separator=" ")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c <count>]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity0_1__withSeparator() {
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="0..1")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c[=<count>]]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity0_n__withSeparator() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="0..*")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c=[<count>]...]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_optionalOptionArity1_n__withSeparator() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"}, arity="1..*")
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c=<count>...]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withProgrammaticallySetSeparator_withParameters() throws UnsupportedEncodingException {
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new App()).setSeparator(":");
        String actual = CommandLineHelpTest.usageString(commandLine, CommandLine.Help.Ansi.OFF);
        String expected = "Usage: <main class> [-v] [-c:<count>] [<files>]...%n      [<files>]...%n  -c, --count:<count>%n  -v, --verbose%n";
        Assert.assertEquals((Object)String.format(expected, new Object[0]), (Object)actual);
    }

    @Test
    public void testSynopsis_withSeparator_withParameters() {
        @CommandLine.Command(separator=":")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c:<count>] [<files>]..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withSeparator_withParameters_ANSI() {
        @CommandLine.Command(separator=":")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@:@|italic <count>|@] [@|yellow <files>|@]..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withSeparator_withLabeledParameters() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE")
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c=<count>] [FILE]..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withSeparator_withLabeledParameters_ANSI() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE")
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@=@|italic <count>|@] [@|yellow FILE|@]..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withSeparator_withLabeledRequiredParameters() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE", arity="1..*")
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-v] [-c=<count>] FILE..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_withSeparator_withLabeledRequiredParameters_ANSI() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE", arity="1..*")
            File[] files;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.ON);
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@=@|italic <count>|@] @|yellow FILE|@..." + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_clustersBooleanOptions() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--aaaa", "-a"})
            boolean aBoolean;
            @CommandLine.Option(names={"--xxxx", "-x"})
            Boolean xBoolean;
            @CommandLine.Option(names={"--count", "-c"}, paramLabel="COUNT")
            int count;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> [-avx] [-c=COUNT]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_clustersRequiredBooleanOptions() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"}, required=true)
            boolean verbose;
            @CommandLine.Option(names={"--aaaa", "-a"}, required=true)
            boolean aBoolean;
            @CommandLine.Option(names={"--xxxx", "-x"}, required=true)
            Boolean xBoolean;
            @CommandLine.Option(names={"--count", "-c"}, paramLabel="COUNT")
            int count;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> -avx [-c=COUNT]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_clustersRequiredBooleanOptionsSeparately() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--aaaa", "-a"})
            boolean aBoolean;
            @CommandLine.Option(names={"--xxxx", "-x"})
            Boolean xBoolean;
            @CommandLine.Option(names={"--Verbose", "-V"}, required=true)
            boolean requiredVerbose;
            @CommandLine.Option(names={"--Aaaa", "-A"}, required=true)
            boolean requiredABoolean;
            @CommandLine.Option(names={"--Xxxx", "-X"}, required=true)
            Boolean requiredXBoolean;
            @CommandLine.Option(names={"--count", "-c"}, paramLabel="COUNT")
            int count;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)("<main class> -AVX [-avx] [-c=COUNT]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_clustersRequiredBooleanOptionsSeparately_ANSI() {
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--aaaa", "-a"})
            boolean aBoolean;
            @CommandLine.Option(names={"--xxxx", "-x"})
            Boolean xBoolean;
            @CommandLine.Option(names={"--Verbose", "-V"}, required=true)
            boolean requiredVerbose;
            @CommandLine.Option(names={"--Aaaa", "-A"}, required=true)
            boolean requiredABoolean;
            @CommandLine.Option(names={"--Xxxx", "-X"}, required=true)
            Boolean requiredXBoolean;
            @CommandLine.Option(names={"--count", "-c"}, paramLabel="COUNT")
            int count;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ @|yellow -AVX|@ [@|yellow -avx|@] [@|yellow -c|@=@|italic COUNT|@]" + LINESEP), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsis_firstLineLengthAdjustedForSynopsisHeading() throws Exception {
        @CommandLine.Command(name="small-test-program", sortOptions=false, separator=" ")
        class App {
            @CommandLine.Option(names={"-a"})
            boolean a;
            @CommandLine.Option(names={"-c"})
            boolean c;
            @CommandLine.Option(names={"-o"})
            boolean o;
            @CommandLine.Option(names={"-r"})
            boolean r;
            @CommandLine.Option(names={"-v"})
            boolean v;
            @CommandLine.Option(names={"-!"})
            boolean exclamation;
            @CommandLine.Option(names={"-?"})
            boolean question;
            @CommandLine.Option(names={"--version"})
            boolean version;
            @CommandLine.Option(names={"--handle", "-h"})
            int number;
            @CommandLine.Option(names={"--ppp", "-p"}, paramLabel="<file>|<folder>")
            File f;
            @CommandLine.Option(names={"--ddd", "-d"}, paramLabel="<folder>", arity="1..2")
            File[] d;
            @CommandLine.Option(names={"--include", "-i"}, paramLabel="<includePattern>")
            String pattern;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        String expected = "Usage: small-test-program [-!?acorv] [--version] [-h <number>] [-i" + LINESEP + "                          <includePattern>] [-p <file>|<folder>] [-d <folder>" + LINESEP + "                          [<folder>]]..." + LINESEP;
        Assert.assertEquals((Object)expected, (Object)(help.synopsisHeading(new Object[0]) + help.synopsis(help.synopsisHeadingLength())));
        help.synopsisHeading = "Usage:%n";
        expected = "Usage:" + LINESEP + "small-test-program [-!?acorv] [--version] [-h <number>] [-i <includePattern>]" + LINESEP + "                   [-p <file>|<folder>] [-d <folder> [<folder>]]..." + LINESEP;
        Assert.assertEquals((Object)expected, (Object)(help.synopsisHeading(new Object[0]) + help.synopsis(help.synopsisHeadingLength())));
    }

    @Test
    public void testLongMultiLineSynopsisIndented() {
        @CommandLine.Command(name="<best-app-ever>")
        class App {
            @CommandLine.Option(names={"--long-option-name"}, paramLabel="<long-option-value>")
            int a;
            @CommandLine.Option(names={"--another-long-option-name"}, paramLabel="<another-long-option-value>")
            int b;
            @CommandLine.Option(names={"--third-long-option-name"}, paramLabel="<third-long-option-value>")
            int c;
            @CommandLine.Option(names={"--fourth-long-option-name"}, paramLabel="<fourth-long-option-value>")
            int d;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("<best-app-ever> [--another-long-option-name=<another-long-option-value>]%n                [--fourth-long-option-name=<fourth-long-option-value>]%n                [--long-option-name=<long-option-value>]%n                [--third-long-option-name=<third-long-option-value>]%n", new Object[0]), (Object)help.synopsis(0));
    }

    @Test
    public void testLongMultiLineSynopsisWithAtMarkIndented() {
        @CommandLine.Command(name="<best-app-ever>")
        class App {
            @CommandLine.Option(names={"--long-option@-name"}, paramLabel="<long-option-valu@@e>")
            int a;
            @CommandLine.Option(names={"--another-long-option-name"}, paramLabel="^[<another-long-option-value>]")
            int b;
            @CommandLine.Option(names={"--third-long-option-name"}, paramLabel="<third-long-option-value>")
            int c;
            @CommandLine.Option(names={"--fourth-long-option-name"}, paramLabel="<fourth-long-option-value>")
            int d;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("<best-app-ever> [--another-long-option-name=^[<another-long-option-value>]]%n                [--fourth-long-option-name=<fourth-long-option-value>]%n                [--long-option@-name=<long-option-valu@@e>]%n                [--third-long-option-name=<third-long-option-value>]%n", new Object[0]), (Object)help.synopsis(0));
    }

    @Test
    public void testLongMultiLineSynopsisWithAtMarkIndented_ANSI() {
        @CommandLine.Command(name="<best-app-ever>")
        class App {
            @CommandLine.Option(names={"--long-option@-name"}, paramLabel="<long-option-valu@@e>")
            int a;
            @CommandLine.Option(names={"--another-long-option-name"}, paramLabel="^[<another-long-option-value>]")
            int b;
            @CommandLine.Option(names={"--third-long-option-name"}, paramLabel="<third-long-option-value>")
            int c;
            @CommandLine.Option(names={"--fourth-long-option-name"}, paramLabel="<fourth-long-option-value>")
            int d;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, String.format("@|bold <best-app-ever>|@ [@|yellow --another-long-option-name|@=@|italic ^[<another-long-option-value>]|@]%n                [@|yellow --fourth-long-option-name|@=@|italic <fourth-long-option-value>|@]%n                [@|yellow --long-option@-name|@=@|italic <long-option-valu@@e>|@]%n                [@|yellow --third-long-option-name|@=@|italic <third-long-option-value>|@]%n", new Object[0])), (Object)help.synopsis(0));
    }

    @Test
    public void testCustomSynopsis() {
        @CommandLine.Command(customSynopsis={"<the-app> --number=NUMBER --other-option=<aargh>", "          --more=OTHER --and-other-option=<aargh>", "<the-app> --number=NUMBER --and-other-option=<aargh>"})
        class App {
            @CommandLine.Option(names={"--ignored"})
            boolean ignored;

            App() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new App(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("<the-app> --number=NUMBER --other-option=<aargh>%n          --more=OTHER --and-other-option=<aargh>%n<the-app> --number=NUMBER --and-other-option=<aargh>%n", new Object[0]), (Object)help.synopsis(0));
    }

    @Test
    public void testTextTable() {
        CommandLine.Help.TextTable table = new CommandLine.Help.TextTable(CommandLine.Help.Ansi.OFF);
        table.addRowValues(CommandLineHelpTest.textArray(CommandLine.Help.Ansi.OFF, "", "-v", ",", "--verbose", "show what you're doing while you are doing it"));
        table.addRowValues(CommandLineHelpTest.textArray(CommandLine.Help.Ansi.OFF, "", "-p", null, null, "the quick brown fox jumped over the lazy dog. The quick brown fox jumped over the lazy dog."));
        Assert.assertEquals((Object)String.format("  -v, --verbose               show what you're doing while you are doing it%n  -p                          the quick brown fox jumped over the lazy dog. The%n                                quick brown fox jumped over the lazy dog.%n", ""), (Object)table.toString(new StringBuilder()).toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTextTableAddsNewRowWhenTooManyValuesSpecified() {
        CommandLine.Help.TextTable table = new CommandLine.Help.TextTable(CommandLine.Help.Ansi.OFF);
        table.addRowValues(CommandLineHelpTest.textArray(CommandLine.Help.Ansi.OFF, "", "-c", ",", "--create", "description", "INVALID", "Row 3"));
    }

    @Test
    public void testTextTableAddsNewRowWhenAnyColumnTooLong() {
        CommandLine.Help.TextTable table = new CommandLine.Help.TextTable(CommandLine.Help.Ansi.OFF);
        table.addRowValues(new String[]{"*", "-c", ",", "--create, --create2, --create3, --create4, --create5, --create6, --create7, --create8", "description"});
        Assert.assertEquals((Object)String.format("* -c, --create, --create2, --create3, --create4, --create5, --create6,%n        --create7, --create8%n                              description%n", ""), (Object)table.toString(new StringBuilder()).toString());
        table = new CommandLine.Help.TextTable(CommandLine.Help.Ansi.OFF);
        table.addRowValues(new String[]{"", "-c", ",", "--create, --create2, --create3, --create4, --create5, --create6, --createAA7, --create8", "description"});
        Assert.assertEquals((Object)String.format("  -c, --create, --create2, --create3, --create4, --create5, --create6,%n        --createAA7, --create8%n                              description%n", ""), (Object)table.toString(new StringBuilder()).toString());
    }

    @Test
    public void testCatUsageFormat() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        @CommandLine.Command(name="cat", customSynopsis={"cat [OPTIONS] [FILE...]"}, description={"Concatenate FILE(s), or standard input, to standard output."}, footer={"Copyright(c) 2017"})
        class Cat {
            @CommandLine.Parameters(paramLabel="FILE", hidden=true, description={"Files whose contents to display"})
            List<File> files;
            @CommandLine.Option(names={"--help"}, help=true, description={"display this help and exit"})
            boolean help;
            @CommandLine.Option(names={"--version"}, help=true, description={"output version information and exit"})
            boolean version;
            @CommandLine.Option(names={"-u"}, description={"(ignored)"})
            boolean u;
            @CommandLine.Option(names={"-t"}, description={"equivalent to -vT"})
            boolean t;
            @CommandLine.Option(names={"-e"}, description={"equivalent to -vET"})
            boolean e;
            @CommandLine.Option(names={"-A", "--show-all"}, description={"equivalent to -vET"})
            boolean showAll;
            @CommandLine.Option(names={"-s", "--squeeze-blank"}, description={"suppress repeated empty output lines"})
            boolean squeeze;
            @CommandLine.Option(names={"-v", "--show-nonprinting"}, description={"use ^ and M- notation, except for LDF and TAB"})
            boolean v;
            @CommandLine.Option(names={"-b", "--number-nonblank"}, description={"number nonempty output lines, overrides -n"})
            boolean b;
            @CommandLine.Option(names={"-T", "--show-tabs"}, description={"display TAB characters as ^I"})
            boolean T;
            @CommandLine.Option(names={"-E", "--show-ends"}, description={"display $ at end of each line"})
            boolean E;
            @CommandLine.Option(names={"-n", "--number"}, description={"number all output lines"})
            boolean n;

            Cat() {
            }
        }
        CommandLine.usage((Object)new Cat(), (PrintStream)new PrintStream(baos), (CommandLine.Help.Ansi)CommandLine.Help.Ansi.OFF);
        String expected = String.format("Usage: cat [OPTIONS] [FILE...]%nConcatenate FILE(s), or standard input, to standard output.%n  -A, --show-all              equivalent to -vET%n  -b, --number-nonblank       number nonempty output lines, overrides -n%n  -e                          equivalent to -vET%n  -E, --show-ends             display $ at end of each line%n  -n, --number                number all output lines%n  -s, --squeeze-blank         suppress repeated empty output lines%n  -t                          equivalent to -vT%n  -T, --show-tabs             display TAB characters as ^I%n  -u                          (ignored)%n  -v, --show-nonprinting      use ^ and M- notation, except for LDF and TAB%n      --help                  display this help and exit%n      --version               output version information and exit%nCopyright(c) 2017%n", "");
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void testZipUsageFormat() {
        String expected = String.format("Copyright (c) 1990-2008 Info-ZIP - Type 'zip \"-L\"' for software license.%nZip 3.0 (July 5th 2008). Command:%nzip [-options] [-b path] [-t mmddyyyy] [-n suffixes] [zipfile list] [-xi list]%n  The default action is to add or replace zipfile entries from list, which%n  can include the special name - to compress standard input.%n  If zipfile and list are omitted, zip compresses stdin to stdout.%n  -f   freshen: only changed files  -u   update: only changed or new files%n  -d   delete entries in zipfile    -m   move into zipfile (delete OS files)%n  -r   recurse into directories     -j   junk (don't record) directory names%n  -0   store only                   -l   convert LF to CR LF (-ll CR LF to LF)%n  -1   compress faster              -9   compress better%n  -q   quiet operation              -v   verbose operation/print version info%n  -c   add one-line comments        -z   add zipfile comment%n  -@   read names from stdin        -o   make zipfile as old as latest entry%n  -x   exclude the following names  -i   include only the following names%n  -F   fix zipfile (-FF try harder) -D   do not add directory entries%n  -A   adjust self-extracting exe   -J   junk zipfile prefix (unzipsfx)%n  -T   test zipfile integrity       -X   eXclude eXtra file attributes%n  -y   store symbolic links as the link instead of the referenced file%n  -e   encrypt                      -n   don't compress these suffixes%n  -h2  show more help%n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)CustomLayoutDemo.createZipUsageFormat(CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testNetstatUsageFormat() {
        String expected = String.format("Displays protocol statistics and current TCP/IP network connections.%n%nNETSTAT [-a] [-b] [-e] [-f] [-n] [-o] [-p proto] [-q] [-r] [-s] [-t] [-x] [-y]%n        [interval]%n%n  -a            Displays all connections and listening ports.%n  -b            Displays the executable involved in creating each connection or%n                listening port. In some cases well-known executables host%n                multiple independent components, and in these cases the%n                sequence of components involved in creating the connection or%n                listening port is displayed. In this case the executable name%n                is in [] at the bottom, on top is the component it called, and%n                so forth until TCP/IP was reached. Note that this option can be%n                time-consuming and will fail unless you have sufficient%n                permissions.%n  -e            Displays Ethernet statistics. This may be combined with the -s%n                option.%n  -f            Displays Fully Qualified Domain Names (FQDN) for foreign%n                addresses.%n  -n            Displays addresses and port numbers in numerical form.%n  -o            Displays the owning process ID associated with each connection.%n  -p proto      Shows connections for the protocol specified by proto; proto%n                may be any of: TCP, UDP, TCPv6, or UDPv6.  If used with the -s%n                option to display per-protocol statistics, proto may be any of:%n                IP, IPv6, ICMP, ICMPv6, TCP, TCPv6, UDP, or UDPv6.%n  -q            Displays all connections, listening ports, and bound%n                nonlistening TCP ports. Bound nonlistening ports may or may not%n                be associated with an active connection.%n  -r            Displays the routing table.%n  -s            Displays per-protocol statistics.  By default, statistics are%n                shown for IP, IPv6, ICMP, ICMPv6, TCP, TCPv6, UDP, and UDPv6;%n                the -p option may be used to specify a subset of the default.%n  -t            Displays the current connection offload state.%n  -x            Displays NetworkDirect connections, listeners, and shared%n                endpoints.%n  -y            Displays the TCP connection template for all connections.%n                Cannot be combined with the other options.%n  interval      Redisplays selected statistics, pausing interval seconds%n                between each display.  Press CTRL+C to stop redisplaying%n                statistics.  If omitted, netstat will print the current%n                configuration information once.%n", "");
        Assert.assertEquals((Object)expected, (Object)CustomLayoutDemo.createNetstatUsageFormat(CommandLine.Help.Ansi.OFF));
    }

    @Test
    public void testUsageIndexedPositionalParameters() throws UnsupportedEncodingException {
        @CommandLine.Command
        class App {
            @CommandLine.Parameters(index="0", description={"source host"})
            InetAddress host1;
            @CommandLine.Parameters(index="1", description={"source port"})
            int port1;
            @CommandLine.Parameters(index="2", description={"destination host"})
            InetAddress host2;
            @CommandLine.Parameters(index="3", arity="1..2", description={"destination port range"})
            int[] port2range;
            @CommandLine.Parameters(index="4..*", description={"files to transfer"})
            String[] files;
            @CommandLine.Parameters(hidden=true)
            String[] all;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new App(), CommandLine.Help.Ansi.OFF);
        String expected = String.format("Usage: <main class> <host1> <port1> <host2> <port2range> [<port2range>]%n                    [<files>]...%n      <host1>                 source host%n      <port1>                 source port%n      <host2>                 destination host%n      <port2range> [<port2range>]%n                              destination port range%n      [<files>]...            files to transfer%n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAttributesInheritedWhenSubclassingForReuse() throws UnsupportedEncodingException {
        @CommandLine.Command
        class EmptySub
        extends Base {
            EmptySub() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new EmptySub());
        Assert.assertEquals((Object)"base", (Object)help.commandName);
        Assert.assertEquals((Object)String.format("cust%n", new Object[0]), (Object)help.synopsis(0));
        Assert.assertEquals((Object)String.format("cust%n", new Object[0]), (Object)help.customSynopsis(new Object[0]));
        Assert.assertEquals((Object)String.format("base%n", new Object[0]), (Object)help.abbreviatedSynopsis());
        Assert.assertEquals((Object)String.format("base%n", new Object[0]), (Object)help.detailedSynopsis(0, null, true));
        Assert.assertEquals((Object)"abcd", (Object)help.synopsisHeading);
        Assert.assertEquals((Object)"", (Object)help.commandList());
        Assert.assertEquals((Object)"c o m m a n d s", (Object)help.commandListHeading);
        Assert.assertEquals((Object)String.format("base description%n", new Object[0]), (Object)help.description(new Object[0]));
        Assert.assertEquals((Object)"base descr heading", (Object)help.descriptionHeading);
        Assert.assertEquals((Object)String.format("base footer%n", new Object[0]), (Object)help.footer(new Object[0]));
        Assert.assertEquals((Object)"base footer heading", (Object)help.footerHeading);
        Assert.assertEquals((Object)String.format("base header%n", new Object[0]), (Object)help.header(new Object[0]));
        Assert.assertEquals((Object)"base header heading", (Object)help.headerHeading);
        Assert.assertEquals((Object)"", (Object)help.optionList());
        Assert.assertEquals((Object)"base option heading", (Object)help.optionListHeading);
        Assert.assertEquals((Object)"", (Object)help.parameterList());
        Assert.assertEquals((Object)"base param heading", (Object)help.parameterListHeading);
        Assert.assertEquals((Object)"=", (Object)help.separator);
        Assert.assertEquals((long)32L, (long)help.requiredOptionMarker.charValue());
        Assert.assertFalse((boolean)help.abbreviateSynopsis);
        Assert.assertFalse((boolean)help.showDefaultValues);
        Assert.assertTrue((boolean)help.sortOptions);
    }

    @Test
    public void testSubclassAttributesOverrideEmptySuper() {
        @CommandLine.Command(name="base", abbreviateSynopsis=true, commandListHeading="c o m m a n d s", customSynopsis={"cust"}, description={"base description"}, descriptionHeading="base descr heading", footer={"base footer"}, footerHeading="base footer heading", header={"base header"}, headerHeading="base header heading", optionListHeading="base option heading", parameterListHeading="base param heading", requiredOptionMarker=38, separator=";", showDefaultValues=true, sortOptions=false, synopsisHeading="abcd")
        class FullBase
        extends 1EmptyBase {
            FullBase() {
                @CommandLine.Command
                class EmptyBase {
                    EmptyBase() {
                    }
                }
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new FullBase());
        Assert.assertEquals((Object)"base", (Object)help.commandName);
        Assert.assertEquals((Object)String.format("cust%n", new Object[0]), (Object)help.synopsis(0));
        Assert.assertEquals((Object)String.format("cust%n", new Object[0]), (Object)help.customSynopsis(new Object[0]));
        Assert.assertEquals((Object)String.format("base%n", new Object[0]), (Object)help.abbreviatedSynopsis());
        Assert.assertEquals((Object)String.format("base%n", new Object[0]), (Object)help.detailedSynopsis(0, null, true));
        Assert.assertEquals((Object)"abcd", (Object)help.synopsisHeading);
        Assert.assertEquals((Object)"", (Object)help.commandList());
        Assert.assertEquals((Object)"c o m m a n d s", (Object)help.commandListHeading);
        Assert.assertEquals((Object)String.format("base description%n", new Object[0]), (Object)help.description(new Object[0]));
        Assert.assertEquals((Object)"base descr heading", (Object)help.descriptionHeading);
        Assert.assertEquals((Object)String.format("base footer%n", new Object[0]), (Object)help.footer(new Object[0]));
        Assert.assertEquals((Object)"base footer heading", (Object)help.footerHeading);
        Assert.assertEquals((Object)String.format("base header%n", new Object[0]), (Object)help.header(new Object[0]));
        Assert.assertEquals((Object)"base header heading", (Object)help.headerHeading);
        Assert.assertEquals((Object)"", (Object)help.optionList());
        Assert.assertEquals((Object)"base option heading", (Object)help.optionListHeading);
        Assert.assertEquals((Object)"", (Object)help.parameterList());
        Assert.assertEquals((Object)"base param heading", (Object)help.parameterListHeading);
        Assert.assertTrue((boolean)help.abbreviateSynopsis);
        Assert.assertTrue((boolean)help.showDefaultValues);
        Assert.assertFalse((boolean)help.sortOptions);
        Assert.assertEquals((Object)";", (Object)help.separator);
        Assert.assertEquals((long)38L, (long)help.requiredOptionMarker.charValue());
    }

    @Test
    public void testSubclassAttributesOverrideSuperValues() {
        @CommandLine.Command(name="sub", abbreviateSynopsis=false, commandListHeading="subc o m m a n d s", customSynopsis={"subcust"}, description={"sub description"}, descriptionHeading="sub descr heading", footer={"sub footer"}, footerHeading="sub footer heading", header={"sub header"}, headerHeading="sub header heading", optionListHeading="sub option heading", parameterListHeading="sub param heading", requiredOptionMarker=37, separator=":", showDefaultValues=false, sortOptions=true, synopsisHeading="xyz")
        class FullSub
        extends Base {
            FullSub() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new FullSub());
        Assert.assertEquals((Object)"sub", (Object)help.commandName);
        Assert.assertEquals((Object)String.format("subcust%n", new Object[0]), (Object)help.synopsis(0));
        Assert.assertEquals((Object)String.format("subcust%n", new Object[0]), (Object)help.customSynopsis(new Object[0]));
        Assert.assertEquals((Object)String.format("sub%n", new Object[0]), (Object)help.abbreviatedSynopsis());
        Assert.assertEquals((Object)String.format("sub%n", new Object[0]), (Object)help.detailedSynopsis(0, null, true));
        Assert.assertEquals((Object)"xyz", (Object)help.synopsisHeading);
        Assert.assertEquals((Object)"", (Object)help.commandList());
        Assert.assertEquals((Object)"subc o m m a n d s", (Object)help.commandListHeading);
        Assert.assertEquals((Object)String.format("sub description%n", new Object[0]), (Object)help.description(new Object[0]));
        Assert.assertEquals((Object)"sub descr heading", (Object)help.descriptionHeading);
        Assert.assertEquals((Object)String.format("sub footer%n", new Object[0]), (Object)help.footer(new Object[0]));
        Assert.assertEquals((Object)"sub footer heading", (Object)help.footerHeading);
        Assert.assertEquals((Object)String.format("sub header%n", new Object[0]), (Object)help.header(new Object[0]));
        Assert.assertEquals((Object)"sub header heading", (Object)help.headerHeading);
        Assert.assertEquals((Object)"", (Object)help.optionList());
        Assert.assertEquals((Object)"sub option heading", (Object)help.optionListHeading);
        Assert.assertEquals((Object)"", (Object)help.parameterList());
        Assert.assertEquals((Object)"sub param heading", (Object)help.parameterListHeading);
        Assert.assertFalse((boolean)help.abbreviateSynopsis);
        Assert.assertFalse((boolean)help.showDefaultValues);
        Assert.assertTrue((boolean)help.sortOptions);
        Assert.assertEquals((Object)":", (Object)help.separator);
        Assert.assertEquals((long)37L, (long)help.requiredOptionMarker.charValue());
    }

    @Test
    public void testSubclassedCommandHelp() throws Exception {
        @CommandLine.Command(name="child", description={"child description"})
        class ChildOption
        extends 1ParentOption {
            ChildOption() {
                @CommandLine.Command(name="parent", description={"parent description"})
                class ParentOption {
                    ParentOption() {
                    }
                }
            }
        }
        String actual = CommandLineHelpTest.usageString(new ChildOption(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: child%nchild description%n", new Object[0]), (Object)actual);
    }

    @Test
    public void testSynopsisOrderCorrectWhenParametersDeclaredOutOfOrder() {
        class WithParams {
            @CommandLine.Parameters(index="1")
            String param1;
            @CommandLine.Parameters(index="0")
            String param0;

            WithParams() {
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new WithParams());
        Assert.assertEquals((Object)String.format("<main class> <param0> <param1>%n", new Object[0]), (Object)help.synopsis(0));
    }

    @Test
    public void testSynopsisOrderCorrectWhenSubClassAddsParameters() {
        class SubWithParams
        extends 1BaseWithParams {
            @CommandLine.Parameters(index="3")
            String param3;
            @CommandLine.Parameters(index="2")
            String param2;

            SubWithParams() {
                class BaseWithParams {
                    @CommandLine.Parameters(index="1")
                    String param1;
                    @CommandLine.Parameters(index="0")
                    String param0;

                    BaseWithParams() {
                    }
                }
            }
        }
        CommandLine.Help help = new CommandLine.Help((Object)new SubWithParams());
        Assert.assertEquals((Object)String.format("<main class> <param0> <param1> <param2> <param3>%n", new Object[0]), (Object)help.synopsis(0));
    }

    @Test
    public void testUsageMainCommand_NoAnsi() throws Exception {
        String actual = CommandLineHelpTest.usageString(Demo.mainCommand(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: git [-hV] [--git-dir=<gitDir>]%nGit is a fast, scalable, distributed revision control system with an unusually%nrich command set that provides both high-level operations and full access to%ninternals.%n  -V, --version               Prints version information and exits%n  -h, --help                  Prints this help message and exits%n      --git-dir=<gitDir>      Set the path to the repository%n%nCommands:%n%nThe most commonly used git commands are:%n  status    Show the working tree status.%n  commit    Record changes to the repository.%n  add       Add file contents to the index.%n  branch    List, create, or delete branches.%n  checkout  Checkout a branch or paths to the working tree.%n  clone     Clone a repository into a new directory.%n  diff      Show changes between commits, commit and working tree, etc.%n  merge     Join two or more development histories together.%n  push      Update remote refs along with associated objects.%n  rebase    Forward-port local commits to the updated upstream head.%n  tag       Create, list, delete or verify a tag object signed with GPG.%n", new Object[0]), (Object)actual);
    }

    @Test
    public void testUsageMainCommand_ANSI() throws Exception {
        String actual = CommandLineHelpTest.usageString(Demo.mainCommand(), CommandLine.Help.Ansi.ON);
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, String.format("Usage: @|bold git|@ [@|yellow -hV|@] [@|yellow --git-dir|@=@|italic <gitDir>|@]%nGit is a fast, scalable, distributed revision control system with an unusually%nrich command set that provides both high-level operations and full access to%ninternals.%n  @|yellow -V|@, @|yellow --version|@               Prints version information and exits%n  @|yellow -h|@, @|yellow --help|@                  Prints this help message and exits%n      @|yellow --git-dir|@=@|italic <gitDir>|@      Set the path to the repository%n%nCommands:%n%nThe most commonly used git commands are:%n  @|bold status|@    Show the working tree status.%n  @|bold commit|@    Record changes to the repository.%n  @|bold add|@       Add file contents to the index.%n  @|bold branch|@    List, create, or delete branches.%n  @|bold checkout|@  Checkout a branch or paths to the working tree.%n  @|bold clone|@     Clone a repository into a new directory.%n  @|bold diff|@      Show changes between commits, commit and working tree, etc.%n  @|bold merge|@     Join two or more development histories together.%n  @|bold push|@      Update remote refs along with associated objects.%n  @|bold rebase|@    Forward-port local commits to the updated upstream head.%n  @|bold tag|@       Create, list, delete or verify a tag object signed with GPG.%n", new Object[0])), (Object)actual);
    }

    @Test
    public void testUsageSubcommandGitStatus_NoAnsi() throws Exception {
        String actual = CommandLineHelpTest.usageString(new Demo.GitStatus(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Show the working tree status.%nUsage: git-status [<options>...] [--] [<pathspec>...]%nDisplays paths that have differences between the index file and the current%nHEAD commit, paths that have differences between the working tree and the index%nfile, and paths in the working tree that are not tracked by Git (and are not%nignored by gitignore(5)). The first are what you would commit by running git%ncommit; the second and third are what you could commit by running git add%nbefore running git commit.%n      --ignored               Show ignored files as well%n  -b, --branch                Show the branch and tracking info even in%n                                short-format%n  -s, --short                 Give the output in the short-format%n  -u, --untracked=<mode>      Show untracked files.%n                              The mode parameter is optional (defaults to%n                                `all`), and is used to specify the handling of%n                                untracked files.%n                              The possible options are:%n                               * no - Show no untracked files.%n                               * normal - Shows untracked files and directories.%n                               * all - Also shows individual files in untracked%n                                directories.%n                                Default: all%n", new Object[0]), (Object)actual);
    }

    @Test
    public void testUsageSubcommandGitStatus_ANSI() throws Exception {
        String actual = CommandLineHelpTest.usageString(new Demo.GitStatus(), CommandLine.Help.Ansi.ON);
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, String.format("Show the working tree status.%nUsage: @|bold git-status|@ [@|yellow <options>|@...] [--] [@|yellow <pathspec>|@...]%nDisplays paths that have differences between the index file and the current%nHEAD commit, paths that have differences between the working tree and the index%nfile, and paths in the working tree that are not tracked by Git (and are not%nignored by gitignore(5)). The first are what you would commit by running git%ncommit; the second and third are what you could commit by running git add%nbefore running git commit.%n      @|yellow --ignored|@               Show ignored files as well%n  @|yellow -b|@, @|yellow --branch|@                Show the branch and tracking info even in%n                                short-format%n  @|yellow -s|@, @|yellow --short|@                 Give the output in the short-format%n  @|yellow -u|@, @|yellow --untracked|@=@|italic <mode>|@      Show untracked files.%n                              The mode parameter is optional (defaults to%n                                `all`), and is used to specify the handling of%n                                untracked files.%n                              The possible options are:%n                               * @|yellow no|@ - Show no untracked files.%n                               * @|yellow normal|@ - Shows untracked files and directories.%n                               * @|yellow all|@ - Also shows individual files in untracked%n                                directories.%n                                Default: all%n", new Object[0])), (Object)actual);
    }

    @Test
    public void testUsageSubcommandGitCommit_NoAnsi() throws Exception {
        String actual = CommandLineHelpTest.usageString(new Demo.GitCommit(), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage:%n%nRecord changes to the repository.%n%ngit-commit [-ap] [--fixup=<commit>] [--squash=<commit>] [-c=<commit>]%n           [-C=<commit>] [-F=<file>] [-m=<msg>]... [<files>]...%n%nDescription:%n%nStores the current contents of the index in a new commit along with a log%nmessage from the user describing the changes.%n%nParameters:%n      [<files>]...            the files to commit%n%nOptions:%n  -a, --all                   Tell the command to automatically stage files%n                                that have been modified and deleted, but new%n                                files you have not told Git about are not%n                                affected.%n  -p, --patch                 Use the interactive patch selection interface to%n                                chose which changes to commit%n  -C, --reuse-message=<commit>%n                              Take an existing commit object, and reuse the log%n                                message and the authorship information%n                                (including the timestamp) when creating the%n                                commit.%n  -c, --reedit-message=<commit>%n                              Like -C, but with -c the editor is invoked, so%n                                that the user canfurther edit the commit%n                                message.%n      --fixup=<commit>        Construct a commit message for use with rebase%n                                --autosquash.%n      --squash=<commit>       Construct a commit message for use with rebase%n                                --autosquash. The commitmessage subject line is%n                                taken from the specified commit with a prefix%n                                of \"squash! \". Can be used with additional%n                                commit message options (-m/-c/-C/-F).%n  -F, --file=<file>           Take the commit message from the given file. Use%n                                - to read the message from the standard input.%n  -m, --message=<msg>         Use the given <msg> as the commit message. If%n                                multiple -m options are given, their values are%n                                concatenated as separate paragraphs.%n", new Object[0]), (Object)actual);
    }

    @Test
    public void testUsageSubcommandGitCommit_ANSI() throws Exception {
        String actual = CommandLineHelpTest.usageString(new Demo.GitCommit(), CommandLine.Help.Ansi.ON);
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, String.format("@|bold,underline Usage:|@%n%nRecord changes to the repository.%n%n@|bold git-commit|@ [@|yellow -ap|@] [@|yellow --fixup|@=@|italic <commit>|@] [@|yellow --squash|@=@|italic <commit>|@] [@|yellow -c|@=@|italic <commit>|@]%n           [@|yellow -C|@=@|italic <commit>|@] [@|yellow -F|@=@|italic <file>|@] [@|yellow -m|@=@|italic <msg>|@]... [@|yellow <files>|@]...%n%n@|bold,underline Description:|@%n%nStores the current contents of the index in a new commit along with a log%nmessage from the user describing the changes.%n%n@|bold,underline Parameters:|@%n      [@|yellow <files>|@]...            the files to commit%n%n@|bold,underline Options:|@%n  @|yellow -a|@, @|yellow --all|@                   Tell the command to automatically stage files%n                                that have been modified and deleted, but new%n                                files you have not told Git about are not%n                                affected.%n  @|yellow -p|@, @|yellow --patch|@                 Use the interactive patch selection interface to%n                                chose which changes to commit%n  @|yellow -C|@, @|yellow --reuse-message|@=@|italic <commit|@@|italic >|@%n                              Take an existing commit object, and reuse the log%n                                message and the authorship information%n                                (including the timestamp) when creating the%n                                commit.%n  @|yellow -c|@, @|yellow --reedit-message|@=@|italic <commi|@@|italic t>|@%n                              Like -C, but with -c the editor is invoked, so%n                                that the user canfurther edit the commit%n                                message.%n      @|yellow --fixup|@=@|italic <commit>|@        Construct a commit message for use with rebase%n                                --autosquash.%n      @|yellow --squash|@=@|italic <commit>|@       Construct a commit message for use with rebase%n                                --autosquash. The commitmessage subject line is%n                                taken from the specified commit with a prefix%n                                of \"squash! \". Can be used with additional%n                                commit message options (-m/-c/-C/-F).%n  @|yellow -F|@, @|yellow --file|@=@|italic <file>|@           Take the commit message from the given file. Use%n                                - to read the message from the standard input.%n  @|yellow -m|@, @|yellow --message|@=@|italic <msg>|@         Use the given <msg> as the commit message. If%n                                multiple -m options are given, their values are%n                                concatenated as separate paragraphs.%n", new Object[0])), (Object)actual);
    }

    @Test
    public void testUsageNestedSubcommand() throws IOException {
        @CommandLine.Command(name="main")
        class MainCommand {
            @CommandLine.Option(names={"-a"})
            boolean a;
            @CommandLine.Option(names={"-h"}, help=true)
            boolean h;

            MainCommand() {
            }
        }
        CommandLine commandLine = new CommandLine((Object)new MainCommand());
        @CommandLine.Command(name="cmd1")
        class ChildCommand1 {
            @CommandLine.Option(names={"-b"})
            boolean b;

            ChildCommand1() {
            }
        }
        @CommandLine.Command(name="sub11")
        class GrandChild1Command1 {
            @CommandLine.Option(names={"-d"})
            boolean d;

            GrandChild1Command1() {
            }
        }
        @CommandLine.Command(name="sub12")
        class GrandChild1Command2 {
            @CommandLine.Option(names={"-e"})
            int e;

            GrandChild1Command2() {
            }
        }
        @CommandLine.Command(name="cmd2")
        class ChildCommand2 {
            @CommandLine.Option(names={"-c"})
            boolean c;
            @CommandLine.Option(names={"-h"}, help=true)
            boolean h;

            ChildCommand2() {
            }
        }
        @CommandLine.Command(name="sub21")
        class GrandChild2Command1 {
            @CommandLine.Option(names={"-h"}, help=true)
            boolean h;

            GrandChild2Command1() {
            }
        }
        @CommandLine.Command(name="sub22")
        class GrandChild2Command2 {
            @CommandLine.Option(names={"-g"})
            boolean g;

            GrandChild2Command2() {
            }
        }
        @CommandLine.Command(name="sub22sub1")
        class GreatGrandChild2Command2_1 {
            @CommandLine.Option(names={"-h"}, help=true)
            boolean h;
            @CommandLine.Option(names={"-t", "--type"})
            String customType;

            GreatGrandChild2Command2_1() {
            }
        }
        commandLine.addSubcommand("cmd1", (Object)new CommandLine((Object)new ChildCommand1()).addSubcommand("sub11", (Object)new GrandChild1Command1()).addSubcommand("sub12", (Object)new GrandChild1Command2())).addSubcommand("cmd2", (Object)new CommandLine((Object)new ChildCommand2()).addSubcommand("sub21", (Object)new GrandChild2Command1()).addSubcommand("sub22", (Object)new CommandLine((Object)new GrandChild2Command2()).addSubcommand("sub22sub1", (Object)new GreatGrandChild2Command2_1())));
        String main = CommandLineHelpTest.usageString(commandLine, CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: main [-ah]%n  -a%n  -h%nCommands:%n  cmd1%n  cmd2%n", new Object[0]), (Object)main);
        String cmd2 = CommandLineHelpTest.usageString((CommandLine)commandLine.getSubcommands().get("cmd2"), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: cmd2 [-ch]%n  -c%n  -h%nCommands:%n  sub21%n  sub22%n", new Object[0]), (Object)cmd2);
        String sub22 = CommandLineHelpTest.usageString((CommandLine)((CommandLine)commandLine.getSubcommands().get("cmd2")).getSubcommands().get("sub22"), CommandLine.Help.Ansi.OFF);
        Assert.assertEquals((Object)String.format("Usage: sub22 [-g]%n  -g%nCommands:%n  sub22sub1%n", new Object[0]), (Object)sub22);
    }

    @Test
    public void testTextConstructorPlain() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"--NoAnsiFormat", (Object)new CommandLine.Help.Ansi.Text(ansi, "--NoAnsiFormat").toString());
    }

    @Test
    public void testTextConstructorWithStyle() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[1m--NoAnsiFormat\u001b[21m\u001b[0m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold --NoAnsiFormat|@").toString());
    }

    @Ignore(value="Until nested styles are supported")
    @Test
    public void testTextConstructorWithNestedStyle() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[1mfirst \u001b[2msecond\u001b[22m\u001b[21m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold first @|underline second|@|@").toString());
        CommandLine.Help.Ansi ansi2 = CommandLine.Help.Ansi.ON;
        ansi2.getClass();
        Assert.assertEquals((Object)"\u001b[1mfirst \u001b[4msecond\u001b[24m third\u001b[21m", (Object)new CommandLine.Help.Ansi.Text(ansi2, "@|bold first @|underline second|@ third|@").toString());
    }

    @Test
    public void testTextApply() {
        CommandLine.Help.Ansi.Text txt = CommandLine.Help.Ansi.ON.apply("--p", Arrays.asList(CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold));
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi, "@|fg(red),bold --p|@"), (Object)txt);
    }

    @Test
    public void testTextDefaultColorScheme() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        CommandLine.Help.ColorScheme scheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)ansi);
        CommandLine.Help.Ansi ansi2 = scheme.ansi();
        ansi2.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi2, "@|yellow -p|@"), (Object)scheme.optionText("-p"));
        CommandLine.Help.Ansi ansi3 = scheme.ansi();
        ansi3.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi3, "@|bold command|@"), (Object)scheme.commandText("command"));
        CommandLine.Help.Ansi ansi4 = scheme.ansi();
        ansi4.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi4, "@|yellow FILE|@"), (Object)scheme.parameterText("FILE"));
        CommandLine.Help.Ansi ansi5 = scheme.ansi();
        ansi5.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi5, "@|italic NUMBER|@"), (Object)scheme.optionParamText("NUMBER"));
    }

    @Test
    public void testTextSubString() {
        CommandLine.Help.Ansi ansi;
        CommandLine.Help.Ansi ansi2 = ansi = CommandLine.Help.Ansi.ON;
        ansi2.getClass();
        CommandLine.Help.Ansi.Text txt = new CommandLine.Help.Ansi.Text(ansi2, "@|bold 01234|@").append("56").append("@|underline 7890|@");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi3, "@|bold 01234|@56@|underline 7890|@"), (Object)txt.substring(0));
        CommandLine.Help.Ansi ansi4 = ansi;
        ansi4.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi4, "@|bold 1234|@56@|underline 7890|@"), (Object)txt.substring(1));
        CommandLine.Help.Ansi ansi5 = ansi;
        ansi5.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi5, "@|bold 234|@56@|underline 7890|@"), (Object)txt.substring(2));
        CommandLine.Help.Ansi ansi6 = ansi;
        ansi6.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi6, "@|bold 34|@56@|underline 7890|@"), (Object)txt.substring(3));
        CommandLine.Help.Ansi ansi7 = ansi;
        ansi7.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi7, "@|bold 4|@56@|underline 7890|@"), (Object)txt.substring(4));
        CommandLine.Help.Ansi ansi8 = ansi;
        ansi8.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi8, "56@|underline 7890|@"), (Object)txt.substring(5));
        CommandLine.Help.Ansi ansi9 = ansi;
        ansi9.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi9, "6@|underline 7890|@"), (Object)txt.substring(6));
        CommandLine.Help.Ansi ansi10 = ansi;
        ansi10.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi10, "@|underline 7890|@"), (Object)txt.substring(7));
        CommandLine.Help.Ansi ansi11 = ansi;
        ansi11.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi11, "@|underline 890|@"), (Object)txt.substring(8));
        CommandLine.Help.Ansi ansi12 = ansi;
        ansi12.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi12, "@|underline 90|@"), (Object)txt.substring(9));
        CommandLine.Help.Ansi ansi13 = ansi;
        ansi13.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi13, "@|underline 0|@"), (Object)txt.substring(10));
        CommandLine.Help.Ansi ansi14 = ansi;
        ansi14.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi14, ""), (Object)txt.substring(11));
        CommandLine.Help.Ansi ansi15 = ansi;
        ansi15.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi15, "@|bold 01234|@56@|underline 7890|@"), (Object)txt.substring(0, 11));
        CommandLine.Help.Ansi ansi16 = ansi;
        ansi16.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi16, "@|bold 01234|@56@|underline 789|@"), (Object)txt.substring(0, 10));
        CommandLine.Help.Ansi ansi17 = ansi;
        ansi17.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi17, "@|bold 01234|@56@|underline 78|@"), (Object)txt.substring(0, 9));
        CommandLine.Help.Ansi ansi18 = ansi;
        ansi18.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi18, "@|bold 01234|@56@|underline 7|@"), (Object)txt.substring(0, 8));
        CommandLine.Help.Ansi ansi19 = ansi;
        ansi19.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi19, "@|bold 01234|@56"), (Object)txt.substring(0, 7));
        CommandLine.Help.Ansi ansi20 = ansi;
        ansi20.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi20, "@|bold 01234|@5"), (Object)txt.substring(0, 6));
        CommandLine.Help.Ansi ansi21 = ansi;
        ansi21.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi21, "@|bold 01234|@"), (Object)txt.substring(0, 5));
        CommandLine.Help.Ansi ansi22 = ansi;
        ansi22.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi22, "@|bold 0123|@"), (Object)txt.substring(0, 4));
        CommandLine.Help.Ansi ansi23 = ansi;
        ansi23.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi23, "@|bold 012|@"), (Object)txt.substring(0, 3));
        CommandLine.Help.Ansi ansi24 = ansi;
        ansi24.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi24, "@|bold 01|@"), (Object)txt.substring(0, 2));
        CommandLine.Help.Ansi ansi25 = ansi;
        ansi25.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi25, "@|bold 0|@"), (Object)txt.substring(0, 1));
        CommandLine.Help.Ansi ansi26 = ansi;
        ansi26.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi26, ""), (Object)txt.substring(0, 0));
        CommandLine.Help.Ansi ansi27 = ansi;
        ansi27.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi27, "@|bold 1234|@56@|underline 789|@"), (Object)txt.substring(1, 10));
        CommandLine.Help.Ansi ansi28 = ansi;
        ansi28.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi28, "@|bold 234|@56@|underline 78|@"), (Object)txt.substring(2, 9));
        CommandLine.Help.Ansi ansi29 = ansi;
        ansi29.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi29, "@|bold 34|@56@|underline 7|@"), (Object)txt.substring(3, 8));
        CommandLine.Help.Ansi ansi30 = ansi;
        ansi30.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi30, "@|bold 4|@56"), (Object)txt.substring(4, 7));
        CommandLine.Help.Ansi ansi31 = ansi;
        ansi31.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi31, "5"), (Object)txt.substring(5, 6));
        CommandLine.Help.Ansi ansi32 = ansi;
        ansi32.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi32, "@|bold 2|@"), (Object)txt.substring(2, 3));
        CommandLine.Help.Ansi ansi33 = ansi;
        ansi33.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi33, "@|underline 8|@"), (Object)txt.substring(8, 9));
        CommandLine.Help.Ansi ansi34 = ansi;
        ansi34.getClass();
        CommandLine.Help.Ansi.Text txt2 = new CommandLine.Help.Ansi.Text(ansi34, "@|bold abc|@@|underline DEF|@");
        CommandLine.Help.Ansi ansi35 = ansi;
        ansi35.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi35, "@|bold abc|@@|underline DEF|@"), (Object)txt2.substring(0));
        CommandLine.Help.Ansi ansi36 = ansi;
        ansi36.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi36, "@|bold bc|@@|underline DEF|@"), (Object)txt2.substring(1));
        CommandLine.Help.Ansi ansi37 = ansi;
        ansi37.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi37, "@|bold abc|@@|underline DE|@"), (Object)txt2.substring(0, 5));
        CommandLine.Help.Ansi ansi38 = ansi;
        ansi38.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi38, "@|bold bc|@@|underline DE|@"), (Object)txt2.substring(1, 5));
    }

    @Test
    public void testTextSplitLines() {
        CommandLine.Help.Ansi.Text[] all;
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        CommandLine.Help.Ansi.Text[] textArray = new CommandLine.Help.Ansi.Text[3];
        CommandLine.Help.Ansi ansi2 = ansi;
        ansi2.getClass();
        textArray[0] = new CommandLine.Help.Ansi.Text(ansi2, "@|bold 012\n34|@").append("5\nAA\n6").append("@|underline 78\n90|@");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        textArray[1] = new CommandLine.Help.Ansi.Text(ansi3, "@|bold 012\r34|@").append("5\rAA\r6").append("@|underline 78\r90|@");
        CommandLine.Help.Ansi ansi4 = ansi;
        ansi4.getClass();
        textArray[2] = new CommandLine.Help.Ansi.Text(ansi4, "@|bold 012\r\n34|@").append("5\r\nAA\r\n6").append("@|underline 78\r\n90|@");
        for (CommandLine.Help.Ansi.Text text : all = textArray) {
            CommandLine.Help.Ansi.Text[] lines = text.splitLines();
            int i = 0;
            CommandLine.Help.Ansi ansi5 = ansi;
            ansi5.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi5, "@|bold 012|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi6 = ansi;
            ansi6.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi6, "@|bold 34|@5"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi7 = ansi;
            ansi7.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi7, "AA"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi8 = ansi;
            ansi8.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi8, "6@|underline 78|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi9 = ansi;
            ansi9.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi9, "@|underline 90|@"), (Object)lines[i++]);
        }
    }

    @Test
    public void testTextSplitLinesStartEnd() {
        CommandLine.Help.Ansi.Text[] all;
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        CommandLine.Help.Ansi.Text[] textArray = new CommandLine.Help.Ansi.Text[3];
        CommandLine.Help.Ansi ansi2 = ansi;
        ansi2.getClass();
        textArray[0] = new CommandLine.Help.Ansi.Text(ansi2, "\n@|bold 012\n34|@").append("5\nAA\n6").append("@|underline 78\n90|@\n");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        textArray[1] = new CommandLine.Help.Ansi.Text(ansi3, "\r@|bold 012\r34|@").append("5\rAA\r6").append("@|underline 78\r90|@\r");
        CommandLine.Help.Ansi ansi4 = ansi;
        ansi4.getClass();
        textArray[2] = new CommandLine.Help.Ansi.Text(ansi4, "\r\n@|bold 012\r\n34|@").append("5\r\nAA\r\n6").append("@|underline 78\r\n90|@\r\n");
        for (CommandLine.Help.Ansi.Text text : all = textArray) {
            CommandLine.Help.Ansi.Text[] lines = text.splitLines();
            int i = 0;
            CommandLine.Help.Ansi ansi5 = ansi;
            ansi5.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi5, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi6 = ansi;
            ansi6.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi6, "@|bold 012|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi7 = ansi;
            ansi7.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi7, "@|bold 34|@5"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi8 = ansi;
            ansi8.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi8, "AA"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi9 = ansi;
            ansi9.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi9, "6@|underline 78|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi10 = ansi;
            ansi10.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi10, "@|underline 90|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi11 = ansi;
            ansi11.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi11, ""), (Object)lines[i++]);
        }
    }

    @Test
    public void testTextSplitLinesStartEndIntermediate() {
        CommandLine.Help.Ansi.Text[] all;
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        CommandLine.Help.Ansi.Text[] textArray = new CommandLine.Help.Ansi.Text[3];
        CommandLine.Help.Ansi ansi2 = ansi;
        ansi2.getClass();
        textArray[0] = new CommandLine.Help.Ansi.Text(ansi2, "\n@|bold 012\n\n\n34|@").append("5\n\n\nAA\n\n\n6").append("@|underline 78\n90|@\n");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        textArray[1] = new CommandLine.Help.Ansi.Text(ansi3, "\r@|bold 012\r\r\r34|@").append("5\r\r\rAA\r\r\r6").append("@|underline 78\r90|@\r");
        CommandLine.Help.Ansi ansi4 = ansi;
        ansi4.getClass();
        textArray[2] = new CommandLine.Help.Ansi.Text(ansi4, "\r\n@|bold 012\r\n\r\n\r\n34|@").append("5\r\n\r\n\r\nAA\r\n\r\n\r\n6").append("@|underline 78\r\n90|@\r\n");
        for (CommandLine.Help.Ansi.Text text : all = textArray) {
            CommandLine.Help.Ansi.Text[] lines = text.splitLines();
            int i = 0;
            CommandLine.Help.Ansi ansi5 = ansi;
            ansi5.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi5, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi6 = ansi;
            ansi6.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi6, "@|bold 012|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi7 = ansi;
            ansi7.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi7, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi8 = ansi;
            ansi8.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi8, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi9 = ansi;
            ansi9.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi9, "@|bold 34|@5"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi10 = ansi;
            ansi10.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi10, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi11 = ansi;
            ansi11.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi11, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi12 = ansi;
            ansi12.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi12, "AA"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi13 = ansi;
            ansi13.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi13, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi14 = ansi;
            ansi14.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi14, ""), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi15 = ansi;
            ansi15.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi15, "6@|underline 78|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi16 = ansi;
            ansi16.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi16, "@|underline 90|@"), (Object)lines[i++]);
            CommandLine.Help.Ansi ansi17 = ansi;
            ansi17.getClass();
            Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi17, ""), (Object)lines[i++]);
        }
    }

    @Test
    public void testEmbeddedNewLinesInUsageSections() throws UnsupportedEncodingException {
        @CommandLine.Command(description={"first line\nsecond line\nthird line"}, headerHeading="headerHeading1\nheaderHeading2", header={"header1\nheader2"}, descriptionHeading="descriptionHeading1\ndescriptionHeading2", footerHeading="footerHeading1\nfooterHeading2", footer={"footer1\nfooter2"})
        class App {
            @CommandLine.Option(names={"-v", "--verbose"}, description={"optionDescription1\noptionDescription2"})
            boolean v;
            @CommandLine.Parameters(description={"paramDescription1\nparamDescription2"})
            String file;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new App(), CommandLine.Help.Ansi.OFF);
        String expected = String.format("headerHeading1%nheaderHeading2header1%nheader2%nUsage: <main class> [-v] <file>%ndescriptionHeading1%ndescriptionHeading2first line%nsecond line%nthird line%n      <file>                  paramDescription1%n                              paramDescription2%n  -v, --verbose               optionDescription1%n                              optionDescription2%nfooterHeading1%nfooterHeading2footer1%nfooter2%n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTextWithMultipleStyledSections() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[1m<main class>\u001b[21m\u001b[0m [\u001b[33m-v\u001b[39m\u001b[0m] [\u001b[33m-c\u001b[39m\u001b[0m [\u001b[3m<count>\u001b[23m\u001b[0m]]", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@ [@|italic <count>|@]]").toString());
    }

    @Test
    public void testTextAdjacentStyles() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[3m<commit\u001b[23m\u001b[0m\u001b[3m>\u001b[23m\u001b[0m%n", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|italic <commit|@@|italic >|@%n").toString());
    }

    @Test
    public void testTextNoConversionWithoutClosingTag() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[3mabc\u001b[23m\u001b[0m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|italic abc|@").toString());
        CommandLine.Help.Ansi ansi2 = CommandLine.Help.Ansi.ON;
        ansi2.getClass();
        Assert.assertEquals((Object)"@|italic abc", (Object)new CommandLine.Help.Ansi.Text(ansi2, "@|italic abc").toString());
    }

    @Test
    public void testTextNoConversionWithoutSpaceSeparator() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[3ma\u001b[23m\u001b[0m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|italic a|@").toString());
        CommandLine.Help.Ansi ansi2 = CommandLine.Help.Ansi.ON;
        ansi2.getClass();
        Assert.assertEquals((Object)"@|italic|@", (Object)new CommandLine.Help.Ansi.Text(ansi2, "@|italic|@").toString());
        CommandLine.Help.Ansi ansi3 = CommandLine.Help.Ansi.ON;
        ansi3.getClass();
        Assert.assertEquals((Object)"", (Object)new CommandLine.Help.Ansi.Text(ansi3, "@|italic |@").toString());
    }

    @Test
    public void testPalette236ColorForegroundIndex() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[38;5;45mabc\u001b[39m\u001b[0m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|fg(45) abc|@").toString());
    }

    @Test
    public void testPalette236ColorForegroundRgb() {
        int num = 231;
        String string = "\u001b[38;5;" + num + "mabc\u001b[39m\u001b[0m";
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)string, (Object)new CommandLine.Help.Ansi.Text(ansi, "@|fg(5;5;5) abc|@").toString());
    }

    @Test
    public void testPalette236ColorBackgroundIndex() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)"\u001b[48;5;77mabc\u001b[49m\u001b[0m", (Object)new CommandLine.Help.Ansi.Text(ansi, "@|bg(77) abc|@").toString());
    }

    @Test
    public void testPalette236ColorBackgroundRgb() {
        int num = 145;
        String string = "\u001b[48;5;" + num + "mabc\u001b[49m\u001b[0m";
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        ansi.getClass();
        Assert.assertEquals((Object)string, (Object)new CommandLine.Help.Ansi.Text(ansi, "@|bg(3;3;3) abc|@").toString());
    }

    @Test
    public void testAnsiEnabled() {
        Assert.assertTrue((boolean)CommandLine.Help.Ansi.ON.enabled());
        Assert.assertFalse((boolean)CommandLine.Help.Ansi.OFF.enabled());
        System.setProperty("picocli.ansi", "true");
        Assert.assertEquals((Object)true, (Object)CommandLine.Help.Ansi.AUTO.enabled());
        System.setProperty("picocli.ansi", "false");
        Assert.assertEquals((Object)false, (Object)CommandLine.Help.Ansi.AUTO.enabled());
        System.clearProperty("picocli.ansi");
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        boolean isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
        boolean isAtty = isWindows && isXterm || this.hasConsole();
        Assert.assertEquals((Object)(isAtty && (!isWindows || isXterm) ? 1 : 0), (Object)CommandLine.Help.Ansi.AUTO.enabled());
    }

    private boolean hasConsole() {
        try {
            return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (Throwable reflectionFailed) {
            return true;
        }
    }

    @Test
    public void testSystemPropertiesOverrideDefaultColorScheme() {
        CommandLine.Help.Ansi ansi;
        CommandLine.Help.Ansi ansi2 = ansi = CommandLine.Help.Ansi.ON;
        ansi2.getClass();
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE", arity="1..*")
            File[] files;

            App() {
            }
        }
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi2, "@|bold <main class>|@ [@|yellow -v|@] [@|yellow -c|@=@|italic <count>|@] @|yellow FILE|@..." + LINESEP), (Object)new CommandLine.Help((Object)new App(), ansi).synopsis(0));
        System.setProperty("picocli.color.commands", "blue");
        System.setProperty("picocli.color.options", "green");
        System.setProperty("picocli.color.parameters", "cyan");
        System.setProperty("picocli.color.optionParams", "magenta");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi3, "@|blue <main class>|@ [@|green -v|@] [@|green -c|@=@|magenta <count>|@] @|cyan FILE|@..." + LINESEP), (Object)new CommandLine.Help((Object)new App(), ansi).synopsis(0));
    }

    @Test
    public void testSystemPropertiesOverrideExplicitColorScheme() {
        CommandLine.Help.Ansi ansi = CommandLine.Help.Ansi.ON;
        CommandLine.Help.ColorScheme explicit = new CommandLine.Help.ColorScheme(ansi).commands(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.faint, CommandLine.Help.Ansi.Style.bg_magenta}).options(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bg_red}).parameters(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.reverse}).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bg_green});
        CommandLine.Help.Ansi ansi2 = ansi;
        ansi2.getClass();
        @CommandLine.Command(separator="=")
        class App {
            @CommandLine.Option(names={"--verbose", "-v"})
            boolean verbose;
            @CommandLine.Option(names={"--count", "-c"})
            int count;
            @CommandLine.Option(names={"--help", "-h"}, hidden=true)
            boolean helpRequested;
            @CommandLine.Parameters(paramLabel="FILE", arity="1..*")
            File[] files;

            App() {
            }
        }
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi2, "@|faint,bg(magenta) <main class>|@ [@|bg(red) -v|@] [@|bg(red) -c|@=@|bg(green) <count>|@] @|reverse FILE|@..." + LINESEP), (Object)new CommandLine.Help((Object)new App(), explicit).synopsis(0));
        System.setProperty("picocli.color.commands", "blue");
        System.setProperty("picocli.color.options", "blink");
        System.setProperty("picocli.color.parameters", "red");
        System.setProperty("picocli.color.optionParams", "magenta");
        CommandLine.Help.Ansi ansi3 = ansi;
        ansi3.getClass();
        Assert.assertEquals((Object)new CommandLine.Help.Ansi.Text(ansi3, "@|blue <main class>|@ [@|blink -v|@] [@|blink -c|@=@|magenta <count>|@] @|red FILE|@..." + LINESEP), (Object)new CommandLine.Help((Object)new App(), explicit).synopsis(0));
    }

    @Test
    public void testCommandLine_printVersionInfo_printsSinglePlainTextString() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        @CommandLine.Command(version={"1.0"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(new PrintStream((OutputStream)baos, true, "UTF8"), CommandLine.Help.Ansi.OFF);
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("1.0%n", new Object[0]), (Object)result);
    }

    @Test
    public void testCommandLine_printVersionInfo_printsArrayOfPlainTextStrings() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        @CommandLine.Command(version={"Versioned Command 1.0", "512-bit superdeluxe", "(c) 2017"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(new PrintStream((OutputStream)baos, true, "UTF8"), CommandLine.Help.Ansi.OFF);
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("Versioned Command 1.0%n512-bit superdeluxe%n(c) 2017%n", new Object[0]), (Object)result);
    }

    @Test
    public void testCommandLine_printVersionInfo_printsSingleStringWithMarkup() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        @CommandLine.Command(version={"@|red 1.0|@"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(new PrintStream((OutputStream)baos, true, "UTF8"), CommandLine.Help.Ansi.ON);
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("\u001b[31m1.0\u001b[39m\u001b[0m%n", new Object[0]), (Object)result);
    }

    @Test
    public void testCommandLine_printVersionInfo_printsArrayOfStringsWithMarkup() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        @CommandLine.Command(version={"@|yellow Versioned Command 1.0|@", "@|blue Build 12345|@", "@|red,bg(white) (c) 2017|@"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(new PrintStream((OutputStream)baos, true, "UTF8"), CommandLine.Help.Ansi.ON);
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("\u001b[33mVersioned Command 1.0\u001b[39m\u001b[0m%n\u001b[34mBuild 12345\u001b[39m\u001b[0m%n\u001b[31m\u001b[47m(c) 2017\u001b[49m\u001b[39m\u001b[0m%n", new Object[0]), (Object)result);
    }

    @Test
    public void testCommandLine_printVersionInfo_formatsArguments() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF8");
        @CommandLine.Command(version={"First line %1$s", "Second line %2$s", "Third line %s %s"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(ps, CommandLine.Help.Ansi.OFF, new Object[]{"VALUE1", "VALUE2", "VALUE3"});
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("First line VALUE1%nSecond line VALUE2%nThird line VALUE1 VALUE2%n", new Object[0]), (Object)result);
    }

    @Test
    public void testCommandLine_printVersionInfo_withMarkupAndParameterContainingMarkup() throws Exception {
        String[] args = new String[]{"@|bold VALUE1|@", "@|underline VALUE2|@", "VALUE3"};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF8");
        @CommandLine.Command(version={"@|yellow Versioned Command 1.0|@", "@|blue Build 12345|@%1$s", "@|red,bg(white) (c) 2017|@%2$s"})
        class Versioned {
            Versioned() {
            }
        }
        new CommandLine((Object)new Versioned()).printVersionHelp(ps, CommandLine.Help.Ansi.ON, (Object[])args);
        String result = baos.toString("UTF8");
        Assert.assertEquals((Object)String.format("\u001b[33mVersioned Command 1.0\u001b[39m\u001b[0m%n\u001b[34mBuild 12345\u001b[39m\u001b[0m\u001b[1mVALUE1\u001b[21m\u001b[0m%n\u001b[31m\u001b[47m(c) 2017\u001b[49m\u001b[39m\u001b[0m\u001b[4mVALUE2\u001b[24m\u001b[0m%n", new Object[0]), (Object)result);
    }

    @Test
    public void testMapFieldHelp() throws Exception {
        class App {
            @CommandLine.Parameters(arity="2", split="\\|", paramLabel="FIXTAG=VALUE", description={"Exactly two lists of vertical bar '|'-separated FIXTAG=VALUE pairs."})
            Map<Integer, String> message;
            @CommandLine.Option(names={"-P", "-map"}, split=",", paramLabel="TIMEUNIT=VALUE", description={"Any number of TIMEUNIT=VALUE pairs. These may be specified separately (-PTIMEUNIT=VALUE) or as a comma-separated list."})
            Map<TimeUnit, String> map;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new App(), CommandLine.Help.Ansi.OFF);
        String expected = String.format("Usage: <main class> [-P=TIMEUNIT=VALUE[,TIMEUNIT=VALUE]...]... FIXTAG=VALUE%n                    [\\|FIXTAG=VALUE]... FIXTAG=VALUE[\\|FIXTAG=VALUE]...%n      FIXTAG=VALUE[\\|FIXTAG=VALUE]... FIXTAG=VALUE[\\|FIXTAG=VALUE]...%n                              Exactly two lists of vertical bar '|'-separated%n                                FIXTAG=VALUE pairs.%n  -P, -map=TIMEUNIT=VALUE[,TIMEUNIT=VALUE]...%n                              Any number of TIMEUNIT=VALUE pairs. These may be%n                                specified separately (-PTIMEUNIT=VALUE) or as a%n                                comma-separated list.%n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMapFieldTypeInference() throws UnsupportedEncodingException {
        class App {
            @CommandLine.Option(names={"-a"})
            Map<Integer, URI> a;
            @CommandLine.Option(names={"-b"})
            Map<TimeUnit, StringBuilder> b;
            @CommandLine.Option(names={"-c"})
            Map c;
            @CommandLine.Option(names={"-d"})
            List<File> d;
            @CommandLine.Option(names={"-e"})
            Map<? extends Integer, ? super Long> e;
            @CommandLine.Option(names={"-f"}, type={Long.class, Float.class})
            Map<? extends Number, ? super Number> f;
            @CommandLine.Option(names={"-g"}, type={TimeUnit.class, Float.class})
            Map g;

            App() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new App(), CommandLine.Help.Ansi.OFF);
        String expected = String.format("Usage: <main class> [-a=<Integer=URI>]... [-b=<TimeUnit=StringBuilder>]...%n                    [-c=<String=String>]... [-d=<d>]... [-e=<Integer=Long>]...%n                    [-f=<Long=Float>]... [-g=<TimeUnit=Float>]...%n  -a= <Integer=URI>%n  -b= <TimeUnit=StringBuilder>%n%n  -c= <String=String>%n  -d= <d>%n  -e= <Integer=Long>%n  -f= <Long=Float>%n  -g= <TimeUnit=Float>%n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test200NPEWithEmptyCommandName() throws UnsupportedEncodingException {
        @CommandLine.Command(name="")
        class Args {
            Args() {
            }
        }
        String actual = CommandLineHelpTest.usageString(new Args(), CommandLine.Help.Ansi.OFF);
        String expected = String.format("Usage: %n", new Object[0]);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    static class UsageDemo {
        @CommandLine.Option(names={"-a"}, description={"boolean option with short name only"})
        boolean a;
        @CommandLine.Option(names={"-b"}, paramLabel="INT", description={"short option with a parameter"})
        int b;
        @CommandLine.Option(names={"-c", "--c-option"}, description={"boolean option with short and long name"})
        boolean c;
        @CommandLine.Option(names={"-d", "--d-option"}, paramLabel="FILE", description={"option with parameter and short and long name"})
        File d;
        @CommandLine.Option(names={"--e-option"}, description={"boolean option with only a long name"})
        boolean e;
        @CommandLine.Option(names={"--f-option"}, paramLabel="STRING", description={"option with parameter and only a long name"})
        String f;
        @CommandLine.Option(names={"-g", "--g-option-with-a-name-so-long-that-it-runs-into-the-descriptions-column"}, description={"boolean option with short and long name"})
        boolean g;
        @CommandLine.Parameters(index="0", paramLabel="0BLAH", description={"first parameter"})
        String param0;
        @CommandLine.Parameters(index="1", paramLabel="1PARAMETER-with-a-name-so-long-that-it-runs-into-the-descriptions-column", description={"2nd parameter"})
        String param1;
        @CommandLine.Parameters(index="2..*", paramLabel="remaining", description={"remaining parameters"})
        String param2_n;
        @CommandLine.Parameters(index="*", paramLabel="all", description={"all parameters"})
        String param_n;

        UsageDemo() {
        }
    }

    @CommandLine.Command(name="base", abbreviateSynopsis=true, commandListHeading="c o m m a n d s", customSynopsis={"cust"}, description={"base description"}, descriptionHeading="base descr heading", footer={"base footer"}, footerHeading="base footer heading", header={"base header"}, headerHeading="base header heading", optionListHeading="base option heading", parameterListHeading="base param heading", requiredOptionMarker=38, separator=";", showDefaultValues=true, sortOptions=false, synopsisHeading="abcd")
    class Base {
        Base() {
        }
    }
}

