/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.tools.picocli.CommandLine;
import org.apache.logging.log4j.core.tools.picocli.CommandLineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommandLineArityTest {
    @Before
    public void setUp() {
        System.clearProperty("picocli.trace");
    }

    @After
    public void tearDown() {
        System.clearProperty("picocli.trace");
    }

    private static void setTraceLevel(String level) {
        System.setProperty("picocli.trace", level);
    }

    @Test
    public void testArityConstructor_fixedRange() {
        CommandLine.Range arity = new CommandLine.Range(1, 23, false, false, null);
        Assert.assertEquals((String)"min", (long)1L, (long)arity.min);
        Assert.assertEquals((String)"max", (long)23L, (long)arity.max);
        Assert.assertEquals((Object)"1..23", (Object)arity.toString());
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1..23"), (Object)arity);
    }

    @Test
    public void testArityConstructor_variableRange() {
        CommandLine.Range arity = new CommandLine.Range(1, Integer.MAX_VALUE, true, false, null);
        Assert.assertEquals((String)"min", (long)1L, (long)arity.min);
        Assert.assertEquals((String)"max", (long)Integer.MAX_VALUE, (long)arity.max);
        Assert.assertEquals((Object)"1..*", (Object)arity.toString());
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1..*"), (Object)arity);
    }

    @Test
    public void testArityForOption_booleanFieldImplicitArity0() throws Exception {
        CommandLine.Range arity = CommandLine.Range.optionArity((Field)CommandLineTest.SupportedTypes.class.getDeclaredField("booleanField"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"0"), (Object)arity);
        Assert.assertEquals((Object)"0", (Object)arity.toString());
    }

    @Test
    public void testArityForOption_intFieldImplicitArity1() throws Exception {
        CommandLine.Range arity = CommandLine.Range.optionArity((Field)CommandLineTest.SupportedTypes.class.getDeclaredField("intField"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1"), (Object)arity);
        Assert.assertEquals((Object)"1", (Object)arity.toString());
    }

    @Test
    public void testArityForOption_isExplicitlyDeclaredValue() throws Exception {
        class Params {
            @CommandLine.Option(names={"-timeUnitList"}, type={TimeUnit.class}, arity="3")
            List<TimeUnit> timeUnitList;

            Params() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.optionArity((Field)Params.class.getDeclaredField("timeUnitList"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"3"), (Object)arity);
        Assert.assertEquals((Object)"3", (Object)arity.toString());
    }

    @Test
    public void testArityForOption_listFieldImplicitArity1() throws Exception {
        class ImplicitList {
            @CommandLine.Option(names={"-a"})
            List<Integer> listIntegers;

            ImplicitList() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.optionArity((Field)ImplicitList.class.getDeclaredField("listIntegers"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1"), (Object)arity);
        Assert.assertEquals((Object)"1", (Object)arity.toString());
    }

    @Test
    public void testArityForOption_arrayFieldImplicitArity1() throws Exception {
        class ImplicitList {
            @CommandLine.Option(names={"-a"})
            int[] intArray;

            ImplicitList() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.optionArity((Field)ImplicitList.class.getDeclaredField("intArray"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1"), (Object)arity);
        Assert.assertEquals((Object)"1", (Object)arity.toString());
    }

    @Test
    public void testArityForParameters_booleanFieldImplicitArity1() throws Exception {
        class ImplicitBoolField {
            @CommandLine.Parameters
            boolean boolSingleValue;

            ImplicitBoolField() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.parameterArity((Field)ImplicitBoolField.class.getDeclaredField("boolSingleValue"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1"), (Object)arity);
        Assert.assertEquals((Object)"1", (Object)arity.toString());
    }

    @Test
    public void testArityForParameters_intFieldImplicitArity1() throws Exception {
        class ImplicitSingleField {
            @CommandLine.Parameters
            int intSingleValue;

            ImplicitSingleField() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.parameterArity((Field)ImplicitSingleField.class.getDeclaredField("intSingleValue"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"1"), (Object)arity);
        Assert.assertEquals((Object)"1", (Object)arity.toString());
    }

    @Test
    public void testArityForParameters_listFieldImplicitArity0_1() throws Exception {
        class Params {
            @CommandLine.Parameters(type={Integer.class})
            List<Integer> list;

            Params() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.parameterArity((Field)Params.class.getDeclaredField("list"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"0..1"), (Object)arity);
        Assert.assertEquals((Object)"0..1", (Object)arity.toString());
    }

    @Test
    public void testArityForParameters_arrayFieldImplicitArity0_1() throws Exception {
        class Args {
            @CommandLine.Parameters
            File[] inputFiles;

            Args() {
            }
        }
        CommandLine.Range arity = CommandLine.Range.parameterArity((Field)Args.class.getDeclaredField("inputFiles"));
        Assert.assertEquals((Object)CommandLine.Range.valueOf((String)"0..1"), (Object)arity);
        Assert.assertEquals((Object)"0..1", (Object)arity.toString());
    }

    @Test
    public void testArrayOptionsWithArity0_nConsumeAllArguments() {
        final double[] DEFAULT_PARAMS = new double[]{1.0, 2.0};
        class ArrayOptionsArity0_nAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-doubles"}, arity="0..*")
            double[] doubleOptions;

            ArrayOptionsArity0_nAndParameters() {
                this.doubleParams = DEFAULT_PARAMS;
            }
        }
        ArrayOptionsArity0_nAndParameters params = (ArrayOptionsArity0_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionsArity0_nAndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])DEFAULT_PARAMS, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionsWithArity1_nConsumeAllArguments() {
        class ArrayOptionsArity1_nAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-doubles"}, arity="1..*")
            double[] doubleOptions;

            ArrayOptionsArity1_nAndParameters() {
            }
        }
        ArrayOptionsArity1_nAndParameters params = (ArrayOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionsArity1_nAndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals(null, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionsWithArity2_nConsumeAllArguments() {
        class ArrayOptionsArity2_nAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-doubles"}, arity="2..*")
            double[] doubleOptions;

            ArrayOptionsArity2_nAndParameters() {
            }
        }
        ArrayOptionsArity2_nAndParameters params = (ArrayOptionsArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionsArity2_nAndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals(null, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionArity2_nConsumesAllArgumentsUpToClusteredOption() {
        class ArrayOptionsArity2_nAndParameters {
            @CommandLine.Parameters
            String[] stringParams;
            @CommandLine.Option(names={"-s"}, arity="2..*")
            String[] stringOptions;
            @CommandLine.Option(names={"-v"})
            boolean verbose;
            @CommandLine.Option(names={"-f"})
            File file;

            ArrayOptionsArity2_nAndParameters() {
            }
        }
        ArrayOptionsArity2_nAndParameters params = (ArrayOptionsArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionsArity2_nAndParameters(), (String[])"-s 1.1 2.2 3.3 4.4 -vfFILE 5.5".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.stringOptions), (Object[])new String[]{"1.1", "2.2", "3.3", "4.4"}, (Object[])params.stringOptions);
        Assert.assertTrue((boolean)params.verbose);
        Assert.assertEquals((Object)new File("FILE"), (Object)params.file);
        Assert.assertArrayEquals((Object[])new String[]{"5.5"}, (Object[])params.stringParams);
    }

    @Test
    public void testArrayOptionArity2_nConsumesAllArgumentIncludingQuotedSimpleOption() {
        class ArrayOptionArity2_nAndParameters {
            @CommandLine.Parameters
            String[] stringParams;
            @CommandLine.Option(names={"-s"}, arity="2..*")
            String[] stringOptions;
            @CommandLine.Option(names={"-v"})
            boolean verbose;
            @CommandLine.Option(names={"-f"})
            File file;

            ArrayOptionArity2_nAndParameters() {
            }
        }
        ArrayOptionArity2_nAndParameters params = (ArrayOptionArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2_nAndParameters(), (String[])"-s 1.1 2.2 3.3 4.4 \"-v\" \"-f\" \"FILE\" 5.5".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.stringOptions), (Object[])new String[]{"1.1", "2.2", "3.3", "4.4", "-v", "-f", "FILE", "5.5"}, (Object[])params.stringOptions);
        Assert.assertFalse((String)"verbose", (boolean)params.verbose);
        Assert.assertNull((String)"file", (Object)params.file);
        Assert.assertArrayEquals(null, (Object[])params.stringParams);
    }

    @Test
    public void testArrayOptionArity2_nConsumesAllArgumentIncludingQuotedClusteredOption() {
        class ArrayOptionArity2_nAndParameters {
            @CommandLine.Parameters
            String[] stringParams;
            @CommandLine.Option(names={"-s"}, arity="2..*")
            String[] stringOptions;
            @CommandLine.Option(names={"-v"})
            boolean verbose;
            @CommandLine.Option(names={"-f"})
            File file;

            ArrayOptionArity2_nAndParameters() {
            }
        }
        ArrayOptionArity2_nAndParameters params = (ArrayOptionArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2_nAndParameters(), (String[])"-s 1.1 2.2 3.3 4.4 \"-vfFILE\" 5.5".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.stringOptions), (Object[])new String[]{"1.1", "2.2", "3.3", "4.4", "-vfFILE", "5.5"}, (Object[])params.stringOptions);
        Assert.assertFalse((String)"verbose", (boolean)params.verbose);
        Assert.assertNull((String)"file", (Object)params.file);
        Assert.assertArrayEquals(null, (Object[])params.stringParams);
    }

    @Test
    public void testArrayOptionArity2_nConsumesAllArgumentsUpToNextSimpleOption() {
        class ArrayOptionArity2_nAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-s"}, arity="2..*")
            String[] stringOptions;
            @CommandLine.Option(names={"-v"})
            boolean verbose;
            @CommandLine.Option(names={"-f"})
            File file;

            ArrayOptionArity2_nAndParameters() {
            }
        }
        ArrayOptionArity2_nAndParameters params = (ArrayOptionArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2_nAndParameters(), (String[])"-s 1.1 2.2 3.3 4.4 -v -f=FILE 5.5".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.stringOptions), (Object[])new String[]{"1.1", "2.2", "3.3", "4.4"}, (Object[])params.stringOptions);
        Assert.assertTrue((boolean)params.verbose);
        Assert.assertEquals((Object)new File("FILE"), (Object)params.file);
        Assert.assertArrayEquals((double[])new double[]{5.5}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionArity2_nConsumesAllArgumentsUpToNextOptionWithAttachment() {
        class ArrayOptionArity2_nAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-s"}, arity="2..*")
            String[] stringOptions;
            @CommandLine.Option(names={"-v"})
            boolean verbose;
            @CommandLine.Option(names={"-f"})
            File file;

            ArrayOptionArity2_nAndParameters() {
            }
        }
        ArrayOptionArity2_nAndParameters params = (ArrayOptionArity2_nAndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2_nAndParameters(), (String[])"-s 1.1 2.2 3.3 4.4 -f=FILE -v 5.5".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.stringOptions), (Object[])new String[]{"1.1", "2.2", "3.3", "4.4"}, (Object[])params.stringOptions);
        Assert.assertTrue((boolean)params.verbose);
        Assert.assertEquals((Object)new File("FILE"), (Object)params.file);
        Assert.assertArrayEquals((double[])new double[]{5.5}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionArityNConsumeAllArguments() {
        class ArrayOptionArityNAndParameters {
            @CommandLine.Parameters
            char[] charParams;
            @CommandLine.Option(names={"-chars"}, arity="*")
            char[] charOptions;

            ArrayOptionArityNAndParameters() {
            }
        }
        ArrayOptionArityNAndParameters params = (ArrayOptionArityNAndParameters)CommandLine.populateCommand((Object)new ArrayOptionArityNAndParameters(), (String[])"-chars a b c d".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.charOptions), (char[])new char[]{'a', 'b', 'c', 'd'}, (char[])params.charOptions);
        Assert.assertArrayEquals(null, (char[])params.charParams);
    }

    @Test
    public void testMissingRequiredParams() {
        class Example {
            @CommandLine.Parameters(index="1", arity="0..1")
            String optional;
            @CommandLine.Parameters(index="0")
            String mandatory;

            Example() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new Example(), (String[])new String[]{"mandatory"});
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.fail();
        }
        try {
            CommandLine.populateCommand((Object)new Example(), (String[])new String[0]);
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <mandatory>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMissingRequiredParams1() {
        class Tricky1 {
            @CommandLine.Parameters(index="2")
            String anotherMandatory;
            @CommandLine.Parameters(index="1", arity="0..1")
            String optional;
            @CommandLine.Parameters(index="0")
            String mandatory;

            Tricky1() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new Tricky1(), (String[])new String[0]);
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters: <mandatory>, <anotherMandatory>", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new Tricky1(), (String[])new String[]{"firstonly"});
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <anotherMandatory>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMissingRequiredParams2() {
        class Tricky2 {
            @CommandLine.Parameters(index="2", arity="0..1")
            String anotherOptional;
            @CommandLine.Parameters(index="1", arity="0..1")
            String optional;
            @CommandLine.Parameters(index="0")
            String mandatory;

            Tricky2() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new Tricky2(), (String[])new String[]{"mandatory"});
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.fail();
        }
        try {
            CommandLine.populateCommand((Object)new Tricky2(), (String[])new String[0]);
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <mandatory>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMissingRequiredParamsWithOptions() {
        class Tricky3 {
            @CommandLine.Option(names={"-v"})
            boolean more;
            @CommandLine.Option(names={"-t"})
            boolean any;
            @CommandLine.Parameters(index="1")
            String alsoMandatory;
            @CommandLine.Parameters(index="0")
            String mandatory;

            Tricky3() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new Tricky3(), (String[])new String[]{"-t", "-v", "mandatory"});
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <alsoMandatory>", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new Tricky3(), (String[])new String[]{"-t", "-v"});
            Assert.fail((String)"Should not accept missing two mandatory parameters");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters: <mandatory>, <alsoMandatory>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMissingRequiredParamWithOption() {
        try {
            class Tricky3 {
                @CommandLine.Option(names={"-t"})
                boolean any;
                @CommandLine.Parameters(index="0")
                String mandatory;

                Tricky3() {
                }
            }
            CommandLine.populateCommand((Object)new Tricky3(), (String[])new String[]{"-t"});
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <mandatory>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNoMissingRequiredParamErrorIfHelpOptionSpecified() {
        class App {
            @CommandLine.Parameters(hidden=true)
            List<String> allParameters;
            @CommandLine.Parameters(index="0")
            InetAddress host;
            @CommandLine.Parameters(index="1")
            int port;
            @CommandLine.Parameters(index="2..*")
            File[] files;
            @CommandLine.Option(names={"-?"}, help=true)
            boolean help;

            App() {
            }
        }
        CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-?"});
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters: <host>, <port>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNoMissingRequiredParamErrorWithLabelIfHelpOptionSpecified() {
        class App {
            @CommandLine.Parameters(hidden=true)
            List<String> allParameters;
            @CommandLine.Parameters(index="0", paramLabel="HOST")
            InetAddress host;
            @CommandLine.Parameters(index="1", paramLabel="PORT")
            int port;
            @CommandLine.Parameters(index="2..*", paramLabel="FILES")
            File[] files;
            @CommandLine.Option(names={"-?"}, help=true)
            boolean help;

            App() {
            }
        }
        CommandLine.populateCommand((Object)new App(), (String[])new String[]{"-?"});
        try {
            CommandLine.populateCommand((Object)new App(), (String[])new String[0]);
            Assert.fail((String)"Should not accept missing mandatory parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters: HOST, PORT", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBooleanOptionsArity0_nConsume1ArgumentIfPossible() {
        BooleanOptionsArity0_nAndParameters params = (BooleanOptionsArity0_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-bool false false true".split(" "));
        Assert.assertFalse((boolean)params.bool);
        Assert.assertArrayEquals((Object[])new String[]{"false", "true"}, (Object[])params.params);
    }

    @Test
    public void testBooleanOptionsArity0_nRequiresNoArgument() {
        BooleanOptionsArity0_nAndParameters params = (BooleanOptionsArity0_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-bool".split(" "));
        Assert.assertTrue((boolean)params.bool);
    }

    @Test
    public void testBooleanOptionsArity0_nConsume0ArgumentsIfNextArgIsOption() {
        BooleanOptionsArity0_nAndParameters params = (BooleanOptionsArity0_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-bool -other".split(" "));
        Assert.assertTrue((boolean)params.bool);
        Assert.assertTrue((boolean)params.vOrOther);
    }

    @Test
    public void testBooleanOptionsArity0_nConsume0ArgumentsIfNextArgIsParameter() {
        BooleanOptionsArity0_nAndParameters params = (BooleanOptionsArity0_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-bool 123 -other".split(" "));
        Assert.assertTrue((boolean)params.bool);
        Assert.assertTrue((boolean)params.vOrOther);
        Assert.assertArrayEquals((Object[])new String[]{"123"}, (Object[])params.params);
    }

    @Test
    public void testBooleanOptionsArity0_nFailsIfAttachedParamNotABoolean() {
        try {
            CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-bool=123 -other".split(" "));
            Assert.fail((String)"was able to assign 123 to boolean");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"'123' is not a boolean for option '-bool'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBooleanOptionsArity0_nShortFormFailsIfAttachedParamNotABoolean() {
        try {
            CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-rv234 -bool".split(" "));
            Assert.fail((String)"Expected exception");
        }
        catch (CommandLine.UnmatchedArgumentException ok) {
            Assert.assertEquals((Object)"Unmatched argument [-234]", (Object)ok.getMessage());
        }
    }

    @Test
    public void testBooleanOptionsArity0_nShortFormFailsIfAttachedParamNotABooleanWithUnmatchedArgsAllowed() {
        CommandLineArityTest.setTraceLevel("OFF");
        CommandLine cmd = new CommandLine((Object)new BooleanOptionsArity0_nAndParameters()).setUnmatchedArgumentsAllowed(true);
        cmd.parse("-rv234 -bool".split(" "));
        Assert.assertEquals(Arrays.asList("-234"), (Object)cmd.getUnmatchedArguments());
    }

    @Test
    public void testBooleanOptionsArity0_nShortFormFailsIfAttachedWithSepParamNotABoolean() {
        try {
            CommandLine.populateCommand((Object)new BooleanOptionsArity0_nAndParameters(), (String[])"-rv=234 -bool".split(" "));
            Assert.fail((String)"was able to assign 234 to boolean");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"'234' is not a boolean for option '-v'", (Object)ex.getMessage());
        }
    }

    @Test
    public void testBooleanOptionsArity1_nConsume1Argument() {
        BooleanOptionsArity1_nAndParameters params = (BooleanOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool false false true".split(" "));
        Assert.assertFalse((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])params.boolParams);
        params = (BooleanOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool true false true".split(" "));
        Assert.assertTrue((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])params.boolParams);
    }

    @Test
    public void testBooleanOptionsArity1_nCaseInsensitive() {
        BooleanOptionsArity1_nAndParameters params = (BooleanOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool fAlsE false true".split(" "));
        Assert.assertFalse((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])params.boolParams);
        params = (BooleanOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool FaLsE false true".split(" "));
        Assert.assertFalse((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])params.boolParams);
        params = (BooleanOptionsArity1_nAndParameters)CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool tRuE false true".split(" "));
        Assert.assertTrue((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])params.boolParams);
    }

    @Test
    public void testBooleanOptionsArity1_nErrorIfValueNotTrueOrFalse() {
        try {
            CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool abc".split(" "));
            Assert.fail((String)"Invalid format abc was accepted for boolean");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"'abc' is not a boolean for option '-bool'", (Object)expected.getMessage());
        }
    }

    @Test
    public void testBooleanOptionsArity1_nErrorIfValueMissing() {
        try {
            CommandLine.populateCommand((Object)new BooleanOptionsArity1_nAndParameters(), (String[])"-bool".split(" "));
            Assert.fail((String)"Missing param was accepted for boolean with arity=1");
        }
        catch (CommandLine.ParameterException expected) {
            Assert.assertEquals((Object)"Missing required parameter for option '-bool' at index 0 (<aBoolean>)", (Object)expected.getMessage());
        }
    }

    @Test
    public void testBooleanOptionArity0Consumes0Arguments() {
        class BooleanOptionArity0AndParameters {
            @CommandLine.Parameters
            boolean[] boolParams;
            @CommandLine.Option(names={"-bool"}, arity="0")
            boolean aBoolean;

            BooleanOptionArity0AndParameters() {
            }
        }
        BooleanOptionArity0AndParameters params = (BooleanOptionArity0AndParameters)CommandLine.populateCommand((Object)new BooleanOptionArity0AndParameters(), (String[])"-bool true false true".split(" "));
        Assert.assertTrue((boolean)params.aBoolean);
        Assert.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])params.boolParams);
    }

    @Test(expected=CommandLine.MissingParameterException.class)
    public void testSingleValueFieldDefaultMinArityIs1() {
        CommandLine.populateCommand((Object)new CommandLineTest.SupportedTypes(), (String[])new String[]{"-Long"});
    }

    @Test
    public void testSingleValueFieldDefaultMinArityIsOne() {
        try {
            CommandLine.populateCommand((Object)new CommandLineTest.SupportedTypes(), (String[])new String[]{"-Long", "-boolean"});
            Assert.fail((String)"should fail");
        }
        catch (CommandLine.ParameterException ex) {
            Assert.assertEquals((Object)"Could not convert '-boolean' to Long for option '-Long': java.lang.NumberFormatException: For input string: \"-boolean\"", (Object)ex.getMessage());
        }
    }

    @Test
    public void testIntOptionArity1_nConsumes1Argument() {
        class IntOptionArity1_nAndParameters {
            @CommandLine.Parameters
            int[] intParams;
            @CommandLine.Option(names={"-int"}, arity="1..*")
            int anInt;

            IntOptionArity1_nAndParameters() {
            }
        }
        IntOptionArity1_nAndParameters params = (IntOptionArity1_nAndParameters)CommandLine.populateCommand((Object)new IntOptionArity1_nAndParameters(), (String[])"-int 23 42 7".split(" "));
        Assert.assertEquals((long)23L, (long)params.anInt);
        Assert.assertArrayEquals((int[])new int[]{42, 7}, (int[])params.intParams);
    }

    @Test
    public void testArrayOptionsWithArity0Consume0Arguments() {
        class OptionsArray0ArityAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-doubles"}, arity="0")
            double[] doubleOptions;

            OptionsArray0ArityAndParameters() {
            }
        }
        OptionsArray0ArityAndParameters params = (OptionsArray0ArityAndParameters)CommandLine.populateCommand((Object)new OptionsArray0ArityAndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[0], (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionWithArity1Consumes1Argument() {
        class Options1ArityAndParameters {
            @CommandLine.Parameters
            double[] doubleParams;
            @CommandLine.Option(names={"-doubles"}, arity="1")
            double[] doubleOptions;

            Options1ArityAndParameters() {
            }
        }
        Options1ArityAndParameters params = (Options1ArityAndParameters)CommandLine.populateCommand((Object)new Options1ArityAndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{2.2, 3.3, 4.4}, (double[])params.doubleParams, (double)1.0E-6);
        params = (Options1ArityAndParameters)CommandLine.populateCommand((Object)new Options1ArityAndParameters(), (String[])"-doubles 1.1 -doubles 2.2 -doubles 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{4.4}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionWithArity2Consumes2Arguments() {
        ArrayOptionArity2AndParameters params = (ArrayOptionArity2AndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2AndParameters(), (String[])"-doubles 1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{3.3, 4.4}, (double[])params.doubleParams, (double)1.0E-6);
        params = (ArrayOptionArity2AndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2AndParameters(), (String[])"-doubles 1.1 2.2 -doubles 3.3 4.4 0".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{0.0}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionsWithArity2Consume2ArgumentsEvenIfFirstIsAttached() {
        ArrayOptionArity2AndParameters params = (ArrayOptionArity2AndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2AndParameters(), (String[])"-doubles=1.1 2.2 3.3 4.4".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{3.3, 4.4}, (double[])params.doubleParams, (double)1.0E-6);
        params = (ArrayOptionArity2AndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2AndParameters(), (String[])"-doubles=1.1 2.2 -doubles=3.3 4.4 0".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.1, 2.2, 3.3, 4.4}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{0.0}, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionsWithArity2MayContainMoreThan2Values() {
        ArrayOptionArity2AndParameters params = (ArrayOptionArity2AndParameters)CommandLine.populateCommand((Object)new ArrayOptionArity2AndParameters(), (String[])"-doubles=1 2 -doubles 3 4 -doubles 5 6".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.doubleOptions), (double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, (double[])params.doubleOptions, (double)1.0E-6);
        Assert.assertArrayEquals(null, (double[])params.doubleParams, (double)1.0E-6);
    }

    @Test
    public void testArrayOptionWithoutArityConsumesOneArgument() {
        class OptionsNoArityAndParameters {
            @CommandLine.Parameters
            char[] charParams;
            @CommandLine.Option(names={"-chars"})
            char[] charOptions;

            OptionsNoArityAndParameters() {
            }
        }
        OptionsNoArityAndParameters params = (OptionsNoArityAndParameters)CommandLine.populateCommand((Object)new OptionsNoArityAndParameters(), (String[])"-chars a b c d".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.charOptions), (char[])new char[]{'a'}, (char[])params.charOptions);
        Assert.assertArrayEquals((String)Arrays.toString(params.charParams), (char[])new char[]{'b', 'c', 'd'}, (char[])params.charParams);
        params = (OptionsNoArityAndParameters)CommandLine.populateCommand((Object)new OptionsNoArityAndParameters(), (String[])"-chars a -chars b c d".split(" "));
        Assert.assertArrayEquals((String)Arrays.toString(params.charOptions), (char[])new char[]{'a', 'b'}, (char[])params.charOptions);
        Assert.assertArrayEquals((String)Arrays.toString(params.charParams), (char[])new char[]{'c', 'd'}, (char[])params.charParams);
        try {
            CommandLine.populateCommand((Object)new OptionsNoArityAndParameters(), (String[])"-chars".split(" "));
            Assert.fail((String)"expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ok) {
            Assert.assertEquals((Object)"Missing required parameter for option '-chars' (<charOptions>)", (Object)ok.getMessage());
        }
    }

    @Test
    public void testArrayParametersWithDefaultArity() {
        class ArrayParamsDefaultArity {
            @CommandLine.Parameters
            List<String> params;

            ArrayParamsDefaultArity() {
            }
        }
        ArrayParamsDefaultArity params = (ArrayParamsDefaultArity)CommandLine.populateCommand((Object)new ArrayParamsDefaultArity(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), params.params);
        params = (ArrayParamsDefaultArity)CommandLine.populateCommand((Object)new ArrayParamsDefaultArity(), (String[])new String[]{"a"});
        Assert.assertEquals(Arrays.asList("a"), params.params);
        params = (ArrayParamsDefaultArity)CommandLine.populateCommand((Object)new ArrayParamsDefaultArity(), (String[])new String[0]);
        Assert.assertEquals(null, params.params);
    }

    @Test
    public void testArrayParametersWithArityMinusOneToN() {
        class ArrayParamsNegativeArity {
            @CommandLine.Parameters(arity="-1..*")
            List<String> params;

            ArrayParamsNegativeArity() {
            }
        }
        ArrayParamsNegativeArity params = (ArrayParamsNegativeArity)CommandLine.populateCommand((Object)new ArrayParamsNegativeArity(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), params.params);
        params = (ArrayParamsNegativeArity)CommandLine.populateCommand((Object)new ArrayParamsNegativeArity(), (String[])new String[]{"a"});
        Assert.assertEquals(Arrays.asList("a"), params.params);
        params = (ArrayParamsNegativeArity)CommandLine.populateCommand((Object)new ArrayParamsNegativeArity(), (String[])new String[0]);
        Assert.assertEquals(null, params.params);
    }

    @Test
    public void testArrayParametersArity0_n() {
        class ArrayParamsArity0_n {
            @CommandLine.Parameters(arity="0..*")
            List<String> params;

            ArrayParamsArity0_n() {
            }
        }
        ArrayParamsArity0_n params = (ArrayParamsArity0_n)CommandLine.populateCommand((Object)new ArrayParamsArity0_n(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), params.params);
        params = (ArrayParamsArity0_n)CommandLine.populateCommand((Object)new ArrayParamsArity0_n(), (String[])new String[]{"a"});
        Assert.assertEquals(Arrays.asList("a"), params.params);
        params = (ArrayParamsArity0_n)CommandLine.populateCommand((Object)new ArrayParamsArity0_n(), (String[])new String[0]);
        Assert.assertEquals(null, params.params);
    }

    @Test
    public void testArrayParametersArity1_n() {
        class ArrayParamsArity1_n {
            @CommandLine.Parameters(arity="1..*")
            List<String> params;

            ArrayParamsArity1_n() {
            }
        }
        ArrayParamsArity1_n params = (ArrayParamsArity1_n)CommandLine.populateCommand((Object)new ArrayParamsArity1_n(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), params.params);
        params = (ArrayParamsArity1_n)CommandLine.populateCommand((Object)new ArrayParamsArity1_n(), (String[])new String[]{"a"});
        Assert.assertEquals(Arrays.asList("a"), params.params);
        try {
            params = (ArrayParamsArity1_n)CommandLine.populateCommand((Object)new ArrayParamsArity1_n(), (String[])new String[0]);
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters at positions 0..*: <params>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testArrayParametersArity2_n() {
        class ArrayParamsArity2_n {
            @CommandLine.Parameters(arity="2..*")
            List<String> params;

            ArrayParamsArity2_n() {
            }
        }
        ArrayParamsArity2_n params = (ArrayParamsArity2_n)CommandLine.populateCommand((Object)new ArrayParamsArity2_n(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), params.params);
        try {
            params = (ArrayParamsArity2_n)CommandLine.populateCommand((Object)new ArrayParamsArity2_n(), (String[])new String[]{"a"});
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<params>) requires at least 2 values, but only 1 were specified: [a]", (Object)ex.getMessage());
        }
        try {
            params = (ArrayParamsArity2_n)CommandLine.populateCommand((Object)new ArrayParamsArity2_n(), (String[])new String[0]);
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<params>) requires at least 2 values, but none were specified.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNonVarargArrayParametersWithNegativeArityConsumesZeroArguments() {
        class NonVarArgArrayParamsNegativeArity {
            @CommandLine.Parameters(arity="-1")
            List<String> params;

            NonVarArgArrayParamsNegativeArity() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new NonVarArgArrayParamsNegativeArity(), (String[])new String[]{"a", "b", "c"});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched arguments [a, b, c]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new NonVarArgArrayParamsNegativeArity(), (String[])new String[]{"a"});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [a]", (Object)ex.getMessage());
        }
        NonVarArgArrayParamsNegativeArity params = (NonVarArgArrayParamsNegativeArity)CommandLine.populateCommand((Object)new NonVarArgArrayParamsNegativeArity(), (String[])new String[0]);
        Assert.assertEquals(null, params.params);
    }

    @Test
    public void testNonVarargArrayParametersWithArity0() {
        class NonVarArgArrayParamsZeroArity {
            @CommandLine.Parameters(arity="0")
            List<String> params;

            NonVarArgArrayParamsZeroArity() {
            }
        }
        try {
            CommandLine.populateCommand((Object)new NonVarArgArrayParamsZeroArity(), (String[])new String[]{"a", "b", "c"});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched arguments [a, b, c]", (Object)ex.getMessage());
        }
        try {
            CommandLine.populateCommand((Object)new NonVarArgArrayParamsZeroArity(), (String[])new String[]{"a"});
            Assert.fail((String)"Expected UnmatchedArgumentException");
        }
        catch (CommandLine.UnmatchedArgumentException ex) {
            Assert.assertEquals((Object)"Unmatched argument [a]", (Object)ex.getMessage());
        }
        NonVarArgArrayParamsZeroArity params = (NonVarArgArrayParamsZeroArity)CommandLine.populateCommand((Object)new NonVarArgArrayParamsZeroArity(), (String[])new String[0]);
        Assert.assertEquals(null, params.params);
    }

    @Test
    public void testNonVarargArrayParametersWithArity1() {
        class NonVarArgArrayParamsArity1 {
            @CommandLine.Parameters(arity="1")
            List<String> params;

            NonVarArgArrayParamsArity1() {
            }
        }
        NonVarArgArrayParamsArity1 actual = (NonVarArgArrayParamsArity1)CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity1(), (String[])new String[]{"a", "b", "c"});
        Assert.assertEquals(Arrays.asList("a", "b", "c"), actual.params);
        NonVarArgArrayParamsArity1 params = (NonVarArgArrayParamsArity1)CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity1(), (String[])new String[]{"a"});
        Assert.assertEquals(Arrays.asList("a"), params.params);
        try {
            params = (NonVarArgArrayParamsArity1)CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity1(), (String[])new String[0]);
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameter: <params>", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNonVarargArrayParametersWithArity2() {
        class NonVarArgArrayParamsArity2 {
            @CommandLine.Parameters(arity="2")
            List<String> params;

            NonVarArgArrayParamsArity2() {
            }
        }
        NonVarArgArrayParamsArity2 params = null;
        try {
            CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity2(), (String[])new String[]{"a", "b", "c"});
            Assert.fail((String)"expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<params>) requires at least 2 values, but only 1 were specified: [c]", (Object)ex.getMessage());
        }
        try {
            params = (NonVarArgArrayParamsArity2)CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity2(), (String[])new String[]{"a"});
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<params>) requires at least 2 values, but only 1 were specified: [a]", (Object)ex.getMessage());
        }
        try {
            params = (NonVarArgArrayParamsArity2)CommandLine.populateCommand((Object)new NonVarArgArrayParamsArity2(), (String[])new String[0]);
            Assert.fail((String)"Should not accept input with missing parameter");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<params>) requires at least 2 values, but none were specified.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testMixPositionalParamsWithOptions_ParamsUnboundedArity_isGreedy() {
        class Arg {
            @CommandLine.Parameters(arity="1..*")
            List<String> parameters;
            @CommandLine.Option(names={"-o"})
            List<String> options;

            Arg() {
            }
        }
        Arg result = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "p2", "-o", "v2", "p3", "p4"});
        Assert.assertEquals(Arrays.asList("p1", "p2", "-o", "v2", "p3", "p4"), result.parameters);
        Assert.assertEquals(Arrays.asList("v1"), result.options);
        Arg result2 = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "-o", "v2", "p3"});
        Assert.assertEquals(Arrays.asList("p1", "-o", "v2", "p3"), result2.parameters);
        Assert.assertEquals(Arrays.asList("v1"), result2.options);
        try {
            CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "-o", "v2"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"Missing required parameters at positions 0..*: <parameters>", (Object)ex.getMessage());
        }
    }

    @Test
    public void test130MixPositionalParamsWithOptions() {
        @CommandLine.Command(name="test-command", description={"tests help from a command script"})
        class Arg {
            @CommandLine.Parameters(description={"some parameters"})
            List<String> parameters;
            @CommandLine.Option(names={"-cp", "--codepath"}, description={"the codepath"})
            List<String> codepath;

            Arg() {
            }
        }
        Arg result = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"--codepath", "/usr/x.jar", "placeholder", "-cp", "/bin/y.jar", "another"});
        Assert.assertEquals(Arrays.asList("/usr/x.jar", "/bin/y.jar"), result.codepath);
        Assert.assertEquals(Arrays.asList("placeholder", "another"), result.parameters);
    }

    @Test
    public void test130MixPositionalParamsWithOptions1() {
        class Arg {
            @CommandLine.Parameters
            List<String> parameters;
            @CommandLine.Option(names={"-o"})
            List<String> options;

            Arg() {
            }
        }
        Arg result = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "p2", "-o", "v2", "p3"});
        Assert.assertEquals(Arrays.asList("v1", "v2"), result.options);
        Assert.assertEquals(Arrays.asList("p1", "p2", "p3"), result.parameters);
    }

    @Test
    public void test130MixPositionalParamsWithOptionsArity() {
        class Arg {
            @CommandLine.Parameters(arity="2")
            List<String> parameters;
            @CommandLine.Option(names={"-o"})
            List<String> options;

            Arg() {
            }
        }
        Arg result = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "p2", "-o", "v2", "p3", "p4"});
        Assert.assertEquals(Arrays.asList("v1", "v2"), result.options);
        Assert.assertEquals(Arrays.asList("p1", "p2", "p3", "p4"), result.parameters);
        Arg result2 = (Arg)CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "-o", "v2", "p3"});
        Assert.assertEquals(Arrays.asList("v1"), result2.options);
        Assert.assertEquals(Arrays.asList("p1", "-o", "v2", "p3"), result2.parameters);
        try {
            CommandLine.populateCommand((Object)new Arg(), (String[])new String[]{"-o", "v1", "p1", "p2", "-o", "v2", "p3"});
            Assert.fail((String)"Expected MissingParameterException");
        }
        catch (CommandLine.MissingParameterException ex) {
            Assert.assertEquals((Object)"positional parameter at index 0..* (<parameters>) requires at least 2 values, but only 1 were specified: [p3]", (Object)ex.getMessage());
        }
    }

    private static class ArrayOptionArity2AndParameters {
        @CommandLine.Parameters
        double[] doubleParams;
        @CommandLine.Option(names={"-doubles"}, arity="2")
        double[] doubleOptions;

        private ArrayOptionArity2AndParameters() {
        }
    }

    private static class BooleanOptionsArity1_nAndParameters {
        @CommandLine.Parameters
        boolean[] boolParams;
        @CommandLine.Option(names={"-bool"}, arity="1..*")
        boolean aBoolean;

        private BooleanOptionsArity1_nAndParameters() {
        }
    }

    private static class BooleanOptionsArity0_nAndParameters {
        @CommandLine.Parameters
        String[] params;
        @CommandLine.Option(names={"-bool"}, arity="0..*")
        boolean bool;
        @CommandLine.Option(names={"-v", "-other"}, arity="0..*")
        boolean vOrOther;
        @CommandLine.Option(names={"-r"})
        boolean rBoolean;

        private BooleanOptionsArity0_nAndParameters() {
        }
    }
}

