/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.junit.ThreadContextMapRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RegexReplacementTest {
    private static final String CONFIG = "log4j-replace.xml";
    private static ListAppender app;
    private static ListAppender app2;
    private static final String EXPECTED;
    @ClassRule
    public static LoggerContextRule context;
    @Rule
    public final ThreadContextMapRule threadContextRule = new ThreadContextMapRule();
    Logger logger = context.getLogger("LoggerTest");
    Logger logger2 = context.getLogger("ReplacementTest");

    @Before
    public void setUp() throws Exception {
        app = context.getListAppender("List").clear();
        app2 = context.getListAppender("List2").clear();
    }

    @Test
    public void testReplacement() {
        this.logger.error(this.getClass().getName());
        List<String> msgs = app.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((String)("Incorrect number of messages. Should be 1 is " + msgs.size()), (long)1L, (long)msgs.size());
        Assert.assertTrue((String)("Replacement failed - expected ending " + EXPECTED + " Actual " + msgs.get(0)), (boolean)msgs.get(0).endsWith(EXPECTED));
        app.clear();
        ThreadContext.put((String)"MyKey", (String)"Apache");
        this.logger.error("This is a test for ${ctx:MyKey}");
        msgs = app.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((String)("Incorrect number of messages. Should be 1 is " + msgs.size()), (long)1L, (long)msgs.size());
        Assert.assertEquals((Object)("LoggerTest This is a test for Apache" + Strings.LINE_SEPARATOR), (Object)msgs.get(0));
    }

    @Test
    public void testConverter() {
        this.logger2.error(this.getClass().getName());
        List<String> msgs = app2.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((String)("Incorrect number of messages. Should be 1 is " + msgs.size()), (long)1L, (long)msgs.size());
        Assert.assertTrue((String)("Replacement failed - expected ending " + EXPECTED + " Actual " + msgs.get(0)), (boolean)msgs.get(0).endsWith(EXPECTED));
    }

    static {
        EXPECTED = "/RegexReplacementTest" + Strings.LINE_SEPARATOR;
        context = new LoggerContextRule(CONFIG);
    }
}

